/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.server.auth.ntlm;

import junit.framework.TestCase;
import org.alfresco.filesys.server.auth.ntlm.Type1NTLMMessage;

public class NTLMMessageTest
extends TestCase {
    public void testType1Message() {
        Type1NTLMMessage ntlmMsg = new Type1NTLMMessage();
        ntlmMsg.buildType1(0, null, null);
        NTLMMessageTest.assertEquals((String)"Minimal type 1 message length wrong", (int)16, (int)ntlmMsg.getLength());
        NTLMMessageTest.assertFalse((String)"Minimal type 1 message domain supplied flag set", (boolean)ntlmMsg.hasFlag(4096));
        NTLMMessageTest.assertFalse((String)"Minimal type 1 message workstation supplied flag set", (boolean)ntlmMsg.hasFlag(8192));
        NTLMMessageTest.assertFalse((String)"Minimal type 1 has domain", (boolean)ntlmMsg.hasDomain());
        NTLMMessageTest.assertNull((String)"Minimal type 1 domain not null", (Object)ntlmMsg.getDomain());
        NTLMMessageTest.assertFalse((String)"Minimal type 1 has workstation", (boolean)ntlmMsg.hasWorkstation());
        NTLMMessageTest.assertNull((String)"Minimal type 1 workstation not null", (Object)ntlmMsg.getWorkstation());
        byte[] buf = new byte[256];
        ntlmMsg = new Type1NTLMMessage(buf, 128, 128);
        ntlmMsg.buildType1(0, null, null);
        NTLMMessageTest.assertEquals((String)"Minimal type 1 message length wrong", (int)16, (int)ntlmMsg.getLength());
        NTLMMessageTest.assertFalse((String)"Minimal type 1 message domain supplied flag set", (boolean)ntlmMsg.hasFlag(4096));
        NTLMMessageTest.assertFalse((String)"Minimal type 1 message workstation supplied flag set", (boolean)ntlmMsg.hasFlag(8192));
        NTLMMessageTest.assertFalse((String)"Minimal type 1 has domain", (boolean)ntlmMsg.hasDomain());
        NTLMMessageTest.assertNull((String)"Minimal type 1 domain not null", (Object)ntlmMsg.getDomain());
        NTLMMessageTest.assertFalse((String)"Minimal type 1 has workstation", (boolean)ntlmMsg.hasWorkstation());
        NTLMMessageTest.assertNull((String)"Minimal type 1 workstation not null", (Object)ntlmMsg.getWorkstation());
        String testDomain = "TESTDOMAIN";
        String testWks = "TESTPC";
        ntlmMsg = new Type1NTLMMessage();
        ntlmMsg.buildType1(0, testDomain, null);
        NTLMMessageTest.assertTrue((String)"Minimal type 1 message length wrong", (ntlmMsg.getLength() > 16 ? 1 : 0) != 0);
        NTLMMessageTest.assertTrue((String)"Minimal type 1 message domain supplied flag not set", (boolean)ntlmMsg.hasFlag(4096));
        NTLMMessageTest.assertFalse((String)"Minimal type 1 message workstation supplied flag set", (boolean)ntlmMsg.hasFlag(8192));
        NTLMMessageTest.assertTrue((String)"Minimal type 1 no domain", (boolean)ntlmMsg.hasDomain());
        NTLMMessageTest.assertEquals((String)"Minimal type 1 domain not correct", (String)testDomain, (String)ntlmMsg.getDomain());
        NTLMMessageTest.assertFalse((String)"Minimal type 1 has workstation", (boolean)ntlmMsg.hasWorkstation());
        NTLMMessageTest.assertNull((String)"Minimal type 1 workstation not null", (Object)ntlmMsg.getWorkstation());
        ntlmMsg = new Type1NTLMMessage(buf, 128, 128);
        ntlmMsg.buildType1(0, testDomain, null);
        NTLMMessageTest.assertTrue((String)"Minimal type 1 message length wrong", (ntlmMsg.getLength() > 16 ? 1 : 0) != 0);
        NTLMMessageTest.assertTrue((String)"Minimal type 1 message domain supplied flag not set", (boolean)ntlmMsg.hasFlag(4096));
        NTLMMessageTest.assertFalse((String)"Minimal type 1 message workstation supplied flag set", (boolean)ntlmMsg.hasFlag(8192));
        NTLMMessageTest.assertTrue((String)"Minimal type 1 no domain", (boolean)ntlmMsg.hasDomain());
        NTLMMessageTest.assertEquals((String)"Minimal type 1 domain not correct", (String)testDomain, (String)ntlmMsg.getDomain());
        NTLMMessageTest.assertFalse((String)"Minimal type 1 has workstation", (boolean)ntlmMsg.hasWorkstation());
        NTLMMessageTest.assertNull((String)"Minimal type 1 workstation not null", (Object)ntlmMsg.getWorkstation());
        ntlmMsg = new Type1NTLMMessage();
        ntlmMsg.buildType1(0, null, testWks);
        NTLMMessageTest.assertTrue((String)"Minimal type 1 message length wrong", (ntlmMsg.getLength() > 16 ? 1 : 0) != 0);
        NTLMMessageTest.assertFalse((String)"Minimal type 1 message domain supplied flag set", (boolean)ntlmMsg.hasFlag(4096));
        NTLMMessageTest.assertTrue((String)"Minimal type 1 message workstation supplied flag not set", (boolean)ntlmMsg.hasFlag(8192));
        NTLMMessageTest.assertFalse((String)"Minimal type 1 has domain", (boolean)ntlmMsg.hasDomain());
        NTLMMessageTest.assertNull((String)"Minimal type 1 domain not null", (Object)ntlmMsg.getDomain());
        NTLMMessageTest.assertTrue((String)"Minimal type 1 no workstation", (boolean)ntlmMsg.hasWorkstation());
        NTLMMessageTest.assertEquals((String)"Minimal type 1 workstation not correct", (String)testWks, (String)ntlmMsg.getWorkstation());
        ntlmMsg = new Type1NTLMMessage(buf, 128, 128);
        ntlmMsg.buildType1(0, null, testWks);
        NTLMMessageTest.assertTrue((String)"Minimal type 1 message length wrong", (ntlmMsg.getLength() > 16 ? 1 : 0) != 0);
        NTLMMessageTest.assertFalse((String)"Minimal type 1 message domain supplied flag set", (boolean)ntlmMsg.hasFlag(4096));
        NTLMMessageTest.assertTrue((String)"Minimal type 1 message workstation supplied flag not set", (boolean)ntlmMsg.hasFlag(8192));
        NTLMMessageTest.assertFalse((String)"Minimal type 1 has domain", (boolean)ntlmMsg.hasDomain());
        NTLMMessageTest.assertNull((String)"Minimal type 1 domain not null", (Object)ntlmMsg.getDomain());
        NTLMMessageTest.assertTrue((String)"Minimal type 1 no workstation", (boolean)ntlmMsg.hasWorkstation());
        NTLMMessageTest.assertEquals((String)"Minimal type 1 workstation not correct", (String)testWks, (String)ntlmMsg.getWorkstation());
        ntlmMsg = new Type1NTLMMessage();
        ntlmMsg.buildType1(0, testDomain, testWks);
        NTLMMessageTest.assertTrue((String)"Minimal type 1 message length wrong", (ntlmMsg.getLength() > 16 ? 1 : 0) != 0);
        NTLMMessageTest.assertTrue((String)"Minimal type 1 message domain supplied flag not set", (boolean)ntlmMsg.hasFlag(4096));
        NTLMMessageTest.assertTrue((String)"Minimal type 1 message workstation supplied flag not set", (boolean)ntlmMsg.hasFlag(8192));
        NTLMMessageTest.assertTrue((String)"Minimal type 1 has domain", (boolean)ntlmMsg.hasDomain());
        NTLMMessageTest.assertEquals((String)"Minimal type 1 domain not correct", (String)testDomain, (String)ntlmMsg.getDomain());
        NTLMMessageTest.assertTrue((String)"Minimal type 1 no workstation", (boolean)ntlmMsg.hasWorkstation());
        NTLMMessageTest.assertEquals((String)"Minimal type 1 workstation not correct", (String)testWks, (String)ntlmMsg.getWorkstation());
        ntlmMsg = new Type1NTLMMessage(buf, 128, 128);
        ntlmMsg.buildType1(0, testDomain, testWks);
        NTLMMessageTest.assertTrue((String)"Minimal type 1 message length wrong", (ntlmMsg.getLength() > 16 ? 1 : 0) != 0);
        NTLMMessageTest.assertTrue((String)"Minimal type 1 message domain supplied flag not set", (boolean)ntlmMsg.hasFlag(4096));
        NTLMMessageTest.assertTrue((String)"Minimal type 1 message workstation supplied flag not set", (boolean)ntlmMsg.hasFlag(8192));
        NTLMMessageTest.assertTrue((String)"Minimal type 1 has domain", (boolean)ntlmMsg.hasDomain());
        NTLMMessageTest.assertEquals((String)"Minimal type 1 domain not correct", (String)testDomain, (String)ntlmMsg.getDomain());
        NTLMMessageTest.assertTrue((String)"Minimal type 1 no workstation", (boolean)ntlmMsg.hasWorkstation());
        NTLMMessageTest.assertEquals((String)"Minimal type 1 workstation not correct", (String)testWks, (String)ntlmMsg.getWorkstation());
    }

    public void testType2Message() {
    }

    public void testType3Message() {
    }
}

