/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.server.auth.ntlm;

public class TargetInfo {
    private int m_type;
    private String m_name;

    public TargetInfo(int type, String name) {
        this.m_type = type;
        this.m_name = name;
    }

    public final int isType() {
        return this.m_type;
    }

    public final String getName() {
        return this.m_name;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[");
        str.append(TargetInfo.getTypeAsString(this.isType()));
        str.append(":");
        str.append(this.getName());
        str.append("]");
        return str.toString();
    }

    public static final String getTypeAsString(int typ) {
        String typStr = null;
        switch (typ) {
            case 1: {
                typStr = "Server";
                break;
            }
            case 2: {
                typStr = "Domain";
                break;
            }
            case 3: {
                typStr = "DNS";
                break;
            }
            case 4: {
                typStr = "DNS Domain";
                break;
            }
            default: {
                typStr = "Unknown 0x" + Integer.toHexString(typ);
            }
        }
        return typStr;
    }
}

