/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.server.auth.ntlm;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.filesys.server.auth.ntlm.NTLMMessage;
import org.alfresco.filesys.server.auth.ntlm.TargetInfo;
import org.alfresco.filesys.util.HexDump;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Type2NTLMMessage
extends NTLMMessage {
    public static final int MinimalMessageLength = 32;
    public static final int OffsetTarget = 12;
    public static final int OffsetFlags = 20;
    public static final int OffsetChallenge = 24;
    public static final int OffsetContext = 32;
    public static final int OffsetTargetInfo = 40;

    public Type2NTLMMessage() {
    }

    public Type2NTLMMessage(byte[] buf) {
        super(buf, 0, buf.length);
    }

    public Type2NTLMMessage(byte[] buf, int offset, int len) {
        super(buf, offset, len);
    }

    @Override
    public int getFlags() {
        return this.getIntValue(20);
    }

    public final boolean hasTarget() {
        return this.hasFlag(4);
    }

    public final String getTarget() {
        return this.getStringValue(12, this.hasFlag(1));
    }

    public final byte[] getChallenge() {
        return this.getRawBytes(24, 8);
    }

    public final boolean hasContext() {
        return this.hasFlag(16384);
    }

    public final int[] getContext() {
        if (!this.hasContext()) {
            return null;
        }
        int[] ctx = new int[]{this.getIntValue(32), this.getIntValue(36)};
        return ctx;
    }

    public final boolean hasTargetInformation() {
        return this.hasFlag(0x800000);
    }

    public final List<TargetInfo> getTargetInformation() {
        if (!this.hasTargetInformation()) {
            return null;
        }
        int tLen = this.getStringLength(40);
        int tOff = this.getStringOffset(40);
        ArrayList<TargetInfo> tList = new ArrayList<TargetInfo>();
        if (tLen == 0) {
            return tList;
        }
        int typ = -1;
        int slen = -1;
        String name = null;
        while (typ != 0) {
            typ = this.getShortValue(tOff);
            slen = this.getShortValue(tOff + 2);
            name = slen > 0 ? this.getRawString(tOff + 4, slen / 2, true) : null;
            if (typ != 0) {
                tList.add(new TargetInfo(typ, name));
            }
            tOff += slen + 4;
        }
        return tList;
    }

    public final void buildType2(int flags, String target, byte[] challenge, int[] ctx, List<TargetInfo> tList) {
        this.initializeHeader(2, flags);
        boolean isUni = this.hasFlag(1);
        int strOff = 40;
        if (tList != null) {
            strOff += 8;
        }
        strOff = this.setStringValue(12, target, strOff, isUni);
        if (challenge != null) {
            this.setRawBytes(24, challenge);
        } else {
            this.zeroBytes(24, 8);
        }
        if (ctx != null) {
            this.setRawInts(32, ctx);
        } else {
            this.zeroBytes(32, 8);
        }
        if (tList != null) {
            this.setIntValue(40, 0);
            this.setIntValue(44, strOff);
            int startOff = strOff;
            for (TargetInfo tInfo : tList) {
                this.setShortValue(strOff, tInfo.isType());
                int tLen = tInfo.getName().length();
                if (isUni) {
                    tLen *= 2;
                }
                this.setShortValue(strOff + 2, tLen);
                strOff = this.setRawString(strOff + 4, tInfo.getName(), isUni);
            }
            this.zeroBytes(strOff, 4);
            this.setShortValue(40, (strOff += 4) - startOff);
            this.setShortValue(42, strOff - startOff);
        }
        this.setLength(strOff);
    }

    @Override
    protected void setFlags(int flags) {
        this.setIntValue(20, flags);
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[Type2:0x");
        str.append(Integer.toHexString(this.getFlags()));
        str.append(",Target:");
        str.append(this.getTarget());
        str.append(",Ch:");
        str.append(HexDump.hexString(this.getChallenge()));
        if (this.hasTargetInformation()) {
            List<TargetInfo> targets = this.getTargetInformation();
            str.append(",TargInf:");
            for (TargetInfo target : targets) {
                str.append(target);
            }
        }
        str.append("]");
        return str.toString();
    }
}

