/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.server.auth.passthru;

import java.util.Hashtable;
import javax.transaction.UserTransaction;
import org.alfresco.config.ConfigElement;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.filesys.server.SessionListener;
import org.alfresco.filesys.server.SrvSession;
import org.alfresco.filesys.server.auth.AuthContext;
import org.alfresco.filesys.server.auth.CifsAuthenticator;
import org.alfresco.filesys.server.auth.ClientInfo;
import org.alfresco.filesys.server.auth.NTLanManAuthContext;
import org.alfresco.filesys.server.auth.passthru.AuthenticateSession;
import org.alfresco.filesys.server.auth.passthru.PassthruDetails;
import org.alfresco.filesys.server.auth.passthru.PassthruServers;
import org.alfresco.filesys.server.config.InvalidConfigurationException;
import org.alfresco.filesys.server.config.ServerConfiguration;
import org.alfresco.filesys.server.core.SharedDevice;
import org.alfresco.filesys.smb.server.SMBServer;
import org.alfresco.filesys.smb.server.SMBSrvSession;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.repository.NodeRef;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PassthruAuthenticator
extends CifsAuthenticator
implements SessionListener {
    private static final Log logger = LogFactory.getLog((String)"org.alfresco.smb.protocol.auth");
    public static final int DefaultSessionTmo = 5000;
    public static final int MinSessionTmo = 2000;
    public static final int MaxSessionTmo = 30000;
    private PassthruServers m_passthruServers;
    private SMBServer m_server;
    private Hashtable<String, PassthruDetails> m_sessions = new Hashtable();

    public int authenticateShareConnect(ClientInfo client, SharedDevice share, String sharePwd, SrvSession sess) {
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int authenticateUser(ClientInfo client, SrvSession sess, int alg) {
        if (client.isNullSession()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Null CIFS logon allowed");
            }
            return 0;
        }
        if (client.getAuthenticationToken() != null && client.getLogonType() != 2) {
            this.m_authComponent.setCurrentUser(client.getUserName());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Re-using existing authentication token");
            }
            return client.getLogonType() != 1 ? 0 : 0x10000000;
        }
        int authSts = -1;
        if (client.isGuest() || client.getUserName().equalsIgnoreCase(this.getGuestUserName())) {
            if (!this.allowGuest()) {
                return -1;
            }
            this.doGuestLogon(client, sess);
            authSts = 0x10000000;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Authenticated user " + client.getUserName() + " sts=" + this.getStatusAsString(authSts)));
            }
            return authSts;
        }
        PassthruDetails passDetails = this.m_sessions.get(sess.getUniqueId());
        if (passDetails != null) {
            AuthenticateSession authSess;
            block33: {
                try {
                    authSess = passDetails.getAuthenticateSession();
                    authSess.doSessionSetup(client.getUserName(), client.getANSIPassword(), client.getPassword());
                    if (authSess.isGuest()) {
                        if (this.allowGuest()) {
                            this.doGuestLogon(client, sess);
                            authSts = 0x10000000;
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("Passthru authenticate user=" + client.getUserName() + ", GUEST"));
                            }
                        }
                        break block33;
                    }
                    UserTransaction tx = this.m_transactionService.getUserTransaction(true);
                    try {
                        tx.begin();
                        String username = client.getUserName();
                        NodeRef userNode = this.m_personService.getPerson(username);
                        if (userNode != null) {
                            String personName = (String)((Object)this.m_nodeService.getProperty(userNode, ContentModel.PROP_USERNAME));
                            this.m_authComponent.setCurrentUser(personName);
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("Setting current user using person " + personName + " (username " + username + ")"));
                            }
                        } else {
                            if (!this.m_personService.getUserNamesAreCaseSensitive()) {
                                username = username.toLowerCase();
                            }
                            this.m_authComponent.setCurrentUser(username);
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("Setting current user using username " + username));
                            }
                        }
                        authSts = 0;
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Passthru authenticate user=" + client.getUserName() + ", FULL"));
                        }
                    }
                    finally {
                        if (tx != null) {
                            try {
                                tx.commit();
                            }
                            catch (Exception ex) {}
                        }
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)ex.getMessage());
                }
            }
            if (!(sess instanceof SMBSrvSession)) {
                this.m_sessions.remove(sess.getUniqueId());
                try {
                    authSess = passDetails.getAuthenticateSession();
                    authSess.CloseSession();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Closed auth session, sessId=" + authSess.getSessionId()));
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)"Passthru error closing session (auth user)", (Throwable)ex);
                }
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("  No PassthruDetails for " + sess.getUniqueId()));
        }
        return authSts;
    }

    public AuthContext getAuthContext(SMBSrvSession sess) {
        NTLanManAuthContext authCtx = null;
        if (sess.hasAuthenticationContext() && sess.hasClientInformation() && sess.getClientInformation().getAuthenticationToken() != null && sess.getClientInformation().getLogonType() != 2) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Re-using existing challenge, already authenticated");
            }
            return sess.getAuthenticationContext();
        }
        try {
            AuthenticateSession authSess = this.m_passthruServers.openSession();
            if (authSess != null) {
                PassthruDetails passDetails = new PassthruDetails(sess, authSess);
                this.m_sessions.put(sess.getUniqueId(), passDetails);
                authCtx = new NTLanManAuthContext(authSess.getEncryptionKey());
                sess.setAuthenticationContext(authCtx);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Passthru sessId=" + authSess.getSessionId() + ", auth ctx=" + authCtx));
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Passthru error getting challenge", (Throwable)ex);
        }
        return authCtx;
    }

    public void initialize(ServerConfiguration config, ConfigElement params) throws InvalidConfigurationException {
        super.initialize(config, params);
        this.m_passthruServers = new PassthruServers();
        ConfigElement sessTmoElem = params.getChild("Timeout");
        if (sessTmoElem != null) {
            try {
                int sessTmo = Integer.parseInt(sessTmoElem.getValue());
                if (sessTmo < 2000 || sessTmo > 30000) {
                    throw new InvalidConfigurationException("Invalid session timeout, valid range is 2000 to 30000");
                }
                this.m_passthruServers.setConnectionTimeout(sessTmo);
            }
            catch (NumberFormatException ex) {
                throw new InvalidConfigurationException("Invalid timeout value specified");
            }
        }
        String srvList = null;
        if (params.getChild("LocalServer") != null && (srvList = config.getLocalServerName(true)) == null) {
            throw new AlfrescoRuntimeException("Passthru authenticator failed to get local server name");
        }
        ConfigElement srvNamesElem = params.getChild("Server");
        if (srvNamesElem != null && srvNamesElem.getValue().length() > 0) {
            if (srvList != null) {
                throw new AlfrescoRuntimeException("Set passthru server via local server or specify name");
            }
            srvList = srvNamesElem.getValue();
        }
        if (srvList != null) {
            this.m_passthruServers.setServerList(srvList);
        } else {
            ConfigElement domNameElem;
            String domainName = null;
            if (params.getChild("LocalDomain") != null) {
                domainName = config.getLocalDomainName();
            }
            if ((domNameElem = params.getChild("Domain")) != null && domNameElem.getValue().length() > 0) {
                if (srvList != null) {
                    throw new AlfrescoRuntimeException("Specify server or domain name for passthru authentication");
                }
                domainName = domNameElem.getValue();
            }
            if (domainName != null) {
                this.m_passthruServers.setDomain(domainName);
            }
        }
        if (this.m_passthruServers.getTotalServerCount() == 0) {
            throw new AlfrescoRuntimeException("No valid authentication servers found for passthru");
        }
        SMBServer smbServer = (SMBServer)config.findServer("SMB");
        if (smbServer != null) {
            smbServer.addSessionListener(this);
        }
    }

    public void closeAuthenticator() {
        if (this.m_passthruServers != null) {
            this.m_passthruServers.shutdown();
        }
    }

    public void sessionClosed(SrvSession sess) {
        PassthruDetails passDetails = this.m_sessions.get(sess.getUniqueId());
        if (passDetails != null) {
            this.m_sessions.remove(sess.getUniqueId());
            try {
                AuthenticateSession authSess = passDetails.getAuthenticateSession();
                authSess.CloseSession();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Closed auth session, sessId=" + authSess.getSessionId()));
                }
            }
            catch (Exception ex) {
                logger.error((Object)"Passthru error closing session (closed)", (Throwable)ex);
            }
        }
    }

    public void sessionCreated(SrvSession sess) {
    }

    public void sessionLoggedOn(SrvSession sess) {
        PassthruDetails passDetails;
        if (sess.hasClientInformation() && sess.getClientInformation().getUserName() != null && sess.getClientInformation().getUserName().length() > 0 && (passDetails = this.m_sessions.get(sess.getUniqueId())) != null) {
            this.m_sessions.remove(sess.getUniqueId());
            try {
                AuthenticateSession authSess = passDetails.getAuthenticateSession();
                authSess.CloseSession();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Closed auth session, sessId=" + authSess.getSessionId()));
                }
            }
            catch (Exception ex) {
                logger.error((Object)"Passthru error closing session (logon)", (Throwable)ex);
            }
        }
    }
}

