/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.server.auth.passthru;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.filesys.netbios.NetBIOSName;
import org.alfresco.filesys.netbios.NetBIOSNameList;
import org.alfresco.filesys.netbios.NetBIOSSession;
import org.alfresco.filesys.server.auth.passthru.AuthSessionFactory;
import org.alfresco.filesys.server.auth.passthru.AuthenticateSession;
import org.alfresco.filesys.server.auth.passthru.PassthruServerDetails;
import org.alfresco.filesys.smb.PCShare;
import org.alfresco.filesys.util.IPAddress;
import org.apache.log4j.Logger;

public class PassthruServers {
    private static final Logger logger = Logger.getLogger((String)"org.alfresco.smb.protocol.auth");
    private static final int DefaultConnectTimeout = 5000;
    private static final long DefaultOfflineCheckInterval = 300000L;
    private List<PassthruServerDetails> m_onlineList = new ArrayList<PassthruServerDetails>();
    private List<PassthruServerDetails> m_offlineList = new ArrayList<PassthruServerDetails>();
    private int m_tmo = 5000;
    private String m_domain;
    private long m_offlineCheckInterval = 300000L;
    PassthruOfflineChecker m_offlineChecker = new PassthruOfflineChecker();

    public final int getOnlineServerCount() {
        return this.m_onlineList.size();
    }

    public final int getOfflineServerCount() {
        return this.m_offlineList.size();
    }

    public final int getTotalServerCount() {
        return this.m_onlineList.size() + this.m_offlineList.size();
    }

    public final boolean hasOnlineServers() {
        return this.m_onlineList.size() > 0;
    }

    public final int getConnectionTimeout() {
        return this.m_tmo;
    }

    public final boolean isDomainAuthentication() {
        return this.m_domain != null;
    }

    public final String getDomain() {
        return this.m_domain;
    }

    public final AuthenticateSession openSession() {
        return this.openSession(0);
    }

    public final AuthenticateSession openSession(int extFlags) {
        PassthruServerDetails passthruServer = this.getAuthenticationServer();
        if (passthruServer == null) {
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Open authenticate session to " + passthruServer));
        }
        PCShare authShare = new PCShare(passthruServer.getAddress().getHostAddress(), "IPC$", "", "");
        authShare.setExtendedSecurityFlags(extFlags);
        AuthenticateSession authSess = null;
        while (authSess == null && passthruServer != null && this.hasOnlineServers()) {
            try {
                authSess = AuthSessionFactory.OpenAuthenticateSession(authShare, this.getConnectionTimeout());
                passthruServer.incrementAuthenticationCount();
            }
            catch (Exception ex) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Failed to connect to " + passthruServer + " : " + ex.getMessage()));
                }
                this.serverOffline(passthruServer);
            }
            if (authSess != null) continue;
            passthruServer = this.getAuthenticationServer();
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("Trying authentication server " + passthruServer));
        }
        return authSess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PassthruServerDetails getAuthenticationServer() {
        PassthruServerDetails passthruServer = null;
        List<PassthruServerDetails> list = this.m_onlineList;
        synchronized (list) {
            if (this.m_onlineList.size() > 1) {
                this.m_onlineList.add(this.m_onlineList.remove(0));
            }
            if (this.m_onlineList.size() > 0) {
                passthruServer = this.m_onlineList.get(0);
            }
        }
        return passthruServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void serverOffline(PassthruServerDetails server) {
        server.setOnline(false);
        List<PassthruServerDetails> list = this.m_onlineList;
        synchronized (list) {
            this.m_onlineList.remove(server);
        }
        list = this.m_offlineList;
        synchronized (list) {
            this.m_offlineList.add(server);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Passthru server offline, " + server));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void serverOnline(PassthruServerDetails server) {
        server.setOnline(true);
        List<PassthruServerDetails> list = this.m_offlineList;
        synchronized (list) {
            this.m_offlineList.remove(server);
        }
        list = this.m_onlineList;
        synchronized (list) {
            this.m_onlineList.add(server);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Passthru server online, " + server));
        }
    }

    public final void setConnectionTimeout(int tmo) {
        this.m_tmo = tmo;
    }

    public final void setOfflineCheckInterval(long interval) {
        this.m_offlineCheckInterval = interval * 1000L;
    }

    public final void setServerList(String servers) {
        StringTokenizer tokens = new StringTokenizer(servers, ",");
        while (tokens.hasMoreTokens()) {
            InetAddress srvAddr;
            String srvName;
            block7: {
                srvName = tokens.nextToken().trim();
                srvAddr = null;
                if (IPAddress.isNumericAddress(srvName)) {
                    try {
                        srvAddr = InetAddress.getByName(srvName);
                        srvName = srvAddr.getHostName();
                    }
                    catch (UnknownHostException ex) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Passthru failed to find name/address for " + srvName));
                        }
                        break block7;
                    }
                }
                try {
                    srvAddr = InetAddress.getByName(srvName);
                }
                catch (UnknownHostException ex) {
                    if (!logger.isDebugEnabled()) break block7;
                    logger.debug((Object)("Passthru failed to find address for " + srvName));
                }
            }
            if (srvName == null || srvAddr == null) continue;
            PassthruServerDetails passthruServer = new PassthruServerDetails(srvName, null, srvAddr, false);
            this.m_offlineList.add(passthruServer);
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("Added passthru server " + passthruServer));
        }
        this.m_offlineChecker.processOfflineServers();
    }

    public final void setDomain(String domain) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Passthru finding domain controller for " + domain + " ..."));
        }
        NetBIOSName nbName = null;
        try {
            nbName = NetBIOSSession.FindName(domain, '\u001c', this.getConnectionTimeout());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("  Found " + nbName.numberOfAddresses() + " domain controller(s)"));
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        if (nbName == null) {
            try {
                nbName = NetBIOSSession.FindName(domain, '\u001d', this.getConnectionTimeout());
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("  Found browse master at " + nbName.getIPAddressString(0)));
                }
            }
            catch (IOException ex) {
                throw new AlfrescoRuntimeException("Failed to find domain controller or browse master for " + domain);
            }
        }
        for (int i = 0; i < nbName.numberOfAddresses(); ++i) {
            String dcName;
            InetAddress dcAddr;
            block14: {
                dcAddr = null;
                dcName = null;
                try {
                    dcAddr = InetAddress.getByName(nbName.getIPAddressString(i));
                    NetBIOSNameList nameList = NetBIOSSession.FindNamesForAddress(dcAddr.getHostAddress());
                    NetBIOSName dcNBName = nameList.findName(' ', false);
                    if (dcNBName != null) {
                        dcName = dcNBName.getName();
                    }
                }
                catch (UnknownHostException ex) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Invalid address for server " + nbName.getIPAddressString(i)));
                    }
                }
                catch (Exception ex) {
                    dcName = dcAddr.getHostAddress();
                    if (!logger.isDebugEnabled()) break block14;
                    logger.debug((Object)("Failed to get NetBIOS name for server " + dcAddr));
                }
            }
            if (dcAddr == null) continue;
            PassthruServerDetails passthruServer = new PassthruServerDetails(dcName, domain, dcAddr, false);
            this.m_offlineList.add(passthruServer);
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("Added passthru server " + passthruServer));
        }
        this.m_offlineChecker.processOfflineServers();
    }

    public final void shutdown() {
        this.m_offlineChecker.shutdownRequest();
        this.m_onlineList.clear();
        this.m_offlineList.clear();
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[");
        if (this.isDomainAuthentication()) {
            str.append("Domain:");
            str.append(this.getDomain());
        } else {
            str.append("Servers:");
        }
        str.append(",Online=");
        str.append(this.getOnlineServerCount());
        str.append(",Offline=");
        str.append(this.getOfflineServerCount());
        str.append("]");
        return str.toString();
    }

    class PassthruOfflineChecker
    extends Thread {
        private boolean m_ishutdown;

        PassthruOfflineChecker() {
            this.setDaemon(true);
            this.setName("PassthruOfflineChecker");
            this.start();
        }

        public void run() {
            this.m_ishutdown = false;
            while (!this.m_ishutdown) {
                try {
                    PassthruOfflineChecker.sleep(PassthruServers.this.m_offlineCheckInterval);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
                if (this.m_ishutdown || PassthruServers.this.getOfflineServerCount() <= 0) continue;
                int idx = 0;
                PassthruServerDetails offlineServer = null;
                PCShare authShare = new PCShare("", "IPC$", "", "");
                AuthenticateSession authSess = null;
                while (idx < PassthruServers.this.getOfflineServerCount()) {
                    block9: {
                        offlineServer = (PassthruServerDetails)PassthruServers.this.m_offlineList.get(idx);
                        if (offlineServer == null) continue;
                        try {
                            authShare.setNodeName(offlineServer.getAddress().getHostAddress());
                            authSess = AuthSessionFactory.OpenAuthenticateSession(authShare, PassthruServers.this.getConnectionTimeout());
                            try {
                                authSess.CloseSession();
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                            PassthruServers.this.serverOnline(offlineServer);
                        }
                        catch (Exception ex) {
                            if (!logger.isDebugEnabled()) break block9;
                            logger.debug((Object)("Passthru offline check failed for " + offlineServer.getName()));
                        }
                    }
                    if (offlineServer.isOnline()) continue;
                    ++idx;
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Passthru offline checker thread closed");
            }
        }

        public final void shutdownRequest() {
            this.m_ishutdown = true;
            this.interrupt();
        }

        public final void processOfflineServers() {
            this.interrupt();
        }
    }
}

