/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.server.auth.passthru;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.Socket;
import java.net.UnknownHostException;
import org.alfresco.filesys.smb.NetworkSession;
import org.alfresco.filesys.util.DataPacker;

public class TcpipSMBNetworkSession
implements NetworkSession {
    private static int _defTimeout = 30000;
    private Socket m_socket;
    private DataInputStream m_in;
    private DataOutputStream m_out;
    private int m_tmo = _defTimeout;
    private static boolean m_debug = false;
    private static PrintStream m_dbg = System.out;

    public TcpipSMBNetworkSession() {
    }

    public TcpipSMBNetworkSession(int tmo) {
        this.m_tmo = tmo;
    }

    public String getProtocolName() {
        return "Native SMB (port 445)";
    }

    public void Open(String toName, String fromName, String toAddr) throws IOException, UnknownHostException {
        this.m_socket = new Socket(toName, 445);
        this.m_socket.setSoTimeout(this.m_tmo);
        this.m_socket.setTcpNoDelay(true);
        this.m_in = new DataInputStream(this.m_socket.getInputStream());
        this.m_out = new DataOutputStream(this.m_socket.getOutputStream());
    }

    public boolean isConnected() {
        return this.m_socket != null;
    }

    public final boolean hasData() throws IOException {
        if (this.m_socket == null || this.m_in == null) {
            return false;
        }
        return this.m_in.available() > 0;
    }

    public int Receive(byte[] buf, int tmo) throws IOException {
        this.m_socket.setSoTimeout(tmo);
        int rdlen = this.m_in.read(buf, 0, 4);
        if (rdlen < 4) {
            throw new IOException("TCP/IP SMB Short Read");
        }
        int pktlen = DataPacker.getInt(buf, 0);
        if (m_debug) {
            m_dbg.println("TcpSMB: Rx " + pktlen + " bytes");
        }
        int totlen = 0;
        int offset = 4;
        while (pktlen > 0) {
            rdlen = this.m_in.read(buf, offset, pktlen);
            totlen += rdlen;
            pktlen -= rdlen;
            offset += rdlen;
        }
        return totlen;
    }

    public boolean Send(byte[] data, int siz) throws IOException {
        DataPacker.putInt(siz, data, 0);
        int len = siz + 4;
        this.m_out.write(data, 0, len);
        return true;
    }

    public void Close() throws IOException {
        if (this.m_in != null) {
            this.m_in.close();
            this.m_in = null;
        }
        if (this.m_out != null) {
            this.m_out.close();
            this.m_out = null;
        }
        if (this.m_socket != null) {
            this.m_socket.close();
            this.m_socket = null;
        }
    }

    public static void setDebug(boolean dbg) {
        m_debug = dbg;
    }

    public static final int getDefaultTimeout() {
        return _defTimeout;
    }

    public static final void setDefaultTimeout(int tmo) {
        _defTimeout = tmo;
    }
}

