/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.server.auth.spnego;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.DERApplicationSpecific;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERGeneralString;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUnknownTag;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NegTokenInit {
    private Oid[] m_mechTypes;
    private int m_contextFlags = -1;
    private byte[] m_mechToken;
    private String m_mecListMICPrincipal;

    public NegTokenInit() {
    }

    public NegTokenInit(Oid[] mechTypes, String mechPrinciple) {
        this.m_mechTypes = mechTypes;
        this.m_mecListMICPrincipal = mechPrinciple;
    }

    public NegTokenInit(Vector<Oid> mechTypes, String mechPrinciple) {
        this.m_mechTypes = new Oid[mechTypes.size()];
        for (int i = 0; i < mechTypes.size(); ++i) {
            this.m_mechTypes[i] = mechTypes.get(i);
        }
        this.m_mecListMICPrincipal = mechPrinciple;
    }

    public final Oid[] getOids() {
        return this.m_mechTypes;
    }

    public final int getContextFlags() {
        return this.m_contextFlags;
    }

    public final byte[] getMechtoken() {
        return this.m_mechToken;
    }

    public final String getPrincipal() {
        return this.m_mecListMICPrincipal;
    }

    public final boolean hasOid(Oid oid) {
        boolean foundOid = false;
        if (this.m_mechTypes != null) {
            foundOid = oid.containedIn(this.m_mechTypes);
        }
        return foundOid;
    }

    public final int numberOfOids() {
        return this.m_mechTypes != null ? this.m_mechTypes.length : 0;
    }

    public final Oid getOidAt(int idx) {
        if (this.m_mechTypes != null && idx >= 0 && idx < this.m_mechTypes.length) {
            return this.m_mechTypes[idx];
        }
        return null;
    }

    public void decode(byte[] buf, int off, int len) throws IOException {
        ByteArrayInputStream bytStream = new ByteArrayInputStream(buf, off, len);
        ASN1InputStream asnStream = new ASN1InputStream((InputStream)bytStream);
        DERObject derObj = asnStream.readObject();
        if (!(derObj instanceof DERApplicationSpecific)) {
            throw new IOException("Bad blob format (AppSpec)");
        }
        DERApplicationSpecific derApp = (DERApplicationSpecific)derObj;
        ByteArrayInputStream appStream = new ByteArrayInputStream(derApp.getContents());
        ASN1InputStream asnAppStream = new ASN1InputStream((InputStream)appStream);
        if (!((derObj = asnAppStream.readObject()) instanceof DERObjectIdentifier)) {
            throw new IOException("Bad blob format (SPNEGO OID)");
        }
        DERObjectIdentifier derOid = (DERObjectIdentifier)derObj;
        if (!derOid.getId().equals("1.3.6.1.5.5.2")) {
            throw new IOException("Not an SPNEGO blob");
        }
        derObj = asnAppStream.readObject();
        if (!(derObj instanceof DERTaggedObject)) {
            throw new IOException("Bad blob format, tagged object missing");
        }
        DERTaggedObject derTagSeq = (DERTaggedObject)derObj;
        if (derTagSeq.getTagNo() != 0 || !(derTagSeq.getObject() instanceof DERSequence)) {
            throw new IOException("Bad blob format, sequence missing");
        }
        DERSequence negTokInitSeq = (DERSequence)derTagSeq.getObject();
        Enumeration seqEnum = negTokInitSeq.getObjects();
        while (seqEnum.hasMoreElements()) {
            derObj = (DERObject)seqEnum.nextElement();
            if (derObj instanceof DERTaggedObject) {
                DERSequence derSeq;
                DERTaggedObject derTag = (DERTaggedObject)derObj;
                if (derTag.getTagNo() == 0 && derTag.getObject() instanceof DERSequence) {
                    derSeq = (DERSequence)derTag.getObject();
                    Enumeration typesEnum = derSeq.getObjects();
                    this.m_mechTypes = new Oid[derSeq.size()];
                    int idx = 0;
                    while (typesEnum.hasMoreElements()) {
                        derObj = (DERObject)typesEnum.nextElement();
                        if (!(derObj instanceof DERObjectIdentifier)) continue;
                        derOid = (DERObjectIdentifier)derObj;
                        try {
                            this.m_mechTypes[idx++] = new Oid(derOid.getId());
                        }
                        catch (GSSException ex) {
                            throw new IOException("Bad mechType OID");
                        }
                    }
                    continue;
                }
                if (derTag.getTagNo() == 1 && derTag.getObject() instanceof DERBitString) continue;
                if (derTag.getTagNo() == 2 && derTag.getObject() instanceof DEROctetString) {
                    DEROctetString derStr = (DEROctetString)derTag.getObject();
                    this.m_mechToken = derStr.getOctets();
                    continue;
                }
                if (derTag.getTagNo() == 3 && derTag.getObject() instanceof DEROctetString) continue;
                if (derTag.getTagNo() == 3 && derTag.getObject() instanceof DERSequence) {
                    derSeq = (DERSequence)derTag.getObject();
                    Enumeration subEnum = derSeq.getObjects();
                    while (subEnum.hasMoreElements()) {
                        derObj = (DERObject)subEnum.nextElement();
                        System.out.println("mechListMIC Seq: " + derObj);
                    }
                    continue;
                }
                throw new IOException("Bad format, unexpected type");
            }
            throw new IOException("Bad format, untagged type");
        }
    }

    public byte[] encode() throws IOException {
        ByteArrayOutputStream tokStream = new ByteArrayOutputStream();
        DEROutputStream derOut = new DEROutputStream((OutputStream)tokStream);
        derOut.writeObject((Object)new DERObjectIdentifier("1.3.6.1.5.5.2"));
        ASN1EncodableVector asnList = new ASN1EncodableVector();
        ASN1EncodableVector mechTypesList = new ASN1EncodableVector();
        for (Oid mechType : this.m_mechTypes) {
            mechTypesList.add((DEREncodable)new DERObjectIdentifier(mechType.toString()));
        }
        asnList.add((DEREncodable)new DERTaggedObject(true, 0, (DEREncodable)new DERSequence((DEREncodableVector)mechTypesList)));
        if (this.m_mecListMICPrincipal != null) {
            ASN1EncodableVector micList = new ASN1EncodableVector();
            micList.add((DEREncodable)new DERTaggedObject(true, 0, (DEREncodable)new DERGeneralString(this.m_mecListMICPrincipal)));
            asnList.add((DEREncodable)new DERTaggedObject(true, 3, (DEREncodable)new DERSequence((DEREncodableVector)micList)));
        }
        derOut.writeObject((Object)new DERTaggedObject(true, 0, (DEREncodable)new DERSequence((DEREncodableVector)asnList)));
        DERUnknownTag token = new DERUnknownTag(96, tokStream.toByteArray());
        tokStream = new ByteArrayOutputStream();
        derOut = new DEROutputStream((OutputStream)tokStream);
        derOut.writeObject((Object)token);
        return tokStream.toByteArray();
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[NegTokenInit ");
        if (this.m_mechTypes != null) {
            str.append("mechTypes=");
            for (Oid oid : this.m_mechTypes) {
                str.append(oid.toString());
                str.append(",");
            }
        }
        if (this.m_contextFlags != -1) {
            str.append(" context=0x");
            str.append(Integer.toHexString(this.m_contextFlags));
        }
        if (this.m_mechToken != null) {
            str.append(" token=");
            str.append(this.m_mechToken.length);
            str.append(" bytes");
        }
        if (this.m_mecListMICPrincipal != null) {
            str.append(" principal=");
            str.append(this.m_mecListMICPrincipal);
        }
        str.append("]");
        return str.toString();
    }
}

