/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.server.auth.spnego;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import org.alfresco.filesys.server.auth.spnego.SPNEGO;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DEREnumerated;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;

public class NegTokenTarg {
    private int m_result;
    private Oid m_supportedMech;
    private byte[] m_responseToken;

    public NegTokenTarg() {
    }

    public NegTokenTarg(int result, Oid mech, byte[] response) {
        this.m_result = result;
        this.m_supportedMech = mech;
        this.m_responseToken = response;
    }

    public final int getResult() {
        return this.m_result;
    }

    public final Oid getSupportedMech() {
        return this.m_supportedMech;
    }

    public final boolean hasResponseToken() {
        return this.m_responseToken != null;
    }

    public final byte[] getResponseToken() {
        return this.m_responseToken;
    }

    public void decode(byte[] buf, int off, int len) throws IOException {
        ByteArrayInputStream bytStream = new ByteArrayInputStream(buf, off, len);
        ASN1InputStream asnStream = new ASN1InputStream((InputStream)bytStream);
        DERObject derObj = asnStream.readObject();
        if (!(derObj instanceof DERTaggedObject)) {
            throw new IOException("Bad blob format (Tagged)");
        }
        DERTaggedObject derTag = (DERTaggedObject)derObj;
        if (!(derTag.getObject() instanceof DERSequence)) {
            throw new IOException("Bad blob format (Seq)");
        }
        DERSequence derSeq = (DERSequence)derTag.getObject();
        Enumeration seqEnum = derSeq.getObjects();
        while (seqEnum.hasMoreElements()) {
            derObj = (DERObject)seqEnum.nextElement();
            if (derObj instanceof DERTaggedObject) {
                derTag = (DERTaggedObject)derObj;
                if (derTag.getTagNo() == 0 && derTag.getObject() instanceof DEREnumerated) {
                    DEREnumerated derEnum = (DEREnumerated)derTag.getObject();
                    this.m_result = derEnum.getValue().intValue();
                    continue;
                }
                if (derTag.getTagNo() == 1 && derTag.getObject() instanceof DERObjectIdentifier) {
                    DERObjectIdentifier derOid = (DERObjectIdentifier)derTag.getObject();
                    try {
                        this.m_supportedMech = new Oid(derOid.getId());
                    }
                    catch (GSSException ex) {}
                    continue;
                }
                if (derTag.getTagNo() == 2 && derTag.getObject() instanceof DEROctetString) {
                    DEROctetString derStr = (DEROctetString)derTag.getObject();
                    this.m_responseToken = derStr.getOctets();
                    continue;
                }
                if (derTag.getTagNo() == 3 && derTag.getObject() instanceof DEROctetString) continue;
                throw new IOException("Bad format, unexpected type");
            }
            throw new IOException("Bad format, untagged type");
        }
    }

    public byte[] encode() throws IOException {
        ByteArrayOutputStream tokStream = new ByteArrayOutputStream();
        DEROutputStream derOut = new DEROutputStream((OutputStream)tokStream);
        ASN1EncodableVector asnList = new ASN1EncodableVector();
        asnList.add((DEREncodable)new DERTaggedObject(true, 0, (DEREncodable)new DEREnumerated(this.m_result)));
        if (this.m_supportedMech != null) {
            asnList.add((DEREncodable)new DERTaggedObject(true, 1, (DEREncodable)new DERObjectIdentifier(this.m_supportedMech.toString())));
        }
        if (this.m_responseToken != null) {
            asnList.add((DEREncodable)new DERTaggedObject(true, 2, (DEREncodable)new DEROctetString(this.m_responseToken)));
        }
        derOut.writeObject((Object)new DERTaggedObject(true, 1, (DEREncodable)new DERSequence((DEREncodableVector)asnList)));
        return tokStream.toByteArray();
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[NegtokenTarg result=");
        str.append(SPNEGO.asResultString(this.getResult()));
        str.append(" oid=");
        str.append(this.getSupportedMech());
        str.append(" response=");
        if (this.hasResponseToken()) {
            str.append(this.getResponseToken().length);
            str.append(" bytes");
        } else {
            str.append("null");
        }
        str.append("]");
        return str.toString();
    }
}

