/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.server.auth.spnego;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.DERApplicationSpecific;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERTaggedObject;

public class SPNEGO {
    public static final int NegTokenInit = 0;
    public static final int NegTokenTarg = 1;
    public static final int ContextDelete = 0;
    public static final int ContextMutual = 1;
    public static final int ContextReplay = 2;
    public static final int ContextSequence = 3;
    public static final int ContextAnon = 4;
    public static final int ContextConf = 5;
    public static final int ContextInteg = 6;
    public static final int AcceptCompleted = 0;
    public static final int AcceptIncomplete = 1;
    public static final int Reject = 2;

    public static String asResultString(int res) {
        String resStr = null;
        switch (res) {
            case 0: {
                resStr = "AcceptCompleted";
                break;
            }
            case 1: {
                resStr = "AcceptIncomplete";
                break;
            }
            case 2: {
                resStr = "Reject";
                break;
            }
            default: {
                resStr = "" + res;
            }
        }
        return resStr;
    }

    public static int checkTokenType(byte[] buf, int off, int len) throws IOException {
        DERTaggedObject derTag;
        ByteArrayInputStream bytStream = new ByteArrayInputStream(buf, off, len);
        ASN1InputStream asnStream = new ASN1InputStream((InputStream)bytStream);
        DERObject derObj = asnStream.readObject();
        int tokType = -1;
        if (derObj instanceof DERApplicationSpecific) {
            tokType = 0;
        } else if (derObj instanceof DERTaggedObject && (derTag = (DERTaggedObject)derObj).getTagNo() == 1) {
            tokType = 1;
        }
        asnStream.close();
        bytStream.close();
        return tokType;
    }
}

