/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.server.config;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;
import net.sf.acegisecurity.AuthenticationManager;
import org.alfresco.config.Config;
import org.alfresco.config.ConfigElement;
import org.alfresco.config.ConfigLookupContext;
import org.alfresco.config.ConfigService;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.filesys.ftp.FTPPath;
import org.alfresco.filesys.ftp.InvalidPathException;
import org.alfresco.filesys.netbios.NetBIOSName;
import org.alfresco.filesys.netbios.NetBIOSNameList;
import org.alfresco.filesys.netbios.NetBIOSSession;
import org.alfresco.filesys.netbios.win32.Win32NetBIOS;
import org.alfresco.filesys.server.NetworkServer;
import org.alfresco.filesys.server.NetworkServerList;
import org.alfresco.filesys.server.auth.CifsAuthenticator;
import org.alfresco.filesys.server.auth.acl.ACLParseException;
import org.alfresco.filesys.server.auth.acl.AccessControlList;
import org.alfresco.filesys.server.auth.acl.AccessControlManager;
import org.alfresco.filesys.server.auth.acl.AccessControlParser;
import org.alfresco.filesys.server.auth.acl.DefaultAccessControlManager;
import org.alfresco.filesys.server.auth.acl.InvalidACLTypeException;
import org.alfresco.filesys.server.config.InvalidConfigurationException;
import org.alfresco.filesys.server.core.DeviceContext;
import org.alfresco.filesys.server.core.DeviceContextException;
import org.alfresco.filesys.server.core.ShareMapper;
import org.alfresco.filesys.server.core.SharedDevice;
import org.alfresco.filesys.server.core.SharedDeviceList;
import org.alfresco.filesys.server.filesys.DefaultShareMapper;
import org.alfresco.filesys.server.filesys.DiskDeviceContext;
import org.alfresco.filesys.server.filesys.DiskInterface;
import org.alfresco.filesys.server.filesys.DiskSharedDevice;
import org.alfresco.filesys.server.filesys.HomeShareMapper;
import org.alfresco.filesys.util.IPAddress;
import org.alfresco.filesys.util.X64;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.NTLMMode;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerConfiguration
implements ApplicationListener {
    private static final Log logger = LogFactory.getLog((String)"org.alfresco.smb.protocol");
    private static final String ConfigArea = "file-servers";
    private static final String ConfigCIFS = "CIFS Server";
    private static final String ConfigFTP = "FTP Server";
    private static final String ConfigFilesystems = "Filesystems";
    private static final String ConfigSecurity = "Filesystem Security";
    public static final String SERVER_CONFIGURATION = "fileServerConfiguration";
    private static final String[] m_sessDbgStr = new String[]{"NETBIOS", "STATE", "NEGOTIATE", "TREE", "SEARCH", "INFO", "FILE", "FILEIO", "TRANSACT", "ECHO", "ERROR", "IPC", "LOCK", "PKTTYPE", "DCERPC", "STATECACHE", "NOTIFY", "STREAMS", "SOCKET"};
    private static final String[] m_ftpDebugStr = new String[]{"STATE", "SEARCH", "INFO", "FILE", "FILEIO", "ERROR", "PKTTYPE", "TIMING", "DATAPORT", "DIRECTORY"};
    private static final int DefaultFTPServerPort = 21;
    private static final String DefaultFTPAnonymousAccount = "anonymous";
    private static final String TokenLocalName = "${localname}";
    private AuthenticationManager authenticationManager;
    private ConfigService configService;
    private DiskInterface diskInterface;
    private PlatformType m_platform = PlatformType.Unknown;
    private boolean m_smbEnable = true;
    private boolean m_ftpEnable = true;
    private String m_name;
    private int m_srvType = 4099;
    private NetworkServerList m_serverList;
    private String m_comment;
    private String m_domain;
    private String m_broadcast;
    private boolean m_announce;
    private int m_announceInterval;
    private SharedDeviceList m_shareList = new SharedDeviceList();
    private CifsAuthenticator m_authenticator;
    private ShareMapper m_shareMapper = new DefaultShareMapper();
    private AccessControlManager m_aclManager;
    private AccessControlList m_globalACLs;
    private boolean m_nbDebug = false;
    private boolean m_announceDebug = false;
    private int m_sessDebug;
    private boolean m_netBIOSEnable = true;
    private boolean m_tcpSMBEnable = false;
    private boolean m_win32NBEnable = false;
    private InetAddress m_smbBindAddress;
    private InetAddress m_nbBindAddress;
    private InetAddress m_winsPrimary;
    private InetAddress m_winsSecondary;
    private boolean m_macExtensions;
    private String m_win32NBName;
    private int m_win32NBLANA = -1;
    private boolean m_win32NBAnnounce = false;
    private int m_win32NBAnnounceInterval;
    private boolean m_win32NBUseWinsock = true;
    private InetAddress m_ftpBindAddress;
    private int m_ftpPort = 21;
    private boolean m_ftpAllowAnonymous;
    private String m_ftpAnonymousAccount;
    private String m_ftpRootPath;
    private int m_ftpDebug;
    private String m_timeZone;
    private int m_tzOffset;
    private String m_jceProviderClass;
    private String m_localName;
    private String m_localDomain;
    private boolean initialised;
    private AuthenticationService authenticationService;
    private AuthenticationComponent m_authenticationComponent;
    private NodeService m_nodeService;
    private PersonService m_personService;
    private TransactionService m_transactionService;

    public ServerConfiguration() {
        try {
            this.m_shareMapper.initializeMapper(this, null);
        }
        catch (InvalidConfigurationException ex) {
            throw new AlfrescoRuntimeException("Failed to initialise share mapper", (Throwable)ex);
        }
        this.m_aclManager = new DefaultAccessControlManager();
        this.m_aclManager.initialize(this, null);
        try {
            this.setTimeZone(TimeZone.getDefault().getID());
        }
        catch (Exception ex) {
            throw new AlfrescoRuntimeException("Failed to set timezone", (Throwable)ex);
        }
        this.m_serverList = new NetworkServerList();
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public void setConfigService(ConfigService configService) {
        this.configService = configService;
    }

    public void setDiskInterface(DiskInterface diskInterface) {
        this.diskInterface = diskInterface;
    }

    public void setAuthenticationComponent(AuthenticationComponent component) {
        this.m_authenticationComponent = component;
    }

    public void setNodeService(NodeService service) {
        this.m_nodeService = service;
    }

    public void setPersonService(PersonService service) {
        this.m_personService = service;
    }

    public void setTransactionService(TransactionService service) {
        this.m_transactionService = service;
    }

    public boolean isInitialised() {
        return this.initialised;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextRefreshedEvent) {
            this.init();
        }
    }

    public void init() {
        if (this.authenticationManager == null) {
            throw new AlfrescoRuntimeException("Property 'authenticationManager' not set");
        }
        if (this.m_authenticationComponent == null) {
            throw new AlfrescoRuntimeException("Property 'authenticationComponent' not set");
        }
        if (this.authenticationService == null) {
            throw new AlfrescoRuntimeException("Property 'authenticationService' not set");
        }
        if (this.m_nodeService == null) {
            throw new AlfrescoRuntimeException("Property 'nodeService' not set");
        }
        if (this.m_personService == null) {
            throw new AlfrescoRuntimeException("Property 'personService' not set");
        }
        if (this.m_transactionService == null) {
            throw new AlfrescoRuntimeException("Property 'transactionService' not set");
        }
        if (this.diskInterface == null) {
            throw new AlfrescoRuntimeException("Property 'diskInterface' not set");
        }
        if (this.configService == null) {
            throw new AlfrescoRuntimeException("Property 'configService' not set");
        }
        this.initialised = false;
        ConfigLookupContext configCtx = new ConfigLookupContext(ConfigArea);
        this.determinePlatformType();
        try {
            Config config = this.configService.getConfig((Object)ConfigCIFS, configCtx);
            this.processCIFSServerConfig(config);
            config = this.configService.getConfig((Object)ConfigFTP, configCtx);
            this.processFTPServerConfig(config);
            config = this.configService.getConfig((Object)ConfigSecurity, configCtx);
            this.processSecurityConfig(config);
            config = this.configService.getConfig((Object)ConfigFilesystems, configCtx);
            this.processFilesystemsConfig(config);
            this.initialised = true;
        }
        catch (UnsatisfiedLinkError ex) {
            logger.error((Object)"Error accessing Win32 NetBIOS, check DLL is on the path");
            this.setNetBIOSSMB(false);
            this.setTcpipSMB(false);
            this.setWin32NetBIOS(false);
            this.setSMBServerEnabled(false);
        }
        catch (Throwable ex) {
            logger.error((Object)("File server configuration error, " + ex.getMessage()), ex);
            this.setNetBIOSSMB(false);
            this.setTcpipSMB(false);
            this.setWin32NetBIOS(false);
            this.setSMBServerEnabled(false);
        }
    }

    private final void determinePlatformType() {
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Windows")) {
            this.m_platform = PlatformType.WINDOWS;
        } else if (osName.equalsIgnoreCase("Linux")) {
            this.m_platform = PlatformType.LINUX;
        } else if (osName.startsWith("Mac OS X")) {
            this.m_platform = PlatformType.MACOSX;
        } else if (osName.startsWith("Solaris")) {
            this.m_platform = PlatformType.SOLARIS;
        }
    }

    public final PlatformType getPlatformType() {
        return this.m_platform;
    }

    private final void processCIFSServerConfig(Config config) {
        ConfigElement elem;
        block87: {
            String winsServers;
            EnumSet<PlatformType> enabledPlatforms;
            String platformsStr;
            String interval;
            if (config == null || config.getConfigElements().isEmpty()) {
                this.setSMBServerEnabled(false);
                return;
            }
            elem = config.getConfigElement("broadcast");
            if (elem != null) {
                if (!IPAddress.isNumericAddress(elem.getValue())) {
                    throw new AlfrescoRuntimeException("Invalid broadcast mask, must be n.n.n.n format");
                }
                this.setBroadcastMask(elem.getValue());
            }
            if ((elem = config.getConfigElement("host")) == null) {
                throw new AlfrescoRuntimeException("CIFS server host settings not specified");
            }
            String hostName = elem.getAttribute("name");
            if (hostName == null || hostName.length() == 0) {
                throw new AlfrescoRuntimeException("Host name not specified or invalid");
            }
            int pos = hostName.indexOf(TokenLocalName);
            if (pos != -1) {
                String srvName = this.getLocalServerName(true);
                StringBuilder hostStr = new StringBuilder();
                hostStr.append(hostName.substring(0, pos));
                hostStr.append(srvName);
                if ((pos += TokenLocalName.length()) < hostName.length()) {
                    hostStr.append(hostName.substring(pos));
                }
                if ((hostName = hostStr.toString()).equals(srvName)) {
                    throw new AlfrescoRuntimeException("CIFS server name must be unique");
                }
            }
            this.setServerName(hostName.toUpperCase());
            String domain = elem.getAttribute("domain");
            if (domain != null && domain.length() > 0) {
                this.setDomainName(domain.toUpperCase());
            } else {
                String localDomain = this.getLocalDomainName();
                if (localDomain == null && this.getPlatformType() != PlatformType.WINDOWS) {
                    localDomain = "WORKGROUP";
                    logger.error((Object)("Failed to get local domain/workgroup name, using default of " + localDomain));
                    logger.error((Object)"(This may be due to firewall settings or incorrect <broadcast> setting)");
                }
                this.setDomainName(localDomain);
            }
            elem = config.getConfigElement("comment");
            if (elem != null) {
                this.setComment(elem.getValue());
            }
            if ((elem = config.getConfigElement("bindto")) != null) {
                String bindText = elem.getValue();
                try {
                    InetAddress bindAddr = InetAddress.getByName(bindText);
                    this.setSMBBindAddress(bindAddr);
                }
                catch (UnknownHostException ex) {
                    throw new AlfrescoRuntimeException("Invalid CIFS server bind address");
                }
            }
            if ((elem = config.getConfigElement("hostAnnounce")) != null) {
                interval = elem.getAttribute("interval");
                if (interval != null && interval.length() > 0) {
                    try {
                        this.setHostAnnounceInterval(Integer.parseInt(interval));
                    }
                    catch (NumberFormatException ex) {
                        throw new AlfrescoRuntimeException("Invalid host announcement interval");
                    }
                }
                if (this.getDomainName() == null) {
                    throw new AlfrescoRuntimeException("Domain name must be specified if host announcement is enabled");
                }
                this.setHostAnnouncer(true);
            }
            if ((elem = config.getConfigElement("netBIOSSMB")) != null) {
                platformsStr = elem.getAttribute("platforms");
                boolean platformOK = false;
                if (platformsStr != null) {
                    enabledPlatforms = this.parsePlatformString(platformsStr);
                    if (enabledPlatforms.contains((Object)this.getPlatformType())) {
                        platformOK = true;
                    }
                } else {
                    platformOK = true;
                }
                if (this.getBroadcastMask() == null) {
                    throw new AlfrescoRuntimeException("Network broadcast mask not specified");
                }
                this.setNetBIOSSMB(platformOK);
                String bindto = elem.getAttribute("bindto");
                if (bindto != null && bindto.length() > 0) {
                    try {
                        InetAddress bindAddr = InetAddress.getByName(bindto);
                        this.setNetBIOSBindAddress(bindAddr);
                    }
                    catch (UnknownHostException ex) {
                        throw new AlfrescoRuntimeException("Invalid NetBIOS bind address");
                    }
                }
                if (this.hasSMBBindAddress()) {
                    this.setNetBIOSBindAddress(this.getSMBBindAddress());
                } else {
                    int i;
                    InetAddress[] addrs = null;
                    try {
                        addrs = InetAddress.getAllByName(InetAddress.getLocalHost().getHostName());
                    }
                    catch (UnknownHostException ex) {
                        logger.error((Object)"Failed to get local address list", (Throwable)ex);
                    }
                    int addrCnt = 0;
                    if (addrs != null) {
                        for (i = 0; i < addrs.length; ++i) {
                            if (addrs[i].getHostAddress().equals("127.0.0.1") || addrs[i].getHostAddress().equals("0.0.0.0")) continue;
                            ++addrCnt;
                        }
                    }
                    if (addrCnt == 0) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"Local address list dump :-");
                            if (addrs != null) {
                                for (i = 0; i < addrs.length; ++i) {
                                    logger.debug((Object)("  Address: " + addrs[i]));
                                }
                            } else {
                                logger.debug((Object)"  No addresses");
                            }
                        }
                        throw new AlfrescoRuntimeException("Failed to get IP address(es) for the local server, check hosts file and/or DNS setup");
                    }
                }
            } else {
                this.setNetBIOSSMB(false);
            }
            elem = config.getConfigElement("tcpipSMB");
            if (elem != null) {
                platformsStr = elem.getAttribute("platforms");
                boolean platformOK = false;
                if (platformsStr != null) {
                    enabledPlatforms = this.parsePlatformString(platformsStr);
                    if (enabledPlatforms.contains((Object)this.getPlatformType())) {
                        platformOK = true;
                    }
                } else {
                    platformOK = true;
                }
                this.setTcpipSMB(platformOK);
            } else {
                this.setTcpipSMB(false);
            }
            elem = config.getConfigElement("Win32NetBIOS");
            if (elem != null) {
                String osName;
                String nativeAPI;
                String lanaStr;
                String win32Name = elem.getAttribute("name");
                if (win32Name != null && win32Name.length() > 0) {
                    if (win32Name.length() > 16) {
                        throw new AlfrescoRuntimeException("Invalid Win32 NetBIOS name, " + win32Name);
                    }
                    this.setWin32NetBIOSName(win32Name);
                }
                if ((lanaStr = elem.getAttribute("lana")) != null && lanaStr.length() > 0) {
                    int lana = -1;
                    try {
                        lana = Integer.parseInt(lanaStr);
                    }
                    catch (NumberFormatException ex) {
                        throw new AlfrescoRuntimeException("Invalid win32 NetBIOS LANA specified");
                    }
                    if (lana < 0 || lana > 255) {
                        throw new AlfrescoRuntimeException("Invalid Win32 NetBIOS LANA number, " + lana);
                    }
                    this.setWin32LANA(lana);
                }
                if ((nativeAPI = elem.getAttribute("api")) != null && nativeAPI.length() > 0) {
                    boolean useWinsock = true;
                    if (nativeAPI.equalsIgnoreCase("netbios")) {
                        useWinsock = false;
                    } else if (!nativeAPI.equalsIgnoreCase("winsock")) {
                        throw new AlfrescoRuntimeException("Invalid NetBIOS API type, spefify 'winsock' or 'netbios'");
                    }
                    this.setWin32WinsockNetBIOS(useWinsock);
                }
                if (this.useWinsockNetBIOS() && X64.isWindows64()) {
                    logger.warn((Object)"Using older Netbios() API code");
                    this.setWin32WinsockNetBIOS(false);
                }
                if ((osName = System.getProperty("os.name")).startsWith("Windows") && !osName.endsWith("95") && !osName.endsWith("98") && !osName.endsWith("ME")) {
                    if (Win32NetBIOS.LanaEnumerate() != null) {
                        this.setWin32NetBIOS(true);
                    } else {
                        logger.warn((Object)"No NetBIOS LANAs available");
                    }
                } else {
                    this.setWin32NetBIOS(false);
                }
            } else {
                this.setWin32NetBIOS(false);
            }
            elem = config.getConfigElement("Win32Announce");
            if (elem != null) {
                interval = elem.getAttribute("interval");
                if (interval != null && interval.length() > 0) {
                    try {
                        this.setWin32HostAnnounceInterval(Integer.parseInt(interval));
                    }
                    catch (NumberFormatException ex) {
                        throw new AlfrescoRuntimeException("Invalid host announcement interval");
                    }
                }
                if (this.getDomainName() == null) {
                    throw new AlfrescoRuntimeException("Domain name must be specified if host announcement is enabled");
                }
                this.setWin32HostAnnouncer(true);
            }
            if (!(this.hasNetBIOSSMB() || this.hasTcpipSMB() || this.hasWin32NetBIOS())) {
                throw new AlfrescoRuntimeException("NetBIOS SMB, TCP/IP SMB or Win32 NetBIOS must be enabled");
            }
            elem = config.getConfigElement("WINS");
            if (elem != null) {
                ConfigElement priWinsElem = elem.getChild("primary");
                if (priWinsElem == null || priWinsElem.getValue().length() == 0) {
                    throw new AlfrescoRuntimeException("No primary WINS server configured");
                }
                InetAddress primaryWINS = null;
                try {
                    primaryWINS = InetAddress.getByName(priWinsElem.getValue());
                }
                catch (UnknownHostException ex) {
                    throw new AlfrescoRuntimeException("Invalid primary WINS server address, " + priWinsElem.getValue());
                }
                ConfigElement secWinsElem = elem.getChild("secondary");
                InetAddress secondaryWINS = null;
                if (secWinsElem != null) {
                    try {
                        secondaryWINS = InetAddress.getByName(secWinsElem.getValue());
                    }
                    catch (UnknownHostException ex) {
                        throw new AlfrescoRuntimeException("Invalid secondary WINS server address, " + secWinsElem.getValue());
                    }
                }
                this.setPrimaryWINSServer(primaryWINS);
                if (secondaryWINS != null) {
                    this.setSecondaryWINSServer(secondaryWINS);
                }
                NetBIOSSession.setWINSServer(primaryWINS);
            } else if (this.hasNetBIOSSMB() && this.getPlatformType() == PlatformType.WINDOWS && (winsServers = Win32NetBIOS.getWINSServerList()) != null) {
                StringTokenizer tokens = new StringTokenizer(winsServers, ",");
                String addr = tokens.nextToken();
                try {
                    InetAddress winsAddr = InetAddress.getByName(addr);
                    Socket winsSocket = new Socket();
                    InetSocketAddress sockAddr = new InetSocketAddress(winsAddr, 137);
                    winsSocket.connect(sockAddr, 3000);
                    winsSocket.close();
                    this.setPrimaryWINSServer(winsAddr);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Configuring to use WINS server " + addr));
                    }
                }
                catch (UnknownHostException ex) {
                    throw new AlfrescoRuntimeException("Invalid auto WINS server address, " + addr);
                }
                catch (IOException ex) {
                    if (!logger.isDebugEnabled()) break block87;
                    logger.debug((Object)("Failed to connect to auto WINS server " + addr));
                }
            }
        }
        elem = config.getConfigElement("sessionDebug");
        if (elem != null) {
            String flags = elem.getAttribute("flags");
            int sessDbg = 0;
            if (flags != null) {
                flags = flags.toUpperCase();
                StringTokenizer token = new StringTokenizer(flags, ",");
                while (token.hasMoreTokens()) {
                    int idx;
                    String dbg = token.nextToken().trim();
                    for (idx = 0; idx < m_sessDbgStr.length && !m_sessDbgStr[idx].equalsIgnoreCase(dbg); ++idx) {
                    }
                    if (idx > m_sessDbgStr.length) {
                        throw new AlfrescoRuntimeException("Invalid session debug flag, " + dbg);
                    }
                    sessDbg += 1 << idx;
                }
            }
            this.setSessionDebugFlags(sessDbg);
        }
    }

    private final void processFTPServerConfig(Config config) {
        ConfigElement elem;
        block21: {
            if (config == null) {
                this.setFTPServerEnabled(false);
                return;
            }
            elem = config.getConfigElement("bindto");
            if (elem != null) {
                String bindText = elem.getValue();
                try {
                    InetAddress bindAddr = InetAddress.getByName(bindText);
                    this.setFTPBindAddress(bindAddr);
                }
                catch (UnknownHostException ex) {
                    throw new AlfrescoRuntimeException("Invalid FTP bindto address, " + elem.getValue());
                }
            }
            if ((elem = config.getConfigElement("port")) != null) {
                try {
                    this.setFTPPort(Integer.parseInt(elem.getValue()));
                    if (this.getFTPPort() <= 0 || this.getFTPPort() >= 65535) {
                        throw new AlfrescoRuntimeException("FTP server port out of valid range");
                    }
                    break block21;
                }
                catch (NumberFormatException ex) {
                    throw new AlfrescoRuntimeException("Invalid FTP server port");
                }
            }
            this.setFTPPort(21);
        }
        elem = config.getConfigElement("allowAnonymous");
        if (elem != null) {
            this.setAllowAnonymousFTP(true);
            String anonAcc = elem.getAttribute("user");
            if (anonAcc != null && anonAcc.length() > 0) {
                this.setAnonymousFTPAccount(anonAcc);
                if (this.getAnonymousFTPAccount() == null || this.getAnonymousFTPAccount().length() == 0) {
                    throw new AlfrescoRuntimeException("Anonymous FTP account invalid");
                }
            } else {
                this.setAnonymousFTPAccount(DefaultFTPAnonymousAccount);
            }
        } else {
            this.setAllowAnonymousFTP(false);
        }
        elem = config.getConfigElement("rootDirectory");
        if (elem != null) {
            String rootPath = elem.getValue();
            try {
                new FTPPath(rootPath);
                this.setFTPRootPath(rootPath);
            }
            catch (InvalidPathException ex) {
                throw new AlfrescoRuntimeException("Invalid FTP root directory, " + rootPath);
            }
        }
        if ((elem = config.getConfigElement("debug")) != null) {
            String flags = elem.getAttribute("flags");
            int ftpDbg = 0;
            if (flags != null) {
                flags = flags.toUpperCase();
                StringTokenizer token = new StringTokenizer(flags, ",");
                while (token.hasMoreTokens()) {
                    int idx;
                    String dbg = token.nextToken().trim();
                    for (idx = 0; idx < m_ftpDebugStr.length && !m_ftpDebugStr[idx].equalsIgnoreCase(dbg); ++idx) {
                    }
                    if (idx >= m_ftpDebugStr.length) {
                        throw new AlfrescoRuntimeException("Invalid FTP debug flag, " + dbg);
                    }
                    ftpDbg += 1 << idx;
                }
            }
            this.setFTPDebug(ftpDbg);
        }
    }

    private final void processFilesystemsConfig(Config config) {
        ConfigElement homeElem = config.getConfigElement("homeFolder");
        if (homeElem != null) {
            try {
                HomeShareMapper shareMapper = new HomeShareMapper();
                shareMapper.initializeMapper(this, homeElem);
                this.m_shareMapper = shareMapper;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Using home folder share mapper");
                }
            }
            catch (InvalidConfigurationException ex) {
                throw new AlfrescoRuntimeException("Failed to initialize home folder share mapper", (Throwable)ex);
            }
        }
        ConfigElement filesystems = config.getConfigElement("filesystems");
        ArrayList<ConfigElement> filesysElems = null;
        if (filesystems != null) {
            filesysElems = filesystems.getChildren();
        } else {
            ConfigElement filesysElem = config.getConfigElement("filesystem");
            if (filesysElem != null) {
                filesysElems = new ArrayList<ConfigElement>(1);
                filesysElems.add(filesysElem);
            }
            logger.warn((Object)"Old style file-servers.xml configuration being used");
        }
        if (filesysElems != null) {
            for (int i = 0; i < filesysElems.size(); ++i) {
                ConfigElement elem = (ConfigElement)filesysElems.get(i);
                String filesysName = elem.getAttribute("name");
                try {
                    DiskInterface filesysDriver = this.diskInterface;
                    DiskDeviceContext filesysContext = (DiskDeviceContext)filesysDriver.createContext(elem);
                    AccessControlList acls = null;
                    ConfigElement aclElem = elem.getChild("accessControl");
                    if (aclElem != null) {
                        acls = this.processAccessControlList(aclElem);
                    } else if (this.hasGlobalAccessControls()) {
                        acls = this.getGlobalAccessControls();
                    }
                    boolean changeNotify = elem.getChild("disableChangeNotification") == null;
                    DiskSharedDevice filesys = new DiskSharedDevice(filesysName, filesysDriver, filesysContext);
                    filesys.setAccessControlList(acls);
                    filesysContext.enableChangeHandler(changeNotify);
                    filesysContext.startFilesystem(filesys);
                    this.addShare(filesys);
                    continue;
                }
                catch (DeviceContextException ex) {
                    throw new AlfrescoRuntimeException("Error creating filesystem " + filesysName, (Throwable)ex);
                }
            }
        } else {
            logger.warn((Object)"No filesystems defined");
        }
    }

    private final void processSecurityConfig(Config config) {
        ConfigElement jceElem;
        AccessControlList acls;
        ConfigElement globalACLs = config.getConfigElement("globalAccessControl");
        if (globalACLs != null && (acls = this.processAccessControlList(globalACLs)) != null) {
            this.setGlobalAccessControls(acls);
        }
        if ((jceElem = config.getConfigElement("JCEProvider")) != null) {
            this.setJCEProvider(jceElem.getValue());
        } else {
            this.setJCEProvider("cryptix.jce.provider.CryptixCrypto");
        }
        ConfigElement authElem = config.getConfigElement("authenticator");
        if (authElem != null) {
            String authType = authElem.getAttribute("type");
            if (authType == null) {
                authType = "alfresco";
            }
            NTLMMode ntlmMode = this.m_authenticationComponent.getNTLMMode();
            CifsAuthenticator auth = null;
            if (authType.equalsIgnoreCase("passthru")) {
                if (ntlmMode != NTLMMode.NONE) {
                    throw new AlfrescoRuntimeException("Wrong authentication setup for passthru authenticator");
                }
                auth = this.loadAuthenticatorClass("org.alfresco.filesys.server.auth.passthru.PassthruAuthenticator");
                if (auth == null) {
                    throw new AlfrescoRuntimeException("Failed to load passthru authenticator");
                }
            } else if (authType.equalsIgnoreCase("alfresco")) {
                if (ntlmMode == NTLMMode.NONE) {
                    throw new AlfrescoRuntimeException("Wrong authentication setup for alfresco authenticator");
                }
                auth = this.loadAuthenticatorClass("org.alfresco.filesys.server.auth.ntlm.AlfrescoAuthenticator");
                if (auth == null) {
                    auth = this.loadAuthenticatorClass("org.alfresco.filesys.server.auth.AlfrescoAuthenticator");
                }
                if (auth == null) {
                    throw new AlfrescoRuntimeException("Failed to load Alfresco authenticator");
                }
            } else if (authType.equalsIgnoreCase("enterprise")) {
                auth = this.loadAuthenticatorClass("org.alfresco.filesys.server.auth.EnterpriseCifsAuthenticator");
                if (auth == null) {
                    throw new AlfrescoRuntimeException("Failed to load Enterprise authenticator");
                }
            } else {
                throw new AlfrescoRuntimeException("Invalid authenticator type, " + authType);
            }
            boolean allowGuest = authElem.getChild("allowGuest") != null;
            boolean mapGuest = authElem.getChild("mapUnknownUserToGuest") != null;
            this.setAuthenticator(auth, authElem, allowGuest);
            auth.setMapToGuest(mapGuest);
        }
    }

    private final AccessControlList processAccessControlList(ConfigElement aclsElem) {
        List aclElemList;
        if (this.getAccessControlManager() == null) {
            throw new AlfrescoRuntimeException("No access control manager configured");
        }
        AccessControlList acls = new AccessControlList();
        String attrib = aclsElem.getAttribute("default");
        if (attrib != null && attrib.length() > 0) {
            try {
                int access = AccessControlParser.parseAccessTypeString(attrib);
                acls.setDefaultAccessLevel(access);
            }
            catch (InvalidACLTypeException ex) {
                throw new AlfrescoRuntimeException("Default access level error", (Throwable)ex);
            }
            catch (ACLParseException ex) {
                throw new AlfrescoRuntimeException("Default access level error", (Throwable)ex);
            }
        }
        if ((aclElemList = aclsElem.getChildren()) != null && aclElemList.size() > 0) {
            for (int i = 0; i < aclsElem.getChildCount(); ++i) {
                ConfigElement curAclElem = (ConfigElement)aclElemList.get(i);
                try {
                    acls.addControl(this.getAccessControlManager().createAccessControl(curAclElem.getName(), curAclElem));
                    continue;
                }
                catch (InvalidACLTypeException ex) {
                    throw new AlfrescoRuntimeException("Invalid access control type - " + curAclElem.getName());
                }
                catch (ACLParseException ex) {
                    throw new AlfrescoRuntimeException("Access control parse error (" + curAclElem.getName() + ")", (Throwable)ex);
                }
            }
        }
        if (acls.getDefaultAccessLevel() == 0 && acls.numberOfControls() == 0) {
            throw new AlfrescoRuntimeException("Empty access control list and default access 'None' not allowed");
        }
        return acls;
    }

    private final EnumSet<PlatformType> parsePlatformString(String platformStr) {
        EnumSet<PlatformType> platformTypes = EnumSet.noneOf(PlatformType.class);
        if (platformStr == null || platformStr.length() == 0) {
            return platformTypes;
        }
        StringTokenizer token = new StringTokenizer(platformStr.toUpperCase(Locale.ENGLISH), ",");
        String typ = null;
        try {
            while (token.hasMoreTokens()) {
                typ = token.nextToken().trim();
                PlatformType platform = PlatformType.valueOf(typ);
                if (platform != PlatformType.Unknown) {
                    platformTypes.add(platform);
                    continue;
                }
                throw new AlfrescoRuntimeException("Invalid platform type, " + typ);
            }
        }
        catch (IllegalArgumentException ex) {
            throw new AlfrescoRuntimeException("Invalid platform type, " + typ);
        }
        return platformTypes;
    }

    public final boolean addShare(SharedDevice shr) {
        return this.m_shareList.addShare(shr);
    }

    public final synchronized void addServer(NetworkServer srv) {
        this.m_serverList.addServer(srv);
    }

    public final NetworkServer findServer(String proto) {
        return this.m_serverList.findServer(proto);
    }

    public final NetworkServer removeServer(String proto) {
        return this.m_serverList.removeServer(proto);
    }

    public final int numberOfServers() {
        return this.m_serverList.numberOfServers();
    }

    public final NetworkServer getServer(int idx) {
        return this.m_serverList.getServer(idx);
    }

    public final boolean hasAccessControlManager() {
        return this.m_aclManager != null;
    }

    public final AccessControlManager getAccessControlManager() {
        return this.m_aclManager;
    }

    public final AuthenticationManager getAuthenticationManager() {
        return this.authenticationManager;
    }

    public final boolean hasGlobalAccessControls() {
        return this.m_globalACLs != null;
    }

    public final AccessControlList getGlobalAccessControls() {
        return this.m_globalACLs;
    }

    public final CifsAuthenticator getAuthenticator() {
        return this.m_authenticator;
    }

    public final AuthenticationService getAuthenticationService() {
        return this.authenticationService;
    }

    public final AuthenticationComponent getAuthenticationComponent() {
        return this.m_authenticationComponent;
    }

    public final NodeService getNodeService() {
        return this.m_nodeService;
    }

    public final PersonService getPersonService() {
        return this.m_personService;
    }

    public final TransactionService getTransactionService() {
        return this.m_transactionService;
    }

    public final InetAddress getSMBBindAddress() {
        return this.m_smbBindAddress;
    }

    public final InetAddress getNetBIOSBindAddress() {
        return this.m_nbBindAddress;
    }

    public final String getBroadcastMask() {
        return this.m_broadcast;
    }

    public final String getComment() {
        return this.m_comment != null ? this.m_comment : "";
    }

    public final DiskInterface getDiskInterface() {
        return this.diskInterface;
    }

    public final String getDomainName() {
        return this.m_domain;
    }

    public final String getServerName() {
        return this.m_name;
    }

    public final int getServerType() {
        return this.m_srvType;
    }

    public final int getSessionDebugFlags() {
        return this.m_sessDebug;
    }

    public final SharedDeviceList getShares() {
        return this.m_shareList;
    }

    public final ShareMapper getShareMapper() {
        return this.m_shareMapper;
    }

    public final String getWin32ServerName() {
        return this.m_win32NBName;
    }

    public final boolean hasWin32EnableAnnouncer() {
        return this.m_win32NBAnnounce;
    }

    public final int getWin32HostAnnounceInterval() {
        return this.m_win32NBAnnounceInterval;
    }

    public final int getWin32LANA() {
        return this.m_win32NBLANA;
    }

    public final boolean useWinsockNetBIOS() {
        return this.m_win32NBUseWinsock;
    }

    public final String getTimeZone() {
        return this.m_timeZone;
    }

    public final int getTimeZoneOffset() {
        return this.m_tzOffset;
    }

    public final boolean hasPrimaryWINSServer() {
        return this.m_winsPrimary != null;
    }

    public final InetAddress getPrimaryWINSServer() {
        return this.m_winsPrimary;
    }

    public final boolean hasSecondaryWINSServer() {
        return this.m_winsSecondary != null;
    }

    public final InetAddress getSecondaryWINSServer() {
        return this.m_winsSecondary;
    }

    public final boolean hasSMBBindAddress() {
        return this.m_smbBindAddress != null;
    }

    public final boolean hasNetBIOSBindAddress() {
        return this.m_nbBindAddress != null;
    }

    public final boolean hasNetBIOSDebug() {
        return this.m_nbDebug;
    }

    public final boolean hasHostAnnounceDebug() {
        return this.m_announceDebug;
    }

    public final boolean hasEnableAnnouncer() {
        return this.m_announce;
    }

    public final int getHostAnnounceInterval() {
        return this.m_announceInterval;
    }

    public final String getJCEProvider() {
        return this.m_jceProviderClass;
    }

    public final String getLocalServerName(boolean trimDomain) {
        int pos;
        if (this.m_localName != null) {
            return this.m_localName;
        }
        String srvName = null;
        if (this.getPlatformType() == PlatformType.WINDOWS) {
            srvName = Win32NetBIOS.GetLocalNetBIOSName();
        } else {
            try {
                srvName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException ex) {
                // empty catch block
            }
        }
        if (trimDomain && srvName != null && (pos = srvName.indexOf(".")) != -1) {
            srvName = srvName.substring(0, pos);
        }
        this.m_localName = srvName;
        return srvName;
    }

    public final String getLocalDomainName() {
        if (this.m_localDomain != null) {
            return this.m_localDomain;
        }
        String domainName = null;
        if (this.getPlatformType() == PlatformType.WINDOWS) {
            domainName = Win32NetBIOS.GetLocalDomainName();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Local domain name is " + domainName + " (via JNI)"));
            }
        } else {
            NetBIOSName nbName = null;
            try {
                NetBIOSNameList nbNameList;
                nbName = NetBIOSSession.FindName("\u0001\u0002__MSBROWSE__\u0002", '\u0001', 5000);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Found browse master at " + nbName.getIPAddressString(0)));
                }
                if ((nbNameList = NetBIOSSession.FindNamesForAddress(nbName.getIPAddressString(0))) != null && (nbName = nbNameList.findName('\u001d', false)) != null) {
                    domainName = nbName.getName();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.m_localDomain = domainName;
        return domainName;
    }

    public final DiskSharedDevice getPrimaryFilesystem() {
        SharedDeviceList shares = this.getShares();
        DiskSharedDevice diskShare = null;
        if (shares != null && shares.numberOfShares() > 0) {
            Enumeration<SharedDevice> shareEnum = shares.enumerateShares();
            while (diskShare == null && shareEnum.hasMoreElements()) {
                SharedDevice curShare = shareEnum.nextElement();
                if (curShare.getType() != 0) continue;
                diskShare = (DiskSharedDevice)curShare;
            }
        }
        return diskShare;
    }

    public final boolean hasMacintoshExtensions() {
        return this.m_macExtensions;
    }

    public final boolean hasNetBIOSSMB() {
        return this.m_netBIOSEnable;
    }

    public final boolean hasTcpipSMB() {
        return this.m_tcpSMBEnable;
    }

    public final boolean hasWin32NetBIOS() {
        return this.m_win32NBEnable;
    }

    public final boolean isSMBServerEnabled() {
        return this.m_smbEnable;
    }

    public final void setSMBServerEnabled(boolean ena) {
        this.m_smbEnable = ena;
    }

    public final void setFTPServerEnabled(boolean ena) {
        this.m_ftpEnable = ena;
    }

    public final void setAuthenticator(CifsAuthenticator auth, ConfigElement params, boolean allowGuest) {
        auth.setAllowGuest(allowGuest);
        try {
            auth.initialize(this, params);
        }
        catch (InvalidConfigurationException ex) {
            throw new AlfrescoRuntimeException("Failed to initialize authenticator", (Throwable)ex);
        }
        this.m_authenticator = auth;
    }

    public final void setSMBBindAddress(InetAddress addr) {
        this.m_smbBindAddress = addr;
    }

    public final void setNetBIOSBindAddress(InetAddress addr) {
        this.m_nbBindAddress = addr;
    }

    public final void setBroadcastMask(String mask) {
        this.m_broadcast = mask;
        NetBIOSSession.setSubnetMask(mask);
    }

    public final void setComment(String comment) {
        this.m_comment = comment;
    }

    public final void setDomainName(String domain) {
        this.m_domain = domain;
    }

    public final void setHostAnnouncer(boolean b) {
        this.m_announce = b;
    }

    public final void setHostAnnounceInterval(int ival) {
        this.m_announceInterval = ival;
    }

    public final void setJCEProvider(String providerClass) {
        try {
            Object jceObj = Class.forName(providerClass).newInstance();
            if (!(jceObj instanceof Provider)) {
                throw new AlfrescoRuntimeException("JCE provider class is not a valid Provider class");
            }
            Provider jceProvider = (Provider)jceObj;
            this.m_jceProviderClass = providerClass;
            Security.addProvider(jceProvider);
        }
        catch (ClassNotFoundException ex) {
            throw new AlfrescoRuntimeException("JCE provider class " + providerClass + " not found");
        }
        catch (Exception ex) {
            throw new AlfrescoRuntimeException("JCE provider class error", (Throwable)ex);
        }
    }

    public final void setNetBIOSDebug(boolean ena) {
        this.m_nbDebug = ena;
    }

    public final void setHostAnnounceDebug(boolean ena) {
        this.m_announceDebug = ena;
    }

    public final void setServerName(String name) {
        this.m_name = name;
    }

    public final void setSessionDebugFlags(int flags) {
        this.m_sessDebug = flags;
    }

    public final void setGlobalAccessControls(AccessControlList acls) {
        this.m_globalACLs = acls;
    }

    public final void setNetBIOSSMB(boolean ena) {
        this.m_netBIOSEnable = ena;
    }

    public final void setTcpipSMB(boolean ena) {
        this.m_tcpSMBEnable = ena;
    }

    public final void setWin32NetBIOS(boolean ena) {
        this.m_win32NBEnable = ena;
    }

    public final void setWin32NetBIOSName(String name) {
        this.m_win32NBName = name;
    }

    public final void setWin32HostAnnouncer(boolean b) {
        this.m_win32NBAnnounce = b;
    }

    public final void setWin32LANA(int ival) {
        this.m_win32NBLANA = ival;
    }

    public final void setWin32HostAnnounceInterval(int ival) {
        this.m_win32NBAnnounceInterval = ival;
    }

    public final void setWin32WinsockNetBIOS(boolean useWinsock) {
        this.m_win32NBUseWinsock = useWinsock;
    }

    public final void setTimeZone(String name) throws InvalidConfigurationException {
        TimeZone tz = TimeZone.getTimeZone(name);
        if (tz == null) {
            throw new InvalidConfigurationException("Invalid timezone, " + name);
        }
        this.m_timeZone = name;
        this.m_tzOffset = -(tz.getRawOffset() / 60000);
    }

    public final void setTimeZoneOffset(int offset) {
        this.m_tzOffset = offset;
    }

    public final void setPrimaryWINSServer(InetAddress addr) {
        this.m_winsPrimary = addr;
    }

    public final void setSecondaryWINSServer(InetAddress addr) {
        this.m_winsSecondary = addr;
    }

    public final boolean isFTPServerEnabled() {
        return this.m_ftpEnable;
    }

    public final InetAddress getFTPBindAddress() {
        return this.m_ftpBindAddress;
    }

    public final int getFTPPort() {
        return this.m_ftpPort;
    }

    public final boolean allowAnonymousFTP() {
        return this.m_ftpAllowAnonymous;
    }

    public final String getAnonymousFTPAccount() {
        return this.m_ftpAnonymousAccount;
    }

    public final int getFTPDebug() {
        return this.m_ftpDebug;
    }

    public final boolean hasFTPRootPath() {
        return this.m_ftpRootPath != null;
    }

    public final String getFTPRootPath() {
        return this.m_ftpRootPath;
    }

    public final void setFTPBindAddress(InetAddress addr) {
        this.m_ftpBindAddress = addr;
    }

    public final void setFTPPort(int port) {
        this.m_ftpPort = port;
    }

    public final void setFTPRootPath(String path) {
        this.m_ftpRootPath = path;
    }

    public final void setAllowAnonymousFTP(boolean ena) {
        this.m_ftpAllowAnonymous = ena;
    }

    public final void setAnonymousFTPAccount(String acc) {
        this.m_ftpAnonymousAccount = acc;
    }

    public final void setFTPDebug(int dbg) {
        this.m_ftpDebug = dbg;
    }

    public final void closeConfiguration() {
        if (this.getAuthenticator() != null) {
            this.getAuthenticator().closeAuthenticator();
            this.m_authenticator = null;
        }
        if (this.getShares() != null && this.getShares().numberOfShares() > 0) {
            Enumeration<SharedDevice> shareEnum = this.getShares().enumerateShares();
            while (shareEnum.hasMoreElements()) {
                SharedDevice share = shareEnum.nextElement();
                DeviceContext devCtx = share.getContext();
                if (devCtx == null) continue;
                devCtx.CloseContext();
            }
        }
    }

    private final CifsAuthenticator loadAuthenticatorClass(String className) {
        CifsAuthenticator srvAuth;
        block3: {
            srvAuth = null;
            try {
                Object authObj = Class.forName(className).newInstance();
                if (authObj instanceof CifsAuthenticator) {
                    srvAuth = (CifsAuthenticator)authObj;
                }
            }
            catch (Exception ex) {
                if (!logger.isDebugEnabled()) break block3;
                logger.debug((Object)("Failed to load authenticator class " + className));
            }
        }
        return srvAuth;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PlatformType {
        Unknown,
        WINDOWS,
        LINUX,
        SOLARIS,
        MACOSX;

    }
}

