/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.server.core;

import org.alfresco.filesys.server.auth.acl.AccessControl;
import org.alfresco.filesys.server.auth.acl.AccessControlList;
import org.alfresco.filesys.server.core.DeviceContext;
import org.alfresco.filesys.server.core.DeviceInterface;
import org.alfresco.filesys.server.core.InvalidDeviceInterfaceException;
import org.alfresco.filesys.server.core.ShareType;

public class SharedDevice
implements Comparable {
    public static final int Admin = 1;
    public static final int Hidden = 2;
    public static final int ReadOnly = 4;
    public static final int Temporary = 8;
    private String m_name;
    private int m_type;
    private String m_comment;
    private DeviceInterface m_interface;
    private DeviceContext m_drvCtx;
    private int m_attrib;
    private int m_maxUses = -1;
    private int m_curUses;
    private AccessControlList m_acls;

    protected SharedDevice(String name, int typ, DeviceContext ctx) {
        this.setName(name);
        this.setType(typ);
        this.setContext(ctx);
    }

    public final int getAttributes() {
        return this.m_attrib;
    }

    public final boolean hasAccessControls() {
        return this.m_acls != null;
    }

    public final AccessControlList getAccessControls() {
        return this.m_acls;
    }

    public final boolean hasComment() {
        return this.m_comment != null;
    }

    public final String getComment() {
        return this.m_comment;
    }

    public final DeviceContext getContext() {
        return this.m_drvCtx;
    }

    public DeviceInterface getInterface() throws InvalidDeviceInterfaceException {
        return this.m_interface;
    }

    public final String getName() {
        return this.m_name;
    }

    public int getType() {
        return this.m_type;
    }

    public final int getCurrentConnectionCount() {
        return this.m_curUses;
    }

    public final int getMaximumConnectionCount() {
        return this.m_maxUses;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public final boolean isAdmin() {
        return (this.m_attrib & 1) != 0;
    }

    public final boolean isHidden() {
        return (this.m_attrib & 2) != 0;
    }

    public final boolean isReadOnly() {
        return (this.m_attrib & 4) != 0;
    }

    public final boolean isTemporary() {
        return (this.m_attrib & 8) != 0;
    }

    public final void setComment(String comm) {
        this.m_comment = comm;
    }

    public final void setAttributes(int attr) {
        this.m_attrib = attr;
    }

    protected void setContext(DeviceContext ctx) {
        this.m_drvCtx = ctx;
    }

    protected final void setInterface(DeviceInterface iface) {
        this.m_interface = iface;
    }

    protected final void setName(String name) {
        this.m_name = name;
    }

    protected final void setType(int typ) {
        this.m_type = typ;
    }

    public final void setMaximumConnectionCount(int maxConn) {
        this.m_maxUses = maxConn;
    }

    public final void setAccessControlList(AccessControlList acls) {
        this.m_acls = acls;
    }

    public final void addAccessControl(AccessControl acl) {
        if (this.m_acls == null) {
            this.m_acls = new AccessControlList();
        }
        this.m_acls.addControl(acl);
    }

    public final AccessControl removeAccessControl(int idx) {
        if (this.m_acls == null || idx < 0 || idx >= this.m_acls.numberOfControls()) {
            return null;
        }
        return this.m_acls.removeControl(idx);
    }

    public final void removeAllAccessControls() {
        if (this.m_acls != null) {
            this.m_acls.removeAllControls();
            this.m_acls = null;
        }
    }

    public DeviceContext createContext(String[] args) {
        return new DeviceContext(args[0]);
    }

    public synchronized void incrementConnectionCount() {
        ++this.m_curUses;
    }

    public synchronized void decrementConnectionCount() {
        --this.m_curUses;
    }

    public int compareTo(Object obj) {
        if (obj instanceof SharedDevice) {
            SharedDevice sd = (SharedDevice)obj;
            return this.getName().compareTo(sd.getName());
        }
        return -1;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SharedDevice) {
            SharedDevice shr = (SharedDevice)obj;
            if (this.getName().compareTo(shr.getName()) == 0) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[");
        str.append(this.getName());
        str.append(",");
        str.append(ShareType.TypeAsString(this.getType()));
        str.append(",");
        if (this.hasAccessControls()) {
            str.append("ACLs=");
            str.append(this.m_acls.numberOfControls());
        }
        if (this.isAdmin()) {
            str.append(",Admin");
        }
        if (this.isHidden()) {
            str.append(",Hidden");
        }
        if (this.isReadOnly()) {
            str.append(",ReadOnly");
        }
        if (this.isTemporary()) {
            str.append(",Temp");
        }
        if (this.getContext() != null && !this.getContext().isAvailable()) {
            str.append(",Offline");
        }
        if (this.m_drvCtx != null) {
            str.append(",");
            str.append(this.m_drvCtx.toString());
        }
        str.append("]");
        return str.toString();
    }
}

