/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.server.filesys;

import java.util.Enumeration;
import org.alfresco.config.ConfigElement;
import org.alfresco.filesys.server.SrvSession;
import org.alfresco.filesys.server.auth.InvalidUserException;
import org.alfresco.filesys.server.config.InvalidConfigurationException;
import org.alfresco.filesys.server.config.ServerConfiguration;
import org.alfresco.filesys.server.core.ShareMapper;
import org.alfresco.filesys.server.core.SharedDevice;
import org.alfresco.filesys.server.core.SharedDeviceList;

public class DefaultShareMapper
implements ShareMapper {
    private ServerConfiguration m_config;
    private boolean m_debug;

    public void initializeMapper(ServerConfiguration config, ConfigElement params) throws InvalidConfigurationException {
        this.m_config = config;
        if (params != null && params.getChild("debug") != null) {
            this.m_debug = true;
        }
    }

    public final boolean hasDebug() {
        return this.m_debug;
    }

    public SharedDevice findShare(String host, String name, int typ, SrvSession sess, boolean create) throws InvalidUserException {
        SharedDevice share = null;
        if (sess.hasDynamicShares()) {
            share = sess.getDynamicShareList().findShare(name, typ, true);
        }
        if (share == null && (share = this.m_config.getShares().findShare(name, typ, false)) == null) {
            share = this.m_config.getShares().findShare(name, typ, true);
        }
        if (share != null && share.getContext() != null && !share.getContext().isAvailable()) {
            share = null;
        }
        return share;
    }

    public void deleteShares(SrvSession sess) {
        if (!sess.hasDynamicShares()) {
            return;
        }
        SharedDeviceList shares = sess.getDynamicShareList();
        Enumeration<SharedDevice> enm = shares.enumerateShares();
        while (enm.hasMoreElements()) {
            SharedDevice shr = enm.nextElement();
            shr.getContext().CloseContext();
        }
        shares.removeAllShares();
    }

    public SharedDeviceList getShareList(String host, SrvSession sess, boolean allShares) {
        SharedDeviceList shrList = new SharedDeviceList(this.m_config.getShares());
        if (sess != null && sess.hasDynamicShares()) {
            shrList.addShares(sess.getDynamicShareList());
        }
        if (!allShares) {
            shrList.removeUnavailableShares();
        }
        return shrList;
    }

    public void closeMapper() {
    }
}

