/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.server.filesys;

import org.alfresco.filesys.server.core.DeviceContext;
import org.alfresco.filesys.server.core.DeviceContextException;
import org.alfresco.filesys.server.filesys.DiskSharedDevice;
import org.alfresco.filesys.server.filesys.SrvDiskInfo;
import org.alfresco.filesys.server.filesys.VolumeInfo;
import org.alfresco.filesys.smb.server.notify.NotifyChangeHandler;
import org.alfresco.filesys.smb.server.notify.NotifyRequest;

public class DiskDeviceContext
extends DeviceContext {
    private NotifyChangeHandler m_changeHandler;
    private VolumeInfo m_volumeInfo;
    private SrvDiskInfo m_diskInfo;
    private int m_filesysAttribs;
    private int m_deviceAttribs;

    public DiskDeviceContext() {
    }

    public DiskDeviceContext(String devName) {
        super(devName);
    }

    public final boolean hasVolumeInformation() {
        return this.m_volumeInfo != null;
    }

    public final VolumeInfo getVolumeInformation() {
        return this.m_volumeInfo;
    }

    public final boolean hasDiskInformation() {
        return this.m_diskInfo != null;
    }

    public final SrvDiskInfo getDiskInformation() {
        return this.m_diskInfo;
    }

    public final int getFilesystemAttributes() {
        return this.m_filesysAttribs;
    }

    public String getFilesystemType() {
        return "FAT";
    }

    public final int getDeviceAttributes() {
        return this.m_deviceAttribs;
    }

    public final boolean isCaseless() {
        return (this.m_filesysAttribs & 2) == 0;
    }

    public final void enableChangeHandler(boolean ena) {
        if (ena) {
            this.m_changeHandler = new NotifyChangeHandler(this);
        } else {
            if (this.m_changeHandler != null) {
                this.m_changeHandler.shutdownRequest();
            }
            this.m_changeHandler = null;
        }
    }

    public void CloseContext() {
        super.CloseContext();
    }

    public final boolean hasChangeHandler() {
        return this.m_changeHandler != null;
    }

    public final NotifyChangeHandler getChangeHandler() {
        return this.m_changeHandler;
    }

    public final void addNotifyRequest(NotifyRequest req) {
        this.m_changeHandler.addNotifyRequest(req);
    }

    public final void removeNotifyRequest(NotifyRequest req) {
        this.m_changeHandler.removeNotifyRequest(req);
    }

    public final void setVolumeInformation(VolumeInfo vol) {
        this.m_volumeInfo = vol;
    }

    public final void setDiskInformation(SrvDiskInfo disk) {
        this.m_diskInfo = disk;
    }

    public final void setFilesystemAttributes(int attrib) {
        this.m_filesysAttribs = attrib;
    }

    public final void setDeviceAttributes(int attrib) {
        this.m_deviceAttribs = attrib;
    }

    public void startFilesystem(DiskSharedDevice share) throws DeviceContextException {
    }
}

