/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.server.filesys;

public final class FileAction {
    public static final int FailIfExists = 0;
    public static final int OpenIfExists = 1;
    public static final int TruncateExisting = 2;
    public static final int CreateNotExist = 16;
    public static final int FileExisted = 1;
    public static final int FileCreated = 2;
    public static final int FileTruncated = 3;
    public static final int NTSupersede = 0;
    public static final int NTOpen = 1;
    public static final int NTCreate = 2;
    public static final int NTOpenIf = 3;
    public static final int NTOverwrite = 4;
    public static final int NTOverwriteIf = 5;

    public static final boolean createNotExists(int action) {
        return (action & 0x10) != 0;
    }

    public static final boolean openIfExists(int action) {
        return (action & 1) != 0;
    }

    public static final boolean truncateExistingFile(int action) {
        return (action & 2) != 0;
    }

    public static final String asString(int flags) {
        StringBuffer str = new StringBuffer();
        str.append("[0x");
        str.append(Integer.toHexString(flags));
        str.append(":");
        if (FileAction.openIfExists(flags)) {
            str.append("OpenExists|");
        }
        if (FileAction.truncateExistingFile(flags)) {
            str.append("Truncate|");
        }
        if (FileAction.createNotExists(flags)) {
            str.append("CreateNotExist");
        }
        str.append("]");
        return str.toString();
    }
}

