/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.server.filesys;

public final class FileAttribute {
    public static final int Normal = 0;
    public static final int ReadOnly = 1;
    public static final int Hidden = 2;
    public static final int System = 4;
    public static final int Volume = 8;
    public static final int Directory = 16;
    public static final int Archive = 32;
    public static final int NTReadOnly = 1;
    public static final int NTHidden = 2;
    public static final int NTSystem = 4;
    public static final int NTVolumeId = 8;
    public static final int NTDirectory = 16;
    public static final int NTArchive = 32;
    public static final int NTDevice = 64;
    public static final int NTNormal = 128;
    public static final int NTTemporary = 256;
    public static final int NTSparse = 512;
    public static final int NTReparsePoint = 1024;
    public static final int NTCompressed = 2048;
    public static final int NTOffline = 4096;
    public static final int NTIndexed = 8192;
    public static final int NTEncrypted = 16384;
    public static final int NTOpenNoRecall = 0x100000;
    public static final int NTOpenReparsePoint = 0x200000;
    public static final int NTPosixSemantics = 0x1000000;
    public static final int NTBackupSemantics = 0x2000000;
    public static final int NTDeleteOnClose = 0x4000000;
    public static final int NTSequentialScan = 0x8000000;
    public static final int NTRandomAccess = 0x10000000;
    public static final int NTNoBuffering = 0x20000000;
    public static final int NTOverlapped = 0x40000000;
    public static final int NTWriteThrough = Integer.MIN_VALUE;

    public static final boolean hasAttribute(int attr, int reqattr) {
        return (attr & reqattr) != 0;
    }

    public static final boolean isReadOnly(int attr) {
        return (attr & 1) != 0;
    }

    public static final boolean isDirectory(int attr) {
        return (attr & 0x10) != 0;
    }

    public static final boolean isHidden(int attr) {
        return (attr & 2) != 0;
    }

    public static final boolean isSystem(int attr) {
        return (attr & 4) != 0;
    }

    public static final boolean isArchived(int attr) {
        return (attr & 0x20) != 0;
    }
}

