/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.server.filesys;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.StringTokenizer;

public final class FileName {
    public static final char DOS_SEPERATOR = '\\';
    public static final String DOS_SEPERATOR_STR = "\\";
    public static final String NTFSStreamSeperator = ":";

    public static String buildPath(String dev, String path, String filename, char sep) {
        StringBuffer fullPath = new StringBuffer();
        if (dev != null) {
            fullPath.append(dev);
            if (dev.length() > 0 && dev.charAt(dev.length() - 1) != sep) {
                fullPath.append(sep);
            }
        }
        if (path != null) {
            if (fullPath.length() > 0 && path.length() > 0 && (path.charAt(0) == sep || path.charAt(0) == '\\')) {
                fullPath.append(path.substring(1));
            } else {
                fullPath.append(path);
            }
            if (path.length() > 0 && path.charAt(path.length() - 1) != sep && filename != null) {
                fullPath.append(sep);
            }
        }
        if (filename != null) {
            if (fullPath.length() > 0 && filename.length() > 0 && (filename.charAt(0) == sep || filename.charAt(0) == '\\')) {
                fullPath.append(filename.substring(1));
            } else {
                fullPath.append(filename);
            }
        }
        if (sep != '\\') {
            return FileName.convertSeperators(fullPath.toString(), sep);
        }
        return fullPath.toString();
    }

    public static String convertSeperators(String path, char sep) {
        if (path.indexOf(92) == -1) {
            return path;
        }
        StringBuffer newPath = new StringBuffer();
        int idx = 0;
        while (idx < path.length()) {
            char ch;
            if ((ch = path.charAt(idx++)) == '\\') {
                newPath.append(sep);
                continue;
            }
            newPath.append(ch);
        }
        return newPath.toString();
    }

    public static final String mapPath(String base, String path) throws FileNotFoundException {
        String pathCopy = path;
        if (pathCopy.length() > 0 && pathCopy.startsWith(DOS_SEPERATOR_STR)) {
            pathCopy = pathCopy.substring(1);
        }
        StringTokenizer token = new StringTokenizer(pathCopy, "\\/");
        int tokCnt = token.countTokens();
        String mappedPath = null;
        if (tokCnt > 0) {
            String[] fileList;
            String[] dirs = new String[token.countTokens()];
            int idx = 0;
            while (token.hasMoreTokens()) {
                dirs[idx++] = token.nextToken();
            }
            int maxDir = dirs.length;
            if (!path.endsWith(DOS_SEPERATOR_STR)) {
                --maxDir;
            }
            StringBuffer pathStr = new StringBuffer(base);
            if (!base.endsWith(File.separator)) {
                pathStr.append(File.separator);
            }
            int lastPos = pathStr.length();
            idx = 0;
            File lastDir = null;
            if (base != null && base.length() > 0) {
                lastDir = new File(base);
            }
            File curDir = null;
            while (idx < maxDir) {
                pathStr.append(dirs[idx]);
                pathStr.append(File.separator);
                curDir = new File(pathStr.toString());
                if (!curDir.exists()) {
                    if (lastDir == null) {
                        throw new FileNotFoundException();
                    }
                    fileList = lastDir.list();
                    if (fileList == null || fileList.length == 0) {
                        throw new FileNotFoundException();
                    }
                    boolean foundPath = false;
                    for (int fidx = 0; fidx < fileList.length && !foundPath; ++fidx) {
                        if (!fileList[fidx].equalsIgnoreCase(dirs[idx])) continue;
                        pathStr.setLength(lastPos);
                        pathStr.append(fileList[fidx]);
                        pathStr.append(File.separator);
                        curDir = new File(pathStr.toString());
                        if (!curDir.exists()) continue;
                        foundPath = true;
                        break;
                    }
                    if (!foundPath) {
                        throw new FileNotFoundException();
                    }
                }
                lastDir = curDir;
                lastPos = pathStr.length();
                ++idx;
            }
            if (!path.endsWith(DOS_SEPERATOR_STR)) {
                fileList = lastDir.list();
                String fileName = dirs[dirs.length - 1];
                if (fileList == null) {
                    throw new FileNotFoundException(path);
                }
                idx = 0;
                boolean foundFile = false;
                while (idx < fileList.length && !foundFile) {
                    if (fileList[idx].compareTo(fileName) == 0) {
                        foundFile = true;
                        continue;
                    }
                    ++idx;
                }
                if (!foundFile) {
                    idx = 0;
                    while (idx < fileList.length && !foundFile) {
                        if (fileList[idx].equalsIgnoreCase(fileName)) {
                            foundFile = true;
                            fileName = fileList[idx];
                            continue;
                        }
                        ++idx;
                    }
                }
                pathStr.append(fileName);
            }
            mappedPath = pathStr.toString();
        }
        return mappedPath;
    }

    public static final String removeFileName(String path) {
        int pos = path.lastIndexOf(92);
        if (pos != -1) {
            return path.substring(0, pos);
        }
        return "";
    }

    public static String[] splitPath(String path) {
        return FileName.splitPath(path, '\\', null);
    }

    public static String[] splitPath(String path, char sep) {
        return FileName.splitPath(path, sep, null);
    }

    public static String[] splitPath(String path, char sep, String[] list) {
        if (path == null) {
            throw new IllegalArgumentException("Path may not be null");
        }
        String[] pathStr = list;
        if (pathStr == null) {
            pathStr = new String[]{"", ""};
        }
        if (path.length() > 0) {
            int pos = path.lastIndexOf(sep);
            if (pos == -1 || pos == path.length() - 1) {
                pathStr[0] = path;
            } else {
                pathStr[1] = path.substring(pos + 1);
                pathStr[0] = pos == 0 ? path.substring(0, pos + 1) : path.substring(0, pos);
            }
        }
        return pathStr;
    }

    public static String[] splitAllPaths(String path) {
        if (path == null || path.length() == 0) {
            return null;
        }
        StringTokenizer token = new StringTokenizer(path, DOS_SEPERATOR_STR);
        String[] names = new String[token.countTokens()];
        int i = 0;
        while (i < names.length && token.hasMoreTokens()) {
            names[i++] = token.nextToken();
        }
        return names;
    }

    public static String[] splitPathStream(String path) {
        String[] pathStr = new String[3];
        FileName.splitPath(path, '\\', pathStr);
        if (pathStr[1] == null) {
            return pathStr;
        }
        int pos = pathStr[1].indexOf(NTFSStreamSeperator);
        if (pos != -1) {
            pathStr[2] = pathStr[1].substring(pos);
            pathStr[1] = pathStr[1].substring(0, pos);
        }
        return pathStr;
    }

    public static boolean containsStreamName(String path) {
        return path.indexOf(NTFSStreamSeperator) != -1;
    }

    public static final String normalizePath(String path) {
        int pos;
        String normPath = path;
        if (path.length() > 3 && (pos = path.lastIndexOf(92)) != -1) {
            String pathPart = path.substring(0, pos).toUpperCase();
            String namePart = path.substring(pos);
            normPath = pathPart + namePart;
        }
        return normPath;
    }

    public static final String makeRelativePath(String basePath, String fullPath) {
        int idx;
        if (basePath.length() == 0 || basePath.equals(DOS_SEPERATOR_STR)) {
            if (fullPath.length() > 0 && fullPath.charAt(0) == '\\') {
                return fullPath.substring(1);
            }
            return fullPath;
        }
        String[] baseNames = FileName.splitAllPaths(basePath);
        String[] fullNames = FileName.splitAllPaths(fullPath);
        if (baseNames != null && baseNames.length > 0 && fullNames != null && fullNames.length > 0 && !baseNames[0].equalsIgnoreCase(fullNames[0])) {
            return null;
        }
        for (idx = 0; idx < baseNames.length && idx < fullNames.length && baseNames[idx].equalsIgnoreCase(fullNames[idx]); ++idx) {
        }
        StringBuffer relPath = new StringBuffer(128);
        while (idx < fullNames.length) {
            relPath.append(fullNames[idx++]);
            if (idx >= fullNames.length) continue;
            relPath.append('\\');
        }
        return relPath.toString();
    }
}

