/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.server.filesys;

import java.util.Enumeration;
import org.alfresco.config.ConfigElement;
import org.alfresco.filesys.server.SrvSession;
import org.alfresco.filesys.server.auth.ClientInfo;
import org.alfresco.filesys.server.auth.InvalidUserException;
import org.alfresco.filesys.server.config.InvalidConfigurationException;
import org.alfresco.filesys.server.config.ServerConfiguration;
import org.alfresco.filesys.server.core.ShareMapper;
import org.alfresco.filesys.server.core.ShareType;
import org.alfresco.filesys.server.core.SharedDevice;
import org.alfresco.filesys.server.core.SharedDeviceList;
import org.alfresco.filesys.server.filesys.DiskInterface;
import org.alfresco.filesys.server.filesys.DiskSharedDevice;
import org.alfresco.filesys.server.filesys.SrvDiskInfo;
import org.alfresco.filesys.smb.server.repo.ContentContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HomeShareMapper
implements ShareMapper {
    private static final Log logger = LogFactory.getLog((String)"org.alfresco.smb.protocol");
    public static final String HOME_FOLDER_SHARE = "HOME";
    private ServerConfiguration m_config;
    private String m_homeShareName = "HOME";
    private boolean m_debug;

    public void initializeMapper(ServerConfiguration config, ConfigElement params) throws InvalidConfigurationException {
        this.m_config = config;
        String homeName = params.getAttribute("name");
        if (homeName != null && homeName.length() > 0) {
            this.m_homeShareName = homeName;
        }
        if (params != null && params.getChild("debug") != null) {
            this.m_debug = true;
        }
    }

    public final boolean hasDebug() {
        return this.m_debug;
    }

    public final String getHomeFolderName() {
        return this.m_homeShareName;
    }

    public SharedDeviceList getShareList(String host, SrvSession sess, boolean allShares) {
        ClientInfo client;
        if (sess != null && sess.hasClientInformation() && !sess.hasDynamicShares() && (client = sess.getClientInformation()).hasHomeFolder()) {
            DiskSharedDevice homeShare = this.createHomeDiskShare(client);
            sess.addDynamicShare(homeShare);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Added " + this.getHomeFolderName() + " share to list of shares for " + client.getUserName()));
            }
        }
        SharedDeviceList shrList = new SharedDeviceList(this.m_config.getShares());
        if (sess != null && sess.hasDynamicShares()) {
            shrList.addShares(sess.getDynamicShareList());
        }
        if (!allShares) {
            shrList.removeUnavailableShares();
        }
        return shrList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SharedDevice findShare(String tohost, String name, int typ, SrvSession sess, boolean create) throws Exception {
        SharedDevice share = null;
        if ((typ == 0 || typ == -1) && name.equalsIgnoreCase(this.getHomeFolderName()) && sess.getClientInformation() != null) {
            ClientInfo client = sess.getClientInformation();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Map share " + name + ", type=" + ShareType.TypeAsString(typ) + ", client=" + client));
            }
            if (client == null) throw new InvalidUserException("No home directory");
            if (!client.hasHomeFolder()) throw new InvalidUserException("No home directory");
            if (sess.hasDynamicShares()) {
                share = sess.getDynamicShareList().findShare(name, typ, false);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("  Reusing existing dynamic share for " + name));
                }
            }
            if (share == null && create) {
                DiskSharedDevice diskShare = this.createHomeDiskShare(client);
                sess.addDynamicShare(diskShare);
                share = diskShare;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("  Mapped share " + name + " to " + client.getHomeFolder()));
                }
            }
        } else {
            share = this.m_config.getShares().findShare(name, typ, false);
            if (share == null) {
                share = this.m_config.getShares().findShare(name, typ, true);
            }
        }
        if (share == null) return share;
        if (share.getContext() == null) return share;
        if (share.getContext().isAvailable()) return share;
        return null;
    }

    public void deleteShares(SrvSession sess) {
        if (!sess.hasDynamicShares()) {
            return;
        }
        SharedDeviceList shares = sess.getDynamicShareList();
        Enumeration<SharedDevice> enm = shares.enumerateShares();
        while (enm.hasMoreElements()) {
            SharedDevice shr = enm.nextElement();
            shr.getContext().CloseContext();
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("Deleted dynamic share " + shr));
        }
        shares.removeAllShares();
    }

    public void closeMapper() {
    }

    private final DiskSharedDevice createHomeDiskShare(ClientInfo client) {
        DiskInterface diskDrv = this.m_config.getDiskInterface();
        ContentContext diskCtx = new ContentContext("", "", client.getHomeFolder());
        diskCtx.setDiskInformation(new SrvDiskInfo(2560, 64, 512, 2304));
        return new DiskSharedDevice(this.getHomeFolderName(), diskDrv, diskCtx, 8);
    }
}

