/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.server.filesys;

import java.io.IOException;
import org.alfresco.filesys.locking.FileLock;
import org.alfresco.filesys.locking.FileLockList;

public abstract class NetworkFile {
    public static final int READONLY = 0;
    public static final int WRITEONLY = 1;
    public static final int READWRITE = 2;
    public static final int IOPending = 1;
    public static final int DeleteOnClose = 2;
    protected int m_fid;
    protected int m_dirId;
    protected long m_uniqueId;
    protected String m_name;
    protected String m_streamName;
    protected int m_streamId;
    protected String m_fullName;
    protected int m_attrib;
    protected long m_fileSize;
    protected long m_createDate;
    protected long m_modifyDate;
    protected long m_accessDate;
    protected int m_grantedAccess;
    protected boolean m_closed = true;
    protected int m_writeCount;
    private FileLockList m_lockList;
    private int m_flags;

    public NetworkFile(int fid) {
        this.m_fid = fid;
    }

    public NetworkFile(int fid, int did) {
        this.m_fid = fid;
        this.m_dirId = did;
    }

    public NetworkFile(int fid, int stid, int did) {
        this.m_fid = fid;
        this.m_streamId = stid;
        this.m_dirId = did;
    }

    public NetworkFile(String name) {
        this.m_name = name;
    }

    public final int getDirectoryId() {
        return this.m_dirId;
    }

    public final int getFileAttributes() {
        return this.m_attrib;
    }

    public final int getFileId() {
        return this.m_fid;
    }

    public final long getFileSize() {
        return this.m_fileSize;
    }

    public final int getFileSizeInt() {
        return (int)(this.m_fileSize & 0xFFFFFFFFL);
    }

    public final String getFullName() {
        return this.m_fullName;
    }

    public final String getFullNameStream() {
        if (this.isStream()) {
            return this.m_fullName + this.m_streamName;
        }
        return this.m_fullName;
    }

    public final int getGrantedAccess() {
        return this.m_grantedAccess;
    }

    public String getName() {
        return this.m_name;
    }

    public final int getStreamId() {
        return this.m_streamId;
    }

    public final String getStreamName() {
        return this.m_streamName;
    }

    public final long getUniqueId() {
        return this.m_uniqueId;
    }

    public final boolean isClosed() {
        return this.m_closed;
    }

    public final boolean isDirectory() {
        return (this.m_attrib & 0x10) != 0;
    }

    public final boolean isHidden() {
        return (this.m_attrib & 2) != 0;
    }

    public final boolean isReadOnly() {
        return (this.m_attrib & 1) != 0;
    }

    public final boolean isSystem() {
        return (this.m_attrib & 4) != 0;
    }

    public final boolean isArchived() {
        return (this.m_attrib & 0x20) != 0;
    }

    public final boolean isStream() {
        return this.m_streamName != null;
    }

    public final boolean hasLocks() {
        return this.m_lockList != null && this.m_lockList.numberOfLocks() > 0;
    }

    public final boolean hasNTAttribute(int attr) {
        return (this.m_attrib & attr) == attr;
    }

    public final boolean hasAccessDate() {
        return this.m_accessDate != 0L;
    }

    public final long getAccessDate() {
        return this.m_accessDate;
    }

    public final boolean hasCreationDate() {
        return this.m_createDate != 0L;
    }

    public final long getCreationDate() {
        return this.m_createDate;
    }

    public final boolean hasDeleteOnClose() {
        return (this.m_flags & 2) != 0;
    }

    public final boolean hasIOPending() {
        return (this.m_flags & 1) != 0;
    }

    public boolean hasModifyDate() {
        return this.m_modifyDate != 0L;
    }

    public final long getModifyDate() {
        return this.m_modifyDate;
    }

    public final int getWriteCount() {
        return this.m_writeCount;
    }

    public final void incrementWriteCount() {
        ++this.m_writeCount;
    }

    public final void setAttributes(int attrib) {
        this.m_attrib = attrib;
    }

    public final void setDeleteOnClose(boolean del) {
        this.setStatusFlag(2, del);
    }

    public final void setDirectoryId(int dirId) {
        this.m_dirId = dirId;
    }

    public final void setFileId(int fid) {
        this.m_fid = fid;
    }

    public final void setFileSize(long siz) {
        this.m_fileSize = siz;
    }

    public final void setFileSize(int siz) {
        this.m_fileSize = siz;
    }

    public final void setFullName(String name) {
        this.m_fullName = name;
    }

    public final void setGrantedAccess(int mode) {
        this.m_grantedAccess = mode;
    }

    public final void setName(String name) {
        this.m_name = name;
    }

    public final void setIOPending(boolean pending) {
        this.setStatusFlag(1, pending);
    }

    public final void setStreamId(int id) {
        this.m_streamId = id;
    }

    public final void setStreamName(String name) {
        this.m_streamName = name;
    }

    public final synchronized void setClosed(boolean b) {
        this.m_closed = b;
    }

    public final void setAccessDate(long dattim) {
        this.m_accessDate = dattim;
    }

    public final void setCreationDate(long dattim) {
        this.m_createDate = dattim;
    }

    public final void setModifyDate(long dattim) {
        this.m_modifyDate = dattim;
    }

    protected final synchronized void setStatusFlag(int flag, boolean sts) {
        boolean state;
        boolean bl = state = (this.m_flags & flag) != 0;
        if (sts && !state) {
            this.m_flags += flag;
        } else if (!sts && state) {
            this.m_flags -= flag;
        }
    }

    public final synchronized void addLock(FileLock lock) {
        if (this.m_lockList == null) {
            this.m_lockList = new FileLockList();
        }
        this.m_lockList.addLock(lock);
    }

    public final synchronized void removeLock(FileLock lock) {
        if (this.m_lockList == null) {
            return;
        }
        this.m_lockList.removeLock(lock);
    }

    public final synchronized void removeAllLocks() {
        if (this.m_lockList != null) {
            this.m_lockList.removeAllLocks();
        }
    }

    public final int numberOfLocks() {
        if (this.m_lockList == null) {
            return 0;
        }
        return this.m_lockList.numberOfLocks();
    }

    public final FileLock getLockAt(int idx) {
        if (this.m_lockList != null) {
            return this.m_lockList.getLockAt(idx);
        }
        return null;
    }

    public final FileLockList getLockList() {
        return this.m_lockList;
    }

    protected final void setUniqueId(long id) {
        this.m_uniqueId = id;
    }

    protected final void setUniqueId(int fid, int did) {
        long ldid = did;
        long lfid = fid;
        this.m_uniqueId = (ldid << 32) + lfid;
    }

    protected final void setUniqueId(String path) {
        this.m_uniqueId = path.toUpperCase().hashCode();
    }

    public abstract void openFile(boolean var1) throws IOException;

    public abstract int readFile(byte[] var1, int var2, int var3, long var4) throws IOException;

    public abstract void writeFile(byte[] var1, int var2, int var3, long var4) throws IOException;

    public abstract long seekFile(long var1, int var3) throws IOException;

    public abstract void flushFile() throws IOException;

    public abstract void truncateFile(long var1) throws IOException;

    public abstract void closeFile() throws IOException;

    public void close() throws IOException {
        this.closeFile();
    }
}

