/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.server.smb.repo;

import java.io.FileNotFoundException;
import org.alfresco.filesys.server.SrvSession;
import org.alfresco.filesys.server.filesys.DiskDeviceContext;
import org.alfresco.filesys.server.filesys.FileName;
import org.alfresco.filesys.server.filesys.IOControlNotImplementedException;
import org.alfresco.filesys.server.filesys.NetworkFile;
import org.alfresco.filesys.server.filesys.TreeConnection;
import org.alfresco.filesys.smb.NTIOCtl;
import org.alfresco.filesys.smb.SMBException;
import org.alfresco.filesys.smb.server.repo.CifsHelper;
import org.alfresco.filesys.smb.server.repo.ContentDiskDriver;
import org.alfresco.filesys.smb.server.repo.IOControlHandler;
import org.alfresco.filesys.util.DataBuffer;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.lock.LockType;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ContentIOControlHandler
implements IOControlHandler {
    private static final Log logger = LogFactory.getLog(ContentIOControlHandler.class);
    private CifsHelper cifsHelper;
    private TransactionService transactionService;
    private NodeService nodeService;
    private CheckOutCheckInService checkInOutService;
    private ContentDiskDriver contentDriver;

    public void initialize(ContentDiskDriver contentDriver, CifsHelper cifsHelper, TransactionService transService, NodeService nodeService, CheckOutCheckInService cociService) {
        this.contentDriver = contentDriver;
        this.cifsHelper = cifsHelper;
        this.transactionService = transService;
        this.nodeService = nodeService;
        this.checkInOutService = cociService;
    }

    public DataBuffer processIOControl(SrvSession sess, TreeConnection tree, int ctrlCode, int fid, DataBuffer dataBuf, boolean isFSCtrl, int filter) throws IOControlNotImplementedException, SMBException {
        NetworkFile netFile = tree.findFile(fid);
        if (netFile == null || !netFile.isDirectory()) {
            throw new SMBException(6, -1073741811);
        }
        int devType = NTIOCtl.getDeviceType(ctrlCode);
        int ioFunc = NTIOCtl.getFunctionCode(ctrlCode);
        if (devType != 9 || dataBuf == null) {
            throw new IOControlNotImplementedException();
        }
        if (dataBuf.getLength() < "ALFRESCO".length()) {
            throw new IOControlNotImplementedException("Bad request length");
        }
        String sig = dataBuf.getString("ALFRESCO".length(), false);
        if (sig == null || sig.compareTo("ALFRESCO") != 0) {
            throw new IOControlNotImplementedException("Bad request signature");
        }
        NodeRef folderNode = null;
        try {
            folderNode = this.contentDriver.getNodeForPath(tree, netFile.getFullName());
            if (!this.cifsHelper.isDirectory(folderNode)) {
                folderNode = null;
            }
        }
        catch (FileNotFoundException ex) {
            folderNode = null;
        }
        if (folderNode == null) {
            throw new SMBException(6, -1073741790);
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("IO control func=0x" + Integer.toHexString(ioFunc) + ", fid=" + fid + ", buffer=" + dataBuf));
            logger.info((Object)("  Folder nodeRef=" + folderNode));
        }
        DataBuffer retBuffer = null;
        switch (ioFunc) {
            case 2048: {
                retBuffer = new DataBuffer("ALFRESCO".length());
                retBuffer.putFixedString("ALFRESCO", "ALFRESCO".length());
                retBuffer.putInt(0);
                break;
            }
            case 2049: {
                retBuffer = this.procIOFileStatus(sess, tree, dataBuf, folderNode);
                break;
            }
            case 2051: {
                retBuffer = this.procIOCheckIn(sess, tree, dataBuf, folderNode, netFile);
                break;
            }
            case 2050: {
                retBuffer = this.procIOCheckOut(sess, tree, dataBuf, folderNode, netFile);
                break;
            }
            default: {
                throw new IOControlNotImplementedException();
            }
        }
        return retBuffer;
    }

    private final DataBuffer procIOFileStatus(SrvSession sess, TreeConnection tree, DataBuffer reqBuf, NodeRef folderNode) {
        sess.beginTransaction(this.transactionService, true);
        String fName = reqBuf.getString(true);
        logger.info((Object)("  File status, fname=" + fName));
        DataBuffer respBuf = new DataBuffer(256);
        respBuf.putFixedString("ALFRESCO", "ALFRESCO".length());
        NodeRef childNode = null;
        try {
            childNode = this.cifsHelper.getNodeRef(folderNode, fName);
        }
        catch (FileNotFoundException ex) {
            // empty catch block
        }
        if (childNode == null) {
            respBuf.putInt(2);
            return respBuf;
        }
        if (this.cifsHelper.isDirectory(childNode)) {
            respBuf.putInt(0);
            respBuf.putInt(1);
        } else {
            respBuf.putInt(0);
            respBuf.putInt(0);
            if (this.nodeService.hasAspect(childNode, ContentModel.ASPECT_WORKING_COPY)) {
                NodeRef fromNode;
                respBuf.putInt(1);
                String owner = (String)((Object)this.nodeService.getProperty(childNode, ContentModel.PROP_WORKING_COPY_OWNER));
                String copiedFrom = null;
                if (this.nodeService.hasAspect(childNode, ContentModel.ASPECT_COPIEDFROM) && (fromNode = (NodeRef)this.nodeService.getProperty(childNode, ContentModel.PROP_COPY_REFERENCE)) != null) {
                    copiedFrom = (String)((Object)this.nodeService.getProperty(fromNode, ContentModel.PROP_NAME));
                }
                respBuf.putString(owner != null ? owner : "", true, true);
                respBuf.putString(copiedFrom != null ? copiedFrom : "", true, true);
            } else {
                respBuf.putInt(0);
            }
            if (this.nodeService.hasAspect(childNode, ContentModel.ASPECT_LOCKABLE)) {
                String lockTypeStr = (String)((Object)this.nodeService.getProperty(childNode, ContentModel.PROP_LOCK_TYPE));
                String lockOwner = null;
                if (lockTypeStr != null) {
                    lockOwner = (String)((Object)this.nodeService.getProperty(childNode, ContentModel.PROP_LOCK_OWNER));
                }
                if (lockTypeStr == null) {
                    respBuf.putInt(0);
                } else {
                    LockType lockType = LockType.valueOf(lockTypeStr);
                    respBuf.putInt(lockType == LockType.READ_ONLY_LOCK ? 1 : 2);
                    respBuf.putString(lockOwner != null ? lockOwner : "", true, true);
                }
            } else {
                respBuf.putInt(0);
            }
            ContentData contentData = (ContentData)this.nodeService.getProperty(childNode, ContentModel.PROP_CONTENT);
            if (contentData != null) {
                String mimeType = contentData.getMimetype();
                respBuf.putInt(1);
                respBuf.putLong(contentData.getSize());
                respBuf.putString(mimeType != null ? mimeType : "", true, true);
            } else {
                respBuf.putInt(0);
            }
        }
        return respBuf;
    }

    private final DataBuffer procIOCheckIn(SrvSession sess, TreeConnection tree, DataBuffer reqBuf, NodeRef folderNode, NetworkFile netFile) {
        sess.beginTransaction(this.transactionService, false);
        String fName = reqBuf.getString(true);
        boolean keepCheckedOut = reqBuf.getInt() == 1;
        logger.info((Object)("  CheckIn, fname=" + fName + ", keepCheckedOut=" + keepCheckedOut));
        DataBuffer respBuf = new DataBuffer(256);
        respBuf.putFixedString("ALFRESCO", "ALFRESCO".length());
        NodeRef childNode = null;
        try {
            childNode = this.cifsHelper.getNodeRef(folderNode, fName);
        }
        catch (FileNotFoundException ex) {
            // empty catch block
        }
        if (childNode == null) {
            respBuf.putInt(2);
            return respBuf;
        }
        if (this.cifsHelper.isDirectory(childNode)) {
            respBuf.putInt(4);
        } else if (this.nodeService.hasAspect(childNode, ContentModel.ASPECT_WORKING_COPY)) {
            try {
                this.checkInOutService.checkin(childNode, null, null, keepCheckedOut);
                respBuf.putInt(0);
                DiskDeviceContext diskCtx = (DiskDeviceContext)tree.getContext();
                if (diskCtx.hasChangeHandler()) {
                    String fileName = FileName.buildPath(netFile.getFullName(), null, fName, '\\');
                    diskCtx.getChangeHandler().notifyFileChanged(2, fileName);
                }
            }
            catch (Exception ex) {
                respBuf.setPosition("ALFRESCO".length());
                respBuf.putInt(1);
                respBuf.putString(ex.getMessage(), true, true);
            }
        } else {
            respBuf.putInt(5);
        }
        return respBuf;
    }

    private final DataBuffer procIOCheckOut(SrvSession sess, TreeConnection tree, DataBuffer reqBuf, NodeRef folderNode, NetworkFile netFile) {
        sess.beginTransaction(this.transactionService, false);
        String fName = reqBuf.getString(true);
        logger.info((Object)("  CheckOut, fname=" + fName));
        DataBuffer respBuf = new DataBuffer(256);
        respBuf.putFixedString("ALFRESCO", "ALFRESCO".length());
        NodeRef childNode = null;
        try {
            childNode = this.cifsHelper.getNodeRef(folderNode, fName);
        }
        catch (FileNotFoundException ex) {
            // empty catch block
        }
        if (childNode == null) {
            respBuf.putInt(2);
            return respBuf;
        }
        if (this.cifsHelper.isDirectory(childNode)) {
            respBuf.putInt(4);
        } else {
            try {
                NodeRef workingCopyNode = this.checkInOutService.checkout(childNode);
                String workingCopyName = (String)((Object)this.nodeService.getProperty(workingCopyNode, ContentModel.PROP_NAME));
                respBuf.putInt(0);
                respBuf.putString(workingCopyName, true, true);
                DiskDeviceContext diskCtx = (DiskDeviceContext)tree.getContext();
                if (diskCtx.hasChangeHandler()) {
                    String fileName = FileName.buildPath(netFile.getFullName(), null, workingCopyName, '\\');
                    diskCtx.getChangeHandler().notifyFileChanged(1, fileName);
                }
            }
            catch (Exception ex) {
                respBuf.setPosition("ALFRESCO".length());
                respBuf.putInt(1);
                respBuf.putString(ex.getMessage(), true, true);
            }
        }
        return respBuf;
    }
}

