/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.smb;

import java.util.BitSet;
import org.alfresco.filesys.smb.Dialect;

public class DialectSelector {
    private BitSet dialects = new BitSet(8);

    public DialectSelector() {
        this.ClearAll();
        this.AddDialect(0);
    }

    public void AddDialect(int d) throws ArrayIndexOutOfBoundsException {
        this.dialects.set(d);
    }

    public void ClearAll() {
        int i = 0;
        while (i < this.dialects.size()) {
            this.dialects.clear(i++);
        }
    }

    public void copyFrom(DialectSelector dsel) {
        this.ClearAll();
        for (int i = 0; i < 8; ++i) {
            if (!dsel.hasDialect(i)) continue;
            this.AddDialect(i);
        }
    }

    public boolean hasDialect(int d) throws ArrayIndexOutOfBoundsException {
        return this.dialects.get(d);
    }

    public boolean hasCore() {
        return this.hasDialect(0) || this.hasDialect(1);
    }

    public boolean hasLanMan() {
        return this.hasDialect(2) || this.hasDialect(4) || this.hasDialect(3) || this.hasDialect(5) || this.hasDialect(6);
    }

    public boolean hasNT() {
        return this.hasDialect(7);
    }

    public void RemoveDialect(int d) throws ArrayIndexOutOfBoundsException {
        this.dialects.clear(d);
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[");
        for (int i = 0; i < this.dialects.size(); ++i) {
            if (!this.hasDialect(i)) continue;
            str.append(Dialect.DialectTypeString(i));
            str.append(",");
        }
        if (str.length() > 1) {
            str.setLength(str.length() - 1);
        }
        str.append("]");
        return str.toString();
    }
}

