/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.smb;

import org.alfresco.filesys.util.StringList;

public class ServerType {
    public static final int WorkStation = 1;
    public static final int Server = 2;
    public static final int SQLServer = 4;
    public static final int DomainCtrl = 8;
    public static final int DomainBakCtrl = 16;
    public static final int TimeSource = 32;
    public static final int AFPServer = 64;
    public static final int NovellServer = 128;
    public static final int DomainMember = 256;
    public static final int PrintServer = 512;
    public static final int DialinServer = 1024;
    public static final int UnixServer = 2048;
    public static final int NTServer = 4096;
    public static final int WfwServer = 8192;
    public static final int MFPNServer = 16384;
    public static final int NTNonDCServer = 32768;
    public static final int PotentialBrowse = 65536;
    public static final int BackupBrowser = 131072;
    public static final int MasterBrowser = 262144;
    public static final int DomainMaster = 524288;
    public static final int OSFServer = 0x100000;
    public static final int VMSServer = 0x200000;
    public static final int Win95Plus = 0x400000;
    public static final int DFSRoot = 0x800000;
    public static final int NTCluster = 0x1000000;
    public static final int TerminalServer = 0x2000000;
    public static final int DCEServer = 0x10000000;
    public static final int AlternateXport = 0x20000000;
    public static final int LocalListOnly = 0x40000000;
    public static final int DomainEnum = Integer.MIN_VALUE;
    private static final String[] _srvType = new String[]{"Workstation", "Server", "SQLServer", "DomainController", "BackupDomainController", "TimeSource", "AFPServer", "NovellServer", "DomainMember", "PrintServer", "DialinServer", "UnixServer", "NTServer", "WfwServer", "MFPNServer", "NtNonDCServer", "PotentialBrowse", "BackupBrowser", "MasterBrowser", "DomainMaster", "OSFServer", "VMSServer", "Win95Plus", "DFSRoot", "NTCluster", "TerminalServer", "", "", "DCEServer"};

    public static final StringList TypeAsStrings(int typ) {
        StringList strs = new StringList();
        for (int i = 0; i < _srvType.length; ++i) {
            int mask = 1 << i;
            if ((typ & mask) == 0) continue;
            strs.addString(_srvType[i]);
        }
        return strs;
    }

    public static final boolean isWorkStation(int typ) {
        return (typ & 1) != 0;
    }

    public static final boolean isServer(int typ) {
        return (typ & 2) != 0;
    }

    public static final boolean isSQLServer(int typ) {
        return (typ & 4) != 0;
    }

    public static final boolean isDomainController(int typ) {
        return (typ & 8) != 0;
    }

    public static final boolean isBackupDomainController(int typ) {
        return (typ & 0x10) != 0;
    }

    public static final boolean isTimeSource(int typ) {
        return (typ & 0x20) != 0;
    }

    public static final boolean isAFPServer(int typ) {
        return (typ & 0x40) != 0;
    }

    public static final boolean isNovellServer(int typ) {
        return (typ & 0x80) != 0;
    }

    public static final boolean isDomainMember(int typ) {
        return (typ & 0x100) != 0;
    }

    public static final boolean isPrintServer(int typ) {
        return (typ & 0x200) != 0;
    }

    public static final boolean isDialinServer(int typ) {
        return (typ & 0x400) != 0;
    }

    public static final boolean isUnixServer(int typ) {
        return (typ & 0x800) != 0;
    }

    public static final boolean isNTServer(int typ) {
        return (typ & 0x1000) != 0;
    }

    public static final boolean isWFWServer(int typ) {
        return (typ & 0x2000) != 0;
    }

    public static final boolean isMFPNServer(int typ) {
        return (typ & 0x4000) != 0;
    }

    public static final boolean isNTNonDomainServer(int typ) {
        return (typ & 0x8000) != 0;
    }

    public static final boolean isPotentialBrowseMaster(int typ) {
        return (typ & 0x10000) != 0;
    }

    public static final boolean isBackupBrowser(int typ) {
        return (typ & 0x20000) != 0;
    }

    public static final boolean isBrowserMaster(int typ) {
        return (typ & 0x40000) != 0;
    }

    public static final boolean isDomainMaster(int typ) {
        return (typ & 0x80000) != 0;
    }

    public static final boolean isOSFServer(int typ) {
        return (typ & 0x100000) != 0;
    }

    public static final boolean isVMSServer(int typ) {
        return (typ & 0x200000) != 0;
    }

    public static final boolean isWin95Plus(int typ) {
        return (typ & 0x400000) != 0;
    }

    public static final boolean isDFSRoot(int typ) {
        return (typ & 0x800000) != 0;
    }

    public static final boolean isNTCluster(int typ) {
        return (typ & 0x1000000) != 0;
    }

    public static final boolean isTerminalServer(int typ) {
        return (typ & 0x2000000) != 0;
    }

    public static final boolean isDCEServer(int typ) {
        return (typ & 0x10000000) != 0;
    }
}

