/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.smb.dcerpc;

import org.alfresco.filesys.util.DataPacker;

public class DCEDataPacker {
    public static final String getDCEString(byte[] buf, int off) throws IndexOutOfBoundsException {
        if (buf.length < off + 12) {
            throw new IndexOutOfBoundsException();
        }
        int maxLen = DataPacker.getIntelInt(buf, off);
        int strLen = DataPacker.getIntelInt(buf, off + 8);
        return DataPacker.getUnicodeString(buf, off + 12, strLen);
    }

    public static final int putDCEString(byte[] buf, int off, String str, boolean incNul) {
        DataPacker.putIntelInt(str.length() + 1, buf, off);
        DataPacker.putZeros(buf, off + 4, 4);
        if (!incNul) {
            DataPacker.putIntelInt(str.length(), buf, off + 8);
        } else {
            DataPacker.putIntelInt(str.length() + 1, buf, off + 8);
        }
        return DataPacker.putUnicodeString(str, buf, off + 12, incNul);
    }

    public static final int wordAlign(int pos) {
        return pos + 1 & 0xFFFFFFFE;
    }

    public static final int longwordAlign(int pos) {
        return pos + 3 & 0xFFFFFFFC;
    }
}

