/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.smb.dcerpc;

import org.alfresco.filesys.util.DataPacker;

public class UUID {
    public static final int UUID_LENGTH = 36;
    public static final int UUID_LENGTH_BINARY = 16;
    private static final String UUID_VALIDCHARS = "0123456789ABCDEFabcdef";
    private String m_uuid;
    private int m_ifVersion;
    private byte[] m_uuidBytes;

    public UUID(String id) {
        if (UUID.validateUUID(id)) {
            this.m_uuid = id;
            this.m_ifVersion = 1;
        }
    }

    public UUID(String id, int ver) {
        if (UUID.validateUUID(id)) {
            this.m_uuid = id;
            this.m_ifVersion = ver;
        }
    }

    public UUID(byte[] buf, int off) {
        if (off + 16 <= buf.length) {
            this.m_uuidBytes = new byte[16];
            for (int i = 0; i < 16; ++i) {
                this.m_uuidBytes[i] = buf[off + i];
            }
            this.m_uuid = UUID.generateUUIDString(this.m_uuidBytes);
        }
    }

    public final boolean isValid() {
        return this.m_uuid != null;
    }

    public final String getUUID() {
        return this.m_uuid;
    }

    public final int getVersion() {
        return this.m_ifVersion;
    }

    public final void setVersion(int ver) {
        this.m_ifVersion = ver;
    }

    public final byte[] getBytes() {
        if (this.m_uuidBytes == null) {
            this.m_uuidBytes = new byte[16];
            try {
                String val = this.m_uuid.substring(0, 8);
                long lval = Long.parseLong(val, 16);
                DataPacker.putIntelInt((int)(lval & 0xFFFFFFFFFFFFFFFFL), this.m_uuidBytes, 0);
                val = this.m_uuid.substring(9, 13);
                int ival = Integer.parseInt(val, 16);
                DataPacker.putIntelShort(ival, this.m_uuidBytes, 4);
                val = this.m_uuid.substring(14, 18);
                ival = Integer.parseInt(val, 16);
                DataPacker.putIntelShort(ival, this.m_uuidBytes, 6);
                val = this.m_uuid.substring(19, 23);
                ival = Integer.parseInt(val, 16);
                DataPacker.putShort((short)(ival & 0xFFFF), this.m_uuidBytes, 8);
                int strPos = 24;
                int bytPos = 10;
                for (int i = 0; i < 6; ++i) {
                    val = this.m_uuid.substring(strPos, strPos + 2);
                    this.m_uuidBytes[bytPos++] = (byte)(Short.parseShort(val, 16) & 0xFF);
                    strPos += 2;
                }
            }
            catch (NumberFormatException ex) {
                this.m_uuidBytes = null;
            }
        }
        return this.m_uuidBytes;
    }

    public static final boolean validateUUID(String idStr) {
        if (idStr == null || idStr.length() != 36) {
            return false;
        }
        if (idStr.charAt(8) != '-' || idStr.charAt(13) != '-' || idStr.charAt(18) != '-' || idStr.charAt(23) != '-') {
            return false;
        }
        int i = 0;
        for (i = 0; i < 8; ++i) {
            if (UUID_VALIDCHARS.indexOf(idStr.charAt(i)) != -1) continue;
            return false;
        }
        for (i = 9; i < 13; ++i) {
            if (UUID_VALIDCHARS.indexOf(idStr.charAt(i)) != -1) continue;
            return false;
        }
        for (i = 14; i < 18; ++i) {
            if (UUID_VALIDCHARS.indexOf(idStr.charAt(i)) != -1) continue;
            return false;
        }
        for (i = 19; i < 23; ++i) {
            if (UUID_VALIDCHARS.indexOf(idStr.charAt(i)) != -1) continue;
            return false;
        }
        for (i = 24; i < 36; ++i) {
            if (UUID_VALIDCHARS.indexOf(idStr.charAt(i)) != -1) continue;
            return false;
        }
        return true;
    }

    public static final String generateUUIDString(byte[] buf) {
        StringBuffer str = new StringBuffer(36);
        int ival = DataPacker.getIntelInt(buf, 0);
        str.append(Integer.toHexString(ival));
        while (str.length() != 8) {
            str.insert(0, ' ');
        }
        str.append("-");
        ival = DataPacker.getIntelShort(buf, 4) & 0xFFFF;
        str.append(Integer.toHexString(ival));
        while (str.length() != 13) {
            str.insert(9, '0');
        }
        str.append("-");
        ival = DataPacker.getIntelShort(buf, 6) & 0xFFFF;
        str.append(Integer.toHexString(ival));
        while (str.length() != 18) {
            str.insert(14, '0');
        }
        str.append("-");
        for (int i = 8; i < 16; ++i) {
            ival = buf[i] & 0xFF;
            if (ival < 16) {
                str.append('0');
            }
            str.append(Integer.toHexString(ival));
            if (i != 9) continue;
            str.append("-");
        }
        return str.toString();
    }

    public final boolean compareTo(UUID id) {
        if (this.getVersion() != id.getVersion()) {
            return false;
        }
        byte[] thisBytes = this.getBytes();
        byte[] idBytes = id.getBytes();
        for (int i = 0; i < 16; ++i) {
            if (thisBytes[i] == idBytes[i]) continue;
            return false;
        }
        return true;
    }

    public final int storeUUID(byte[] buf, int off, boolean writeVer) {
        int pos = off;
        byte[] uuidByts = this.getBytes();
        if (uuidByts == null) {
            return pos;
        }
        for (int i = 0; i < 16; ++i) {
            buf[pos + i] = uuidByts[i];
        }
        pos += 16;
        if (writeVer) {
            DataPacker.putIntelInt(this.getVersion(), buf, pos);
            pos += 4;
        }
        return pos;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[");
        str.append(this.m_uuid);
        str.append(":");
        str.append(this.m_ifVersion);
        str.append("]");
        return str.toString();
    }
}

