/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.smb.dcerpc.info;

import org.alfresco.filesys.smb.dcerpc.DCEBuffer;
import org.alfresco.filesys.smb.dcerpc.DCEBufferException;
import org.alfresco.filesys.smb.dcerpc.DCEReadable;
import org.alfresco.filesys.smb.dcerpc.DCEWriteable;

public class ShareInfo
implements DCEWriteable,
DCEReadable {
    public static final int InfoLevel0 = 0;
    public static final int InfoLevel1 = 1;
    public static final int InfoLevel2 = 2;
    public static final int InfoLevel502 = 502;
    public static final int InfoLevel1005 = 1005;
    public static final int Disk = 0;
    public static final int PrintQueue = 1;
    public static final int Device = 2;
    public static final int IPC = 3;
    public static final int Hidden = Integer.MIN_VALUE;
    public static final int Read = 1;
    public static final int Write = 2;
    public static final int Create = 4;
    public static final int Execute = 8;
    public static final int Delete = 16;
    public static final int Attrib = 32;
    public static final int Perm = 64;
    public static final int All = 127;
    private int m_infoLevel;
    private String m_name;
    private int m_type;
    private String m_comment;
    private int m_permissions;
    private int m_maxUsers;
    private int m_curUsers;
    private String m_path;
    private String m_password;
    private int m_flags;

    public ShareInfo() {
    }

    public ShareInfo(int lev) {
        this.m_infoLevel = lev;
    }

    public ShareInfo(int lev, String name, int typ, String comment) {
        this.m_infoLevel = lev;
        this.m_name = name;
        this.m_type = typ;
        this.m_comment = comment;
    }

    public final int getInformationLevel() {
        return this.m_infoLevel;
    }

    public final String getName() {
        return this.m_name;
    }

    public final int getType() {
        return this.m_type;
    }

    public final int getFlags() {
        return this.m_flags;
    }

    public final boolean isHidden() {
        return (this.m_type & Integer.MIN_VALUE) != 0;
    }

    public final boolean isDisk() {
        return (this.m_type & 0xFFFF) == 0;
    }

    public final boolean isPrinter() {
        return (this.m_type & 0xFFFF) == 1;
    }

    public final boolean isDevice() {
        return (this.m_type & 0xFFFF) == 2;
    }

    public final boolean isNamedPipe() {
        return (this.m_type & 0xFFFF) == 3;
    }

    public final int getPermissions() {
        return this.m_permissions;
    }

    public final int getMaximumUsers() {
        return this.m_maxUsers;
    }

    public final int getCurrentUsers() {
        return this.m_curUsers;
    }

    public final String getPath() {
        return this.m_path;
    }

    public final String getPassword() {
        return this.m_password;
    }

    public final String getTypeAsString() {
        String typ = "";
        switch (this.getType() & 0xFF) {
            case 0: {
                typ = "Disk";
                break;
            }
            case 1: {
                typ = "Printer";
                break;
            }
            case 2: {
                typ = "Device";
                break;
            }
            case 3: {
                typ = "IPC";
            }
        }
        return typ;
    }

    public final String getComment() {
        return this.m_comment;
    }

    public final void setInformationLevel(int lev) {
        this.m_infoLevel = lev;
    }

    public final void setType(int typ) {
        this.m_type = typ;
    }

    public final void setFlags(int flags) {
        this.m_flags = flags;
    }

    public final void setName(String name) {
        this.m_name = name;
    }

    public final void setComment(String str) {
        this.m_comment = str;
    }

    public final void setPermissions(int perm) {
        this.m_permissions = perm;
    }

    public final void setMaximumUsers(int maxUsers) {
        this.m_maxUsers = maxUsers;
    }

    public final void setCurrentUsers(int curUsers) {
        this.m_curUsers = curUsers;
    }

    public final void setPath(String path) {
        this.m_path = path;
    }

    protected final void clearStrings() {
        this.m_name = null;
        this.m_comment = null;
        this.m_path = null;
        this.m_password = null;
    }

    public void readObject(DCEBuffer buf) throws DCEBufferException {
        this.clearStrings();
        switch (this.getInformationLevel()) {
            case 0: {
                this.m_name = buf.getPointer() != 0 ? "" : null;
                break;
            }
            case 1: {
                this.m_name = buf.getPointer() != 0 ? "" : null;
                this.m_type = buf.getInt();
                this.m_comment = buf.getPointer() != 0 ? "" : null;
                break;
            }
            case 2: {
                this.m_name = buf.getPointer() != 0 ? "" : null;
                this.m_type = buf.getInt();
                this.m_comment = buf.getPointer() != 0 ? "" : null;
                this.m_permissions = buf.getInt();
                this.m_maxUsers = buf.getInt();
                this.m_curUsers = buf.getInt();
                this.m_path = buf.getPointer() != 0 ? "" : null;
                this.m_password = buf.getPointer() != 0 ? "" : null;
                break;
            }
            case 502: {
                this.m_name = buf.getPointer() != 0 ? "" : null;
                this.m_type = buf.getInt();
                this.m_comment = buf.getPointer() != 0 ? "" : null;
                this.m_permissions = buf.getInt();
                this.m_maxUsers = buf.getInt();
                this.m_curUsers = buf.getInt();
                this.m_path = buf.getPointer() != 0 ? "" : null;
                this.m_password = buf.getPointer() != 0 ? "" : null;
                buf.skipBytes(4);
            }
        }
    }

    public void readStrings(DCEBuffer buf) throws DCEBufferException {
        switch (this.getInformationLevel()) {
            case 0: {
                if (this.getName() == null) break;
                this.m_name = buf.getString(1);
                break;
            }
            case 1: {
                if (this.getName() != null) {
                    this.m_name = buf.getString(1);
                }
                if (this.getComment() == null) break;
                this.m_comment = buf.getString(1);
                break;
            }
            case 2: 
            case 502: {
                if (this.getName() != null) {
                    this.m_name = buf.getString(1);
                }
                if (this.getComment() != null) {
                    this.m_comment = buf.getString(1);
                }
                if (this.getPath() != null) {
                    this.m_path = buf.getString(1);
                }
                if (this.getPassword() == null) break;
                this.m_password = buf.getString(1);
            }
        }
    }

    public void writeObject(DCEBuffer buf, DCEBuffer strBuf) {
        switch (this.getInformationLevel()) {
            case 0: {
                buf.putPointer(true);
                strBuf.putString(this.getName(), 1, true);
                break;
            }
            case 1: {
                buf.putPointer(true);
                buf.putInt(this.getType());
                buf.putPointer(true);
                strBuf.putString(this.getName(), 1, true);
                strBuf.putString(this.getComment() != null ? this.getComment() : "", 1, true);
                break;
            }
            case 2: {
                buf.putPointer(true);
                buf.putInt(this.getType());
                buf.putPointer(true);
                buf.putInt(this.getPermissions());
                buf.putInt(this.getMaximumUsers());
                buf.putInt(this.getCurrentUsers());
                buf.putPointer(this.getPath() != null);
                buf.putPointer(this.getPassword() != null);
                strBuf.putString(this.getName(), 1, true);
                strBuf.putString(this.getComment() != null ? this.getComment() : "", 1, true);
                if (this.getPath() != null) {
                    strBuf.putString(this.getPath(), 1, true);
                }
                if (this.getPassword() == null) break;
                strBuf.putString(this.getPassword(), 1, true);
                break;
            }
            case 502: {
                buf.putPointer(true);
                buf.putInt(this.getType());
                buf.putPointer(true);
                buf.putInt(this.getPermissions());
                buf.putInt(this.getMaximumUsers());
                buf.putInt(this.getCurrentUsers());
                buf.putPointer(this.getPath() != null);
                buf.putPointer(this.getPassword() != null);
                buf.putInt(0);
                buf.putPointer(false);
                strBuf.putString(this.getName(), 1, true);
                strBuf.putString(this.getComment() != null ? this.getComment() : "", 1, true);
                if (this.getPath() != null) {
                    strBuf.putString(this.getPath(), 1, true);
                }
                if (this.getPassword() == null) break;
                strBuf.putString(this.getPassword(), 1, true);
                break;
            }
            case 1005: {
                buf.putInt(this.getFlags());
            }
        }
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[");
        str.append(this.getName());
        str.append(":");
        str.append(this.getInformationLevel());
        str.append(":");
        if (this.getInformationLevel() == 1) {
            str.append("0x");
            str.append(Integer.toHexString(this.getType()));
            str.append(",");
            str.append(this.getComment());
        }
        str.append("]");
        return str.toString();
    }
}

