/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.smb.dcerpc.server;

import java.io.IOException;
import org.alfresco.filesys.smb.dcerpc.DCEBuffer;
import org.alfresco.filesys.smb.dcerpc.DCEBufferException;
import org.alfresco.filesys.smb.dcerpc.Wkssvc;
import org.alfresco.filesys.smb.dcerpc.info.WorkstationInfo;
import org.alfresco.filesys.smb.dcerpc.server.DCEHandler;
import org.alfresco.filesys.smb.dcerpc.server.DCEPipeFile;
import org.alfresco.filesys.smb.server.SMBServer;
import org.alfresco.filesys.smb.server.SMBSrvException;
import org.alfresco.filesys.smb.server.SMBSrvSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WkssvcDCEHandler
implements DCEHandler {
    private static final Log logger = LogFactory.getLog((String)"org.alfresco.smb.protocol");

    public void processRequest(SMBSrvSession sess, DCEBuffer inBuf, DCEPipeFile pipeFile) throws IOException, SMBSrvException {
        int opNum = inBuf.getHeaderValue(9);
        try {
            inBuf.skipBytes(24);
        }
        catch (DCEBufferException ex) {
            // empty catch block
        }
        if (logger.isDebugEnabled() && sess.hasDebug(16384)) {
            logger.debug((Object)("DCE/RPC WksSvc request=" + Wkssvc.getOpcodeName(opNum)));
        }
        DCEBuffer outBuf = new DCEBuffer();
        outBuf.putResponseHeader(inBuf.getHeaderValue(7), 0);
        boolean processed = false;
        switch (opNum) {
            case 0: {
                processed = this.netWkstaGetInfo(sess, inBuf, outBuf);
                break;
            }
        }
        if (!processed) {
            sess.sendErrorResponseSMB(65535, 2);
            return;
        }
        outBuf.setHeaderValue(8, outBuf.getLength());
        pipeFile.setBufferedData(outBuf);
    }

    protected final boolean netWkstaGetInfo(SMBSrvSession sess, DCEBuffer inBuf, DCEBuffer outBuf) {
        String srvName = null;
        int infoLevel = 0;
        try {
            inBuf.skipPointer();
            srvName = inBuf.getString(1);
            infoLevel = inBuf.getInt();
        }
        catch (DCEBufferException ex) {
            return false;
        }
        if (logger.isDebugEnabled() && sess.hasDebug(16384)) {
            logger.debug((Object)("NetWkstaGetInfo srvName=" + srvName + ", infoLevel=" + infoLevel));
        }
        WorkstationInfo wkstaInfo = new WorkstationInfo(infoLevel);
        SMBServer srv = sess.getSMBServer();
        wkstaInfo.setWorkstationName(srv.getServerName());
        wkstaInfo.setDomain(srv.getConfiguration().getDomainName());
        wkstaInfo.setPlatformId(500);
        wkstaInfo.setVersion(5, 1);
        wkstaInfo.writeObject(outBuf, outBuf);
        outBuf.putInt(0);
        return true;
    }
}

