/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.smb.mailslot;

import java.io.IOException;
import org.alfresco.filesys.netbios.NetBIOSName;
import org.alfresco.filesys.netbios.win32.WinsockNetBIOSException;
import org.alfresco.filesys.smb.mailslot.MailSlot;
import org.alfresco.filesys.smb.mailslot.SMBMailslotPacket;
import org.alfresco.filesys.util.StringList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class HostAnnouncer
extends Thread {
    protected static final Log logger = LogFactory.getLog((String)"org.alfresco.smb.protocol.mailslot");
    public static final int SHUTDOWN_WAIT = 2000;
    public static final int SHUTDOWN_COUNT = 3;
    public static final long STARTING_INTERVAL = 5000L;
    private StringList m_names;
    private String m_domain;
    private String m_comment;
    private int m_interval;
    private int m_srvtype = 3;
    private SMBMailslotPacket m_smbPkt;
    private byte m_updateCount;
    private boolean m_shutdown = false;
    private boolean m_debug;

    public HostAnnouncer() {
        this.commonConstructor();
    }

    public HostAnnouncer(String name, String domain, int intval) {
        this.commonConstructor();
        this.addHostName(name);
        this.setDomain(domain);
        this.setInterval(intval);
    }

    private final void commonConstructor() {
        this.m_names = new StringList();
    }

    public final String getComment() {
        return this.m_comment;
    }

    public final String getDomain() {
        return this.m_domain;
    }

    public final int numberOfNames() {
        return this.m_names.numberOfStrings();
    }

    public final String getHostName(int idx) {
        if (idx < 0 || idx > this.m_names.numberOfStrings()) {
            return null;
        }
        return this.m_names.getStringAt(idx);
    }

    public final int getInterval() {
        return this.m_interval;
    }

    public final int getServerType() {
        return this.m_srvtype;
    }

    public final boolean hasDebug() {
        return this.m_debug;
    }

    public final void setDebug(boolean dbg) {
        this.m_debug = dbg;
    }

    protected final void initHostAnnounceSMB(String name) {
        if (this.m_smbPkt == null) {
            this.m_smbPkt = new SMBMailslotPacket();
        }
        byte[] data = new byte[256];
        byte by = this.m_updateCount;
        this.m_updateCount = (byte)(by + 1);
        int pos = MailSlot.createHostAnnouncement(data, 0, name, this.m_comment, this.m_srvtype, this.m_interval, by);
        this.m_smbPkt.initializeMailslotSMB("\\MAILSLOT\\BROWSE", data, pos);
    }

    public void run() {
        try {
            this.initialize();
        }
        catch (Exception ex) {
            logger.error((Object)"HostAnnouncer initialization error", (Throwable)ex);
            return;
        }
        this.m_shutdown = false;
        long sleepTime = 5000L;
        long sleepNormal = this.getInterval() * 60 * 1000;
        while (!this.m_shutdown) {
            try {
                if (this.isNetworkEnabled()) {
                    for (int i = 0; i < this.m_names.numberOfStrings(); ++i) {
                        String hostName = this.getHostName(i);
                        this.initHostAnnounceSMB(hostName);
                        this.sendAnnouncement(hostName, this.m_smbPkt.getBuffer(), 0, this.m_smbPkt.getLength());
                        if (!logger.isDebugEnabled() || !this.hasDebug()) continue;
                        logger.debug((Object)("HostAnnouncer: Announced host " + hostName));
                    }
                } else {
                    sleepTime = 5000L;
                }
                HostAnnouncer.sleep(sleepTime);
                if (!this.isNetworkEnabled() || sleepTime >= sleepNormal || (sleepTime *= 2L) <= sleepNormal) continue;
                sleepTime = sleepNormal;
            }
            catch (WinsockNetBIOSException ex) {
                if (!this.m_shutdown) {
                    logger.error((Object)"HostAnnouncer error", (Throwable)ex);
                }
                this.m_shutdown = true;
            }
            catch (IOException ex) {
                if (!this.m_shutdown) {
                    logger.error((Object)"HostAnnouncer error", (Throwable)ex);
                    logger.error((Object)" Check <broadcast> setting in file-servers.xml");
                }
                this.m_shutdown = true;
            }
            catch (Exception ex) {
                if (!this.m_shutdown) {
                    logger.error((Object)"HostAnnouncer error", (Throwable)ex);
                }
                this.m_shutdown = true;
            }
        }
        this.setInterval(0);
        if ((this.m_srvtype & 2) != 0) {
            this.m_srvtype -= 2;
        }
        for (int j = 0; j < 3; ++j) {
            for (int i = 0; i < this.m_names.numberOfStrings(); ++i) {
                String hostName = this.getHostName(i);
                this.initHostAnnounceSMB(hostName);
                try {
                    this.sendAnnouncement(hostName, this.m_smbPkt.getBuffer(), 0, this.m_smbPkt.getLength());
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            try {
                HostAnnouncer.sleep(2000L);
                continue;
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
    }

    protected void initialize() throws Exception {
    }

    public abstract boolean isNetworkEnabled();

    protected abstract void sendAnnouncement(String var1, byte[] var2, int var3, int var4) throws Exception;

    public final void setComment(String comment) {
        this.m_comment = comment;
        if (this.m_comment != null && this.m_comment.length() > 80) {
            this.m_comment = this.m_comment.substring(0, 80);
        }
    }

    public final void setDomain(String name) {
        this.m_domain = name.toUpperCase();
    }

    public final void addHostName(String name) {
        this.m_names.addString(NetBIOSName.toUpperCaseName(name));
    }

    public final void addHostNames(StringList names) {
        this.m_names.addStrings(names);
    }

    public final void setInterval(int intval) {
        this.m_interval = intval;
    }

    public final void setServerType(int typ) {
        this.m_srvtype = typ;
    }

    public final synchronized void shutdownAnnouncer() {
        this.m_shutdown = true;
        this.interrupt();
        try {
            this.join(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

