/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.smb.mailslot;

import org.alfresco.filesys.netbios.NetBIOSName;
import org.alfresco.filesys.netbios.win32.NetBIOSSocket;
import org.alfresco.filesys.smb.mailslot.HostAnnouncer;
import org.alfresco.filesys.smb.server.win32.Win32NetBIOSSessionSocketHandler;

public class WinsockNetBIOSHostAnnouncer
extends HostAnnouncer {
    private Win32NetBIOSSessionSocketHandler m_handler;
    private NetBIOSSocket m_dgramSocket;

    public WinsockNetBIOSHostAnnouncer(Win32NetBIOSSessionSocketHandler handler, String domain, int intval) {
        this.m_handler = handler;
        this.addHostName(handler.getServerName());
        this.setDomain(domain);
        this.setInterval(intval);
    }

    public final int getLana() {
        return this.m_handler.getLANANumber();
    }

    protected void initialize() throws Exception {
        this.setName("WinsockHostAnnouncer_L" + this.getLana());
        this.m_dgramSocket = NetBIOSSocket.createDatagramSocket(this.getLana());
    }

    public boolean isNetworkEnabled() {
        return this.m_handler.isLANAValid();
    }

    protected void sendAnnouncement(String hostName, byte[] buf, int offset, int len) throws Exception {
        NetBIOSName destNbName = new NetBIOSName(this.getDomain(), '\u001d', false);
        int sts = this.m_dgramSocket.sendDatagram(destNbName, buf, 0, len);
        if (sts != len) {
            logger.debug((Object)"WinsockNetBIOS host announce error");
        }
    }
}

