/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.smb.server;

import java.io.IOException;
import org.alfresco.filesys.server.auth.CifsAuthenticator;
import org.alfresco.filesys.server.auth.InvalidUserException;
import org.alfresco.filesys.server.core.InvalidDeviceInterfaceException;
import org.alfresco.filesys.server.core.ShareType;
import org.alfresco.filesys.server.core.SharedDevice;
import org.alfresco.filesys.server.filesys.AccessDeniedException;
import org.alfresco.filesys.server.filesys.DirectoryNotEmptyException;
import org.alfresco.filesys.server.filesys.DiskDeviceContext;
import org.alfresco.filesys.server.filesys.DiskInterface;
import org.alfresco.filesys.server.filesys.FileExistsException;
import org.alfresco.filesys.server.filesys.FileInfo;
import org.alfresco.filesys.server.filesys.FileName;
import org.alfresco.filesys.server.filesys.FileOpenParams;
import org.alfresco.filesys.server.filesys.FileSharingException;
import org.alfresco.filesys.server.filesys.NetworkFile;
import org.alfresco.filesys.server.filesys.SearchContext;
import org.alfresco.filesys.server.filesys.SrvDiskInfo;
import org.alfresco.filesys.server.filesys.TooManyConnectionsException;
import org.alfresco.filesys.server.filesys.TooManyFilesException;
import org.alfresco.filesys.server.filesys.TreeConnection;
import org.alfresco.filesys.server.filesys.VolumeInfo;
import org.alfresco.filesys.smb.InvalidUNCPathException;
import org.alfresco.filesys.smb.PCShare;
import org.alfresco.filesys.smb.SMBDate;
import org.alfresco.filesys.smb.server.CoreResumeKey;
import org.alfresco.filesys.smb.server.ProtocolHandler;
import org.alfresco.filesys.smb.server.SMBSrvException;
import org.alfresco.filesys.smb.server.SMBSrvPacket;
import org.alfresco.filesys.smb.server.SMBSrvSession;
import org.alfresco.filesys.util.DataPacker;
import org.alfresco.filesys.util.WildCard;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class CoreProtocolHandler
extends ProtocolHandler {
    private static final Log logger = LogFactory.getLog((String)"org.alfresco.smb.protocol");
    private static final int RESUME_START = 32771;
    private static final int RESUME_DOT = 32770;
    private static final int RESUME_DOTDOT = 32769;
    private static final int MaxWordValue = 65535;
    protected SMBSrvPacket m_smbPkt;

    protected CoreProtocolHandler() {
    }

    protected CoreProtocolHandler(SMBSrvSession sess) {
        super(sess);
    }

    public String getName() {
        return "Core Protocol";
    }

    protected final void MapExceptionToSMBError(Exception ex) {
    }

    protected final int packSearchInfo(byte[] buf, int bufPos, String searchStr, int resumeId, int searchId, FileInfo info) {
        CoreResumeKey.putResumeKey(buf, bufPos, searchStr, resumeId + (searchId << 16));
        bufPos += 21;
        buf[bufPos++] = (byte)(info.getFileAttributes() & 0xFF);
        SMBDate dateTime = new SMBDate(info.getModifyDateTime());
        if (dateTime != null) {
            DataPacker.putIntelShort(dateTime.asSMBTime(), buf, bufPos);
            DataPacker.putIntelShort(dateTime.asSMBDate(), buf, bufPos + 2);
        } else {
            DataPacker.putIntelShort(0, buf, bufPos);
            DataPacker.putIntelShort(0, buf, bufPos + 2);
        }
        DataPacker.putIntelInt((int)info.getSize(), buf, bufPos += 4);
        bufPos += 4;
        StringBuffer strBuf = new StringBuffer();
        strBuf.append(info.getFileName());
        while (strBuf.length() < 13) {
            strBuf.append('\u0000');
        }
        if (strBuf.length() > 12) {
            strBuf.setLength(12);
        }
        DataPacker.putString(strBuf.toString().toUpperCase(), buf, bufPos, true);
        return bufPos += 13;
    }

    protected void procCheckDirectory(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        if (!this.m_smbPkt.checkPacketIsValid(0, 2)) {
            this.m_sess.sendErrorResponseSMB(64, 2);
            return;
        }
        int treeId = this.m_smbPkt.getTreeId();
        TreeConnection conn = this.m_sess.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        int dataPos = this.m_smbPkt.getByteOffset();
        int dataLen = this.m_smbPkt.getByteCount();
        byte[] buf = this.m_smbPkt.getBuffer();
        String dirName = DataPacker.getDataString('\u0004', buf, dataPos, dataLen, this.m_smbPkt.isUnicode());
        if (dirName == null) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(64)) {
            logger.debug((Object)("Directory Check [" + treeId + "] name=" + dirName));
        }
        try {
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            if (disk.fileExists(this.m_sess, conn, dirName) == 2) {
                outPkt.setParameterCount(0);
                outPkt.setByteCount(0);
                this.m_sess.sendResponseSMB(outPkt);
            } else {
                this.m_sess.sendErrorResponseSMB(3, 1);
            }
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        catch (IOException ex) {
            this.m_sess.sendErrorResponseSMB(3, 1);
            return;
        }
    }

    protected void procCloseFile(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        if (!this.m_smbPkt.checkPacketIsValid(3, 0)) {
            this.m_sess.sendErrorResponseSMB(64, 2);
            return;
        }
        int treeId = this.m_smbPkt.getTreeId();
        TreeConnection conn = this.m_sess.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        int fid = this.m_smbPkt.getParameter(0);
        int ftime = this.m_smbPkt.getParameter(1);
        int fdate = this.m_smbPkt.getParameter(2);
        NetworkFile netFile = conn.findFile(fid);
        if (netFile == null) {
            this.m_sess.sendErrorResponseSMB(6, 1);
            return;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(64)) {
            logger.debug((Object)("File close [" + treeId + "] fid=" + fid));
        }
        try {
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            if (disk != null) {
                disk.closeFile(this.m_sess, conn, netFile);
            }
            netFile.setClosed(true);
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        catch (IOException ex) {
            // empty catch block
        }
        conn.removeFile(fid, this.getSession());
        outPkt.setParameterCount(0);
        outPkt.setByteCount(0);
        this.m_sess.sendResponseSMB(outPkt);
    }

    protected void procCreateDirectory(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        if (!this.m_smbPkt.checkPacketIsValid(0, 2)) {
            this.m_sess.sendErrorResponseSMB(64, 2);
            return;
        }
        int treeId = this.m_smbPkt.getTreeId();
        TreeConnection conn = this.m_sess.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(15, 1);
            return;
        }
        if (!conn.hasWriteAccess()) {
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        int dataPos = this.m_smbPkt.getByteOffset();
        int dataLen = this.m_smbPkt.getByteCount();
        byte[] buf = this.m_smbPkt.getBuffer();
        String dirName = DataPacker.getDataString('\u0004', buf, dataPos, dataLen, this.m_smbPkt.isUnicode());
        if (dirName == null) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(64)) {
            logger.debug((Object)("Directory Create [" + treeId + "] name=" + dirName));
        }
        try {
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            FileOpenParams params = new FileOpenParams(dirName, 16, 2, 16);
            disk.createDirectory(this.m_sess, conn, params);
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        catch (FileExistsException ex) {
            this.m_sess.sendErrorResponseSMB(-1073741771, 80, 1);
            return;
        }
        catch (AccessDeniedException ex) {
            this.m_sess.sendErrorResponseSMB(-1073741790, 15, 1);
            return;
        }
        catch (IOException ex) {
            this.m_sess.sendErrorResponseSMB(3, 1);
            return;
        }
        outPkt.setParameterCount(0);
        outPkt.setByteCount(0);
        this.m_sess.sendResponseSMB(outPkt);
    }

    protected void procCreateFile(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        int fid;
        if (!this.m_smbPkt.checkPacketIsValid(3, 2)) {
            this.m_sess.sendErrorResponseSMB(64, 2);
            return;
        }
        int treeId = this.m_smbPkt.getTreeId();
        TreeConnection conn = this.m_sess.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(15, 1);
            return;
        }
        if (!conn.hasWriteAccess()) {
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        int dataPos = this.m_smbPkt.getByteOffset();
        int dataLen = this.m_smbPkt.getByteCount();
        byte[] buf = this.m_smbPkt.getBuffer();
        String fileName = DataPacker.getDataString('\u0004', buf, dataPos, dataLen, this.m_smbPkt.isUnicode());
        if (fileName == null) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        int attr = this.m_smbPkt.getParameter(0);
        FileOpenParams params = new FileOpenParams(fileName, 16, 2, attr);
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(64)) {
            logger.debug((Object)("File Create [" + treeId + "] params=" + params));
        }
        NetworkFile netFile = null;
        try {
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            netFile = disk.createFile(this.m_sess, conn, params);
            fid = conn.addFile(netFile, this.getSession());
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        catch (TooManyFilesException ex) {
            this.m_sess.sendErrorResponseSMB(4, 1);
            return;
        }
        catch (FileExistsException ex) {
            this.m_sess.sendErrorResponseSMB(80, 1);
            return;
        }
        catch (IOException ex) {
            this.m_sess.sendErrorResponseSMB(2, 1);
            return;
        }
        outPkt.setParameterCount(1);
        outPkt.setParameter(0, fid);
        outPkt.setByteCount(0);
        this.m_sess.sendResponseSMB(outPkt);
    }

    protected void procCreateTemporaryFile(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
    }

    protected void procDeleteDirectory(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        if (!this.m_smbPkt.checkPacketIsValid(0, 2)) {
            this.m_sess.sendErrorResponseSMB(64, 2);
            return;
        }
        int treeId = this.m_smbPkt.getTreeId();
        TreeConnection conn = this.m_sess.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(15, 1);
            return;
        }
        if (!conn.hasWriteAccess()) {
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        int dataPos = this.m_smbPkt.getByteOffset();
        int dataLen = this.m_smbPkt.getByteCount();
        byte[] buf = this.m_smbPkt.getBuffer();
        String dirName = DataPacker.getDataString('\u0004', buf, dataPos, dataLen, this.m_smbPkt.isUnicode());
        if (dirName == null) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(64)) {
            logger.debug((Object)("Directory Delete [" + treeId + "] name=" + dirName));
        }
        try {
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            disk.deleteDirectory(this.m_sess, conn, dirName);
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        catch (AccessDeniedException ex) {
            this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
            return;
        }
        catch (DirectoryNotEmptyException ex) {
            this.m_sess.sendErrorResponseSMB(145, 1);
            return;
        }
        catch (IOException ex) {
            this.m_sess.sendErrorResponseSMB(3, 1);
            return;
        }
        outPkt.setParameterCount(0);
        outPkt.setByteCount(0);
        this.m_sess.sendResponseSMB(outPkt);
    }

    protected void procDeleteFile(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        if (!this.m_smbPkt.checkPacketIsValid(1, 2)) {
            this.m_sess.sendErrorResponseSMB(64, 2);
            return;
        }
        int treeId = this.m_smbPkt.getTreeId();
        TreeConnection conn = this.m_sess.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(15, 1);
            return;
        }
        if (!conn.hasWriteAccess()) {
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        int dataPos = this.m_smbPkt.getByteOffset();
        int dataLen = this.m_smbPkt.getByteCount();
        byte[] buf = this.m_smbPkt.getBuffer();
        String fileName = DataPacker.getDataString('\u0004', buf, dataPos, dataLen, this.m_smbPkt.isUnicode());
        if (fileName == null) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(64)) {
            logger.debug((Object)("File Delete [" + treeId + "] name=" + fileName));
        }
        Object netFile = null;
        try {
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            disk.deleteFile(this.m_sess, conn, fileName);
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        catch (IOException ex) {
            this.m_sess.sendErrorResponseSMB(2, 1);
            return;
        }
        outPkt.setParameterCount(0);
        outPkt.setByteCount(0);
        this.m_sess.sendResponseSMB(outPkt);
    }

    protected void procDiskAttributes(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(32)) {
            logger.debug((Object)"Get disk attributes");
        }
        if (this.m_smbPkt.getParameterCount() != 0 && this.m_smbPkt.getByteCount() != 0) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        int treeId = this.m_smbPkt.getTreeId();
        TreeConnection conn = this.m_sess.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(5, 2);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        DiskInterface disk = null;
        DiskDeviceContext diskCtx = null;
        try {
            disk = (DiskInterface)conn.getSharedDevice().getInterface();
            diskCtx = (DiskDeviceContext)conn.getContext();
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        SrvDiskInfo diskInfo = this.getDiskInformation(disk, diskCtx);
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(32)) {
            logger.debug((Object)("  Disk info - total=" + diskInfo.getTotalUnits() + ", free=" + diskInfo.getFreeUnits() + ", blocksPerUnit=" + diskInfo.getBlocksPerAllocationUnit() + ", blockSize=" + diskInfo.getBlockSize()));
        }
        long totUnits = diskInfo.getTotalUnits();
        long freeUnits = diskInfo.getFreeUnits();
        int blocksUnit = diskInfo.getBlocksPerAllocationUnit();
        while (totUnits > 65535L && blocksUnit <= 65535) {
            blocksUnit *= 2;
            totUnits /= 2L;
            freeUnits /= 2L;
        }
        if (totUnits > 65535L || blocksUnit > 65535) {
            totUnits = 65535L;
            if (freeUnits > 65535L) {
                freeUnits = 32767L;
            }
            if (blocksUnit > 65535) {
                blocksUnit = 65535;
            }
        }
        outPkt.setParameterCount(5);
        outPkt.setParameter(0, (int)totUnits);
        outPkt.setParameter(1, blocksUnit);
        outPkt.setParameter(2, diskInfo.getBlockSize());
        outPkt.setParameter(3, (int)freeUnits);
        outPkt.setParameter(4, 0);
        outPkt.setByteCount(0);
        this.m_sess.sendResponseSMB(outPkt);
    }

    protected void procEcho(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        if (!this.m_smbPkt.checkPacketIsValid(1, 0)) {
            this.m_sess.sendErrorResponseSMB(64, 2);
            return;
        }
        int echoCnt = this.m_smbPkt.getParameter(0);
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(512)) {
            logger.debug((Object)("Echo - Count = " + echoCnt));
        }
        int echoSeq = 1;
        while (echoCnt > 0) {
            outPkt.setParameter(0, echoSeq++);
            this.m_sess.sendResponseSMB(outPkt);
            --echoCnt;
            if (!logger.isDebugEnabled() || !this.m_sess.hasDebug(512)) continue;
            logger.debug((Object)("Echo Packet, Seq = " + echoSeq));
        }
    }

    protected void procFlushFile(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        if (!this.m_smbPkt.checkPacketIsValid(1, 0)) {
            this.m_sess.sendErrorResponseSMB(64, 2);
            return;
        }
        int treeId = this.m_smbPkt.getTreeId();
        TreeConnection conn = this.m_sess.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(15, 1);
            return;
        }
        if (!conn.hasWriteAccess()) {
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        int fid = this.m_smbPkt.getParameter(0);
        NetworkFile netFile = conn.findFile(fid);
        if (netFile == null) {
            this.m_sess.sendErrorResponseSMB(6, 1);
            return;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(64)) {
            logger.debug((Object)("File Flush [" + netFile.getFileId() + "]"));
        }
        try {
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            disk.flushFile(this.m_sess, conn, netFile);
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        catch (IOException ex) {
            if (logger.isDebugEnabled() && this.m_sess.hasDebug(64)) {
                logger.debug((Object)("File Flush Error [" + netFile.getFileId() + "] : " + ex.toString()));
            }
            this.m_sess.sendErrorResponseSMB(29, 3);
            return;
        }
        outPkt.setParameterCount(0);
        outPkt.setByteCount(0);
        this.m_sess.sendResponseSMB(outPkt);
    }

    protected void procGetFileAttributes(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        if (!this.m_smbPkt.checkPacketIsValid(0, 2)) {
            this.m_sess.sendErrorResponseSMB(64, 2);
            return;
        }
        int treeId = this.m_smbPkt.getTreeId();
        TreeConnection conn = this.m_sess.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        int dataPos = this.m_smbPkt.getByteOffset();
        int dataLen = this.m_smbPkt.getByteCount();
        byte[] buf = this.m_smbPkt.getBuffer();
        String fileName = DataPacker.getDataString('\u0004', buf, dataPos, dataLen, this.m_smbPkt.isUnicode());
        if (fileName == null) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(64)) {
            logger.debug((Object)("Get File Information [" + treeId + "] name=" + fileName));
        }
        try {
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            FileInfo finfo = disk.getFileInformation(this.m_sess, conn, fileName);
            if (finfo != null) {
                if (conn.getSharedDevice().isReadOnly() && !finfo.isReadOnly()) {
                    finfo.setFileAttributes(finfo.getFileAttributes() + 1);
                }
                outPkt.setParameterCount(10);
                outPkt.setParameter(0, finfo.getFileAttributes());
                if (finfo.getModifyDateTime() != 0L) {
                    SMBDate dateTime = new SMBDate(finfo.getModifyDateTime());
                    outPkt.setParameter(1, dateTime.asSMBTime());
                    outPkt.setParameter(2, dateTime.asSMBDate());
                } else {
                    outPkt.setParameter(1, 0);
                    outPkt.setParameter(2, 0);
                }
                outPkt.setParameter(3, (int)finfo.getSize() & 0xFFFF);
                outPkt.setParameter(4, (int)(finfo.getSize() & 0xFFFFFFFFFFFF0000L) >> 16);
                for (int i = 5; i < 10; ++i) {
                    outPkt.setParameter(i, 0);
                }
                outPkt.setByteCount(0);
                this.m_sess.sendResponseSMB(outPkt);
                return;
            }
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        catch (IOException ex) {
            // empty catch block
        }
        this.m_sess.sendErrorResponseSMB(2, 1);
    }

    protected void procGetFileInformation(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        if (!this.m_smbPkt.checkPacketIsValid(1, 0)) {
            this.m_sess.sendErrorResponseSMB(64, 2);
            return;
        }
        int treeId = this.m_smbPkt.getTreeId();
        TreeConnection conn = this.m_sess.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        int fid = this.m_smbPkt.getParameter(0);
        NetworkFile netFile = conn.findFile(fid);
        if (netFile == null) {
            this.m_sess.sendErrorResponseSMB(6, 1);
            return;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(64)) {
            logger.debug((Object)("Get File Information 2 [" + netFile.getFileId() + "]"));
        }
        try {
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            FileInfo finfo = disk.getFileInformation(this.m_sess, conn, netFile.getFullName());
            if (finfo != null) {
                if (conn.getSharedDevice().isReadOnly() && !finfo.isReadOnly()) {
                    finfo.setFileAttributes(finfo.getFileAttributes() + 1);
                }
                outPkt.setParameterCount(11);
                outPkt.setByteCount(0);
                SMBDate dateTime = new SMBDate(0);
                if (finfo.getCreationDateTime() != 0L) {
                    dateTime.setTime(finfo.getCreationDateTime());
                    outPkt.setParameter(0, dateTime.asSMBDate());
                    outPkt.setParameter(1, dateTime.asSMBTime());
                } else {
                    outPkt.setParameter(0, 0);
                    outPkt.setParameter(1, 0);
                }
                if (finfo.getAccessDateTime() != 0L) {
                    dateTime.setTime(finfo.getAccessDateTime());
                    outPkt.setParameter(2, dateTime.asSMBDate());
                    outPkt.setParameter(3, dateTime.asSMBTime());
                } else {
                    outPkt.setParameter(2, 0);
                    outPkt.setParameter(3, 0);
                }
                if (finfo.getModifyDateTime() != 0L) {
                    dateTime.setTime(finfo.getModifyDateTime());
                    outPkt.setParameter(4, dateTime.asSMBDate());
                    outPkt.setParameter(5, dateTime.asSMBTime());
                } else {
                    outPkt.setParameter(4, 0);
                    outPkt.setParameter(5, 0);
                }
                outPkt.setParameter(6, (int)finfo.getSize() & 0xFFFF);
                outPkt.setParameter(7, (int)(finfo.getSize() & 0xFFFFFFFFFFFF0000L) >> 16);
                outPkt.setParameter(8, (int)finfo.getSize() & 0xFFFF);
                outPkt.setParameter(9, (int)(finfo.getSize() & 0xFFFFFFFFFFFF0000L) >> 16);
                outPkt.setParameter(10, finfo.getFileAttributes());
                this.m_sess.sendResponseSMB(outPkt);
                return;
            }
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        catch (IOException ex) {
            // empty catch block
        }
        this.m_sess.sendErrorResponseSMB(2, 1);
    }

    protected void procLockFile(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        if (!this.m_smbPkt.checkPacketIsValid(5, 0)) {
            this.m_sess.sendErrorResponseSMB(64, 2);
            return;
        }
        int treeId = this.m_smbPkt.getTreeId();
        TreeConnection conn = this.m_sess.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        int fid = this.m_smbPkt.getParameter(0);
        long lockcnt = this.m_smbPkt.getParameterLong(1);
        long lockoff = this.m_smbPkt.getParameterLong(3);
        NetworkFile netFile = conn.findFile(fid);
        if (netFile == null) {
            this.m_sess.sendErrorResponseSMB(6, 1);
            return;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(128)) {
            logger.debug((Object)("File Lock [" + netFile.getFileId() + "] : Offset=" + lockoff + " ,Count=" + lockcnt));
        }
        outPkt.setParameterCount(0);
        outPkt.setByteCount(0);
        this.m_sess.sendResponseSMB(outPkt);
    }

    protected void procOpenFile(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        int fid;
        if (!this.m_smbPkt.checkPacketIsValid(2, 2)) {
            this.m_sess.sendErrorResponseSMB(64, 2);
            return;
        }
        int treeId = this.m_smbPkt.getTreeId();
        TreeConnection conn = this.m_sess.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        int dataPos = this.m_smbPkt.getByteOffset();
        int dataLen = this.m_smbPkt.getByteCount();
        byte[] buf = this.m_smbPkt.getBuffer();
        String fileName = DataPacker.getDataString('\u0004', buf, dataPos, dataLen, this.m_smbPkt.isUnicode());
        if (fileName == null) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        int mode = this.m_smbPkt.getParameter(0);
        int attr = this.m_smbPkt.getParameter(1);
        FileOpenParams params = new FileOpenParams(fileName, mode, 2, attr);
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(64)) {
            logger.debug((Object)("File Open [" + treeId + "] params=" + params));
        }
        NetworkFile netFile = null;
        try {
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            netFile = disk.openFile(this.m_sess, conn, params);
            fid = conn.addFile(netFile, this.getSession());
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        catch (TooManyFilesException ex) {
            this.m_sess.sendErrorResponseSMB(4, 1);
            return;
        }
        catch (AccessDeniedException ex) {
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        catch (FileSharingException ex) {
            this.m_sess.sendErrorResponseSMB(32, 1);
            return;
        }
        catch (IOException ex) {
            this.m_sess.sendErrorResponseSMB(2, 1);
            return;
        }
        outPkt.setParameterCount(7);
        outPkt.setParameter(0, fid);
        outPkt.setParameter(1, 0);
        if (netFile.hasModifyDate()) {
            outPkt.setParameterLong(2, (int)(netFile.getModifyDate() / 1000L));
        } else {
            outPkt.setParameterLong(2, 0);
        }
        outPkt.setParameterLong(4, netFile.getFileSizeInt());
        outPkt.setParameter(6, netFile.getGrantedAccess());
        outPkt.setByteCount(0);
        this.m_sess.sendResponseSMB(outPkt);
    }

    protected void procProcessExit(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        if (!this.m_smbPkt.checkPacketIsValid(0, 0)) {
            this.m_sess.sendErrorResponseSMB(64, 2);
            return;
        }
        int treeId = this.m_smbPkt.getTreeId();
        TreeConnection conn = this.m_sess.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(15, 1);
            return;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(64)) {
            logger.debug((Object)("Process Exit - Open files = " + conn.openFileCount()));
        }
        if (conn.openFileCount() > 0) {
            conn.closeConnection(this.getSession());
        }
        outPkt.setParameterCount(0);
        outPkt.setByteCount(0);
        this.m_sess.sendResponseSMB(outPkt);
    }

    protected void procReadFile(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        if (!this.m_smbPkt.checkPacketIsValid(5, 0)) {
            this.m_sess.sendErrorResponseSMB(64, 2);
            return;
        }
        int treeId = this.m_smbPkt.getTreeId();
        TreeConnection conn = this.m_sess.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        int fid = this.m_smbPkt.getParameter(0);
        int reqcnt = this.m_smbPkt.getParameter(1);
        int reqoff = this.m_smbPkt.getParameter(2) + (this.m_smbPkt.getParameter(3) << 16);
        NetworkFile netFile = conn.findFile(fid);
        if (netFile == null) {
            this.m_sess.sendErrorResponseSMB(6, 1);
            return;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(128)) {
            logger.debug((Object)("File Read [" + netFile.getFileId() + "] : Size=" + reqcnt + " ,Pos=" + reqoff));
        }
        byte[] buf = outPkt.getBuffer();
        int rdlen = 0;
        try {
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            int dataOff = outPkt.getByteOffset() + 3;
            int availCnt = buf.length - dataOff;
            if (!this.m_sess.hasClientCapability(16384)) {
                availCnt = this.m_sess.getClientMaximumBufferSize() - dataOff;
            }
            if (availCnt < reqcnt) {
                reqcnt = availCnt;
                if (logger.isDebugEnabled() && this.m_sess.hasDebug(128)) {
                    logger.debug((Object)("File Read [" + netFile.getFileId() + "] Limited to " + availCnt));
                }
            }
            rdlen = disk.readFile(this.m_sess, conn, netFile, buf, outPkt.getByteOffset() + 3, reqcnt, reqoff);
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        catch (IOException ex) {
            if (logger.isDebugEnabled() && this.m_sess.hasDebug(128)) {
                logger.debug((Object)("File Read Error [" + netFile.getFileId() + "] : " + ex.toString()));
            }
            this.m_sess.sendErrorResponseSMB(30, 3);
            return;
        }
        int bytOff = outPkt.getByteOffset();
        buf[bytOff] = 1;
        DataPacker.putIntelShort(rdlen, buf, bytOff + 1);
        outPkt.setByteCount(rdlen + 3);
        outPkt.setParameter(0, rdlen);
        outPkt.setParameter(1, 0);
        outPkt.setParameter(2, 0);
        outPkt.setParameter(3, 0);
        outPkt.setParameter(4, 0);
        this.m_sess.sendResponseSMB(outPkt);
    }

    protected void procRenameFile(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        boolean isUni;
        if (!this.m_smbPkt.checkPacketIsValid(1, 4)) {
            this.m_sess.sendErrorResponseSMB(64, 2);
            return;
        }
        int treeId = this.m_smbPkt.getTreeId();
        TreeConnection conn = this.m_sess.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(15, 1);
            return;
        }
        if (!conn.hasWriteAccess()) {
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        int dataPos = this.m_smbPkt.getByteOffset();
        int dataLen = this.m_smbPkt.getByteCount();
        byte[] buf = this.m_smbPkt.getBuffer();
        String oldName = DataPacker.getDataString('\u0004', buf, dataPos, dataLen, isUni = this.m_smbPkt.isUnicode());
        if (oldName == null) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        if (isUni) {
            int len = oldName.length() * 2 + 2;
            dataPos = DataPacker.wordAlign(dataPos + 1) + len;
            dataLen -= len;
        } else {
            dataPos += oldName.length() + 2;
            dataLen -= oldName.length() + 2;
        }
        String newName = DataPacker.getDataString('\u0004', buf, dataPos, dataLen, isUni);
        if (newName == null) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(64)) {
            logger.debug((Object)("File Rename [" + treeId + "] old name=" + oldName + ", new name=" + newName));
        }
        Object netFile = null;
        try {
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            disk.renameFile(this.m_sess, conn, oldName, newName);
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        catch (IOException ex) {
            this.m_sess.sendErrorResponseSMB(2, 1);
            return;
        }
        outPkt.setParameterCount(0);
        outPkt.setByteCount(0);
        this.m_sess.sendResponseSMB(outPkt);
    }

    protected final void procSearch(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        if (!this.m_smbPkt.checkPacketIsValid(2, 5)) {
            this.m_sess.sendErrorResponseSMB(64, 2);
            return;
        }
        int treeId = this.m_smbPkt.getTreeId();
        TreeConnection conn = this.m_sess.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(5, 2);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        int maxFiles = this.m_smbPkt.getParameter(0);
        int srchAttr = this.m_smbPkt.getParameter(1);
        if ((srchAttr & 8) != 0) {
            this.procSearchVolumeLabel(outPkt);
            return;
        }
        int dataPos = this.m_smbPkt.getByteOffset();
        int dataLen = this.m_smbPkt.getByteCount();
        byte[] buf = this.m_smbPkt.getBuffer();
        String srchPath = DataPacker.getDataString('\u0004', buf, dataPos, dataLen, this.m_smbPkt.isUnicode());
        if (srchPath == null) {
            this.m_sess.sendErrorResponseSMB(1, 1);
            return;
        }
        dataPos += srchPath.length() + 2;
        dataLen -= srchPath.length() + 2;
        int resumeLen = 0;
        if (buf[dataPos++] == 5) {
            resumeLen = DataPacker.getIntelShort(buf, dataPos);
            dataPos += 2;
            if (resumeLen > (dataLen -= 3)) {
                this.m_sess.sendErrorResponseSMB(13, 1);
                return;
            }
        }
        SearchContext ctx = null;
        DiskInterface disk = null;
        try {
            disk = (DiskInterface)conn.getSharedDevice().getInterface();
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        byte[] resumeKey = null;
        int searchId = -1;
        int resumeId = 32771;
        if (resumeLen == 0 && srchPath.length() > 0) {
            searchId = this.m_sess.allocateSearchSlot();
            if (searchId == -1) {
                int idx = 0;
                ctx = this.m_sess.getSearchContext(idx);
                while (ctx != null && searchId == -1) {
                    if (ctx.getSearchString().compareTo("????????.???") == 0) {
                        if (logger.isDebugEnabled() && this.m_sess.hasDebug(16)) {
                            logger.debug((Object)("Release leaked search [" + idx + "]"));
                        }
                        this.m_sess.deallocateSearchSlot(idx);
                        searchId = this.m_sess.allocateSearchSlot();
                        continue;
                    }
                    ctx = this.m_sess.getSearchContext(++idx);
                }
                if (searchId == -1) {
                    this.m_sess.sendErrorResponseSMB(89, 2);
                    return;
                }
            }
            if (logger.isDebugEnabled() && this.m_sess.hasDebug(16)) {
                logger.debug((Object)("Start search [" + searchId + "] - " + srchPath + ", attr=0x" + Integer.toHexString(srchAttr) + ", maxFiles=" + maxFiles));
            }
            if ((ctx = disk.startSearch(this.m_sess, conn, srchPath, srchAttr)) != null) {
                ctx.setTreeId(treeId);
                ctx.setMaximumFiles(maxFiles);
            }
            this.m_sess.setSearchContext(searchId, ctx);
        } else {
            resumeKey = new byte[21];
            CoreResumeKey.getResumeKey(buf, dataPos, resumeKey);
            int id = CoreResumeKey.getServerArea(resumeKey, 0);
            searchId = (id & 0xFFFF0000) >> 16;
            ctx = this.m_sess.getSearchContext(searchId);
            if (ctx == null) {
                this.m_sess.sendErrorResponseSMB(13, 1);
                return;
            }
            resumeId = id & 0xFFFF;
            if (resumeId < 32769 && ctx.getResumeId() != resumeId) {
                if (logger.isDebugEnabled() && this.m_sess.hasDebug(16)) {
                    logger.debug((Object)("Search resume at " + resumeId));
                }
                if (!ctx.restartAt(resumeId)) {
                    if (logger.isDebugEnabled() && this.m_sess.hasDebug(16)) {
                        logger.debug((Object)"Search restart failed");
                    }
                    this.m_sess.sendErrorResponseSMB(18, 1);
                    this.m_sess.deallocateSearchSlot(searchId);
                    return;
                }
            }
        }
        if (ctx == null) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        if (ctx.getTreeId() != treeId) {
            this.m_sess.sendErrorResponseSMB(5, 2);
            return;
        }
        outPkt.setParameterCount(1);
        int bufPos = outPkt.getByteOffset();
        buf[bufPos] = 5;
        bufPos += 3;
        int fileCnt = 0;
        if ((srchAttr & 0x10) != 0 && resumeId >= 32769 && WildCard.containsWildcards(srchPath)) {
            String workDir = FileName.removeFileName(srchPath);
            FileInfo dirInfo = disk.getFileInformation(this.m_sess, conn, workDir);
            if (dirInfo != null) {
                dirInfo = new FileInfo(".", 0L, 16);
            }
            if (logger.isDebugEnabled() && this.m_sess.hasDebug(16)) {
                logger.debug((Object)("Search adding . and .. entries:  " + dirInfo.toString()));
            }
            if (resumeId == 32771) {
                dirInfo.setFileName(".");
                resumeId = 32770;
                bufPos = this.packSearchInfo(buf, bufPos, ctx.getSearchString(), 32770, searchId, dirInfo);
                ++fileCnt;
            }
            if (resumeId == 32770) {
                dirInfo.setFileName("..");
                bufPos = this.packSearchInfo(buf, bufPos, ctx.getSearchString(), 32769, searchId, dirInfo);
                ++fileCnt;
            }
        }
        FileInfo fileInfo = new FileInfo();
        while (fileCnt < ctx.getMaximumFiles() && ctx.nextFileInfo(fileInfo)) {
            if (fileInfo.getFileName().startsWith(".")) continue;
            resumeId = ctx.getResumeId();
            if (logger.isDebugEnabled() && this.m_sess.hasDebug(16)) {
                logger.debug((Object)("Search return file " + fileInfo.toString() + ", resumeId=" + resumeId));
            }
            if (conn.getSharedDevice().isReadOnly() && !fileInfo.isReadOnly()) {
                fileInfo.setFileAttributes(fileInfo.getFileAttributes() + 1);
            }
            bufPos = this.packSearchInfo(buf, bufPos, ctx.getSearchString(), resumeId, searchId, fileInfo);
            ++fileCnt;
            fileInfo.resetInfo();
        }
        if (fileCnt == 0) {
            outPkt.setParameterCount(1);
            outPkt.setParameter(0, 0);
            outPkt.setByteCount(0);
            outPkt.setErrorClass(1);
            outPkt.setErrorCode(18);
            this.m_sess.sendResponseSMB(outPkt);
            if (logger.isDebugEnabled() && this.m_sess.hasDebug(16)) {
                logger.debug((Object)("End search [" + searchId + "]"));
            }
            this.m_sess.deallocateSearchSlot(searchId);
        } else {
            dataLen = bufPos - outPkt.getByteOffset();
            outPkt.setByteCount(dataLen);
            bufPos = outPkt.getByteOffset() + 1;
            DataPacker.putIntelShort(dataLen - 3, buf, bufPos);
            outPkt.setParameter(0, fileCnt);
            this.m_sess.sendResponseSMB(outPkt);
            if (fileCnt == 1 && resumeLen == 0 && !WildCard.containsWildcards(srchPath)) {
                if (logger.isDebugEnabled() && this.m_sess.hasDebug(16)) {
                    logger.debug((Object)("End search [" + searchId + "] (Not wildcard)"));
                }
                this.m_sess.deallocateSearchSlot(searchId);
            }
        }
    }

    protected final void procSearchVolumeLabel(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        int treeId = this.m_smbPkt.getTreeId();
        TreeConnection conn = this.m_sess.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(5, 2);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(16)) {
            logger.debug((Object)"Start Search - Volume Label");
        }
        DiskInterface disk = null;
        DiskDeviceContext diskCtx = null;
        try {
            disk = (DiskInterface)conn.getSharedDevice().getInterface();
            diskCtx = (DiskDeviceContext)conn.getContext();
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        VolumeInfo volInfo = diskCtx.getVolumeInformation();
        String volLabel = "";
        if (volInfo != null) {
            volLabel = volInfo.getVolumeLabel();
        }
        outPkt.setParameterCount(1);
        int bufPos = outPkt.getByteOffset();
        byte[] buf = outPkt.getBuffer();
        buf[bufPos++] = 5;
        int dataLen = 43;
        DataPacker.putIntelShort(dataLen, buf, bufPos);
        CoreResumeKey.putResumeKey(buf, bufPos += 2, volLabel, -1);
        bufPos += 21;
        buf[bufPos++] = 8;
        for (int i = 0; i < 8; ++i) {
            buf[bufPos++] = 0;
        }
        StringBuffer volBuf = new StringBuffer();
        volBuf.append(volLabel);
        while (volBuf.length() < 13) {
            volBuf.append(" ");
        }
        if (volBuf.length() > 12) {
            volBuf.setLength(12);
        }
        bufPos = DataPacker.putString(volBuf.toString().toUpperCase(), buf, bufPos, true);
        dataLen = bufPos - this.m_smbPkt.getByteOffset();
        outPkt.setByteCount(dataLen);
        this.m_sess.sendResponseSMB(outPkt);
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(16)) {
            logger.debug((Object)("Volume label for " + conn.toString() + " is " + volLabel));
        }
    }

    protected final void procSeekFile(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        if (!this.m_smbPkt.checkPacketIsValid(4, 0)) {
            this.m_sess.sendErrorResponseSMB(64, 2);
            return;
        }
        int treeId = this.m_smbPkt.getTreeId();
        TreeConnection conn = this.m_sess.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        int fid = this.m_smbPkt.getParameter(0);
        int seekMode = this.m_smbPkt.getParameter(1);
        long seekPos = this.m_smbPkt.getParameterLong(2);
        NetworkFile netFile = conn.findFile(fid);
        if (netFile == null) {
            this.m_sess.sendErrorResponseSMB(6, 1);
            return;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(64)) {
            logger.debug((Object)("File Seek [" + netFile.getFileId() + "] : Mode = " + seekMode + ", Pos = " + seekPos));
        }
        byte[] buf = outPkt.getBuffer();
        long pos = 0L;
        try {
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            pos = disk.seekFile(this.m_sess, conn, netFile, seekPos, seekMode);
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        catch (IOException ex) {
            if (logger.isDebugEnabled() && this.m_sess.hasDebug(64)) {
                logger.debug((Object)("File Seek Error [" + netFile.getFileId() + "] : " + ex.toString()));
            }
            this.m_sess.sendErrorResponseSMB(30, 3);
            return;
        }
        outPkt.setParameterCount(2);
        outPkt.setParameterLong(0, (int)(pos & 0xFFFFFFFFL));
        outPkt.setByteCount(0);
        this.m_sess.sendResponseSMB(outPkt);
    }

    protected void procSessionSetup(SMBSrvPacket outPkt) throws SMBSrvException, IOException, TooManyConnectionsException {
        outPkt.setParameterCount(3);
        outPkt.setParameter(0, 0);
        outPkt.setParameter(1, 0);
        outPkt.setParameter(2, 8192);
        outPkt.setByteCount(0);
        outPkt.setTreeId(0);
        outPkt.setUserId(0);
        int pos = outPkt.getByteOffset();
        byte[] buf = outPkt.getBuffer();
        pos = DataPacker.putString("Java", buf, pos, true);
        pos = DataPacker.putString("JLAN Server " + this.m_sess.getServer().isVersion(), buf, pos, true);
        pos = DataPacker.putString(this.m_sess.getServer().getConfiguration().getDomainName(), buf, pos, true);
        outPkt.setByteCount(pos - outPkt.getByteOffset());
        this.m_sess.sendResponseSMB(outPkt);
        this.m_sess.setState(3);
    }

    protected void procSetFileAttributes(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        if (!this.m_smbPkt.checkPacketIsValid(8, 0)) {
            this.m_sess.sendErrorResponseSMB(64, 2);
            return;
        }
        int treeId = this.m_smbPkt.getTreeId();
        TreeConnection conn = this.m_sess.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(15, 1);
            return;
        }
        if (!conn.hasWriteAccess()) {
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        int dataPos = this.m_smbPkt.getByteOffset();
        int dataLen = this.m_smbPkt.getByteCount();
        byte[] buf = this.m_smbPkt.getBuffer();
        String fileName = DataPacker.getDataString('\u0004', buf, dataPos, dataLen, this.m_smbPkt.isUnicode());
        if (fileName == null) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        int fattr = this.m_smbPkt.getParameter(0);
        int setFlags = 4;
        FileInfo finfo = new FileInfo(fileName, 0L, fattr);
        int fdate = this.m_smbPkt.getParameter(1);
        int ftime = this.m_smbPkt.getParameter(2);
        if (fdate != 0 && ftime != 0) {
            finfo.setModifyDateTime(new SMBDate(fdate, ftime).getTime());
            setFlags += 8;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(64)) {
            logger.debug((Object)("Set File Attributes [" + treeId + "] name=" + fileName + ", attr=0x" + Integer.toHexString(fattr) + ", fdate=" + fdate + ", ftime=" + ftime));
        }
        try {
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            finfo.setFileInformationFlags(setFlags);
            disk.setFileInformation(this.m_sess, conn, fileName, finfo);
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        catch (IOException ex) {
            // empty catch block
        }
        outPkt.setParameterCount(0);
        outPkt.setByteCount(0);
        this.m_sess.sendResponseSMB(outPkt);
    }

    protected void procSetFileInformation(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        if (!this.m_smbPkt.checkPacketIsValid(7, 0)) {
            this.m_sess.sendErrorResponseSMB(64, 2);
            return;
        }
        int treeId = this.m_smbPkt.getTreeId();
        TreeConnection conn = this.m_sess.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(15, 1);
            return;
        }
        if (!conn.hasWriteAccess()) {
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        int fid = this.m_smbPkt.getParameter(0);
        NetworkFile netFile = conn.findFile(fid);
        if (netFile == null) {
            this.m_sess.sendErrorResponseSMB(6, 1);
            return;
        }
        int setFlags = 0;
        FileInfo finfo = new FileInfo(netFile.getName(), 0L, 0);
        int fdate = this.m_smbPkt.getParameter(1);
        int ftime = this.m_smbPkt.getParameter(2);
        if (fdate != 0 && ftime != 0) {
            finfo.setCreationDateTime(new SMBDate(fdate, ftime).getTime());
            setFlags += 16;
        }
        fdate = this.m_smbPkt.getParameter(3);
        ftime = this.m_smbPkt.getParameter(4);
        if (fdate != 0 && ftime != 0) {
            finfo.setAccessDateTime(new SMBDate(fdate, ftime).getTime());
            setFlags += 32;
        }
        fdate = this.m_smbPkt.getParameter(5);
        ftime = this.m_smbPkt.getParameter(6);
        if (fdate != 0 && ftime != 0) {
            finfo.setModifyDateTime(new SMBDate(fdate, ftime).getTime());
            setFlags += 8;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(64)) {
            logger.debug((Object)("Set File Information 2 [" + netFile.getFileId() + "] " + finfo.toString()));
        }
        try {
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            finfo.setFileInformationFlags(setFlags);
            disk.setFileInformation(this.m_sess, conn, netFile.getFullName(), finfo);
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        catch (IOException ex) {
            // empty catch block
        }
        outPkt.setParameterCount(0);
        outPkt.setByteCount(0);
        this.m_sess.sendResponseSMB(outPkt);
    }

    protected void procTreeConnect(SMBSrvPacket outPkt) throws SMBSrvException, TooManyConnectionsException, IOException {
        boolean isUni;
        if (!this.m_smbPkt.checkPacketIsValid(0, 4)) {
            this.m_sess.sendErrorResponseSMB(64, 2);
            return;
        }
        int dataPos = this.m_smbPkt.getByteOffset();
        int dataLen = this.m_smbPkt.getByteCount();
        byte[] buf = this.m_smbPkt.getBuffer();
        String uncPath = DataPacker.getDataString('\u0004', buf, dataPos, dataLen, isUni = this.m_smbPkt.isUnicode());
        if (uncPath == null) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        if (isUni) {
            dataPos = DataPacker.wordAlign(dataPos + 1) + uncPath.length() * 2 + 2;
            dataLen -= uncPath.length() * 2 + 2;
        } else {
            dataPos += uncPath.length() + 2;
            dataLen -= uncPath.length() + 2;
        }
        String pwd = DataPacker.getDataString('\u0004', buf, dataPos, dataLen, isUni);
        if (pwd == null) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        if (isUni) {
            dataPos = DataPacker.wordAlign(dataPos + 1) + pwd.length() * 2 + 2;
            dataLen -= pwd.length() * 2 + 2;
        } else {
            dataPos += pwd.length() + 2;
            dataLen -= pwd.length() + 2;
        }
        String service = DataPacker.getDataString('\u0004', buf, dataPos, dataLen, isUni);
        if (service == null) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        int servType = ShareType.ServiceAsType(service);
        if (servType == -1) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(8)) {
            logger.debug((Object)("Tree connect - " + uncPath + ", " + service));
        }
        PCShare share = null;
        try {
            share = new PCShare(uncPath);
        }
        catch (InvalidUNCPathException ex) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        if (servType == 2 && share.getShareName().compareTo("IPC$") == 0) {
            servType = 3;
        }
        SharedDevice shareDev = null;
        try {
            shareDev = this.m_sess.getSMBServer().findShare(share.getNodeName(), share.getShareName(), servType, this.getSession(), true);
        }
        catch (InvalidUserException ex) {
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        catch (Exception ex) {
            this.m_sess.sendErrorResponseSMB(6, 2);
            return;
        }
        if (shareDev == null || shareDev.getType() != servType) {
            this.m_sess.sendErrorResponseSMB(15, 1);
            return;
        }
        int treeId = this.m_sess.addConnection(shareDev);
        CifsAuthenticator auth = this.getSession().getSMBServer().getAuthenticator();
        int filePerm = 2;
        if (auth != null && (filePerm = auth.authenticateShareConnect(this.m_sess.getClientInformation(), shareDev, pwd, this.m_sess)) < 0) {
            this.m_sess.sendErrorResponseSMB(4, 2);
            return;
        }
        TreeConnection tree = this.m_sess.findConnection(treeId);
        tree.setPermission(filePerm);
        outPkt.setParameterCount(2);
        outPkt.setParameter(0, buf.length - 4);
        outPkt.setParameter(1, treeId);
        outPkt.setByteCount(0);
        outPkt.setAndXCommand(255);
        this.m_sess.sendResponseSMB(outPkt);
        if (tree.getInterface() != null) {
            tree.getInterface().treeOpened(this.m_sess, tree);
        }
    }

    protected void procTreeDisconnect(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        if (!this.m_smbPkt.checkPacketIsValid(0, 0)) {
            this.m_sess.sendErrorResponseSMB(64, 2);
            return;
        }
        int treeId = this.m_smbPkt.getTreeId();
        TreeConnection conn = this.m_sess.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(15, 1);
            return;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(8)) {
            logger.debug((Object)("Tree disconnect - " + treeId + ", " + conn.toString()));
        }
        this.m_sess.removeConnection(treeId);
        outPkt.setParameterCount(0);
        outPkt.setByteCount(0);
        this.m_sess.sendResponseSMB(outPkt);
        if (conn.getInterface() != null) {
            conn.getInterface().treeClosed(this.m_sess, conn);
        }
    }

    protected void procUnLockFile(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        if (!this.m_smbPkt.checkPacketIsValid(5, 0)) {
            this.m_sess.sendErrorResponseSMB(64, 2);
            return;
        }
        int treeId = this.m_smbPkt.getTreeId();
        TreeConnection conn = this.m_sess.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        int fid = this.m_smbPkt.getParameter(0);
        long lockcnt = this.m_smbPkt.getParameterLong(1);
        long lockoff = this.m_smbPkt.getParameterLong(3);
        NetworkFile netFile = conn.findFile(fid);
        if (netFile == null) {
            this.m_sess.sendErrorResponseSMB(6, 1);
            return;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(128)) {
            logger.debug((Object)("File UnLock [" + netFile.getFileId() + "] : Offset=" + lockoff + " ,Count=" + lockcnt));
        }
        outPkt.setParameterCount(0);
        outPkt.setByteCount(0);
        this.m_sess.sendResponseSMB(outPkt);
    }

    protected final void procUnsupported(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        this.m_sess.sendErrorResponseSMB(65535, 2);
    }

    protected void procWriteFile(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        if (!this.m_smbPkt.checkPacketIsValid(5, 0)) {
            this.m_sess.sendErrorResponseSMB(64, 2);
            return;
        }
        int treeId = this.m_smbPkt.getTreeId();
        TreeConnection conn = this.m_sess.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(15, 1);
            return;
        }
        if (!conn.hasWriteAccess()) {
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        int fid = this.m_smbPkt.getParameter(0);
        int wrtcnt = this.m_smbPkt.getParameter(1);
        long wrtoff = (long)(this.m_smbPkt.getParameter(2) + (this.m_smbPkt.getParameter(3) << 16)) & 0xFFFFFFFFL;
        NetworkFile netFile = conn.findFile(fid);
        if (netFile == null) {
            this.m_sess.sendErrorResponseSMB(6, 1);
            return;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(128)) {
            logger.debug((Object)("File Write [" + netFile.getFileId() + "] : Size=" + wrtcnt + " ,Pos=" + wrtoff));
        }
        byte[] buf = this.m_smbPkt.getBuffer();
        int pos = this.m_smbPkt.getByteOffset();
        int wrtlen = 0;
        if (buf[pos] != 1) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        try {
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            pos += 3;
            if (wrtcnt == 0) {
                disk.truncateFile(this.m_sess, conn, netFile, wrtoff);
            } else {
                wrtlen = disk.writeFile(this.m_sess, conn, netFile, buf, pos, wrtcnt, wrtoff);
            }
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        catch (IOException ex) {
            if (logger.isDebugEnabled() && this.m_sess.hasDebug(128)) {
                logger.debug((Object)("File Write Error [" + netFile.getFileId() + "] : " + ex.toString()));
            }
            this.m_sess.sendErrorResponseSMB(29, 3);
            return;
        }
        outPkt.setParameterCount(1);
        outPkt.setParameter(0, wrtlen);
        outPkt.setByteCount(0);
        this.m_sess.sendResponseSMB(outPkt);
    }

    protected void procWriteAndCloseFile(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        if (!this.m_smbPkt.checkPacketIsValid(6, 0)) {
            this.m_sess.sendErrorResponseSMB(64, 2);
            return;
        }
        int treeId = this.m_smbPkt.getTreeId();
        TreeConnection conn = this.m_sess.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(15, 1);
            return;
        }
        if (!conn.hasWriteAccess()) {
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        int fid = this.m_smbPkt.getParameter(0);
        int wrtcnt = this.m_smbPkt.getParameter(1);
        int wrtoff = this.m_smbPkt.getParameterLong(2);
        NetworkFile netFile = conn.findFile(fid);
        if (netFile == null) {
            this.m_sess.sendErrorResponseSMB(6, 1);
            return;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(128)) {
            logger.debug((Object)("File Write And Close [" + netFile.getFileId() + "] : Size=" + wrtcnt + " ,Pos=" + wrtoff));
        }
        byte[] buf = this.m_smbPkt.getBuffer();
        int pos = this.m_smbPkt.getByteOffset() + 1;
        int wrtlen = 0;
        try {
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            wrtlen = disk.writeFile(this.m_sess, conn, netFile, buf, pos, wrtcnt, wrtoff);
            if (disk != null) {
                disk.closeFile(this.m_sess, conn, netFile);
            }
            netFile.setClosed(true);
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        catch (IOException ex) {
            if (logger.isDebugEnabled() && this.m_sess.hasDebug(128)) {
                logger.debug((Object)("File Write Error [" + netFile.getFileId() + "] : " + ex.toString()));
            }
            this.m_sess.sendErrorResponseSMB(29, 3);
            return;
        }
        outPkt.setParameterCount(1);
        outPkt.setParameter(0, wrtlen);
        outPkt.setByteCount(0);
        outPkt.setError(0, 0);
        this.m_sess.sendResponseSMB(outPkt);
    }

    public boolean runProtocol() throws IOException, SMBSrvException, TooManyConnectionsException {
        if (this.m_smbPkt == null) {
            this.m_smbPkt = new SMBSrvPacket(this.m_sess.getBuffer());
        }
        boolean handledOK = true;
        SMBSrvPacket outPkt = this.m_smbPkt;
        switch (this.m_smbPkt.getCommand()) {
            case 115: {
                this.procSessionSetup(outPkt);
                break;
            }
            case 112: {
                this.procTreeConnect(outPkt);
                break;
            }
            case 113: {
                this.procTreeDisconnect(outPkt);
                break;
            }
            case 129: {
                this.procSearch(outPkt);
                break;
            }
            case 128: {
                this.procDiskAttributes(outPkt);
                break;
            }
            case 8: {
                this.procGetFileAttributes(outPkt);
                break;
            }
            case 9: {
                this.procSetFileAttributes(outPkt);
                break;
            }
            case 35: {
                this.procGetFileInformation(outPkt);
                break;
            }
            case 34: {
                this.procSetFileInformation(outPkt);
                break;
            }
            case 2: {
                this.procOpenFile(outPkt);
                break;
            }
            case 10: {
                this.procReadFile(outPkt);
                break;
            }
            case 18: {
                this.procSeekFile(outPkt);
                break;
            }
            case 4: {
                this.procCloseFile(outPkt);
                break;
            }
            case 3: 
            case 15: {
                this.procCreateFile(outPkt);
                break;
            }
            case 11: {
                this.procWriteFile(outPkt);
                break;
            }
            case 44: {
                this.procWriteAndCloseFile(outPkt);
                break;
            }
            case 5: {
                this.procFlushFile(outPkt);
                break;
            }
            case 7: {
                this.procRenameFile(outPkt);
                break;
            }
            case 6: {
                this.procDeleteFile(outPkt);
                break;
            }
            case 0: {
                this.procCreateDirectory(outPkt);
                break;
            }
            case 1: {
                this.procDeleteDirectory(outPkt);
                break;
            }
            case 16: {
                this.procCheckDirectory(outPkt);
                break;
            }
            case 39: {
                this.procUnsupported(outPkt);
                break;
            }
            case 43: {
                this.procEcho(outPkt);
                break;
            }
            case 17: {
                this.procProcessExit(outPkt);
                break;
            }
            case 14: {
                this.procCreateTemporaryFile(outPkt);
                break;
            }
            case 12: {
                this.procLockFile(outPkt);
                break;
            }
            case 13: {
                this.procUnLockFile(outPkt);
                break;
            }
            default: {
                handledOK = false;
            }
        }
        return handledOK;
    }
}

