/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.smb.server;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.alfresco.filesys.server.auth.CifsAuthenticator;
import org.alfresco.filesys.server.auth.ClientInfo;
import org.alfresco.filesys.server.auth.InvalidUserException;
import org.alfresco.filesys.server.core.InvalidDeviceInterfaceException;
import org.alfresco.filesys.server.core.ShareType;
import org.alfresco.filesys.server.core.SharedDevice;
import org.alfresco.filesys.server.filesys.AccessDeniedException;
import org.alfresco.filesys.server.filesys.DiskDeviceContext;
import org.alfresco.filesys.server.filesys.DiskInterface;
import org.alfresco.filesys.server.filesys.FileAccess;
import org.alfresco.filesys.server.filesys.FileAction;
import org.alfresco.filesys.server.filesys.FileInfo;
import org.alfresco.filesys.server.filesys.FileOfflineException;
import org.alfresco.filesys.server.filesys.FileOpenParams;
import org.alfresco.filesys.server.filesys.FileSharingException;
import org.alfresco.filesys.server.filesys.NetworkFile;
import org.alfresco.filesys.server.filesys.SearchContext;
import org.alfresco.filesys.server.filesys.SrvDiskInfo;
import org.alfresco.filesys.server.filesys.TooManyConnectionsException;
import org.alfresco.filesys.server.filesys.TooManyFilesException;
import org.alfresco.filesys.server.filesys.TreeConnection;
import org.alfresco.filesys.server.filesys.UnsupportedInfoLevelException;
import org.alfresco.filesys.server.filesys.VolumeInfo;
import org.alfresco.filesys.smb.InvalidUNCPathException;
import org.alfresco.filesys.smb.PCShare;
import org.alfresco.filesys.smb.SMBDate;
import org.alfresco.filesys.smb.server.CoreProtocolHandler;
import org.alfresco.filesys.smb.server.DiskInfoPacker;
import org.alfresco.filesys.smb.server.FindInfoPacker;
import org.alfresco.filesys.smb.server.IPCHandler;
import org.alfresco.filesys.smb.server.QueryInfoPacker;
import org.alfresco.filesys.smb.server.SMBSrvException;
import org.alfresco.filesys.smb.server.SMBSrvPacket;
import org.alfresco.filesys.smb.server.SMBSrvSession;
import org.alfresco.filesys.smb.server.SMBSrvTransPacket;
import org.alfresco.filesys.smb.server.SrvTransactBuffer;
import org.alfresco.filesys.util.DataBuffer;
import org.alfresco.filesys.util.DataPacker;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class LanManProtocolHandler
extends CoreProtocolHandler {
    private static final Log logger = LogFactory.getLog((String)"org.alfresco.smb.protocol");
    protected static final int LockShared = 1;
    protected static final int LockOplockRelease = 2;
    protected static final int LockChangeType = 4;
    protected static final int LockCancel = 8;
    protected static final int LockLargeFiles = 16;

    protected LanManProtocolHandler() {
    }

    protected LanManProtocolHandler(SMBSrvSession sess) {
        super(sess);
    }

    public String getName() {
        return "LanMan";
    }

    protected final int procAndXCommands(SMBSrvPacket outPkt) {
        int andxCmd = this.m_smbPkt.getAndXCommand();
        int andxOff = this.m_smbPkt.getParameter(1) + 4;
        outPkt.setAndXCommand(andxCmd);
        outPkt.setParameter(1, andxOff - 4);
        int paramBlk = 36;
        int endOfPkt = outPkt.getByteOffset() + outPkt.getByteCount();
        boolean andxErr = false;
        while (andxCmd != 255 && !andxErr) {
            int prevEndOfPkt = endOfPkt;
            switch (andxCmd) {
                case 117: {
                    endOfPkt = this.procChainedTreeConnectAndX(andxOff, outPkt, endOfPkt);
                }
            }
            andxCmd = this.m_smbPkt.getAndXParameter(andxOff, 0) & 0xFF;
            andxOff = this.m_smbPkt.getAndXParameter(andxOff, 1);
            outPkt.setAndXCommand(prevEndOfPkt, andxCmd);
            outPkt.setAndXParameter(paramBlk, 1, prevEndOfPkt - 4);
            paramBlk = prevEndOfPkt;
            if (outPkt.getErrorCode() == 0) continue;
            andxErr = true;
        }
        return endOfPkt;
    }

    protected final int procChainedTreeConnectAndX(int cmdOff, SMBSrvPacket outPkt, int endOff) {
        String uncPath;
        int flags = this.m_smbPkt.getAndXParameter(cmdOff, 2);
        int pwdLen = this.m_smbPkt.getAndXParameter(cmdOff, 3);
        int dataPos = this.m_smbPkt.getAndXByteOffset(cmdOff);
        int dataLen = this.m_smbPkt.getAndXByteCount(cmdOff);
        byte[] buf = this.m_smbPkt.getBuffer();
        String pwd = null;
        if (pwdLen > 0) {
            pwd = new String(buf, dataPos, pwdLen);
            dataPos += pwdLen;
            dataLen -= pwdLen;
        }
        if ((uncPath = DataPacker.getString(buf, dataPos, dataLen)) == null) {
            outPkt.setError(13, 1);
            return endOff;
        }
        String service = DataPacker.getString(buf, dataPos += uncPath.length() + 1, dataLen -= uncPath.length() + 1);
        if (service == null) {
            outPkt.setError(13, 1);
            return endOff;
        }
        int servType = ShareType.ServiceAsType(service);
        if (servType == -1 && service.compareTo("?????") != 0) {
            outPkt.setError(13, 1);
            return endOff;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(8)) {
            logger.debug((Object)("ANDX Tree Connect AndX - " + uncPath + ", " + service));
        }
        PCShare share = null;
        try {
            share = new PCShare(uncPath);
        }
        catch (InvalidUNCPathException ex) {
            outPkt.setError(13, 1);
            return endOff;
        }
        if (servType == 2 && share.getShareName().compareTo("IPC$") == 0) {
            servType = 3;
        }
        SharedDevice shareDev = null;
        try {
            shareDev = this.m_sess.getSMBServer().findShare(share.getNodeName(), share.getShareName(), servType, this.getSession(), true);
        }
        catch (InvalidUserException ex) {
            outPkt.setError(5, 1);
            return endOff;
        }
        catch (Exception ex) {
            outPkt.setError(6, 2);
            return endOff;
        }
        if (shareDev == null || servType != -1 && shareDev.getType() != servType) {
            outPkt.setError(15, 1);
            return endOff;
        }
        CifsAuthenticator auth = this.getSession().getSMBServer().getAuthenticator();
        int filePerm = 2;
        if (auth != null && (filePerm = auth.authenticateShareConnect(this.m_sess.getClientInformation(), shareDev, pwd, this.m_sess)) < 0) {
            outPkt.setError(5, 1);
            return endOff;
        }
        try {
            int treeId = this.m_sess.addConnection(shareDev);
            outPkt.setTreeId(treeId);
            TreeConnection tree = this.m_sess.findConnection(treeId);
            tree.setPermission(filePerm);
            if (tree.getInterface() != null) {
                tree.getInterface().treeOpened(this.m_sess, tree);
            }
            if (logger.isDebugEnabled() && this.m_sess.hasDebug(8)) {
                logger.debug((Object)("ANDX Tree Connect AndX - Allocated Tree Id = " + treeId));
            }
        }
        catch (TooManyConnectionsException ex) {
            outPkt.setError(89, 2);
            return endOff;
        }
        outPkt.setAndXParameterCount(endOff, 2);
        outPkt.setAndXParameter(endOff, 0, 255);
        outPkt.setAndXParameter(endOff, 1, 0);
        int pos = outPkt.getAndXByteOffset(endOff);
        byte[] outBuf = outPkt.getBuffer();
        pos = DataPacker.putString(ShareType.TypeAsService(shareDev.getType()), outBuf, pos, true);
        int bytLen = pos - outPkt.getAndXByteOffset(endOff);
        outPkt.setAndXByteCount(endOff, bytLen);
        return pos;
    }

    protected final void procFindClose(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        if (!this.m_smbPkt.checkPacketIsValid(1, 0)) {
            this.m_sess.sendErrorResponseSMB(64, 2);
            return;
        }
        int treeId = this.m_smbPkt.getTreeId();
        TreeConnection conn = this.m_sess.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(5, 2);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
            return;
        }
        int searchId = this.m_smbPkt.getParameter(0);
        SearchContext ctx = this.m_sess.getSearchContext(searchId);
        if (ctx == null) {
            this.m_sess.sendSuccessResponseSMB();
            return;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(16)) {
            logger.debug((Object)("Close trans search [" + searchId + "]"));
        }
        this.m_sess.deallocateSearchSlot(searchId);
        this.m_sess.sendSuccessResponseSMB();
    }

    protected final void procLockingAndX(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        if (!this.m_smbPkt.checkPacketIsValid(8, 0)) {
            this.m_sess.sendErrorResponseSMB(64, 2);
            return;
        }
        int treeId = this.m_smbPkt.getTreeId();
        TreeConnection conn = this.m_sess.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(5, 2);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
            return;
        }
        int fid = this.m_smbPkt.getParameter(2);
        int lockType = this.m_smbPkt.getParameter(3);
        long lockTmo = this.m_smbPkt.getParameterLong(4);
        int lockCnt = this.m_smbPkt.getParameter(6);
        int unlockCnt = this.m_smbPkt.getParameter(7);
        NetworkFile netFile = conn.findFile(fid);
        if (netFile == null) {
            this.m_sess.sendErrorResponseSMB(6, 1);
            return;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(4096)) {
            logger.debug((Object)("File Lock [" + netFile.getFileId() + "] : type=0x" + Integer.toHexString(lockType) + ", tmo=" + lockTmo + ", locks=" + lockCnt + ", unlocks=" + unlockCnt));
        }
        outPkt.setParameterCount(2);
        outPkt.setAndXCommand(255);
        outPkt.setParameter(1, 0);
        outPkt.setByteCount(0);
        this.m_sess.sendResponseSMB(outPkt);
    }

    protected final void procLogoffAndX(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        if (!this.m_smbPkt.checkPacketIsValid(15, 1)) {
            this.m_sess.sendErrorResponseSMB(64, 2);
            return;
        }
        this.m_sess.sendSuccessResponseSMB();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void procOpenAndX(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        int fid;
        if (!this.m_smbPkt.checkPacketIsValid(15, 1)) {
            this.m_sess.sendErrorResponseSMB(64, 2);
            return;
        }
        int treeId = this.m_smbPkt.getTreeId();
        TreeConnection conn = this.m_sess.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(5, 2);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        if (conn.getSharedDevice().getType() == 3) {
            IPCHandler.processIPCRequest(this.m_sess, outPkt);
            return;
        }
        if (conn.getSharedDevice().getType() != 0) {
            this.m_sess.sendErrorResponseSMB(4, 2);
            return;
        }
        int flags = this.m_smbPkt.getParameter(2);
        int access = this.m_smbPkt.getParameter(3);
        int srchAttr = this.m_smbPkt.getParameter(4);
        int fileAttr = this.m_smbPkt.getParameter(5);
        int crTime = this.m_smbPkt.getParameter(6);
        int crDate = this.m_smbPkt.getParameter(7);
        int openFunc = this.m_smbPkt.getParameter(8);
        int allocSiz = this.m_smbPkt.getParameterLong(9);
        String fileName = this.m_smbPkt.unpackString(this.m_smbPkt.isUnicode());
        if (fileName == null) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        SMBDate crDateTime = null;
        if (crTime > 0 && crDate > 0) {
            crDateTime = new SMBDate(crDate, crTime);
        }
        FileOpenParams params = new FileOpenParams(fileName, openFunc, access, srchAttr, fileAttr, allocSiz, crDateTime.getTime());
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(64)) {
            logger.debug((Object)("File Open AndX [" + treeId + "] params=" + params));
        }
        NetworkFile netFile = null;
        int respAction = 0;
        try {
            block21: {
                DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
                int fileSts = disk.fileExists(this.m_sess, conn, fileName);
                if (fileSts == 0) {
                    if (FileAction.createNotExists(openFunc)) {
                        if (!conn.hasWriteAccess()) {
                            this.m_sess.sendErrorResponseSMB(5, 1);
                            return;
                        }
                        netFile = disk.createFile(this.m_sess, conn, params);
                        respAction = 2;
                        break block21;
                    } else {
                        if (fileSts == 2) {
                            this.m_sess.sendErrorResponseSMB(5, 1);
                            return;
                        }
                        this.m_sess.sendErrorResponseSMB(2, 1);
                        return;
                    }
                }
                netFile = disk.openFile(this.m_sess, conn, params);
                respAction = FileAction.truncateExistingFile(openFunc) ? 3 : 1;
            }
            fid = conn.addFile(netFile, this.getSession());
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        catch (TooManyFilesException ex) {
            this.m_sess.sendErrorResponseSMB(4, 1);
            return;
        }
        catch (AccessDeniedException ex) {
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        catch (FileSharingException ex) {
            this.m_sess.sendErrorResponseSMB(32, 1);
            return;
        }
        catch (FileOfflineException ex) {
            this.m_sess.sendErrorResponseSMB(-1073741209, 21, 3);
            return;
        }
        catch (IOException ex) {
            this.m_sess.sendErrorResponseSMB(2, 1);
            return;
        }
        outPkt.setParameterCount(15);
        outPkt.setAndXCommand(255);
        outPkt.setParameter(1, 0);
        outPkt.setParameter(2, fid);
        outPkt.setParameter(3, netFile.getFileAttributes());
        SMBDate modDate = null;
        if (netFile.hasModifyDate()) {
            modDate = new SMBDate(netFile.getModifyDate());
        }
        outPkt.setParameter(4, modDate != null ? modDate.asSMBTime() : 0);
        outPkt.setParameter(5, modDate != null ? modDate.asSMBDate() : 0);
        outPkt.setParameterLong(6, netFile.getFileSizeInt());
        outPkt.setParameter(8, netFile.getGrantedAccess());
        outPkt.setParameter(9, 0);
        outPkt.setParameter(10, 0);
        outPkt.setParameter(11, respAction);
        outPkt.setParameter(12, 0);
        outPkt.setParameter(13, 0);
        outPkt.setParameter(14, 0);
        outPkt.setByteCount(0);
        this.m_sess.sendResponseSMB(outPkt);
    }

    protected final void procReadAndX(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        if (!this.m_smbPkt.checkPacketIsValid(10, 0)) {
            this.m_sess.sendErrorResponseSMB(64, 2);
            return;
        }
        int treeId = this.m_smbPkt.getTreeId();
        TreeConnection conn = this.m_sess.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(5, 2);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        if (conn.getSharedDevice().getType() == 3) {
            IPCHandler.processIPCRequest(this.m_sess, outPkt);
            return;
        }
        int fid = this.m_smbPkt.getParameter(2);
        int offset = this.m_smbPkt.getParameterLong(3);
        int maxCount = this.m_smbPkt.getParameter(5);
        NetworkFile netFile = conn.findFile(fid);
        if (netFile == null) {
            this.m_sess.sendErrorResponseSMB(6, 1);
            return;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(128)) {
            logger.debug((Object)("File Read AndX [" + netFile.getFileId() + "] : Size=" + maxCount + " ,Pos=" + offset));
        }
        byte[] buf = outPkt.getBuffer();
        int dataPos = 0;
        int rdlen = 0;
        try {
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            outPkt.setParameterCount(12);
            dataPos = outPkt.getByteOffset();
            int dataLen = buf.length - dataPos;
            if (dataLen < maxCount) {
                maxCount = dataLen;
            }
            rdlen = disk.readFile(this.m_sess, conn, netFile, buf, dataPos, maxCount, offset);
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        catch (AccessDeniedException ex) {
            if (logger.isDebugEnabled() && this.m_sess.hasDebug(128)) {
                logger.debug((Object)("File Read Error [" + netFile.getFileId() + "] : " + ex.toString()));
            }
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        catch (IOException ex) {
            logger.error((Object)("File Read Error [" + netFile.getFileId() + "] : "), (Throwable)ex);
            this.m_sess.sendErrorResponseSMB(30, 3);
            return;
        }
        outPkt.setAndXCommand(255);
        outPkt.setParameter(1, 0);
        outPkt.setParameter(2, 0);
        outPkt.setParameter(3, 0);
        outPkt.setParameter(4, 0);
        outPkt.setParameter(5, rdlen);
        outPkt.setParameter(6, dataPos - 4);
        for (int i = 7; i < 12; ++i) {
            outPkt.setParameter(i, 0);
        }
        outPkt.setByteCount(dataPos + rdlen - outPkt.getByteOffset());
        this.m_sess.sendResponseSMB(outPkt);
    }

    protected void procRenameFile(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        if (!this.m_smbPkt.checkPacketIsValid(1, 4)) {
            this.m_sess.sendErrorResponseSMB(64, 2);
            return;
        }
        int treeId = this.m_smbPkt.getTreeId();
        TreeConnection conn = this.m_sess.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(15, 1);
            return;
        }
        if (!conn.hasWriteAccess()) {
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        boolean isUni = this.m_smbPkt.isUnicode();
        this.m_smbPkt.resetBytePointer();
        if (this.m_smbPkt.unpackByte() != 4) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        String oldName = this.m_smbPkt.unpackString(isUni);
        if (oldName == null) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        if (this.m_smbPkt.unpackByte() != 4) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        String newName = this.m_smbPkt.unpackString(isUni);
        if (oldName == null) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(64)) {
            logger.debug((Object)("File Rename [" + treeId + "] old name=" + oldName + ", new name=" + newName));
        }
        Object netFile = null;
        try {
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            disk.renameFile(this.m_sess, conn, oldName, newName);
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        catch (IOException ex) {
            this.m_sess.sendErrorResponseSMB(2, 1);
            return;
        }
        outPkt.setParameterCount(0);
        outPkt.setByteCount(0);
        this.m_sess.sendResponseSMB(outPkt);
    }

    protected void procSessionSetup(SMBSrvPacket outPkt) throws SMBSrvException, IOException, TooManyConnectionsException {
        String user;
        int dataPos = this.m_smbPkt.getByteOffset();
        int dataLen = this.m_smbPkt.getByteCount();
        byte[] buf = this.m_smbPkt.getBuffer();
        int maxBufSize = this.m_smbPkt.getParameter(2);
        int maxMpx = this.m_smbPkt.getParameter(3);
        int vcNum = this.m_smbPkt.getParameter(4);
        byte[] pwd = null;
        int pwdLen = this.m_smbPkt.getParameter(7);
        if (pwdLen > 0) {
            pwd = new byte[pwdLen];
            for (int i = 0; i < pwdLen; ++i) {
                pwd[i] = buf[dataPos + i];
            }
            dataPos += pwdLen;
            dataLen -= pwdLen;
        }
        if ((user = DataPacker.getString(buf, dataPos, dataLen)) == null) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        dataPos += user.length() + 1;
        String domain = "";
        if ((dataLen -= user.length() + 1) > 0) {
            domain = DataPacker.getString(buf, dataPos, dataLen);
            if (domain == null) {
                this.m_sess.sendErrorResponseSMB(13, 1);
                return;
            }
            dataLen -= domain.length() + 1;
            dataPos += domain.length() + 1;
        }
        String clientOS = "";
        if (dataLen > 0 && (clientOS = DataPacker.getString(buf, dataPos, dataLen)) == null) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(4)) {
            logger.debug((Object)("Session setup from user=" + user + ", password=" + pwd + ", domain=" + domain + ", os=" + clientOS + ", VC=" + vcNum + ", maxBuf=" + maxBufSize + ", maxMpx=" + maxMpx));
        }
        this.m_sess.setClientMaximumBufferSize(maxBufSize);
        this.m_sess.setClientMaximumMultiplex(maxMpx);
        ClientInfo client = new ClientInfo(user, pwd);
        client.setDomain(domain);
        client.setOperatingSystem(clientOS);
        if (this.m_sess.hasRemoteAddress()) {
            client.setClientAddress(this.m_sess.getRemoteAddress().getHostAddress());
        }
        if (this.m_sess.getClientInformation() == null) {
            this.m_sess.setClientInformation(client);
        } else {
            ClientInfo curClient = this.m_sess.getClientInformation();
            if (curClient.getUserName() == null || curClient.getUserName().length() == 0) {
                this.m_sess.setClientInformation(client);
            } else if (logger.isDebugEnabled() && this.m_sess.hasDebug(4)) {
                logger.debug((Object)"Session already has client information set");
            }
        }
        CifsAuthenticator auth = this.getSession().getSMBServer().getAuthenticator();
        boolean isGuest = false;
        if (auth != null) {
            int sts = auth.authenticateUser(client, this.m_sess, 0);
            if (sts > 0 && (sts & 0x10000000) != 0) {
                isGuest = true;
            } else if (sts != 0) {
                this.m_sess.sendErrorResponseSMB(5, 1);
                return;
            }
        }
        client.setGuest(isGuest);
        this.getSession().setLoggedOn(true);
        outPkt.setParameterCount(3);
        outPkt.setParameter(0, 0);
        outPkt.setParameter(1, 0);
        outPkt.setParameter(2, isGuest ? 1 : 0);
        outPkt.setByteCount(0);
        outPkt.setTreeId(0);
        outPkt.setUserId(0);
        int flags = outPkt.getFlags();
        outPkt.setFlags(flags &= 0xFFFFFFF7);
        outPkt.setFlags2(1);
        int pos = outPkt.getByteOffset();
        buf = outPkt.getBuffer();
        pos = DataPacker.putString("Java", buf, pos, true);
        pos = DataPacker.putString("JLAN Server " + this.m_sess.getServer().isVersion(), buf, pos, true);
        pos = DataPacker.putString(this.m_sess.getServer().getConfiguration().getDomainName(), buf, pos, true);
        outPkt.setByteCount(pos - outPkt.getByteOffset());
        if (this.m_smbPkt.hasAndXCommand() && dataPos < this.m_smbPkt.getReceivedLength()) {
            pos = this.procAndXCommands(outPkt);
        } else {
            outPkt.setAndXCommand(255);
        }
        this.m_sess.sendResponseSMB(outPkt, pos);
        this.m_sess.setState(3);
        this.m_sess.getSMBServer().sessionLoggedOn(this.m_sess);
    }

    protected void procTransact2(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        if (!this.m_smbPkt.checkPacketIsValid(15, 0)) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 6);
            return;
        }
        int treeId = this.m_smbPkt.getTreeId();
        TreeConnection conn = this.m_sess.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 6);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        SMBSrvTransPacket tranPkt = new SMBSrvTransPacket(this.m_smbPkt.getBuffer());
        SrvTransactBuffer transBuf = null;
        int subCmd = tranPkt.getSubFunction();
        if (tranPkt.getTotalParameterCount() == tranPkt.getParameterBlockCount() && tranPkt.getTotalDataCount() == tranPkt.getDataBlockCount()) {
            transBuf = new SrvTransactBuffer(tranPkt);
        } else {
            transBuf = new SrvTransactBuffer(tranPkt.getSetupCount(), tranPkt.getTotalParameterCount(), tranPkt.getTotalDataCount());
            transBuf.setType(tranPkt.getCommand());
            transBuf.setFunction(subCmd);
            byte[] buf = tranPkt.getBuffer();
            transBuf.appendSetup(buf, tranPkt.getSetupOffset(), tranPkt.getSetupCount() * 2);
            transBuf.appendParameter(buf, tranPkt.getParameterBlockOffset(), tranPkt.getParameterBlockCount());
            transBuf.appendData(buf, tranPkt.getDataBlockOffset(), tranPkt.getDataBlockCount());
        }
        transBuf.setReturnLimits(tranPkt.getMaximumReturnSetupCount(), tranPkt.getMaximumReturnParameterCount(), tranPkt.getMaximumReturnDataCount());
        if (transBuf.isMultiPacket()) {
            this.m_sess.setTransaction(transBuf);
            this.m_sess.sendSuccessResponseSMB();
            return;
        }
        if (conn.getSharedDevice().getType() == 3) {
            IPCHandler.procTransaction(transBuf, this.m_sess, outPkt);
            return;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(256)) {
            logger.debug((Object)("Transaction [" + treeId + "] tbuf=" + transBuf));
        }
        this.processTransactionBuffer(transBuf, outPkt);
    }

    protected void procTransact2Secondary(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        int dlen;
        if (!this.m_smbPkt.checkPacketIsValid(8, 0)) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 6);
            return;
        }
        int treeId = this.m_smbPkt.getTreeId();
        TreeConnection conn = this.m_sess.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 6);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        if (!this.m_sess.hasTransaction() || this.m_sess.getTransaction().isType() == 37 && this.m_smbPkt.getCommand() != 38 || this.m_sess.getTransaction().isType() == 50 && this.m_smbPkt.getCommand() != 51) {
            this.m_sess.sendErrorResponseSMB(1, 2);
            return;
        }
        SMBSrvTransPacket tpkt = new SMBSrvTransPacket(this.m_smbPkt.getBuffer());
        byte[] buf = tpkt.getBuffer();
        SrvTransactBuffer transBuf = this.m_sess.getTransaction();
        int plen = tpkt.getSecondaryParameterBlockCount();
        if (plen > 0) {
            DataBuffer paramBuf = transBuf.getParameterBuffer();
            paramBuf.appendData(buf, tpkt.getSecondaryParameterBlockOffset(), plen);
        }
        if ((dlen = tpkt.getSecondaryDataBlockCount()) > 0) {
            DataBuffer dataBuf = transBuf.getDataBuffer();
            dataBuf.appendData(buf, tpkt.getSecondaryDataBlockOffset(), dlen);
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(256)) {
            logger.debug((Object)("Transaction Secondary [" + treeId + "] paramLen=" + plen + ", dataLen=" + dlen));
        }
        int totParam = tpkt.getTotalParameterCount();
        int totData = tpkt.getTotalDataCount();
        int paramDisp = tpkt.getParameterBlockDisplacement();
        int dataDisp = tpkt.getDataBlockDisplacement();
        if (paramDisp + plen == totParam && dataDisp + dlen == totData) {
            if (logger.isDebugEnabled() && this.m_sess.hasDebug(256)) {
                logger.debug((Object)"Transaction complete, processing ...");
            }
            this.m_sess.setTransaction(null);
            if (conn.getSharedDevice().getType() == 3) {
                IPCHandler.procTransaction(transBuf, this.m_sess, outPkt);
                return;
            }
            if (logger.isDebugEnabled() && this.m_sess.hasDebug(256)) {
                logger.debug((Object)("Transaction second [" + treeId + "] tbuf=" + transBuf));
            }
            this.processTransactionBuffer(transBuf, outPkt);
        } else {
            this.m_sess.sendSuccessResponseSMB();
        }
    }

    private final void processTransactionBuffer(SrvTransactBuffer tbuf, SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        switch (tbuf.getFunction()) {
            case 1: {
                this.procTrans2FindFirst(tbuf, outPkt);
                break;
            }
            case 2: {
                this.procTrans2FindNext(tbuf, outPkt);
                break;
            }
            case 3: {
                this.procTrans2QueryFileSys(tbuf, outPkt);
                break;
            }
            case 5: {
                this.procTrans2QueryPath(tbuf, outPkt);
                break;
            }
            default: {
                this.m_sess.sendErrorResponseSMB(64, 2);
            }
        }
    }

    protected final void procTrans2FindFirst(SrvTransactBuffer tbuf, SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        int treeId = this.m_smbPkt.getTreeId();
        TreeConnection conn = this.m_sess.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(5, 2);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        DataBuffer paramBuf = tbuf.getParameterBuffer();
        int srchAttr = paramBuf.getShort();
        int maxFiles = paramBuf.getShort();
        int srchFlag = paramBuf.getShort();
        int infoLevl = paramBuf.getShort();
        paramBuf.skipBytes(4);
        String srchPath = paramBuf.getString(tbuf.isUnicode());
        if (srchPath == null || srchPath.length() == 0) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        SearchContext ctx = null;
        DiskInterface disk = null;
        int searchId = -1;
        try {
            disk = (DiskInterface)conn.getSharedDevice().getInterface();
            searchId = this.m_sess.allocateSearchSlot();
            if (searchId == -1) {
                this.m_sess.sendErrorResponseSMB(89, 2);
                return;
            }
            if (logger.isDebugEnabled() && this.m_sess.hasDebug(16)) {
                logger.debug((Object)("Start trans search [" + searchId + "] - " + srchPath + ", attr=0x" + Integer.toHexString(srchAttr) + ", maxFiles=" + maxFiles + ", infoLevel=" + infoLevl + ", flags=0x" + Integer.toHexString(srchFlag)));
            }
            if ((ctx = disk.startSearch(this.m_sess, conn, srchPath, srchAttr)) == null) {
                this.m_sess.sendErrorResponseSMB(2, 1);
                return;
            }
            ctx.setTreeId(treeId);
            ctx.setMaximumFiles(maxFiles);
            this.m_sess.setSearchContext(searchId, ctx);
            SrvTransactBuffer replyBuf = new SrvTransactBuffer(tbuf);
            DataBuffer dataBuf = replyBuf.getDataBuffer();
            int maxLen = replyBuf.getReturnDataLimit();
            boolean resumeReq = (srchFlag & 4) != 0;
            int fileCnt = 0;
            int packLen = 0;
            int lastNameOff = 0;
            boolean pktDone = false;
            boolean searchDone = false;
            FileInfo info = new FileInfo();
            while (!pktDone && fileCnt < maxFiles) {
                if (!ctx.nextFileInfo(info)) {
                    pktDone = true;
                    searchDone = true;
                    continue;
                }
                if (FindInfoPacker.calcInfoSize(info, infoLevl, false, true) <= maxLen) {
                    if (resumeReq) {
                        dataBuf.putZeros(4);
                        maxLen -= 4;
                    }
                    lastNameOff = dataBuf.getPosition();
                    packLen = FindInfoPacker.packInfo(info, dataBuf, infoLevl, tbuf.isUnicode());
                    ++fileCnt;
                    maxLen -= packLen;
                    continue;
                }
                ctx.restartAt(info);
                pktDone = true;
            }
            paramBuf = replyBuf.getParameterBuffer();
            paramBuf.putShort(searchId);
            paramBuf.putShort(fileCnt);
            paramBuf.putShort(ctx.hasMoreFiles() ? 0 : 1);
            paramBuf.putShort(0);
            paramBuf.putShort(lastNameOff);
            SMBSrvTransPacket tpkt = new SMBSrvTransPacket(outPkt.getBuffer());
            tpkt.doTransactionResponse(this.m_sess, replyBuf);
            if (logger.isDebugEnabled() && this.m_sess.hasDebug(16)) {
                logger.debug((Object)("Search [" + searchId + "] Returned " + fileCnt + " files, moreFiles=" + ctx.hasMoreFiles()));
            }
            if (searchDone) {
                if (logger.isDebugEnabled() && this.m_sess.hasDebug(16)) {
                    logger.debug((Object)("End start search [" + searchId + "] (Search complete)"));
                }
                this.m_sess.deallocateSearchSlot(searchId);
            }
        }
        catch (FileNotFoundException ex) {
            if (searchId != -1) {
                this.m_sess.deallocateSearchSlot(searchId);
            }
            this.m_sess.sendErrorResponseSMB(18, 1);
        }
        catch (InvalidDeviceInterfaceException ex) {
            if (searchId != -1) {
                this.m_sess.deallocateSearchSlot(searchId);
            }
            this.m_sess.sendErrorResponseSMB(13, 1);
        }
        catch (UnsupportedInfoLevelException ex) {
            if (searchId != -1) {
                this.m_sess.deallocateSearchSlot(searchId);
            }
            this.m_sess.sendErrorResponseSMB(65535, 2);
        }
    }

    protected final void procTrans2FindNext(SrvTransactBuffer tbuf, SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        int treeId = this.m_smbPkt.getTreeId();
        TreeConnection conn = this.m_sess.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(5, 2);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        DataBuffer paramBuf = tbuf.getParameterBuffer();
        int searchId = paramBuf.getShort();
        int maxFiles = paramBuf.getShort();
        int infoLevl = paramBuf.getShort();
        int reskey = paramBuf.getInt();
        int srchFlag = paramBuf.getShort();
        String resumeName = paramBuf.getString(tbuf.isUnicode());
        SearchContext ctx = null;
        DiskInterface disk = null;
        try {
            disk = (DiskInterface)conn.getSharedDevice().getInterface();
            ctx = this.m_sess.getSearchContext(searchId);
            if (ctx == null) {
                if (logger.isDebugEnabled() && this.m_sess.hasDebug(16)) {
                    logger.debug((Object)("Search context null - [" + searchId + "]"));
                }
                this.m_sess.sendErrorResponseSMB(18, 1);
                return;
            }
            if (logger.isDebugEnabled() && this.m_sess.hasDebug(16)) {
                logger.debug((Object)("Continue search [" + searchId + "] - " + resumeName + ", maxFiles=" + maxFiles + ", infoLevel=" + infoLevl + ", flags=0x" + Integer.toHexString(srchFlag)));
            }
            SrvTransactBuffer replyBuf = new SrvTransactBuffer(tbuf);
            DataBuffer dataBuf = replyBuf.getDataBuffer();
            int maxLen = replyBuf.getReturnDataLimit();
            boolean resumeReq = (srchFlag & 4) != 0;
            int fileCnt = 0;
            int packLen = 0;
            int lastNameOff = 0;
            boolean pktDone = false;
            boolean searchDone = false;
            FileInfo info = new FileInfo();
            while (!pktDone && fileCnt < maxFiles) {
                if (!ctx.nextFileInfo(info)) {
                    pktDone = true;
                    searchDone = true;
                    continue;
                }
                if (FindInfoPacker.calcInfoSize(info, infoLevl, false, true) <= maxLen) {
                    if (resumeReq) {
                        dataBuf.putZeros(4);
                    }
                    lastNameOff = dataBuf.getPosition();
                    packLen = FindInfoPacker.packInfo(info, dataBuf, infoLevl, tbuf.isUnicode());
                    ++fileCnt;
                    maxLen -= packLen;
                    continue;
                }
                ctx.restartAt(info);
                pktDone = true;
            }
            paramBuf = replyBuf.getParameterBuffer();
            paramBuf.putShort(fileCnt);
            paramBuf.putShort(ctx.hasMoreFiles() ? 0 : 1);
            paramBuf.putShort(0);
            paramBuf.putShort(lastNameOff);
            SMBSrvTransPacket tpkt = new SMBSrvTransPacket(outPkt.getBuffer());
            tpkt.doTransactionResponse(this.m_sess, replyBuf);
            if (logger.isDebugEnabled() && this.m_sess.hasDebug(16)) {
                logger.debug((Object)("Search [" + searchId + "] Returned " + fileCnt + " files, moreFiles=" + ctx.hasMoreFiles()));
            }
            if (searchDone) {
                if (logger.isDebugEnabled() && this.m_sess.hasDebug(16)) {
                    logger.debug((Object)("End start search [" + searchId + "] (Search complete)"));
                }
                this.m_sess.deallocateSearchSlot(searchId);
            }
        }
        catch (FileNotFoundException ex) {
            if (searchId != -1) {
                this.m_sess.deallocateSearchSlot(searchId);
            }
            this.m_sess.sendErrorResponseSMB(18, 1);
        }
        catch (InvalidDeviceInterfaceException ex) {
            if (searchId != -1) {
                this.m_sess.deallocateSearchSlot(searchId);
            }
            this.m_sess.sendErrorResponseSMB(13, 1);
        }
        catch (UnsupportedInfoLevelException ex) {
            if (searchId != -1) {
                this.m_sess.deallocateSearchSlot(searchId);
            }
            this.m_sess.sendErrorResponseSMB(65535, 2);
        }
    }

    protected final void procTrans2QueryFileSys(SrvTransactBuffer tbuf, SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        int treeId = this.m_smbPkt.getTreeId();
        TreeConnection conn = this.m_sess.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(5, 2);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        DataBuffer paramBuf = tbuf.getParameterBuffer();
        int infoLevl = paramBuf.getShort();
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(32)) {
            logger.debug((Object)("Query File System Info - level = 0x" + Integer.toHexString(infoLevl)));
        }
        try {
            int prmPos;
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            DiskDeviceContext diskCtx = (DiskDeviceContext)conn.getContext();
            outPkt.setParameterCount(10);
            byte[] buf = outPkt.getBuffer();
            int dataPos = prmPos = DataPacker.longwordAlign(outPkt.getByteOffset());
            DataBuffer replyBuf = new DataBuffer(buf, dataPos, buf.length - dataPos);
            SrvDiskInfo diskInfo = null;
            VolumeInfo volInfo = null;
            switch (infoLevl) {
                case 1: {
                    diskInfo = this.getDiskInformation(disk, diskCtx);
                    DiskInfoPacker.packStandardInfo(diskInfo, replyBuf);
                    break;
                }
                case 2: {
                    volInfo = this.getVolumeInformation(disk, diskCtx);
                    DiskInfoPacker.packVolumeInfo(volInfo, replyBuf, tbuf.isUnicode());
                    break;
                }
                case 258: {
                    volInfo = this.getVolumeInformation(disk, diskCtx);
                    DiskInfoPacker.packFsVolumeInformation(volInfo, replyBuf, tbuf.isUnicode());
                    break;
                }
                case 259: {
                    diskInfo = this.getDiskInformation(disk, diskCtx);
                    DiskInfoPacker.packFsSizeInformation(diskInfo, replyBuf);
                    break;
                }
                case 260: {
                    DiskInfoPacker.packFsDevice(0, 0, replyBuf);
                    break;
                }
                case 261: {
                    DiskInfoPacker.packFsAttribute(0, 255, "JLAN", tbuf.isUnicode(), replyBuf);
                }
            }
            if (replyBuf.getPosition() == dataPos) {
                this.m_sess.sendErrorResponseSMB(65535, 2);
                return;
            }
            int dataLen = replyBuf.getLength();
            SMBSrvTransPacket.initTransactReply(outPkt, 0, prmPos, dataLen, dataPos);
            outPkt.setByteCount(replyBuf.getPosition() - outPkt.getByteOffset());
            this.m_sess.sendResponseSMB(outPkt);
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
    }

    protected final void procTrans2QueryPath(SrvTransactBuffer tbuf, SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        int treeId = this.m_smbPkt.getTreeId();
        TreeConnection conn = this.m_sess.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 6);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        DataBuffer paramBuf = tbuf.getParameterBuffer();
        int infoLevl = paramBuf.getShort();
        paramBuf.skipBytes(4);
        String path = paramBuf.getString(tbuf.isUnicode());
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(32)) {
            logger.debug((Object)("Query Path - level = 0x" + Integer.toHexString(infoLevl) + ", path = " + path));
        }
        try {
            int prmPos;
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            outPkt.setParameterCount(10);
            byte[] buf = outPkt.getBuffer();
            int dataPos = prmPos = DataPacker.longwordAlign(outPkt.getByteOffset());
            DataBuffer replyBuf = new DataBuffer(buf, dataPos, buf.length - dataPos);
            FileInfo fileInfo = disk.getFileInformation(this.m_sess, conn, path);
            if (fileInfo == null) {
                this.m_sess.sendErrorResponseSMB(-1073741772, 6);
                return;
            }
            int dataLen = QueryInfoPacker.packInfo(fileInfo, replyBuf, infoLevl, true);
            if (dataLen == 0) {
                this.m_sess.sendErrorResponseSMB(-1073741811, 6);
                return;
            }
            SMBSrvTransPacket.initTransactReply(outPkt, 0, prmPos, dataLen, dataPos);
            outPkt.setByteCount(replyBuf.getPosition() - outPkt.getByteOffset());
            this.m_sess.sendResponseSMB(outPkt);
        }
        catch (FileNotFoundException ex) {
            this.m_sess.sendErrorResponseSMB(-1073741772, 6);
            return;
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 6);
            return;
        }
        catch (UnsupportedInfoLevelException ex) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 6);
            return;
        }
    }

    protected void procTreeConnectAndX(SMBSrvPacket outPkt) throws SMBSrvException, TooManyConnectionsException, IOException {
        String uncPath;
        if (!this.m_smbPkt.checkPacketIsValid(4, 3)) {
            this.m_sess.sendErrorResponseSMB(64, 2);
            return;
        }
        int flags = this.m_smbPkt.getParameter(2);
        int pwdLen = this.m_smbPkt.getParameter(3);
        int dataPos = this.m_smbPkt.getByteOffset();
        int dataLen = this.m_smbPkt.getByteCount();
        byte[] buf = this.m_smbPkt.getBuffer();
        String pwd = null;
        if (pwdLen > 0) {
            pwd = new String(buf, dataPos, pwdLen);
            dataPos += pwdLen;
            dataLen -= pwdLen;
        }
        if ((uncPath = DataPacker.getString(buf, dataPos, dataLen)) == null) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        String service = DataPacker.getString(buf, dataPos += uncPath.length() + 1, dataLen -= uncPath.length() + 1);
        if (service == null) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        int servType = ShareType.ServiceAsType(service);
        if (servType == -1 && service.compareTo("?????") != 0) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(8)) {
            logger.debug((Object)("Tree Connect AndX - " + uncPath + ", " + service));
        }
        PCShare share = null;
        try {
            share = new PCShare(uncPath);
        }
        catch (InvalidUNCPathException ex) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        if (servType == 2 && share.getShareName().compareTo("IPC$") == 0) {
            servType = 3;
        }
        SharedDevice shareDev = null;
        try {
            shareDev = this.m_sess.getSMBServer().findShare(share.getNodeName(), share.getShareName(), servType, this.getSession(), true);
        }
        catch (InvalidUserException ex) {
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        catch (Exception ex) {
            this.m_sess.sendErrorResponseSMB(6, 2);
            return;
        }
        if (shareDev == null || servType != -1 && shareDev.getType() != servType) {
            this.m_sess.sendErrorResponseSMB(15, 1);
            return;
        }
        CifsAuthenticator auth = this.getSession().getSMBServer().getAuthenticator();
        int filePerm = 2;
        if (auth != null && (filePerm = auth.authenticateShareConnect(this.m_sess.getClientInformation(), shareDev, pwd, this.m_sess)) < 0) {
            this.m_sess.sendErrorResponseSMB(4, 2);
            return;
        }
        int treeId = this.m_sess.addConnection(shareDev);
        outPkt.setTreeId(treeId);
        TreeConnection tree = this.m_sess.findConnection(treeId);
        tree.setPermission(filePerm);
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(8)) {
            logger.debug((Object)("Tree Connect AndX - Allocated Tree Id = " + treeId + ", Permission = " + FileAccess.asString(filePerm)));
        }
        outPkt.setParameterCount(3);
        outPkt.setAndXCommand(255);
        outPkt.setParameter(1, 0);
        outPkt.setParameter(2, 0);
        int pos = outPkt.getByteOffset();
        pos = DataPacker.putString(ShareType.TypeAsService(shareDev.getType()), buf, pos, true);
        outPkt.setByteCount(pos - outPkt.getByteOffset());
        this.m_sess.sendResponseSMB(outPkt);
        if (tree.getInterface() != null) {
            tree.getInterface().treeOpened(this.m_sess, tree);
        }
    }

    protected final void procWriteAndX(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        if (!this.m_smbPkt.checkPacketIsValid(12, 0)) {
            this.m_sess.sendErrorResponseSMB(64, 2);
            return;
        }
        int treeId = this.m_smbPkt.getTreeId();
        TreeConnection conn = this.m_sess.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(5, 2);
            return;
        }
        if (!conn.hasWriteAccess()) {
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        if (conn.getSharedDevice().getType() == 3) {
            IPCHandler.processIPCRequest(this.m_sess, outPkt);
            return;
        }
        int fid = this.m_smbPkt.getParameter(2);
        int offset = this.m_smbPkt.getParameterLong(3);
        int dataLen = this.m_smbPkt.getParameter(10);
        int dataPos = this.m_smbPkt.getParameter(11) + 4;
        NetworkFile netFile = conn.findFile(fid);
        if (netFile == null) {
            this.m_sess.sendErrorResponseSMB(6, 1);
            return;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(128)) {
            logger.debug((Object)("File Write AndX [" + netFile.getFileId() + "] : Size=" + dataLen + " ,Pos=" + offset));
        }
        byte[] buf = this.m_smbPkt.getBuffer();
        int wrtlen = 0;
        try {
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            wrtlen = disk.writeFile(this.m_sess, conn, netFile, buf, dataPos, dataLen, offset);
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        catch (IOException ex) {
            logger.error((Object)("File Write Error [" + netFile.getFileId() + "] : "), (Throwable)ex);
            this.m_sess.sendErrorResponseSMB(29, 3);
            return;
        }
        outPkt.setParameterCount(6);
        outPkt.setAndXCommand(255);
        outPkt.setParameter(1, 0);
        outPkt.setParameter(2, wrtlen);
        outPkt.setParameter(3, 0);
        outPkt.setParameter(4, 0);
        outPkt.setParameter(5, 0);
        outPkt.setByteCount(0);
        this.m_sess.sendResponseSMB(outPkt);
    }

    public boolean runProtocol() throws IOException, SMBSrvException, TooManyConnectionsException {
        if (this.m_smbPkt == null) {
            this.m_smbPkt = this.m_sess.getReceivePacket();
        }
        if (!this.m_smbPkt.checkPacketSignature()) {
            throw new IOException("Invalid SMB signature");
        }
        SMBSrvPacket outPkt = this.m_smbPkt;
        boolean chainedCmd = this.hasChainedCommand(this.m_smbPkt);
        if (chainedCmd) {
            if (logger.isDebugEnabled() && this.m_sess.hasDebug(2)) {
                logger.debug((Object)("AndX Command = 0x" + Integer.toHexString(this.m_smbPkt.getAndXCommand())));
            }
            outPkt = new SMBSrvPacket(this.m_smbPkt);
        }
        this.m_smbPkt.resetBytePointer();
        boolean handledOK = true;
        switch (this.m_smbPkt.getCommand()) {
            case 115: {
                this.procSessionSetup(outPkt);
                break;
            }
            case 117: {
                this.procTreeConnectAndX(outPkt);
                break;
            }
            case 37: 
            case 50: {
                this.procTransact2(outPkt);
                break;
            }
            case 38: 
            case 51: {
                this.procTransact2Secondary(outPkt);
                break;
            }
            case 52: {
                this.procFindClose(outPkt);
                break;
            }
            case 45: {
                this.procOpenAndX(outPkt);
                break;
            }
            case 46: {
                this.procReadAndX(outPkt);
                break;
            }
            case 47: {
                this.procWriteAndX(outPkt);
                break;
            }
            case 113: {
                this.procTreeDisconnect(outPkt);
                break;
            }
            case 36: {
                this.procLockingAndX(outPkt);
                break;
            }
            case 116: {
                this.procLogoffAndX(outPkt);
                break;
            }
            case 112: {
                super.runProtocol();
                break;
            }
            case 7: {
                this.procRenameFile(outPkt);
                break;
            }
            case 43: {
                super.procEcho(outPkt);
                break;
            }
            default: {
                int treeId = this.m_smbPkt.getTreeId();
                TreeConnection conn = null;
                if (treeId != -1) {
                    conn = this.m_sess.findConnection(treeId);
                }
                if (conn == null) break;
                if (conn.getSharedDevice().getType() == 0 || conn.getSharedDevice().getType() == 1) {
                    handledOK = super.runProtocol();
                    break;
                }
                if (conn.getSharedDevice().getType() != 3) break;
                IPCHandler.processIPCRequest(this.m_sess, outPkt);
                handledOK = true;
            }
        }
        return handledOK;
    }
}

