/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.smb.server;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.alfresco.filesys.locking.FileLock;
import org.alfresco.filesys.locking.LockConflictException;
import org.alfresco.filesys.locking.NotLockedException;
import org.alfresco.filesys.server.auth.CifsAuthenticator;
import org.alfresco.filesys.server.auth.InvalidUserException;
import org.alfresco.filesys.server.auth.acl.AccessControlManager;
import org.alfresco.filesys.server.core.InvalidDeviceInterfaceException;
import org.alfresco.filesys.server.core.ShareType;
import org.alfresco.filesys.server.core.SharedDevice;
import org.alfresco.filesys.server.filesys.AccessDeniedException;
import org.alfresco.filesys.server.filesys.DirectoryNotEmptyException;
import org.alfresco.filesys.server.filesys.DiskDeviceContext;
import org.alfresco.filesys.server.filesys.DiskFullException;
import org.alfresco.filesys.server.filesys.DiskInterface;
import org.alfresco.filesys.server.filesys.FileAccess;
import org.alfresco.filesys.server.filesys.FileAction;
import org.alfresco.filesys.server.filesys.FileExistsException;
import org.alfresco.filesys.server.filesys.FileInfo;
import org.alfresco.filesys.server.filesys.FileName;
import org.alfresco.filesys.server.filesys.FileOfflineException;
import org.alfresco.filesys.server.filesys.FileOpenParams;
import org.alfresco.filesys.server.filesys.FileSharingException;
import org.alfresco.filesys.server.filesys.IOControlNotImplementedException;
import org.alfresco.filesys.server.filesys.IOCtlInterface;
import org.alfresco.filesys.server.filesys.NetworkFile;
import org.alfresco.filesys.server.filesys.PathNotFoundException;
import org.alfresco.filesys.server.filesys.SearchContext;
import org.alfresco.filesys.server.filesys.SrvDiskInfo;
import org.alfresco.filesys.server.filesys.TooManyConnectionsException;
import org.alfresco.filesys.server.filesys.TooManyFilesException;
import org.alfresco.filesys.server.filesys.TreeConnection;
import org.alfresco.filesys.server.filesys.UnsupportedInfoLevelException;
import org.alfresco.filesys.server.filesys.VolumeInfo;
import org.alfresco.filesys.server.locking.FileLockingInterface;
import org.alfresco.filesys.server.locking.LockManager;
import org.alfresco.filesys.smb.InvalidUNCPathException;
import org.alfresco.filesys.smb.LockingAndX;
import org.alfresco.filesys.smb.NTIOCtl;
import org.alfresco.filesys.smb.NTTime;
import org.alfresco.filesys.smb.PCShare;
import org.alfresco.filesys.smb.SMBDate;
import org.alfresco.filesys.smb.SMBException;
import org.alfresco.filesys.smb.server.CoreProtocolHandler;
import org.alfresco.filesys.smb.server.DiskInfoPacker;
import org.alfresco.filesys.smb.server.FindInfoPacker;
import org.alfresco.filesys.smb.server.IPCHandler;
import org.alfresco.filesys.smb.server.NTParameterPacker;
import org.alfresco.filesys.smb.server.NTTransPacket;
import org.alfresco.filesys.smb.server.QueryInfoPacker;
import org.alfresco.filesys.smb.server.SMBSrvException;
import org.alfresco.filesys.smb.server.SMBSrvPacket;
import org.alfresco.filesys.smb.server.SMBSrvSession;
import org.alfresco.filesys.smb.server.SMBSrvTransPacket;
import org.alfresco.filesys.smb.server.SrvTransactBuffer;
import org.alfresco.filesys.smb.server.notify.NotifyChangeEventList;
import org.alfresco.filesys.smb.server.notify.NotifyChangeHandler;
import org.alfresco.filesys.smb.server.notify.NotifyRequest;
import org.alfresco.filesys.smb.server.ntfs.NTFSStreamsInterface;
import org.alfresco.filesys.smb.server.ntfs.StreamInfoList;
import org.alfresco.filesys.util.DataBuffer;
import org.alfresco.filesys.util.DataPacker;
import org.alfresco.filesys.util.WildCard;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NTProtocolHandler
extends CoreProtocolHandler {
    private static final Log logger = LogFactory.getLog((String)"org.alfresco.smb.protocol");
    public static final boolean ReturnDotFiles = true;
    public static final boolean FakeOpLocks = false;
    public static final int FileSizeChangeRate = 10;
    private static byte[] _sdEveryOne = new byte[]{1, 0, 4, -128, 20, 0, 0, 0, 32, 0, 0, 0, 0, 0, 0, 0, 44, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 2, 0, 28, 0, 1, 0, 0, 0, 0, 0, 20, 0, -1, 1, 31, 0, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0};

    protected NTProtocolHandler() {
    }

    protected NTProtocolHandler(SMBSrvSession sess) {
        super(sess);
    }

    public String getName() {
        return "NT";
    }

    public boolean runProtocol() throws IOException, SMBSrvException, TooManyConnectionsException {
        if (this.m_smbPkt == null) {
            this.m_smbPkt = this.m_sess.getReceivePacket();
        }
        if (!this.m_smbPkt.checkPacketSignature()) {
            throw new IOException("Invalid SMB signature");
        }
        SMBSrvPacket outPkt = this.m_smbPkt;
        boolean chainedCmd = this.hasChainedCommand(this.m_smbPkt);
        if (chainedCmd) {
            if (logger.isDebugEnabled() && this.m_sess.hasDebug(2)) {
                logger.debug((Object)("AndX Command = 0x" + Integer.toHexString(this.m_smbPkt.getAndXCommand())));
            }
            outPkt = new SMBSrvPacket(this.m_smbPkt, this.m_smbPkt.getPacketLength());
        }
        this.m_smbPkt.resetBytePointer();
        this.m_sess.setProcessId(this.m_smbPkt.getProcessId());
        boolean handledOK = true;
        switch (this.m_smbPkt.getCommand()) {
            case 115: {
                this.procSessionSetup(outPkt);
                break;
            }
            case 117: {
                this.procTreeConnectAndX(outPkt);
                break;
            }
            case 37: 
            case 50: {
                this.procTransact2(outPkt);
                break;
            }
            case 38: 
            case 51: {
                this.procTransact2Secondary(outPkt);
                break;
            }
            case 52: {
                this.procFindClose(outPkt);
                break;
            }
            case 45: {
                this.procOpenAndX(outPkt);
                break;
            }
            case 4: {
                this.procCloseFile(outPkt);
                break;
            }
            case 46: {
                this.procReadAndX(outPkt);
                break;
            }
            case 47: {
                this.procWriteAndX(outPkt);
                break;
            }
            case 7: {
                this.procRenameFile(outPkt);
                break;
            }
            case 6: {
                this.procDeleteFile(outPkt);
                break;
            }
            case 1: {
                this.procDeleteDirectory(outPkt);
                break;
            }
            case 113: {
                this.procTreeDisconnect(outPkt);
                break;
            }
            case 36: {
                this.procLockingAndX(outPkt);
                break;
            }
            case 116: {
                this.procLogoffAndX(outPkt);
                break;
            }
            case 162: {
                this.procNTCreateAndX(outPkt);
                break;
            }
            case 112: {
                super.runProtocol();
                break;
            }
            case 164: {
                this.procNTCancel(outPkt);
                break;
            }
            case 160: {
                this.procNTTransaction(outPkt);
                break;
            }
            case 161: {
                this.procNTTransactionSecondary(outPkt);
                break;
            }
            case 43: {
                super.procEcho(outPkt);
                break;
            }
            default: {
                int treeId = this.m_smbPkt.getTreeId();
                TreeConnection conn = null;
                if (treeId != -1) {
                    conn = this.m_sess.findConnection(treeId);
                }
                if (conn == null) break;
                if (conn.getSharedDevice().getType() == 0 || conn.getSharedDevice().getType() == 1) {
                    handledOK = super.runProtocol();
                    break;
                }
                if (conn.getSharedDevice().getType() != 3) break;
                IPCHandler.processIPCRequest(this.m_sess, outPkt);
                handledOK = true;
            }
        }
        return handledOK;
    }

    protected void procSessionSetup(SMBSrvPacket outPkt) throws SMBSrvException, IOException, TooManyConnectionsException {
        CifsAuthenticator cifsAuthenticator = this.m_sess.getServer().getAuthenticator();
        try {
            cifsAuthenticator.processSessionSetup(this.m_sess, this.m_smbPkt, outPkt);
        }
        catch (SMBSrvException ex) {
            this.m_sess.sendErrorResponseSMB(ex.getNTErrorCode(), ex.getErrorCode(), ex.getErrorClass());
            return;
        }
        int pos = outPkt.getLength();
        if (this.m_smbPkt.hasAndXCommand() && this.m_smbPkt.getPosition() < this.m_smbPkt.getReceivedLength()) {
            pos = this.procAndXCommands(outPkt);
            pos -= 4;
        } else {
            outPkt.setAndXCommand(255);
        }
        this.m_sess.sendResponseSMB(outPkt, pos);
        if (outPkt.getLongErrorCode() == 0) {
            this.m_sess.setState(3);
            this.m_sess.getSMBServer().sessionLoggedOn(this.m_sess);
        }
    }

    protected final int procAndXCommands(SMBSrvPacket outPkt) {
        return this.procAndXCommands(outPkt, outPkt.getByteOffset() + outPkt.getByteCount(), null);
    }

    protected final int procAndXCommands(SMBSrvPacket outPkt, int endPos, NetworkFile file) {
        int andxCmd = this.m_smbPkt.getAndXCommand();
        int andxOff = this.m_smbPkt.getParameter(1) + 4;
        outPkt.setAndXCommand(andxCmd);
        outPkt.setParameter(1, andxOff - 4);
        int paramBlk = 36;
        int endOfPkt = endPos;
        boolean andxErr = false;
        while (andxCmd != 255 && !andxErr) {
            int prevEndOfPkt = endOfPkt;
            boolean endOfChain = false;
            switch (andxCmd) {
                case 117: {
                    endOfPkt = this.procChainedTreeConnectAndX(andxOff, outPkt, endOfPkt);
                    break;
                }
                case 4: {
                    endOfPkt = this.procChainedClose(andxOff, outPkt, endOfPkt);
                    endOfChain = true;
                    break;
                }
                case 46: {
                    endOfPkt = this.procChainedReadAndX(andxOff, outPkt, endOfPkt, file);
                    break;
                }
            }
            outPkt.setAndXCommand(paramBlk, andxCmd);
            outPkt.setAndXParameter(paramBlk, 1, prevEndOfPkt - 4);
            if (!endOfChain) {
                andxCmd = this.m_smbPkt.getAndXParameter(andxOff, 0) & 0xFF;
                andxOff = this.m_smbPkt.getAndXParameter(andxOff, 1);
                paramBlk = prevEndOfPkt;
            } else {
                andxCmd = 255;
            }
            if (outPkt.getErrorCode() == 0) continue;
            andxErr = true;
        }
        return endOfPkt;
    }

    protected final int procChainedTreeConnectAndX(int cmdOff, SMBSrvPacket outPkt, int endOff) {
        boolean unicode;
        String uncPath;
        int pwdLen = this.m_smbPkt.getAndXParameter(cmdOff, 3);
        this.m_smbPkt.setBytePointer(this.m_smbPkt.getAndXByteOffset(cmdOff), this.m_smbPkt.getAndXByteCount(cmdOff));
        String pwd = null;
        if (pwdLen > 0) {
            byte[] pwdByt = this.m_smbPkt.unpackBytes(pwdLen);
            pwd = new String(pwdByt);
        }
        if ((uncPath = this.m_smbPkt.unpackString(unicode = this.m_smbPkt.isUnicode())) == null) {
            outPkt.setError(this.m_smbPkt.isLongErrorCode(), -1073741811, 1, 2);
            return endOff;
        }
        String service = this.m_smbPkt.unpackString(false);
        if (service == null) {
            outPkt.setError(this.m_smbPkt.isLongErrorCode(), -1073741811, 1, 2);
            return endOff;
        }
        int servType = ShareType.ServiceAsType(service);
        if (servType == -1 && service.compareTo("?????") != 0) {
            outPkt.setError(this.m_smbPkt.isLongErrorCode(), -1073741811, 1, 2);
            return endOff;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(8)) {
            logger.debug((Object)("NT ANDX Tree Connect AndX - " + uncPath + ", " + service));
        }
        PCShare share = null;
        try {
            share = new PCShare(uncPath);
        }
        catch (InvalidUNCPathException ex) {
            outPkt.setError(this.m_smbPkt.isLongErrorCode(), -1073741811, 1, 2);
            return endOff;
        }
        if (servType == 2 && share.getShareName().compareTo("IPC$") == 0) {
            servType = 3;
        }
        if (this.m_sess.hasClientInformation() && this.m_sess.getClientInformation().isNullSession() && servType != 3) {
            outPkt.setError(this.m_smbPkt.isLongErrorCode(), -1073741790, 5, 1);
            return endOff;
        }
        SharedDevice shareDev = null;
        try {
            shareDev = this.m_sess.getSMBServer().findShare(share.getNodeName(), share.getShareName(), servType, this.m_sess, true);
        }
        catch (InvalidUserException ex) {
            outPkt.setError(this.m_smbPkt.isLongErrorCode(), -1073741715, 5, 1);
            return endOff;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception in TreeConnectAndX", (Throwable)ex);
            outPkt.setError(this.m_smbPkt.isLongErrorCode(), -1073741620, 6, 2);
            return endOff;
        }
        if (shareDev == null || servType != -1 && shareDev.getType() != servType) {
            outPkt.setError(this.m_smbPkt.isLongErrorCode(), -1073741620, 6, 2);
            return endOff;
        }
        CifsAuthenticator auth = this.getSession().getSMBServer().getAuthenticator();
        int sharePerm = 2;
        if (auth != null && (sharePerm = auth.authenticateShareConnect(this.m_sess.getClientInformation(), shareDev, pwd, this.m_sess)) < 0) {
            outPkt.setError(this.m_smbPkt.isLongErrorCode(), -1073741790, 5, 1);
            return endOff;
        }
        if (this.getSession().getServer().hasAccessControlManager() && shareDev.hasAccessControls()) {
            AccessControlManager aclMgr = this.getSession().getServer().getAccessControlManager();
            int aclPerm = aclMgr.checkAccessControl(this.getSession(), shareDev);
            if (aclPerm == 0) {
                outPkt.setError(this.m_smbPkt.isLongErrorCode(), -1073741790, 5, 1);
                return endOff;
            }
            if (aclPerm != -1) {
                sharePerm = aclPerm;
            }
        }
        TreeConnection tree = null;
        try {
            int treeId = this.m_sess.addConnection(shareDev);
            outPkt.setTreeId(treeId);
            tree = this.m_sess.findConnection(treeId);
            tree.setPermission(sharePerm);
            if (tree.getInterface() != null) {
                tree.getInterface().treeOpened(this.m_sess, tree);
            }
            if (logger.isDebugEnabled() && this.m_sess.hasDebug(8)) {
                logger.debug((Object)("ANDX Tree Connect AndX - Allocated Tree Id = " + treeId));
            }
        }
        catch (TooManyConnectionsException ex) {
            outPkt.setError(89, 2);
            return endOff;
        }
        outPkt.setAndXParameterCount(endOff, 2);
        outPkt.setAndXParameter(endOff, 0, 255);
        outPkt.setAndXParameter(endOff, 1, 0);
        int pos = outPkt.getAndXByteOffset(endOff);
        byte[] outBuf = outPkt.getBuffer();
        pos = DataPacker.putString(ShareType.TypeAsService(shareDev.getType()), outBuf, pos, true);
        String devType = "";
        try {
            if (shareDev.getType() == 0) {
                if (shareDev.getInterface() instanceof NTFSStreamsInterface) {
                    NTFSStreamsInterface ntfsStreams = (NTFSStreamsInterface)((Object)shareDev.getInterface());
                    if (ntfsStreams.hasStreamsEnabled(this.m_sess, tree)) {
                        devType = "NTFS";
                    }
                } else {
                    DiskDeviceContext diskCtx = (DiskDeviceContext)tree.getContext();
                    devType = diskCtx.getFilesystemType();
                }
            }
        }
        catch (InvalidDeviceInterfaceException ex) {
            logger.error((Object)"TreeConnectAndX error", (Throwable)ex);
        }
        pos = DataPacker.putString(devType, outBuf, pos, true, outPkt.isUnicode());
        int bytLen = pos - outPkt.getAndXByteOffset(endOff);
        outPkt.setAndXByteCount(endOff, bytLen);
        return pos;
    }

    protected final int procChainedReadAndX(int cmdOff, SMBSrvPacket outPkt, int endOff, NetworkFile netFile) {
        int treeId = this.m_smbPkt.getTreeId();
        TreeConnection conn = this.m_sess.findConnection(treeId);
        if (conn == null) {
            outPkt.setError(15, 1);
            return endOff;
        }
        long offset = this.m_smbPkt.getAndXParameterLong(cmdOff, 3);
        offset &= 0xFFFFFFFFL;
        int maxCount = this.m_smbPkt.getAndXParameter(cmdOff, 5);
        if (this.m_smbPkt.getAndXParameterCount(cmdOff) == 12) {
            long topOff = this.m_smbPkt.getAndXParameterLong(cmdOff, 10);
            offset += topOff << 32;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(64)) {
            logger.debug((Object)("Chained File Read AndX : Size=" + maxCount + " ,Pos=" + offset));
        }
        byte[] buf = outPkt.getBuffer();
        int dataPos = 0;
        int rdlen = 0;
        try {
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            outPkt.setAndXParameterCount(endOff, 12);
            dataPos = outPkt.getAndXByteOffset(endOff);
            dataPos = DataPacker.wordAlign(dataPos);
            int dataLen = buf.length - dataPos;
            if (dataLen < maxCount) {
                maxCount = dataLen;
            }
            rdlen = disk.readFile(this.m_sess, conn, netFile, buf, dataPos, maxCount, offset);
            outPkt.setAndXParameter(endOff, 0, 255);
            outPkt.setAndXParameter(endOff, 1, 0);
            outPkt.setAndXParameter(endOff, 2, 0);
            outPkt.setAndXParameter(endOff, 3, 0);
            outPkt.setAndXParameter(endOff, 4, 0);
            outPkt.setAndXParameter(endOff, 5, rdlen);
            outPkt.setAndXParameter(endOff, 6, dataPos - 4);
            for (int i = 7; i < 12; ++i) {
                outPkt.setAndXParameter(endOff, i, 0);
            }
            outPkt.setAndXByteCount(endOff, dataPos + rdlen - outPkt.getAndXByteOffset(endOff));
            endOff = dataPos + rdlen;
        }
        catch (InvalidDeviceInterfaceException ex) {
            outPkt.setError(13, 1);
            return endOff;
        }
        catch (IOException ex) {
            // empty catch block
        }
        return endOff;
    }

    protected final int procChainedClose(int cmdOff, SMBSrvPacket outPkt, int endOff) {
        int treeId = this.m_smbPkt.getTreeId();
        TreeConnection conn = this.m_sess.findConnection(treeId);
        if (conn == null) {
            outPkt.setError(15, 1);
            return endOff;
        }
        int fid = this.m_smbPkt.getAndXParameter(cmdOff, 0);
        NetworkFile netFile = conn.findFile(fid);
        if (netFile == null) {
            outPkt.setError(15, 1);
            return endOff;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(64)) {
            logger.debug((Object)("Chained File Close [" + treeId + "] fid=" + fid));
        }
        try {
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            if (disk != null) {
                disk.closeFile(this.m_sess, conn, netFile);
            }
            netFile.setClosed(true);
        }
        catch (InvalidDeviceInterfaceException ex) {
            outPkt.setError(13, 1);
            return endOff;
        }
        catch (IOException ex) {
            // empty catch block
        }
        outPkt.setAndXParameterCount(endOff, 0);
        outPkt.setAndXByteCount(endOff, 0);
        endOff = outPkt.getAndXByteOffset(endOff) - 4;
        conn.removeFile(fid, this.getSession());
        return endOff;
    }

    protected void procTreeConnectAndX(SMBSrvPacket outPkt) throws SMBSrvException, TooManyConnectionsException, IOException {
        String uncPath;
        if (!this.m_smbPkt.checkPacketIsValid(4, 3)) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 1, 2);
            return;
        }
        int pwdLen = this.m_smbPkt.getParameter(3);
        this.m_smbPkt.resetBytePointer();
        boolean unicode = this.m_smbPkt.isUnicode();
        String pwd = null;
        if (pwdLen > 0) {
            byte[] pwdByts = this.m_smbPkt.unpackBytes(pwdLen);
            pwd = new String(pwdByts);
        }
        if ((uncPath = this.m_smbPkt.unpackString(unicode)) == null) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 1, 2);
            return;
        }
        String service = this.m_smbPkt.unpackString(false);
        if (service == null) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 1, 2);
            return;
        }
        int servType = ShareType.ServiceAsType(service);
        if (servType == -1 && service.compareTo("?????") != 0) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 1, 2);
            return;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(8)) {
            logger.debug((Object)("NT Tree Connect AndX - " + uncPath + ", " + service));
        }
        String shareName = null;
        String hostName = null;
        if (uncPath.startsWith("\\")) {
            try {
                PCShare share = new PCShare(uncPath);
                shareName = share.getShareName();
                hostName = share.getNodeName();
            }
            catch (InvalidUNCPathException ex) {
                this.m_sess.sendErrorResponseSMB(-1073741811, 1, 2);
                return;
            }
        } else {
            shareName = uncPath;
        }
        if (servType == 2 && shareName.compareTo("IPC$") == 0) {
            servType = 3;
        }
        if (this.m_sess.hasClientInformation() && this.m_sess.getClientInformation().isNullSession() && servType != 3) {
            this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
            return;
        }
        SharedDevice shareDev = null;
        try {
            shareDev = this.m_sess.getSMBServer().findShare(hostName, shareName, servType, this.m_sess, true);
        }
        catch (InvalidUserException ex) {
            this.m_sess.sendErrorResponseSMB(-1073741715, 5, 1);
            return;
        }
        catch (Exception ex) {
            logger.error((Object)"TreeConnectAndX error", (Throwable)ex);
            this.m_sess.sendErrorResponseSMB(-1073741620, 6, 2);
            return;
        }
        if (shareDev == null || servType != -1 && shareDev.getType() != servType) {
            this.m_sess.sendErrorResponseSMB(-1073741620, 6, 2);
            return;
        }
        CifsAuthenticator auth = this.getSession().getSMBServer().getAuthenticator();
        int sharePerm = 2;
        if (auth != null && (sharePerm = auth.authenticateShareConnect(this.m_sess.getClientInformation(), shareDev, pwd, this.m_sess)) < 0) {
            if (logger.isDebugEnabled() && this.m_sess.hasDebug(8)) {
                logger.debug((Object)("Tree connect to " + shareName + ", access denied"));
            }
            this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
            return;
        }
        if (this.getSession().getServer().hasAccessControlManager() && shareDev.hasAccessControls()) {
            AccessControlManager aclMgr = this.getSession().getServer().getAccessControlManager();
            int aclPerm = aclMgr.checkAccessControl(this.getSession(), shareDev);
            if (aclPerm == 0) {
                this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
                return;
            }
            if (aclPerm != -1) {
                sharePerm = aclPerm;
            }
        }
        int treeId = this.m_sess.addConnection(shareDev);
        outPkt.setTreeId(treeId);
        TreeConnection tree = this.m_sess.findConnection(treeId);
        tree.setPermission(sharePerm);
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(8)) {
            logger.debug((Object)("Tree Connect AndX - Allocated Tree Id = " + treeId + ", Permission = " + FileAccess.asString(sharePerm)));
        }
        outPkt.setParameterCount(3);
        outPkt.setAndXCommand(255);
        outPkt.setParameter(1, 0);
        outPkt.setParameter(2, 0);
        int pos = outPkt.getByteOffset();
        pos = DataPacker.putString(ShareType.TypeAsService(shareDev.getType()), this.m_smbPkt.getBuffer(), pos, true);
        String devType = "";
        try {
            if (shareDev.getType() == 0) {
                if (shareDev.getInterface() instanceof NTFSStreamsInterface) {
                    NTFSStreamsInterface ntfsStreams = (NTFSStreamsInterface)((Object)shareDev.getInterface());
                    if (ntfsStreams.hasStreamsEnabled(this.m_sess, tree)) {
                        devType = "NTFS";
                    }
                } else {
                    DiskDeviceContext diskCtx = (DiskDeviceContext)tree.getContext();
                    devType = diskCtx.getFilesystemType();
                }
            }
        }
        catch (InvalidDeviceInterfaceException ex) {
            logger.error((Object)"TreeConnectAndX error", (Throwable)ex);
        }
        pos = DataPacker.putString(devType, this.m_smbPkt.getBuffer(), pos, true, outPkt.isUnicode());
        outPkt.setByteCount(pos - outPkt.getByteOffset());
        this.m_sess.sendResponseSMB(outPkt);
        if (tree.getInterface() != null) {
            tree.getInterface().treeOpened(this.m_sess, tree);
        }
    }

    protected void procCloseFile(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        if (!this.m_smbPkt.checkPacketIsValid(3, 0)) {
            this.m_sess.sendErrorResponseSMB(64, 2);
            return;
        }
        int treeId = this.m_smbPkt.getTreeId();
        TreeConnection conn = this.m_sess.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(4, 2);
            return;
        }
        int fid = this.m_smbPkt.getParameter(0);
        NetworkFile netFile = conn.findFile(fid);
        if (netFile == null) {
            this.m_sess.sendErrorResponseSMB(6, 1);
            return;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(64)) {
            logger.debug((Object)("File close [" + treeId + "] fid=" + fid));
        }
        try {
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            if (disk != null) {
                disk.closeFile(this.m_sess, conn, netFile);
            }
            netFile.setClosed(true);
        }
        catch (AccessDeniedException ex) {
            this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
            return;
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        catch (IOException ex) {
            // empty catch block
        }
        conn.removeFile(fid, this.getSession());
        outPkt.setParameterCount(0);
        outPkt.setByteCount(0);
        this.m_sess.sendResponseSMB(outPkt);
        DiskDeviceContext diskCtx = (DiskDeviceContext)conn.getContext();
        if (netFile.getWriteCount() > 0 && diskCtx.hasChangeHandler()) {
            diskCtx.getChangeHandler().notifyFileSizeChanged(netFile.getFullName());
        }
        if (netFile.hasDeleteOnClose() && diskCtx.hasChangeHandler()) {
            diskCtx.getChangeHandler().notifyFileChanged(2, netFile.getFullName());
        }
    }

    protected void procTransact2(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        if (!this.m_smbPkt.checkPacketIsValid(14, 0)) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 1, 2);
            return;
        }
        int treeId = this.m_smbPkt.getTreeId();
        TreeConnection conn = this.m_sess.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(4, 2);
            return;
        }
        SMBSrvTransPacket tranPkt = new SMBSrvTransPacket(this.m_smbPkt.getBuffer());
        SrvTransactBuffer transBuf = null;
        int subCmd = tranPkt.getSubFunction();
        if (tranPkt.getTotalParameterCount() == tranPkt.getRxParameterBlockLength() && tranPkt.getTotalDataCount() == tranPkt.getRxDataBlockLength()) {
            transBuf = new SrvTransactBuffer(tranPkt);
        } else {
            transBuf = new SrvTransactBuffer(tranPkt.getSetupCount(), tranPkt.getTotalParameterCount(), tranPkt.getTotalDataCount());
            transBuf.setType(tranPkt.getCommand());
            transBuf.setFunction(subCmd);
            byte[] buf = tranPkt.getBuffer();
            transBuf.appendSetup(buf, tranPkt.getSetupOffset(), tranPkt.getSetupCount() * 2);
            transBuf.appendParameter(buf, tranPkt.getRxParameterBlock(), tranPkt.getRxParameterBlockLength());
            transBuf.appendData(buf, tranPkt.getRxDataBlock(), tranPkt.getRxDataBlockLength());
        }
        transBuf.setReturnLimits(tranPkt.getMaximumReturnSetupCount(), tranPkt.getMaximumReturnParameterCount(), tranPkt.getMaximumReturnDataCount());
        if (transBuf.isMultiPacket()) {
            this.m_sess.setTransaction(transBuf);
            this.m_sess.sendSuccessResponseSMB();
            return;
        }
        if (conn.getSharedDevice().getType() == 3) {
            IPCHandler.procTransaction(transBuf, this.m_sess, outPkt);
            return;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(256)) {
            logger.debug((Object)("Transaction [" + treeId + "] tbuf=" + transBuf));
        }
        this.processTransactionBuffer(transBuf, outPkt);
    }

    protected void procTransact2Secondary(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        int dlen;
        if (!this.m_smbPkt.checkPacketIsValid(8, 0)) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 1, 2);
            return;
        }
        int treeId = this.m_smbPkt.getTreeId();
        TreeConnection conn = this.m_sess.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(4, 2);
            return;
        }
        if (!this.m_sess.hasTransaction() || this.m_sess.getTransaction().isType() == 37 && this.m_smbPkt.getCommand() != 38 || this.m_sess.getTransaction().isType() == 50 && this.m_smbPkt.getCommand() != 51) {
            this.m_sess.sendErrorResponseSMB(1, 2);
            return;
        }
        SMBSrvTransPacket tpkt = new SMBSrvTransPacket(this.m_smbPkt.getBuffer());
        byte[] buf = tpkt.getBuffer();
        SrvTransactBuffer transBuf = this.m_sess.getTransaction();
        int plen = tpkt.getSecondaryParameterBlockCount();
        if (plen > 0) {
            DataBuffer paramBuf = transBuf.getParameterBuffer();
            paramBuf.appendData(buf, tpkt.getSecondaryParameterBlockOffset(), plen);
        }
        if ((dlen = tpkt.getSecondaryDataBlockCount()) > 0) {
            DataBuffer dataBuf = transBuf.getDataBuffer();
            dataBuf.appendData(buf, tpkt.getSecondaryDataBlockOffset(), dlen);
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(256)) {
            logger.debug((Object)("Transaction Secondary [" + treeId + "] paramLen=" + plen + ", dataLen=" + dlen));
        }
        int totParam = tpkt.getTotalParameterCount();
        int totData = tpkt.getTotalDataCount();
        int paramDisp = tpkt.getParameterBlockDisplacement();
        int dataDisp = tpkt.getDataBlockDisplacement();
        if (paramDisp + plen == totParam && dataDisp + dlen == totData) {
            if (logger.isDebugEnabled() && this.m_sess.hasDebug(256)) {
                logger.debug((Object)"Transaction complete, processing ...");
            }
            this.m_sess.setTransaction(null);
            if (conn.getSharedDevice().getType() == 3) {
                IPCHandler.procTransaction(transBuf, this.m_sess, outPkt);
                return;
            }
            if (logger.isDebugEnabled() && this.m_sess.hasDebug(256)) {
                logger.debug((Object)("Transaction second [" + treeId + "] tbuf=" + transBuf));
            }
            this.processTransactionBuffer(transBuf, outPkt);
        } else {
            this.m_sess.sendSuccessResponseSMB();
        }
    }

    private final void processTransactionBuffer(SrvTransactBuffer tbuf, SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        switch (tbuf.getFunction()) {
            case 1: {
                this.procTrans2FindFirst(tbuf, outPkt);
                break;
            }
            case 2: {
                this.procTrans2FindNext(tbuf, outPkt);
                break;
            }
            case 3: {
                this.procTrans2QueryFileSys(tbuf, outPkt);
                break;
            }
            case 5: {
                this.procTrans2QueryPath(tbuf, outPkt);
                break;
            }
            case 7: {
                this.procTrans2QueryFile(tbuf, outPkt);
                break;
            }
            case 8: {
                this.procTrans2SetFile(tbuf, outPkt);
                break;
            }
            case 6: {
                this.procTrans2SetPath(tbuf, outPkt);
                break;
            }
            default: {
                this.m_sess.sendErrorResponseSMB(-1073741811, 1, 2);
            }
        }
    }

    protected final void procFindClose(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        if (!this.m_smbPkt.checkPacketIsValid(1, 0)) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 1, 2);
            return;
        }
        int treeId = this.m_smbPkt.getTreeId();
        TreeConnection conn = this.m_sess.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(4, 2);
            return;
        }
        int searchId = this.m_smbPkt.getParameter(0);
        SearchContext ctx = this.m_sess.getSearchContext(searchId);
        if (ctx == null) {
            this.m_sess.sendSuccessResponseSMB();
            return;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(16)) {
            logger.debug((Object)("Close trans search [" + searchId + "]"));
        }
        this.m_sess.deallocateSearchSlot(searchId);
        this.m_sess.sendSuccessResponseSMB();
    }

    protected final void procLockingAndX(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        if (!this.m_smbPkt.checkPacketIsValid(8, 0)) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 1, 2);
            return;
        }
        int treeId = this.m_smbPkt.getTreeId();
        TreeConnection conn = this.m_sess.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(4, 2);
            return;
        }
        int fid = this.m_smbPkt.getParameter(2);
        int lockType = this.m_smbPkt.getParameter(3);
        long lockTmo = this.m_smbPkt.getParameterLong(4);
        int unlockCnt = this.m_smbPkt.getParameter(6);
        int lockCnt = this.m_smbPkt.getParameter(7);
        NetworkFile netFile = conn.findFile(fid);
        if (netFile == null) {
            this.m_sess.sendErrorResponseSMB(6, 6, 1);
            return;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(4096)) {
            logger.debug((Object)("File Lock [" + netFile.getFileId() + "] : type=0x" + Integer.toHexString(lockType) + ", tmo=" + lockTmo + ", locks=" + lockCnt + ", unlocks=" + unlockCnt));
        }
        DiskInterface disk = null;
        try {
            disk = (DiskInterface)conn.getSharedDevice().getInterface();
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        if (disk instanceof FileLockingInterface) {
            FileLockingInterface lockInterface = (FileLockingInterface)((Object)disk);
            LockManager lockMgr = lockInterface.getLockManager(this.m_sess, conn);
            this.m_smbPkt.resetBytePointer();
            boolean largeFileLock = LockingAndX.hasLargeFiles(lockType);
            if (unlockCnt + lockCnt == 1) {
                int pid = this.m_smbPkt.unpackWord();
                long offset = -1L;
                long length = -1L;
                if (!largeFileLock) {
                    offset = this.m_smbPkt.unpackInt();
                    length = this.m_smbPkt.unpackInt();
                } else {
                    this.m_smbPkt.skipBytes(2);
                    offset = (long)this.m_smbPkt.unpackInt() << 32;
                    offset += (long)this.m_smbPkt.unpackInt();
                    length = (long)this.m_smbPkt.unpackInt() << 32;
                    length += (long)this.m_smbPkt.unpackInt();
                }
                FileLock fLock = lockMgr.createLockObject(this.m_sess, conn, netFile, offset, length, pid);
                if (logger.isDebugEnabled() && this.m_sess.hasDebug(4096)) {
                    logger.debug((Object)("  Single " + (lockCnt == 1 ? "Lock" : "UnLock") + " lock=" + fLock.toString()));
                }
                try {
                    if (unlockCnt > 0) {
                        lockMgr.unlockFile(this.m_sess, conn, netFile, fLock);
                    }
                    lockMgr.lockFile(this.m_sess, conn, netFile, fLock);
                }
                catch (NotLockedException ex) {
                    this.m_sess.sendErrorResponseSMB(158, 1);
                    return;
                }
                catch (LockConflictException ex) {
                    this.m_sess.sendErrorResponseSMB(-1073741739, 33, 1);
                    return;
                }
                catch (IOException ex) {
                    this.m_sess.sendErrorResponseSMB(65, 2);
                    return;
                }
            }
        } else if (unlockCnt > 0) {
            this.m_sess.sendErrorResponseSMB(158, 1);
            return;
        }
        outPkt.setParameterCount(2);
        outPkt.setAndXCommand(255);
        outPkt.setParameter(1, 0);
        outPkt.setByteCount(0);
        this.m_sess.sendResponseSMB(outPkt);
    }

    protected final void procLogoffAndX(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        this.m_sess.sendSuccessResponseSMB();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void procOpenAndX(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        int fid;
        if (!this.m_smbPkt.checkPacketIsValid(15, 1)) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 1, 2);
            return;
        }
        int treeId = this.m_smbPkt.getTreeId();
        TreeConnection conn = this.m_sess.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
            return;
        }
        if (conn.getSharedDevice().getType() == 3) {
            IPCHandler.processIPCRequest(this.m_sess, outPkt);
            return;
        }
        if (conn.getSharedDevice().getType() != 0) {
            this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
            return;
        }
        int access = this.m_smbPkt.getParameter(3);
        int srchAttr = this.m_smbPkt.getParameter(4);
        int fileAttr = this.m_smbPkt.getParameter(5);
        int crTime = this.m_smbPkt.getParameter(6);
        int crDate = this.m_smbPkt.getParameter(7);
        int openFunc = this.m_smbPkt.getParameter(8);
        int allocSiz = this.m_smbPkt.getParameterLong(9);
        String fileName = this.m_smbPkt.unpackString(this.m_smbPkt.isUnicode());
        if (fileName == null) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        long crDateTime = 0L;
        if (crTime > 0 && crDate > 0) {
            crDateTime = new SMBDate(crDate, crTime).getTime();
        }
        FileOpenParams params = new FileOpenParams(fileName, openFunc, access, srchAttr, fileAttr, allocSiz, crDateTime);
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(64)) {
            logger.debug((Object)("File Open AndX [" + treeId + "] params=" + params));
        }
        NetworkFile netFile = null;
        int respAction = 0;
        try {
            block20: {
                DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
                int fileSts = disk.fileExists(this.m_sess, conn, fileName);
                if (fileSts == 0) {
                    if (FileAction.createNotExists(openFunc)) {
                        netFile = disk.createFile(this.m_sess, conn, params);
                        respAction = 2;
                        break block20;
                    } else {
                        if (fileSts == 2) {
                            this.m_sess.sendErrorResponseSMB(5, 1);
                            return;
                        }
                        this.m_sess.sendErrorResponseSMB(2, 1);
                        return;
                    }
                }
                netFile = disk.openFile(this.m_sess, conn, params);
                respAction = FileAction.truncateExistingFile(openFunc) ? 3 : 1;
            }
            fid = conn.addFile(netFile, this.getSession());
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        catch (TooManyFilesException ex) {
            this.m_sess.sendErrorResponseSMB(4, 1);
            return;
        }
        catch (AccessDeniedException ex) {
            this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
            return;
        }
        catch (FileSharingException ex) {
            this.m_sess.sendErrorResponseSMB(-1073741757, 32, 1);
            return;
        }
        catch (FileOfflineException ex) {
            this.m_sess.sendErrorResponseSMB(-1073741209, 21, 3);
            return;
        }
        catch (IOException ex) {
            this.m_sess.sendErrorResponseSMB(2, 1);
            return;
        }
        outPkt.setParameterCount(15);
        outPkt.setAndXCommand(255);
        outPkt.setParameter(1, 0);
        outPkt.setParameter(2, fid);
        outPkt.setParameter(3, netFile.getFileAttributes());
        SMBDate modDate = null;
        if (netFile.hasModifyDate()) {
            modDate = new SMBDate(netFile.getModifyDate());
        }
        outPkt.setParameter(4, modDate != null ? modDate.asSMBTime() : 0);
        outPkt.setParameter(5, modDate != null ? modDate.asSMBDate() : 0);
        outPkt.setParameterLong(6, netFile.getFileSizeInt());
        outPkt.setParameter(8, netFile.getGrantedAccess());
        outPkt.setParameter(9, 0);
        outPkt.setParameter(10, 0);
        outPkt.setParameter(11, respAction);
        outPkt.setParameter(12, 0);
        outPkt.setParameter(13, 0);
        outPkt.setParameter(14, 0);
        outPkt.setByteCount(0);
        this.m_sess.sendResponseSMB(outPkt);
    }

    protected final void procReadAndX(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        NetworkFile netFile;
        if (!this.m_smbPkt.checkPacketIsValid(10, 0)) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 1, 2);
            return;
        }
        int treeId = this.m_smbPkt.getTreeId();
        TreeConnection conn = this.m_sess.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
            return;
        }
        if (conn.getSharedDevice().getType() == 3) {
            IPCHandler.processIPCRequest(this.m_sess, outPkt);
            return;
        }
        int fid = this.m_smbPkt.getParameter(2);
        long offset = this.m_smbPkt.getParameterLong(3);
        offset &= 0xFFFFFFFFL;
        int maxCount = this.m_smbPkt.getParameter(5);
        if (this.m_smbPkt.getParameterCount() == 12) {
            long topOff = this.m_smbPkt.getParameterLong(10);
            offset += topOff << 32;
        }
        if ((netFile = conn.findFile(fid)) == null) {
            this.m_sess.sendErrorResponseSMB(6, 1);
            return;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(128)) {
            logger.debug((Object)("File Read AndX [" + netFile.getFileId() + "] : Size=" + maxCount + " ,Pos=" + offset));
        }
        byte[] buf = outPkt.getBuffer();
        int dataPos = 0;
        int rdlen = 0;
        try {
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            outPkt.setParameterCount(12);
            dataPos = outPkt.getByteOffset();
            dataPos = DataPacker.wordAlign(dataPos);
            int dataLen = buf.length - dataPos;
            if (dataLen < maxCount) {
                maxCount = dataLen;
            }
            rdlen = disk.readFile(this.m_sess, conn, netFile, buf, dataPos, maxCount, offset);
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        catch (FileOfflineException ex) {
            this.m_sess.sendErrorResponseSMB(-1073741209, 30, 3);
            return;
        }
        catch (LockConflictException ex) {
            if (logger.isDebugEnabled() && this.m_sess.hasDebug(4096)) {
                logger.debug((Object)("Read Lock Error [" + netFile.getFileId() + "] : Size=" + maxCount + " ,Pos=" + offset));
            }
            this.m_sess.sendErrorResponseSMB(-1073741740, 33, 1);
            return;
        }
        catch (AccessDeniedException ex) {
            this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
            return;
        }
        catch (IOException ex) {
            this.m_sess.sendErrorResponseSMB(30, 3);
            return;
        }
        outPkt.setAndXCommand(255);
        outPkt.setParameter(1, 0);
        outPkt.setParameter(2, 0);
        outPkt.setParameter(3, 0);
        outPkt.setParameter(4, 0);
        outPkt.setParameter(5, rdlen);
        outPkt.setParameter(6, dataPos - 4);
        for (int i = 7; i < 12; ++i) {
            outPkt.setParameter(i, 0);
        }
        outPkt.setByteCount(dataPos + rdlen - outPkt.getByteOffset());
        if (this.m_smbPkt.hasAndXCommand()) {
            int pos = this.procAndXCommands(outPkt, outPkt.getPacketLength(), netFile);
            this.m_sess.sendResponseSMB(outPkt, pos);
        } else {
            this.m_sess.sendResponseSMB(outPkt);
        }
    }

    protected void procRenameFile(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        if (!this.m_smbPkt.checkPacketIsValid(1, 4)) {
            this.m_sess.sendErrorResponseSMB(64, 2);
            return;
        }
        int treeId = this.m_smbPkt.getTreeId();
        TreeConnection conn = this.m_sess.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 15, 1);
            return;
        }
        if (!conn.hasWriteAccess()) {
            this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
            return;
        }
        boolean isUni = this.m_smbPkt.isUnicode();
        this.m_smbPkt.resetBytePointer();
        if (this.m_smbPkt.unpackByte() != 4) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        String oldName = this.m_smbPkt.unpackString(isUni);
        if (oldName == null) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        if (this.m_smbPkt.unpackByte() != 4) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        String newName = this.m_smbPkt.unpackString(isUni);
        if (newName == null) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(64)) {
            logger.debug((Object)("File Rename [" + treeId + "] old name=" + oldName + ", new name=" + newName));
        }
        try {
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            disk.renameFile(this.m_sess, conn, oldName, newName);
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        catch (FileNotFoundException ex) {
            this.m_sess.sendErrorResponseSMB(-1073741772, 2, 1);
            return;
        }
        catch (FileExistsException ex) {
            this.m_sess.sendErrorResponseSMB(-1073741771, 80, 1);
            return;
        }
        catch (AccessDeniedException ex) {
            this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
            return;
        }
        catch (FileSharingException ex) {
            this.m_sess.sendErrorResponseSMB(-1073741757, 32, 1);
            return;
        }
        outPkt.setParameterCount(0);
        outPkt.setByteCount(0);
        this.m_sess.sendResponseSMB(outPkt);
        DiskDeviceContext diskCtx = (DiskDeviceContext)conn.getContext();
        if (diskCtx.hasChangeHandler()) {
            diskCtx.getChangeHandler().notifyRename(oldName, newName);
        }
    }

    protected void procDeleteFile(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        if (!this.m_smbPkt.checkPacketIsValid(1, 2)) {
            this.m_sess.sendErrorResponseSMB(64, 2);
            return;
        }
        int treeId = this.m_smbPkt.getTreeId();
        TreeConnection conn = this.m_sess.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 15, 1);
            return;
        }
        if (!conn.hasWriteAccess()) {
            this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
            return;
        }
        boolean isUni = this.m_smbPkt.isUnicode();
        this.m_smbPkt.resetBytePointer();
        if (this.m_smbPkt.unpackByte() != 4) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        String fileName = this.m_smbPkt.unpackString(isUni);
        if (fileName == null) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(64)) {
            logger.debug((Object)("File Delete [" + treeId + "] name=" + fileName));
        }
        try {
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            disk.deleteFile(this.m_sess, conn, fileName);
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        catch (AccessDeniedException ex) {
            this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
            return;
        }
        catch (IOException ex) {
            this.m_sess.sendErrorResponseSMB(-1073741772, 2, 1);
            return;
        }
        outPkt.setParameterCount(0);
        outPkt.setByteCount(0);
        this.m_sess.sendResponseSMB(outPkt);
        DiskDeviceContext diskCtx = (DiskDeviceContext)conn.getContext();
        if (diskCtx.hasChangeHandler()) {
            diskCtx.getChangeHandler().notifyFileChanged(2, fileName);
        }
    }

    protected void procDeleteDirectory(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        if (!this.m_smbPkt.checkPacketIsValid(0, 2)) {
            this.m_sess.sendErrorResponseSMB(64, 2);
            return;
        }
        int treeId = this.m_smbPkt.getTreeId();
        TreeConnection conn = this.m_sess.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 15, 1);
            return;
        }
        if (!conn.hasWriteAccess()) {
            this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
            return;
        }
        boolean isUni = this.m_smbPkt.isUnicode();
        this.m_smbPkt.resetBytePointer();
        if (this.m_smbPkt.unpackByte() != 4) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        String dirName = this.m_smbPkt.unpackString(isUni);
        if (dirName == null) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(64)) {
            logger.debug((Object)("Directory Delete [" + treeId + "] name=" + dirName));
        }
        try {
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            disk.deleteDirectory(this.m_sess, conn, dirName);
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        catch (AccessDeniedException ex) {
            this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
            return;
        }
        catch (DirectoryNotEmptyException ex) {
            this.m_sess.sendErrorResponseSMB(145, 1);
            return;
        }
        catch (IOException ex) {
            this.m_sess.sendErrorResponseSMB(3, 1);
            return;
        }
        outPkt.setParameterCount(0);
        outPkt.setByteCount(0);
        this.m_sess.sendResponseSMB(outPkt);
        DiskDeviceContext diskCtx = (DiskDeviceContext)conn.getContext();
        if (diskCtx.hasChangeHandler()) {
            diskCtx.getChangeHandler().notifyDirectoryChanged(2, dirName);
        }
    }

    protected final void procTrans2FindFirst(SrvTransactBuffer tbuf, SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        int treeId = this.m_smbPkt.getTreeId();
        TreeConnection conn = this.m_sess.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(4, 2);
            return;
        }
        DataBuffer paramBuf = tbuf.getParameterBuffer();
        int srchAttr = paramBuf.getShort();
        int maxFiles = paramBuf.getShort();
        int srchFlag = paramBuf.getShort();
        int infoLevl = paramBuf.getShort();
        paramBuf.skipBytes(4);
        String srchPath = paramBuf.getString(tbuf.isUnicode());
        if (srchPath == null || srchPath.length() == 0) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        if (srchPath.endsWith("\\")) {
            srchPath = srchPath + "*.*";
        }
        if (infoLevl == 770 && !this.getSession().hasMacintoshExtensions()) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 65535, 2);
            return;
        }
        SearchContext ctx = null;
        DiskInterface disk = null;
        int searchId = -1;
        boolean wildcardSearch = false;
        try {
            disk = (DiskInterface)conn.getSharedDevice().getInterface();
            searchId = this.m_sess.allocateSearchSlot();
            if (searchId == -1) {
                this.m_sess.sendErrorResponseSMB(89, 2);
                return;
            }
            if (WildCard.containsWildcards(srchPath) || WildCard.containsUnicodeWildcard(srchPath)) {
                wildcardSearch = true;
            }
            if (tbuf.isUnicode() && WildCard.containsUnicodeWildcard(srchPath)) {
                srchPath = WildCard.convertUnicodeWildcardToDOS(srchPath);
                if (logger.isDebugEnabled() && this.m_sess.hasDebug(16)) {
                    logger.debug((Object)("Converted Unicode wildcards to:" + srchPath));
                }
            }
            if ((ctx = disk.startSearch(this.m_sess, conn, srchPath, srchAttr)) == null) {
                this.m_sess.sendErrorResponseSMB(-1073741809, 2, 1);
                return;
            }
            ctx.setTreeId(treeId);
            ctx.setMaximumFiles(maxFiles);
            this.m_sess.setSearchContext(searchId, ctx);
            SrvTransactBuffer replyBuf = new SrvTransactBuffer(tbuf);
            DataBuffer dataBuf = replyBuf.getDataBuffer();
            int maxLen = replyBuf.getReturnDataLimit();
            if (logger.isDebugEnabled() && this.m_sess.hasDebug(16)) {
                logger.debug((Object)("Start trans search [" + searchId + "] - " + srchPath + ", attr=0x" + Integer.toHexString(srchAttr) + ", maxFiles=" + maxFiles + ", maxLen=" + maxLen + ", infoLevel=" + infoLevl + ", flags=0x" + Integer.toHexString(srchFlag)));
            }
            int fileCnt = 0;
            int packLen = 0;
            int lastNameOff = 0;
            boolean resumeIds = false;
            if (infoLevl == 1 && (srchFlag & 4) != 0) {
                resumeIds = true;
            }
            if (wildcardSearch) {
                if (resumeIds) {
                    dataBuf.putInt(-1);
                    maxLen -= 4;
                }
                lastNameOff = dataBuf.getPosition();
                FileInfo dotInfo = new FileInfo(".", 0L, 16);
                dotInfo.setFileId(dotInfo.getFileName().hashCode());
                packLen = FindInfoPacker.packInfo(dotInfo, dataBuf, infoLevl, tbuf.isUnicode());
                ++fileCnt;
                maxLen -= packLen;
                if (resumeIds) {
                    dataBuf.putInt(-2);
                    maxLen -= 4;
                }
                lastNameOff = dataBuf.getPosition();
                dotInfo.setFileName("..");
                dotInfo.setFileId(dotInfo.getFileName().hashCode());
                packLen = FindInfoPacker.packInfo(dotInfo, dataBuf, infoLevl, tbuf.isUnicode());
                ++fileCnt;
                maxLen -= packLen;
            }
            boolean pktDone = false;
            boolean searchDone = false;
            FileInfo info = new FileInfo();
            while (!pktDone && fileCnt < maxFiles) {
                if (!ctx.nextFileInfo(info)) {
                    pktDone = true;
                    searchDone = true;
                    continue;
                }
                if (FindInfoPacker.calcInfoSize(info, infoLevl, false, true) <= maxLen) {
                    if (resumeIds) {
                        dataBuf.putInt(ctx.getResumeId());
                        maxLen -= 4;
                    }
                    lastNameOff = dataBuf.getPosition();
                    packLen = FindInfoPacker.packInfo(info, dataBuf, infoLevl, tbuf.isUnicode());
                    ++fileCnt;
                    maxLen -= packLen;
                    continue;
                }
                ctx.restartAt(info);
                pktDone = true;
            }
            if (!wildcardSearch && fileCnt == 0) {
                throw new FileNotFoundException(srchPath);
            }
            if (maxFiles == 1 && fileCnt == 1) {
                searchDone = true;
            }
            FindInfoPacker.clearNextOffset(dataBuf, infoLevl, lastNameOff);
            paramBuf = replyBuf.getParameterBuffer();
            paramBuf.putShort(searchId);
            paramBuf.putShort(fileCnt);
            paramBuf.putShort(ctx.hasMoreFiles() ? 0 : 1);
            paramBuf.putShort(0);
            paramBuf.putShort(lastNameOff);
            SMBSrvTransPacket tpkt = new SMBSrvTransPacket(outPkt.getBuffer());
            tpkt.doTransactionResponse(this.m_sess, replyBuf);
            if (logger.isDebugEnabled() && this.m_sess.hasDebug(16)) {
                logger.debug((Object)("Search [" + searchId + "] Returned " + fileCnt + " files, dataLen=" + dataBuf.getLength() + ", moreFiles=" + ctx.hasMoreFiles()));
            }
            if (searchDone || !ctx.hasMoreFiles()) {
                if (logger.isDebugEnabled() && this.m_sess.hasDebug(16)) {
                    logger.debug((Object)("End start search [" + searchId + "] (Search complete)"));
                }
                this.m_sess.deallocateSearchSlot(searchId);
            }
        }
        catch (FileNotFoundException ex) {
            this.m_sess.sendErrorResponseSMB(-1073741809, 18, 1);
        }
        catch (PathNotFoundException ex) {
            if (searchId != -1) {
                this.m_sess.deallocateSearchSlot(searchId);
            }
            this.m_sess.sendErrorResponseSMB(-1073741766, 2, 1);
            return;
        }
        catch (InvalidDeviceInterfaceException ex) {
            if (searchId != -1) {
                this.m_sess.deallocateSearchSlot(searchId);
            }
            this.m_sess.sendErrorResponseSMB(13, 1);
        }
        catch (UnsupportedInfoLevelException ex) {
            if (searchId != -1) {
                this.m_sess.deallocateSearchSlot(searchId);
            }
            this.m_sess.sendErrorResponseSMB(65535, 2);
        }
    }

    protected final void procTrans2FindNext(SrvTransactBuffer tbuf, SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        int treeId = this.m_smbPkt.getTreeId();
        TreeConnection conn = this.m_sess.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
            return;
        }
        DataBuffer paramBuf = tbuf.getParameterBuffer();
        int searchId = paramBuf.getShort();
        int maxFiles = paramBuf.getShort();
        int infoLevl = paramBuf.getShort();
        paramBuf.getInt();
        int srchFlag = paramBuf.getShort();
        String resumeName = paramBuf.getString(tbuf.isUnicode());
        SearchContext ctx = null;
        try {
            ctx = this.m_sess.getSearchContext(searchId);
            if (ctx == null) {
                if (logger.isDebugEnabled() && this.m_sess.hasDebug(16)) {
                    logger.debug((Object)("Search context null - [" + searchId + "]"));
                }
                this.m_sess.sendErrorResponseSMB(18, 1);
                return;
            }
            SrvTransactBuffer replyBuf = new SrvTransactBuffer(tbuf);
            DataBuffer dataBuf = replyBuf.getDataBuffer();
            int maxLen = replyBuf.getReturnDataLimit();
            if (logger.isDebugEnabled() && this.m_sess.hasDebug(16)) {
                logger.debug((Object)("Continue search [" + searchId + "] - " + resumeName + ", maxFiles=" + maxFiles + ", maxLen=" + maxLen + ", infoLevel=" + infoLevl + ", flags=0x" + Integer.toHexString(srchFlag)));
            }
            int fileCnt = 0;
            int packLen = 0;
            int lastNameOff = 0;
            boolean resumeIds = false;
            if (infoLevl == 1 && (srchFlag & 4) != 0) {
                resumeIds = true;
            }
            boolean pktDone = false;
            boolean searchDone = false;
            FileInfo info = new FileInfo();
            while (!pktDone && fileCnt < maxFiles) {
                if (!ctx.nextFileInfo(info)) {
                    pktDone = true;
                    searchDone = true;
                    continue;
                }
                if (FindInfoPacker.calcInfoSize(info, infoLevl, false, true) <= maxLen) {
                    if (resumeIds) {
                        dataBuf.putInt(ctx.getResumeId());
                        maxLen -= 4;
                    }
                    lastNameOff = dataBuf.getPosition();
                    packLen = FindInfoPacker.packInfo(info, dataBuf, infoLevl, tbuf.isUnicode());
                    ++fileCnt;
                    maxLen -= packLen;
                    continue;
                }
                ctx.restartAt(info);
                pktDone = true;
            }
            paramBuf = replyBuf.getParameterBuffer();
            paramBuf.putShort(fileCnt);
            paramBuf.putShort(ctx.hasMoreFiles() ? 0 : 1);
            paramBuf.putShort(0);
            paramBuf.putShort(lastNameOff);
            SMBSrvTransPacket tpkt = new SMBSrvTransPacket(outPkt.getBuffer());
            tpkt.doTransactionResponse(this.m_sess, replyBuf);
            if (logger.isDebugEnabled() && this.m_sess.hasDebug(16)) {
                logger.debug((Object)("Search [" + searchId + "] Returned " + fileCnt + " files, dataLen=" + dataBuf.getLength() + ", moreFiles=" + ctx.hasMoreFiles()));
            }
            if (searchDone || !ctx.hasMoreFiles()) {
                if (logger.isDebugEnabled() && this.m_sess.hasDebug(16)) {
                    logger.debug((Object)("End start search [" + searchId + "] (Search complete)"));
                }
                this.m_sess.deallocateSearchSlot(searchId);
            }
        }
        catch (FileNotFoundException ex) {
            if (searchId != -1) {
                this.m_sess.deallocateSearchSlot(searchId);
            }
            this.m_sess.sendErrorResponseSMB(18, 1);
        }
        catch (UnsupportedInfoLevelException ex) {
            if (searchId != -1) {
                this.m_sess.deallocateSearchSlot(searchId);
            }
            this.m_sess.sendErrorResponseSMB(65535, 2);
        }
    }

    protected final void procTrans2QueryFileSys(SrvTransactBuffer tbuf, SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        int treeId = this.m_smbPkt.getTreeId();
        TreeConnection conn = this.m_sess.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
            return;
        }
        DataBuffer paramBuf = tbuf.getParameterBuffer();
        int infoLevl = paramBuf.getShort();
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(32)) {
            logger.debug((Object)("Query File System Info - level = 0x" + Integer.toHexString(infoLevl)));
        }
        try {
            int prmPos;
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            DiskDeviceContext diskCtx = (DiskDeviceContext)conn.getContext();
            outPkt.setParameterCount(10);
            byte[] buf = outPkt.getBuffer();
            int dataPos = prmPos = DataPacker.longwordAlign(outPkt.getByteOffset());
            DataBuffer replyBuf = new DataBuffer(buf, dataPos, buf.length - dataPos);
            SrvDiskInfo diskInfo = null;
            VolumeInfo volInfo = null;
            switch (infoLevl) {
                case 1: {
                    diskInfo = this.getDiskInformation(disk, diskCtx);
                    DiskInfoPacker.packStandardInfo(diskInfo, replyBuf);
                    break;
                }
                case 2: {
                    volInfo = this.getVolumeInformation(disk, diskCtx);
                    DiskInfoPacker.packVolumeInfo(volInfo, replyBuf, tbuf.isUnicode());
                    break;
                }
                case 258: {
                    volInfo = this.getVolumeInformation(disk, diskCtx);
                    DiskInfoPacker.packFsVolumeInformation(volInfo, replyBuf, tbuf.isUnicode());
                    break;
                }
                case 259: {
                    diskInfo = this.getDiskInformation(disk, diskCtx);
                    DiskInfoPacker.packFsSizeInformation(diskInfo, replyBuf);
                    break;
                }
                case 260: {
                    DiskInfoPacker.packFsDevice(7, diskCtx.getDeviceAttributes(), replyBuf);
                    break;
                }
                case 261: {
                    NTFSStreamsInterface ntfsStreams;
                    String fsType = diskCtx.getFilesystemType();
                    if (disk instanceof NTFSStreamsInterface && (ntfsStreams = (NTFSStreamsInterface)((Object)disk)).hasStreamsEnabled(this.m_sess, conn)) {
                        fsType = "NTFS";
                    }
                    DiskInfoPacker.packFsAttribute(diskCtx.getFilesystemAttributes(), 255, fsType, tbuf.isUnicode(), replyBuf);
                    break;
                }
                case 769: {
                    boolean ntfs = false;
                    if (disk instanceof NTFSStreamsInterface) {
                        NTFSStreamsInterface ntfsStreams = (NTFSStreamsInterface)((Object)disk);
                        ntfs = ntfsStreams.hasStreamsEnabled(this.m_sess, conn);
                    }
                    if (ntfs) break;
                    diskInfo = this.getDiskInformation(disk, diskCtx);
                    volInfo = this.getVolumeInformation(disk, diskCtx);
                    DiskInfoPacker.packMacFsInformation(diskInfo, volInfo, ntfs, replyBuf);
                    break;
                }
                case 1007: {
                    diskInfo = this.getDiskInformation(disk, diskCtx);
                    long userLimit = diskInfo.getTotalUnits();
                    DiskInfoPacker.packFullFsSizeInformation(userLimit, diskInfo, replyBuf);
                }
            }
            if (replyBuf.getPosition() == dataPos) {
                this.m_sess.sendErrorResponseSMB(65535, 2);
                return;
            }
            int bytCnt = replyBuf.getPosition() - outPkt.getByteOffset();
            replyBuf.setEndOfBuffer();
            int dataLen = replyBuf.getLength();
            SMBSrvTransPacket.initTransactReply(outPkt, 0, prmPos, dataLen, dataPos);
            outPkt.setByteCount(bytCnt);
            this.m_sess.sendResponseSMB(outPkt);
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
    }

    protected final void procTrans2QueryPath(SrvTransactBuffer tbuf, SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        int treeId = this.m_smbPkt.getTreeId();
        TreeConnection conn = this.m_sess.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
            return;
        }
        DataBuffer paramBuf = tbuf.getParameterBuffer();
        int infoLevl = paramBuf.getShort();
        paramBuf.skipBytes(4);
        String path = paramBuf.getString(tbuf.isUnicode());
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(32)) {
            logger.debug((Object)("Query Path - level = 0x" + Integer.toHexString(infoLevl) + ", path = " + path));
        }
        try {
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            outPkt.setParameterCount(10);
            byte[] buf = outPkt.getBuffer();
            int prmPos = DataPacker.longwordAlign(outPkt.getByteOffset());
            int dataPos = prmPos + 4;
            outPkt.setPosition(prmPos);
            outPkt.packWord(0);
            DataBuffer replyBuf = new DataBuffer(buf, dataPos, buf.length - dataPos);
            boolean streams = false;
            if (disk instanceof NTFSStreamsInterface) {
                NTFSStreamsInterface ntfsStreams = (NTFSStreamsInterface)((Object)disk);
                streams = ntfsStreams.hasStreamsEnabled(this.m_sess, conn);
            }
            if (!streams && path.indexOf(":") != -1) {
                this.m_sess.sendErrorResponseSMB(-1073741773, 2, 1);
                return;
            }
            int dataLen = 0;
            if (streams && (infoLevl == 265 || infoLevl == 1022)) {
                NTFSStreamsInterface ntfsStreams;
                StreamInfoList streamList;
                if (logger.isDebugEnabled() && this.m_sess.hasDebug(131072)) {
                    logger.debug((Object)("Get NTFS streams list path=" + path));
                }
                if ((streamList = (ntfsStreams = (NTFSStreamsInterface)((Object)disk)).getStreamList(this.m_sess, conn, path)) == null) {
                    this.m_sess.sendErrorResponseSMB(-1073741772, 1, 2);
                    return;
                }
                dataLen = QueryInfoPacker.packStreamFileInfo(streamList, replyBuf, true);
            } else {
                FileInfo fileInfo = disk.getFileInformation(this.m_sess, conn, path);
                if (fileInfo == null) {
                    this.m_sess.sendErrorResponseSMB(-1073741772, 2, 1);
                    return;
                }
                dataLen = QueryInfoPacker.packInfo(fileInfo, replyBuf, infoLevl, true);
            }
            if (dataLen == 0) {
                this.m_sess.sendErrorResponseSMB(-1073741811, 1, 2);
                return;
            }
            SMBSrvTransPacket.initTransactReply(outPkt, 2, prmPos, dataLen, dataPos);
            outPkt.setByteCount(replyBuf.getPosition() - outPkt.getByteOffset());
            this.m_sess.sendResponseSMB(outPkt);
        }
        catch (AccessDeniedException ex) {
            this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
            return;
        }
        catch (FileNotFoundException ex) {
            this.m_sess.sendErrorResponseSMB(-1073741772, 2, 1);
            return;
        }
        catch (PathNotFoundException ex) {
            this.m_sess.sendErrorResponseSMB(-1073741766, 2, 1);
            return;
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 1, 2);
            return;
        }
        catch (UnsupportedInfoLevelException ex) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 1, 2);
            return;
        }
    }

    protected final void procTrans2QueryFile(SrvTransactBuffer tbuf, SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        int treeId = this.m_smbPkt.getTreeId();
        TreeConnection conn = this.m_sess.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
            return;
        }
        DataBuffer paramBuf = tbuf.getParameterBuffer();
        int fid = paramBuf.getShort();
        int infoLevl = paramBuf.getShort();
        NetworkFile netFile = conn.findFile(fid);
        if (netFile == null) {
            this.m_sess.sendErrorResponseSMB(6, 1);
            return;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(32)) {
            logger.debug((Object)("Query File - level=0x" + Integer.toHexString(infoLevl) + ", fid=" + fid + ", stream=" + netFile.getStreamId() + ", name=" + netFile.getFullName()));
        }
        try {
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            outPkt.setParameterCount(10);
            byte[] buf = outPkt.getBuffer();
            int prmPos = DataPacker.longwordAlign(outPkt.getByteOffset());
            int dataPos = prmPos + 4;
            outPkt.setPosition(prmPos);
            outPkt.packWord(0);
            DataBuffer replyBuf = new DataBuffer(buf, dataPos, buf.length - dataPos);
            boolean streams = false;
            if (disk instanceof NTFSStreamsInterface) {
                NTFSStreamsInterface ntfsStreams = (NTFSStreamsInterface)((Object)disk);
                streams = ntfsStreams.hasStreamsEnabled(this.m_sess, conn);
            }
            int dataLen = 0;
            if (streams && (infoLevl == 265 || infoLevl == 1022)) {
                NTFSStreamsInterface ntfsStreams;
                StreamInfoList streamList;
                if (logger.isDebugEnabled() && this.m_sess.hasDebug(131072)) {
                    logger.debug((Object)("Get NTFS streams list fid=" + fid + ", name=" + netFile.getFullName()));
                }
                if ((streamList = (ntfsStreams = (NTFSStreamsInterface)((Object)disk)).getStreamList(this.m_sess, conn, netFile.getFullName())) == null) {
                    this.m_sess.sendErrorResponseSMB(-1073741772, 1, 2);
                    return;
                }
                dataLen = QueryInfoPacker.packStreamFileInfo(streamList, replyBuf, true);
            } else {
                FileInfo fileInfo = disk.getFileInformation(this.m_sess, conn, netFile.getFullNameStream());
                if (fileInfo == null) {
                    this.m_sess.sendErrorResponseSMB(-1073741772, 1, 2);
                    return;
                }
                dataLen = QueryInfoPacker.packInfo(fileInfo, replyBuf, infoLevl, true);
            }
            if (dataLen == 0) {
                this.m_sess.sendErrorResponseSMB(-1073741811, 1, 2);
                return;
            }
            SMBSrvTransPacket.initTransactReply(outPkt, 2, prmPos, dataLen, dataPos);
            outPkt.setByteCount(replyBuf.getPosition() - outPkt.getByteOffset());
            this.m_sess.sendResponseSMB(outPkt);
        }
        catch (AccessDeniedException ex) {
            this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
            return;
        }
        catch (FileNotFoundException ex) {
            this.m_sess.sendErrorResponseSMB(-1073741772, 2, 1);
            return;
        }
        catch (PathNotFoundException ex) {
            this.m_sess.sendErrorResponseSMB(-1073741766, 2, 1);
            return;
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 1, 2);
            return;
        }
        catch (UnsupportedInfoLevelException ex) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 1, 2);
            return;
        }
    }

    protected final void procTrans2SetFile(SrvTransactBuffer tbuf, SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        int treeId = this.m_smbPkt.getTreeId();
        TreeConnection conn = this.m_sess.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 15, 1);
            return;
        }
        if (!conn.hasWriteAccess()) {
            this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
            return;
        }
        DataBuffer paramBuf = tbuf.getParameterBuffer();
        int fid = paramBuf.getShort();
        int infoLevl = paramBuf.getShort();
        NetworkFile netFile = conn.findFile(fid);
        if (netFile == null) {
            this.m_sess.sendErrorResponseSMB(6, 1);
            return;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(32)) {
            logger.debug((Object)("Set File - level=0x" + Integer.toHexString(infoLevl) + ", fid=" + fid + ", name=" + netFile.getFullName()));
        }
        try {
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            DataBuffer dataBuf = tbuf.getDataBuffer();
            FileInfo finfo = null;
            switch (infoLevl) {
                case 257: {
                    int setFlags = 0;
                    finfo = new FileInfo(netFile.getFullName(), 0L, -1);
                    long timeNow = System.currentTimeMillis();
                    long nttim = dataBuf.getLong();
                    boolean hasSetTime = false;
                    if (nttim != 0L) {
                        if (nttim != -1L) {
                            finfo.setCreationDateTime(NTTime.toJavaDate(nttim));
                            setFlags += 16;
                        }
                        hasSetTime = true;
                    }
                    if ((nttim = dataBuf.getLong()) != 0L) {
                        if (nttim != -1L) {
                            finfo.setAccessDateTime(NTTime.toJavaDate(nttim));
                            setFlags += 32;
                        } else {
                            finfo.setAccessDateTime(timeNow);
                            setFlags += 32;
                        }
                        hasSetTime = true;
                    }
                    if ((nttim = dataBuf.getLong()) > 0L) {
                        if (nttim != -1L) {
                            finfo.setModifyDateTime(NTTime.toJavaDate(nttim));
                            setFlags += 8;
                        } else {
                            finfo.setModifyDateTime(timeNow);
                            setFlags += 8;
                        }
                        hasSetTime = true;
                    }
                    if ((nttim = dataBuf.getLong()) > 0L) {
                        if (nttim != -1L) {
                            finfo.setChangeDateTime(NTTime.toJavaDate(nttim));
                            setFlags += 64;
                        }
                        hasSetTime = true;
                    }
                    int attr = dataBuf.getInt();
                    int unknown = dataBuf.getInt();
                    if (!hasSetTime && unknown == 0) {
                        finfo.setFileAttributes(attr);
                        setFlags += 4;
                    }
                    finfo.setFileInformationFlags(setFlags);
                    disk.setFileInformation(this.m_sess, conn, netFile.getFullName(), finfo);
                    if (!logger.isDebugEnabled() || !this.m_sess.hasDebug(32)) break;
                    logger.debug((Object)("  Set Basic Info [" + treeId + "] name=" + netFile.getFullName() + ", attr=0x" + Integer.toHexString(attr) + ", setTime=" + hasSetTime + ", setFlags=0x" + Integer.toHexString(setFlags) + ", unknown=" + unknown));
                    break;
                }
                case 260: {
                    long eofPos = dataBuf.getLong();
                    disk.truncateFile(this.m_sess, conn, netFile, eofPos);
                    if (!logger.isDebugEnabled() || !this.m_sess.hasDebug(32)) break;
                    logger.debug((Object)("  Set end of file position fid=" + fid + ", eof=" + eofPos));
                    break;
                }
                case 259: {
                    long allocSize = dataBuf.getLong();
                    disk.truncateFile(this.m_sess, conn, netFile, allocSize);
                    if (!logger.isDebugEnabled() || !this.m_sess.hasDebug(32)) break;
                    logger.debug((Object)("  Set allocation size fid=" + fid + ", allocSize=" + allocSize));
                    break;
                }
                case 1010: {
                    boolean streams = false;
                    if (disk instanceof NTFSStreamsInterface) {
                        NTFSStreamsInterface ntfsStreams = (NTFSStreamsInterface)((Object)disk);
                        streams = ntfsStreams.hasStreamsEnabled(this.m_sess, conn);
                    }
                    if (!streams) {
                        this.m_sess.sendErrorResponseSMB(-1073741637, 65535, 2);
                        return;
                    }
                    boolean overwrite = dataBuf.getByte() == 1;
                    dataBuf.skipBytes(3);
                    int rootFid = dataBuf.getInt();
                    int nameLen = dataBuf.getInt();
                    String newName = dataBuf.getString(nameLen, true);
                    if (logger.isDebugEnabled() && this.m_sess.hasDebug(32)) {
                        logger.debug((Object)("  Set rename fid=" + fid + ", newName=" + newName + ", overwrite=" + overwrite + ", rootFID=" + rootFid));
                    }
                    if (newName.indexOf("\\") != -1) {
                        this.m_sess.sendErrorResponseSMB(-1073741637, 65535, 2);
                        return;
                    }
                    if (logger.isDebugEnabled() && this.m_sess.hasDebug(131072)) {
                        logger.debug((Object)("Rename stream fid=" + fid + ", name=" + netFile.getFullNameStream() + ", newName=" + newName + ", overwrite=" + overwrite));
                    }
                    NTFSStreamsInterface ntfsStreams = (NTFSStreamsInterface)((Object)disk);
                    ntfsStreams.renameStream(this.m_sess, conn, netFile.getFullNameStream(), newName, overwrite);
                    break;
                }
                case 258: 
                case 1013: {
                    int flag = dataBuf.getByte();
                    boolean delFlag = flag == 1;
                    FileInfo delInfo = new FileInfo();
                    delInfo.setDeleteOnClose(delFlag);
                    delInfo.setFileInformationFlags(1024);
                    disk.setFileInformation(this.m_sess, conn, netFile.getFullName(), delInfo);
                    netFile.setDeleteOnClose(delFlag);
                    if (!logger.isDebugEnabled() || !this.m_sess.hasDebug(32)) break;
                    logger.debug((Object)("  Set file disposition fid=" + fid + ", name=" + netFile.getName() + ", delete=" + delFlag));
                }
            }
            outPkt.setParameterCount(10);
            byte[] buf = outPkt.getBuffer();
            int prmPos = outPkt.getByteOffset();
            prmPos = DataPacker.longwordAlign(prmPos);
            DataPacker.putIntelShort(0, buf, prmPos);
            SMBSrvTransPacket.initTransactReply(outPkt, 2, prmPos, 0, prmPos + 4);
            outPkt.setByteCount(prmPos - outPkt.getByteOffset() + 4);
            this.m_sess.sendResponseSMB(outPkt);
            DiskDeviceContext diskCtx = (DiskDeviceContext)conn.getContext();
            if (diskCtx.hasChangeHandler() && netFile.getFullName() != null) {
                NotifyChangeHandler changeHandler = diskCtx.getChangeHandler();
                if (finfo != null) {
                    if (finfo.hasSetFlag(4)) {
                        changeHandler.notifyAttributesChanged(netFile.getFullName(), netFile.isDirectory());
                    }
                    if (finfo.hasSetFlag(8)) {
                        changeHandler.notifyLastWriteTimeChanged(netFile.getFullName(), netFile.isDirectory());
                    }
                } else if (infoLevl == 259 || infoLevl == 260) {
                    changeHandler.notifyFileSizeChanged(netFile.getFullName());
                }
            }
        }
        catch (FileNotFoundException ex) {
            this.m_sess.sendErrorResponseSMB(-1073741772, 2, 1);
            return;
        }
        catch (AccessDeniedException ex) {
            this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
            return;
        }
        catch (DiskFullException ex) {
            this.m_sess.sendErrorResponseSMB(-1073741697, 29, 3);
            return;
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 1, 2);
            return;
        }
    }

    protected final void procTrans2SetPath(SrvTransactBuffer tbuf, SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        int treeId = this.m_smbPkt.getTreeId();
        TreeConnection conn = this.m_sess.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 15, 1);
            return;
        }
        if (!conn.hasWriteAccess()) {
            this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
            return;
        }
        DataBuffer paramBuf = tbuf.getParameterBuffer();
        int infoLevl = paramBuf.getShort();
        paramBuf.skipBytes(4);
        String path = paramBuf.getString(tbuf.isUnicode());
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(32)) {
            logger.debug((Object)("Set Path - path=" + path + ", level=0x" + Integer.toHexString(infoLevl)));
        }
        try {
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            DataBuffer dataBuf = tbuf.getDataBuffer();
            FileInfo finfo = null;
            switch (infoLevl) {
                case 1: {
                    int fileSize;
                    int setFlags = 0;
                    finfo = new FileInfo(path, 0L, -1);
                    int smbDate = dataBuf.getShort();
                    int smbTime = dataBuf.getShort();
                    boolean hasSetTime = false;
                    if (smbDate != 0 && smbTime != 0) {
                        finfo.setCreationDateTime(new SMBDate(smbDate, smbTime).getTime());
                        setFlags += 16;
                        hasSetTime = true;
                    }
                    smbDate = dataBuf.getShort();
                    smbTime = dataBuf.getShort();
                    if (smbDate != 0 && smbTime != 0) {
                        finfo.setAccessDateTime(new SMBDate(smbDate, smbTime).getTime());
                        setFlags += 32;
                        hasSetTime = true;
                    }
                    smbDate = dataBuf.getShort();
                    smbTime = dataBuf.getShort();
                    if (smbDate != 0 && smbTime != 0) {
                        finfo.setModifyDateTime(new SMBDate(smbDate, smbTime).getTime());
                        setFlags += 8;
                        hasSetTime = true;
                    }
                    if ((fileSize = dataBuf.getInt()) != 0) {
                        finfo.setFileSize(fileSize);
                        ++setFlags;
                    }
                    if ((fileSize = dataBuf.getInt()) != 0) {
                        finfo.setAllocationSize(fileSize);
                        setFlags += 2;
                    }
                    int attr = dataBuf.getInt();
                    int eaListLen = dataBuf.getInt();
                    if (!hasSetTime && eaListLen == 0) {
                        finfo.setFileAttributes(attr);
                        setFlags += 4;
                    }
                    finfo.setFileInformationFlags(setFlags);
                    disk.setFileInformation(this.m_sess, conn, path, finfo);
                    if (!logger.isDebugEnabled() || !this.m_sess.hasDebug(32)) break;
                    logger.debug((Object)("  Set Standard Info [" + treeId + "] name=" + path + ", attr=0x" + Integer.toHexString(attr) + ", setTime=" + hasSetTime + ", setFlags=0x" + Integer.toHexString(setFlags) + ", eaListLen=" + eaListLen));
                }
            }
            outPkt.setParameterCount(10);
            byte[] buf = outPkt.getBuffer();
            int prmPos = outPkt.getByteOffset();
            prmPos = DataPacker.longwordAlign(prmPos);
            DataPacker.putIntelShort(0, buf, prmPos);
            SMBSrvTransPacket.initTransactReply(outPkt, 2, prmPos, 0, prmPos + 4);
            outPkt.setByteCount(prmPos - outPkt.getByteOffset() + 4);
            this.m_sess.sendResponseSMB(outPkt);
            DiskDeviceContext diskCtx = (DiskDeviceContext)conn.getContext();
            if (diskCtx.hasChangeHandler() && path != null) {
                NotifyChangeHandler changeHandler = diskCtx.getChangeHandler();
                if (finfo != null) {
                    int fileSts = disk.fileExists(this.m_sess, conn, path);
                    if (finfo.hasSetFlag(4)) {
                        changeHandler.notifyAttributesChanged(path, fileSts == 2);
                    }
                    if (finfo.hasSetFlag(8)) {
                        changeHandler.notifyLastWriteTimeChanged(path, fileSts == 2);
                    }
                }
            }
        }
        catch (FileNotFoundException ex) {
            this.m_sess.sendErrorResponseSMB(-1073741772, 2, 1);
            return;
        }
        catch (AccessDeniedException ex) {
            this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
            return;
        }
        catch (DiskFullException ex) {
            this.m_sess.sendErrorResponseSMB(-1073741697, 29, 3);
            return;
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 1, 2);
            return;
        }
    }

    protected final void procWriteAndX(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        NetworkFile netFile;
        if (!this.m_smbPkt.checkPacketIsValid(12, 0)) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 1, 2);
            return;
        }
        int treeId = this.m_smbPkt.getTreeId();
        TreeConnection conn = this.m_sess.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 15, 1);
            return;
        }
        if (!conn.hasWriteAccess()) {
            this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
            return;
        }
        if (conn.getSharedDevice().getType() == 3) {
            IPCHandler.processIPCRequest(this.m_sess, outPkt);
            return;
        }
        int fid = this.m_smbPkt.getParameter(2);
        long offset = (long)this.m_smbPkt.getParameterLong(3) & 0xFFFFFFFFL;
        int dataPos = this.m_smbPkt.getParameter(11) + 4;
        int dataLen = this.m_smbPkt.getParameter(10);
        int dataLenHigh = 0;
        if (this.m_smbPkt.getReceivedLength() > 65535) {
            dataLenHigh = this.m_smbPkt.getParameter(9) & 1;
        }
        if (dataLenHigh > 0) {
            dataLen += dataLenHigh << 16;
        }
        if (this.m_smbPkt.getParameterCount() == 14) {
            long topOff = (long)this.m_smbPkt.getParameterLong(12) & 0xFFFFFFFFL;
            offset += topOff << 32;
        }
        if ((netFile = conn.findFile(fid)) == null) {
            this.m_sess.sendErrorResponseSMB(6, 1);
            return;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(128)) {
            logger.debug((Object)("File Write AndX [" + netFile.getFileId() + "] : Size=" + dataLen + " ,Pos=" + offset));
        }
        byte[] buf = this.m_smbPkt.getBuffer();
        int wrtlen = 0;
        try {
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            wrtlen = disk.writeFile(this.m_sess, conn, netFile, buf, dataPos, dataLen, offset);
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        catch (AccessDeniedException ex) {
            if (logger.isDebugEnabled() && this.m_sess.hasDebug(128)) {
                logger.debug((Object)("File Write Error [" + netFile.getFileId() + "] : " + ex.toString()));
            }
            this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
            return;
        }
        catch (LockConflictException ex) {
            if (logger.isDebugEnabled() && this.m_sess.hasDebug(4096)) {
                logger.debug((Object)("Write Lock Error [" + netFile.getFileId() + "] : Size=" + dataLen + " ,Pos=" + offset));
            }
            this.m_sess.sendErrorResponseSMB(-1073741740, 5, 1);
            return;
        }
        catch (DiskFullException ex) {
            if (logger.isDebugEnabled() && this.m_sess.hasDebug(128)) {
                logger.debug((Object)("Write Quota Error [" + netFile.getFileId() + "] Disk full : Size=" + dataLen + " ,Pos=" + offset));
            }
            this.m_sess.sendErrorResponseSMB(-1073741697, 29, 3);
            return;
        }
        catch (IOException ex) {
            if (logger.isDebugEnabled() && this.m_sess.hasDebug(128)) {
                logger.debug((Object)("File Write Error [" + netFile.getFileId() + "] : " + ex.toString()));
            }
            this.m_sess.sendErrorResponseSMB(-1073741697, 29, 3);
            return;
        }
        outPkt.setParameterCount(6);
        outPkt.setAndXCommand(255);
        outPkt.setParameter(1, 0);
        outPkt.setParameter(2, wrtlen);
        outPkt.setParameter(3, 65535);
        if (dataLenHigh > 0) {
            outPkt.setParameter(4, dataLen >> 16);
            outPkt.setParameter(5, 0);
        } else {
            outPkt.setParameterLong(4, 0);
        }
        outPkt.setByteCount(0);
        outPkt.setParameter(1, outPkt.getLength());
        this.m_sess.sendResponseSMB(outPkt);
        DiskDeviceContext diskCtx = (DiskDeviceContext)conn.getContext();
        if (netFile.getWriteCount() % 10 == 0 && diskCtx.hasChangeHandler() && netFile.getFullName() != null) {
            NotifyChangeHandler changeHandler = diskCtx.getChangeHandler();
            changeHandler.notifyFileSizeChanged(netFile.getFullName());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void procNTCreateAndX(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        int fid;
        int respAction;
        NetworkFile netFile;
        String fileName;
        int flags;
        NTParameterPacker prms;
        TreeConnection conn;
        block46: {
            block47: {
                if (!this.m_smbPkt.checkPacketIsValid(24, 1)) {
                    this.m_sess.sendErrorResponseSMB(-1073741811, 1, 2);
                    return;
                }
                int treeId = this.m_smbPkt.getTreeId();
                conn = this.m_sess.findConnection(treeId);
                if (conn == null) {
                    this.m_sess.sendErrorResponseSMB(-1073741811, 15, 1);
                    return;
                }
                if (!conn.hasReadAccess()) {
                    this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
                    return;
                }
                if (conn.getSharedDevice().getType() == 3) {
                    IPCHandler.processIPCRequest(this.m_sess, outPkt);
                    return;
                }
                if (conn.getSharedDevice().getType() != 0) {
                    this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
                    return;
                }
                prms = new NTParameterPacker(this.m_smbPkt.getBuffer(), 42);
                int nameLen = prms.unpackWord();
                flags = prms.unpackInt();
                int rootFID = prms.unpackInt();
                int accessMask = prms.unpackInt();
                long allocSize = prms.unpackLong();
                int attrib = prms.unpackInt();
                int shrAccess = prms.unpackInt();
                int createDisp = prms.unpackInt();
                int createOptn = prms.unpackInt();
                int impersonLev = prms.unpackInt();
                int secFlags = prms.unpackByte();
                fileName = DataPacker.getUnicodeString(this.m_smbPkt.getBuffer(), DataPacker.wordAlign(this.m_smbPkt.getByteOffset()), nameLen / 2);
                if (fileName == null) {
                    this.m_sess.sendErrorResponseSMB(-1073741811, 1, 2);
                    return;
                }
                DiskInterface disk = null;
                try {
                    disk = (DiskInterface)conn.getSharedDevice().getInterface();
                }
                catch (InvalidDeviceInterfaceException ex) {
                    this.m_sess.sendErrorResponseSMB(13, 1);
                    return;
                }
                if (FileName.containsStreamName(fileName)) {
                    boolean streams = false;
                    if (disk instanceof NTFSStreamsInterface) {
                        NTFSStreamsInterface ntfsStreams = (NTFSStreamsInterface)((Object)disk);
                        streams = ntfsStreams.hasStreamsEnabled(this.m_sess, conn);
                    }
                    if (!streams) {
                        this.m_sess.sendErrorResponseSMB(-1073741773, 2, 1);
                        return;
                    }
                }
                FileOpenParams params = new FileOpenParams(fileName, createDisp, accessMask, attrib, shrAccess, allocSize, createOptn, rootFID, impersonLev, secFlags);
                if (logger.isDebugEnabled() && this.m_sess.hasDebug(64)) {
                    logger.debug((Object)("NT Create AndX [" + treeId + "] params=" + params));
                }
                netFile = null;
                respAction = 0;
                try {
                    block45: {
                        int fileSts = disk.fileExists(this.m_sess, conn, fileName);
                        if (fileSts == 0) {
                            if (createDisp == 2 || createDisp == 3 || createDisp == 5 || createDisp == 0) {
                                if (!conn.hasWriteAccess()) {
                                    this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
                                    return;
                                }
                                if ((createOptn & 1) == 0) {
                                    netFile = disk.createFile(this.m_sess, conn, params);
                                } else {
                                    disk.createDirectory(this.m_sess, conn, params);
                                    netFile = disk.openFile(this.m_sess, conn, params);
                                }
                                if (netFile != null && (createOptn & 0x1000) != 0) {
                                    netFile.setDeleteOnClose(true);
                                }
                                respAction = 2;
                                break block45;
                            } else {
                                if (fileSts == 2) {
                                    this.m_sess.sendErrorResponseSMB(-1073741771, 80, 1);
                                    return;
                                }
                                this.m_sess.sendErrorResponseSMB(-1073741772, 2, 1);
                                return;
                            }
                        }
                        if (createDisp == 2) {
                            if (fileSts != 1 && fileSts != 2) {
                                this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
                                return;
                            }
                            this.m_sess.sendErrorResponseSMB(-1073741771, 80, 1);
                            return;
                        }
                        netFile = disk.openFile(this.m_sess, conn, params);
                        if (createDisp == 0 || createDisp == 5) {
                            disk.truncateFile(this.m_sess, conn, netFile, 0L);
                            if (logger.isDebugEnabled() && this.m_sess.hasDebug(64)) {
                                logger.debug((Object)("  [" + treeId + "] name=" + fileName + " truncated"));
                            }
                        }
                        respAction = 1;
                    }
                    fid = conn.addFile(netFile, this.getSession());
                }
                catch (TooManyFilesException ex) {
                    this.m_sess.sendErrorResponseSMB(-1073741537, 4, 1);
                    return;
                }
                catch (AccessDeniedException ex) {
                    this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
                    return;
                }
                catch (FileExistsException ex) {
                    this.m_sess.sendErrorResponseSMB(-1073741771, 80, 1);
                    return;
                }
                catch (FileSharingException ex) {
                    this.m_sess.sendErrorResponseSMB(-1073741757, 32, 1);
                    return;
                }
                catch (FileOfflineException ex) {
                    this.m_sess.sendErrorResponseSMB(-1073741209, 21, 3);
                    return;
                }
                catch (IOException ex) {
                    this.m_sess.sendErrorResponseSMB(-1073741772, 2, 1);
                    return;
                }
                outPkt.setParameterCount(34);
                outPkt.setAndXCommand(255);
                outPkt.setParameter(1, 0);
                prms.reset(outPkt.getBuffer(), 41);
                boolean fakeOpLocks = false;
                String fname = params.getPath().toUpperCase();
                if (fname.endsWith(".URL")) {
                    fakeOpLocks = true;
                }
                if (!fakeOpLocks) break block47;
                if ((flags & 4) != 0) {
                    prms.packByte(2);
                    break block46;
                } else if ((flags & 2) != 0) {
                    prms.packByte(1);
                    break block46;
                } else {
                    prms.packByte(0);
                }
                break block46;
            }
            prms.packByte(0);
        }
        prms.packWord(fid);
        prms.packInt(respAction);
        if (netFile.hasCreationDate()) {
            prms.packLong(NTTime.toNTTime(netFile.getCreationDate()));
        } else {
            prms.packLong(0L);
        }
        if (netFile.hasAccessDate()) {
            prms.packLong(NTTime.toNTTime(netFile.getAccessDate()));
        } else {
            prms.packLong(0L);
        }
        if (netFile.hasModifyDate()) {
            long modDate = NTTime.toNTTime(netFile.getModifyDate());
            prms.packLong(modDate);
            prms.packLong(modDate);
        } else {
            prms.packLong(0L);
            prms.packLong(0L);
        }
        prms.packInt(netFile.getFileAttributes());
        long fileSize = netFile.getFileSize();
        if (fileSize > 0L) {
            fileSize = fileSize + 512L & 0xFFFFFFFFFFFFFE00L;
        }
        prms.packLong(fileSize);
        prms.packLong(netFile.getFileSize());
        prms.packWord(0);
        prms.packWord((flags & 0x10) != 0 ? 7 : 0);
        prms.packByte(netFile.isDirectory() ? 1 : 0);
        prms.packWord(0);
        int endPos = prms.getPosition();
        outPkt.setParameter(1, endPos - 4);
        if (this.m_smbPkt.hasAndXCommand()) {
            endPos = this.procAndXCommands(outPkt, endPos, netFile);
        }
        this.m_sess.sendResponseSMB(outPkt, endPos - 4);
        DiskDeviceContext diskCtx = (DiskDeviceContext)conn.getContext();
        if (!diskCtx.hasChangeHandler()) return;
        if (respAction != 2) return;
        if (netFile.isDirectory()) {
            diskCtx.getChangeHandler().notifyDirectoryChanged(1, fileName);
            return;
        }
        diskCtx.getChangeHandler().notifyFileChanged(1, fileName);
    }

    protected final void procNTCancel(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        if (!this.m_smbPkt.checkPacketIsValid(0, 0)) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 1, 2);
            return;
        }
        int treeId = this.m_smbPkt.getTreeId();
        TreeConnection conn = this.m_sess.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 15, 1);
            return;
        }
        NotifyRequest req = this.m_sess.findNotifyRequest(this.m_smbPkt.getMultiplexId(), this.m_smbPkt.getTreeId(), this.m_smbPkt.getUserId(), this.m_smbPkt.getProcessId());
        if (req != null) {
            this.m_sess.removeNotifyRequest(req);
            this.m_smbPkt.setParameterCount(0);
            this.m_smbPkt.setByteCount(0);
            if (!this.m_smbPkt.isLongErrorCode()) {
                this.m_smbPkt.setFlags2(this.m_smbPkt.getFlags2() + 16384);
            }
            this.m_smbPkt.setLongErrorCode(-1073741536);
            if (!this.m_smbPkt.isUnicode()) {
                this.m_smbPkt.setFlags2(this.m_smbPkt.getFlags2() + 32768);
            }
            this.m_sess.sendResponseSMB(this.m_smbPkt);
            if (logger.isDebugEnabled() && this.m_sess.hasDebug(65536)) {
                DiskDeviceContext diskCtx = (DiskDeviceContext)conn.getContext();
                logger.debug((Object)("NT Cancel notify mid=" + req.getMultiplexId() + ", dir=" + req.getWatchPath() + ", queue=" + diskCtx.getChangeHandler().getRequestQueueSize()));
            }
        } else {
            this.m_sess.sendErrorResponseSMB(-1073741811, 1, 2);
        }
    }

    protected final void procNTTransaction(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        if (!this.m_smbPkt.checkPacketIsValid(19, 0)) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 1, 2);
            return;
        }
        int treeId = this.m_smbPkt.getTreeId();
        TreeConnection conn = this.m_sess.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
            return;
        }
        if (conn.getSharedDevice().getType() == 3) {
            IPCHandler.processIPCRequest(this.m_sess, outPkt);
            return;
        }
        NTTransPacket ntTrans = new NTTransPacket(this.m_smbPkt.getBuffer());
        int subCmd = ntTrans.getNTFunction();
        if (subCmd == 4) {
            this.procNTTransactNotifyChange(ntTrans, outPkt);
            return;
        }
        SrvTransactBuffer transBuf = null;
        if (ntTrans.getTotalParameterCount() == ntTrans.getParameterBlockCount() && ntTrans.getTotalDataCount() == ntTrans.getDataBlockCount()) {
            transBuf = new SrvTransactBuffer(ntTrans);
        } else {
            transBuf = new SrvTransactBuffer(ntTrans.getSetupCount(), ntTrans.getTotalParameterCount(), ntTrans.getTotalDataCount());
            transBuf.setType(ntTrans.getCommand());
            transBuf.setFunction(subCmd);
            if (logger.isDebugEnabled() && this.m_sess.hasDebug(256)) {
                logger.debug((Object)("NT Transaction [" + treeId + "] transbuf=" + transBuf));
            }
            byte[] buf = ntTrans.getBuffer();
            int cnt = ntTrans.getSetupCount();
            if (cnt > 0) {
                transBuf.appendSetup(buf, ntTrans.getSetupOffset(), cnt * 2);
            }
            if (logger.isDebugEnabled() && this.m_sess.hasDebug(256)) {
                logger.debug((Object)("NT Transaction [" + treeId + "] pcnt=" + ntTrans.getNTParameter(4) + ", offset=" + ntTrans.getNTParameter(5)));
            }
            if ((cnt = ntTrans.getParameterBlockCount()) > 0) {
                transBuf.appendParameter(buf, ntTrans.getParameterBlockOffset(), cnt);
            }
            if ((cnt = ntTrans.getDataBlockCount()) > 0) {
                transBuf.appendData(buf, ntTrans.getDataBlockOffset(), cnt);
            }
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(256)) {
            logger.debug((Object)("NT Transaction [" + treeId + "] cmd=0x" + Integer.toHexString(subCmd) + ", multiPkt=" + transBuf.isMultiPacket()));
        }
        if (transBuf.isMultiPacket()) {
            this.m_sess.setTransaction(transBuf);
            this.m_sess.sendSuccessResponseSMB();
            return;
        }
        this.processNTTransactionBuffer(transBuf, ntTrans);
    }

    protected final void procNTTransactionSecondary(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        int dlen;
        if (!this.m_smbPkt.checkPacketIsValid(18, 0)) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 1, 2);
            return;
        }
        int treeId = this.m_smbPkt.getTreeId();
        TreeConnection conn = this.m_sess.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
            return;
        }
        if (conn.getSharedDevice().getType() == 3) {
            IPCHandler.processIPCRequest(this.m_sess, outPkt);
            return;
        }
        if (!this.m_sess.hasTransaction() || this.m_sess.getTransaction().isType() != 160) {
            this.m_sess.sendErrorResponseSMB(1, 2);
            return;
        }
        NTTransPacket ntTrans = new NTTransPacket(this.m_smbPkt.getBuffer());
        byte[] buf = ntTrans.getBuffer();
        SrvTransactBuffer transBuf = this.m_sess.getTransaction();
        int plen = ntTrans.getParameterBlockCount();
        if (plen > 0) {
            DataBuffer paramBuf = transBuf.getParameterBuffer();
            paramBuf.appendData(buf, ntTrans.getParameterBlockOffset(), plen);
        }
        if ((dlen = ntTrans.getDataBlockCount()) > 0) {
            DataBuffer dataBuf = transBuf.getDataBuffer();
            dataBuf.appendData(buf, ntTrans.getDataBlockOffset(), dlen);
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(256)) {
            logger.debug((Object)("NT Transaction Secondary [" + treeId + "] paramLen=" + plen + ", dataLen=" + dlen));
        }
        int totParam = ntTrans.getTotalParameterCount();
        int totData = ntTrans.getTotalDataCount();
        int paramDisp = ntTrans.getParameterBlockDisplacement();
        int dataDisp = ntTrans.getDataBlockDisplacement();
        if (paramDisp + plen == totParam && dataDisp + dlen == totData) {
            if (logger.isDebugEnabled() && this.m_sess.hasDebug(256)) {
                logger.debug((Object)"NT Transaction complete, processing ...");
            }
            this.m_sess.setTransaction(null);
            this.processNTTransactionBuffer(transBuf, ntTrans);
        }
    }

    private final void processNTTransactionBuffer(SrvTransactBuffer tbuf, NTTransPacket outPkt) throws IOException, SMBSrvException {
        switch (tbuf.getFunction()) {
            case 1: {
                this.procNTTransactCreate(tbuf, outPkt);
                break;
            }
            case 2: {
                this.procNTTransactIOCtl(tbuf, outPkt);
                break;
            }
            case 6: {
                this.procNTTransactQuerySecurityDesc(tbuf, outPkt);
                break;
            }
            case 3: {
                this.procNTTransactSetSecurityDesc(tbuf, outPkt);
                break;
            }
            case 5: {
                this.procNTTransactRename(tbuf, outPkt);
                break;
            }
            case 7: {
                this.m_sess.sendErrorResponseSMB(-1073741822, 65535, 2);
                break;
            }
            case 8: {
                this.m_sess.sendErrorResponseSMB(-1073741822, 65535, 2);
                break;
            }
            default: {
                this.m_sess.sendErrorResponseSMB(-1073741811, 1, 2);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void procNTTransactCreate(SrvTransactBuffer tbuf, NTTransPacket outPkt) throws IOException, SMBSrvException {
        int fid;
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(256)) {
            logger.debug((Object)"NT TransactCreate");
        }
        if (tbuf.hasParameterBuffer() && tbuf.getParameterBuffer().getLength() < 52) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 1, 2);
            return;
        }
        int treeId = tbuf.getTreeId();
        TreeConnection conn = this.m_sess.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 15, 1);
            return;
        }
        if (!conn.hasWriteAccess()) {
            this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
            return;
        }
        if (conn.getSharedDevice().getType() != 0) {
            this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
            return;
        }
        DataBuffer tparams = tbuf.getParameterBuffer();
        int flags = tparams.getInt();
        int rootFID = tparams.getInt();
        int accessMask = tparams.getInt();
        long allocSize = tparams.getLong();
        int attrib = tparams.getInt();
        int shrAccess = tparams.getInt();
        int createDisp = tparams.getInt();
        int createOptn = tparams.getInt();
        int sdLen = tparams.getInt();
        int eaLen = tparams.getInt();
        int nameLen = tparams.getInt();
        int impersonLev = tparams.getInt();
        int secFlags = tparams.getByte();
        tparams.wordAlign();
        String fileName = tparams.getString(nameLen, true);
        if (fileName == null) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 1, 2);
            return;
        }
        DiskInterface disk = null;
        try {
            disk = (DiskInterface)conn.getSharedDevice().getInterface();
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        if (fileName.indexOf(":") != -1) {
            boolean streams = false;
            if (disk instanceof NTFSStreamsInterface) {
                NTFSStreamsInterface ntfsStreams = (NTFSStreamsInterface)((Object)disk);
                streams = ntfsStreams.hasStreamsEnabled(this.m_sess, conn);
            }
            if (!streams) {
                this.m_sess.sendErrorResponseSMB(-1073741772, 2, 1);
                return;
            }
        }
        FileOpenParams params = new FileOpenParams(fileName, createDisp, accessMask, attrib, shrAccess, allocSize, createOptn, rootFID, impersonLev, secFlags);
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(64)) {
            logger.debug((Object)("NT TransactCreate [" + treeId + "] params=" + params + "  secDescLen=" + sdLen + ", extAttribLen=" + eaLen));
        }
        NetworkFile netFile = null;
        int respAction = 0;
        try {
            block38: {
                int fileSts = disk.fileExists(this.m_sess, conn, fileName);
                if (fileSts == 0) {
                    if (createDisp == 2 || createDisp == 3 || createDisp == 5 || createDisp == 0) {
                        if ((createOptn & 1) == 0) {
                            netFile = disk.createFile(this.m_sess, conn, params);
                        } else {
                            disk.createDirectory(this.m_sess, conn, params);
                            netFile = disk.openFile(this.m_sess, conn, params);
                        }
                        respAction = 2;
                        break block38;
                    } else {
                        if (fileSts == 2) {
                            this.m_sess.sendErrorResponseSMB(-1073741771, 80, 1);
                            return;
                        }
                        this.m_sess.sendErrorResponseSMB(-1073741772, 2, 1);
                        return;
                    }
                }
                if (createDisp == 2) {
                    if (fileSts != 1 && fileSts != 2) {
                        this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
                        return;
                    }
                    this.m_sess.sendErrorResponseSMB(-1073741771, 80, 1);
                    return;
                }
                netFile = disk.openFile(this.m_sess, conn, params);
                if (createDisp == 0 || createDisp == 5) {
                    disk.truncateFile(this.m_sess, conn, netFile, 0L);
                    if (logger.isDebugEnabled() && this.m_sess.hasDebug(64)) {
                        logger.debug((Object)("  [" + treeId + "] name=" + fileName + " truncated"));
                    }
                }
                respAction = 1;
            }
            fid = conn.addFile(netFile, this.getSession());
        }
        catch (TooManyFilesException ex) {
            this.m_sess.sendErrorResponseSMB(-1073741537, 4, 1);
            return;
        }
        catch (AccessDeniedException ex) {
            this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
            return;
        }
        catch (FileExistsException ex) {
            this.m_sess.sendErrorResponseSMB(-1073741771, 80, 1);
            return;
        }
        catch (FileSharingException ex) {
            this.m_sess.sendErrorResponseSMB(-1073741757, 32, 1);
            return;
        }
        catch (FileOfflineException ex) {
            this.m_sess.sendErrorResponseSMB(-1073741209, 21, 3);
            return;
        }
        catch (IOException ex) {
            this.m_sess.sendErrorResponseSMB(-1073741772, 2, 1);
            return;
        }
        DataBuffer prms = new DataBuffer(128);
        if ((flags & 4) != 0) {
            prms.putByte(2);
        } else if ((flags & 2) != 0) {
            prms.putByte(1);
        } else {
            prms.putByte(0);
        }
        prms.putByte(0);
        prms.putShort(fid);
        prms.putInt(respAction);
        prms.putInt(0);
        if (netFile.hasCreationDate()) {
            prms.putLong(NTTime.toNTTime(netFile.getCreationDate()));
        } else {
            prms.putLong(0L);
        }
        if (netFile.hasModifyDate()) {
            long modDate = NTTime.toNTTime(netFile.getModifyDate());
            prms.putLong(modDate);
            prms.putLong(modDate);
            prms.putLong(modDate);
        } else {
            prms.putLong(0L);
            prms.putLong(0L);
            prms.putLong(0L);
        }
        prms.putInt(netFile.getFileAttributes());
        prms.putLong(netFile.getFileSize());
        prms.putLong(netFile.getFileSize());
        prms.putShort(0);
        prms.putShort(0);
        prms.putByte(netFile.isDirectory() ? 1 : 0);
        outPkt.initTransactReply(prms.getBuffer(), prms.getLength(), null, 0);
        this.m_sess.sendResponseSMB(outPkt);
        DiskDeviceContext diskCtx = (DiskDeviceContext)conn.getContext();
        if (!diskCtx.hasChangeHandler()) return;
        if (respAction != 2) return;
        if (netFile.isDirectory()) {
            diskCtx.getChangeHandler().notifyDirectoryChanged(1, fileName);
            return;
        }
        diskCtx.getChangeHandler().notifyFileChanged(1, fileName);
    }

    protected final void procNTTransactIOCtl(SrvTransactBuffer tbuf, NTTransPacket outPkt) throws IOException, SMBSrvException {
        int treeId = tbuf.getTreeId();
        TreeConnection conn = this.m_sess.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 15, 1);
            return;
        }
        DataBuffer setupBuf = tbuf.getSetupBuffer();
        int ctrlCode = setupBuf.getInt();
        int fid = setupBuf.getShort();
        boolean fsctrl = setupBuf.getByte() == 1;
        int filter = setupBuf.getByte();
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(256)) {
            logger.debug((Object)("NT IOCtl code=" + NTIOCtl.asString(ctrlCode) + ", fid=" + fid + ", fsctrl=" + fsctrl + ", filter=" + filter));
        }
        DiskInterface disk = null;
        try {
            disk = (DiskInterface)conn.getSharedDevice().getInterface();
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 13, 1);
            return;
        }
        if (disk instanceof IOCtlInterface) {
            IOCtlInterface ioControl = (IOCtlInterface)((Object)disk);
            try {
                DataBuffer response = ioControl.processIOControl(this.m_sess, conn, ctrlCode, fid, tbuf.getDataBuffer(), fsctrl, filter);
                if (response != null) {
                    outPkt.initTransactReply(null, 0, response.getBuffer(), response.getLength(), 1);
                    outPkt.setSetupParameter(0, response.getLength());
                } else {
                    outPkt.initTransactReply(null, 0, null, 0, 1);
                    outPkt.setSetupParameter(0, 0);
                }
            }
            catch (IOControlNotImplementedException ex) {
                this.m_sess.sendErrorResponseSMB(-1073741822, 65, 2);
                return;
            }
            catch (SMBException ex) {
                this.m_sess.sendErrorResponseSMB(ex.getErrorCode(), 65, 2);
                return;
            }
            this.m_sess.sendResponseSMB(outPkt);
        } else {
            this.m_sess.sendErrorResponseSMB(-1073741822, 65535, 2);
        }
    }

    protected final void procNTTransactQuerySecurityDesc(SrvTransactBuffer tbuf, NTTransPacket outPkt) throws IOException, SMBSrvException {
        NetworkFile netFile;
        int treeId = tbuf.getTreeId();
        TreeConnection conn = this.m_sess.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
            return;
        }
        DataBuffer paramBuf = tbuf.getParameterBuffer();
        int fid = paramBuf.getShort();
        int flags = paramBuf.getShort();
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(256)) {
            logger.debug((Object)("NT QuerySecurityDesc fid=" + fid + ", flags=" + flags));
        }
        if ((netFile = conn.findFile(fid)) == null) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 15, 1);
            return;
        }
        if (tbuf.getReturnDataLimit() == 0) {
            byte[] paramblk = new byte[4];
            DataPacker.putIntelInt(_sdEveryOne.length, paramblk, 0);
            outPkt.initTransactReply(paramblk, paramblk.length, null, 0);
            outPkt.setLongErrorCode(-1073741789);
        } else {
            byte[] paramblk = new byte[4];
            DataPacker.putIntelInt(_sdEveryOne.length, paramblk, 0);
            outPkt.initTransactReply(paramblk, paramblk.length, _sdEveryOne, _sdEveryOne.length);
        }
        this.m_sess.sendResponseSMB(outPkt);
    }

    protected final void procNTTransactSetSecurityDesc(SrvTransactBuffer tbuf, NTTransPacket outPkt) throws IOException, SMBSrvException {
        DataBuffer paramBuf = tbuf.getParameterBuffer();
        int treeId = tbuf.getTreeId();
        TreeConnection conn = this.m_sess.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 15, 1);
            return;
        }
        if (!conn.hasWriteAccess()) {
            this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
            return;
        }
        int fid = paramBuf.getShort();
        paramBuf.skipBytes(2);
        int flags = paramBuf.getInt();
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(256)) {
            logger.debug((Object)("NT SetSecurityDesc fid=" + fid + ", flags=" + flags));
        }
        this.m_sess.sendErrorResponseSMB(1, 2);
    }

    protected final void procNTTransactNotifyChange(NTTransPacket ntpkt, SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        NotifyRequest req;
        int treeId = ntpkt.getTreeId();
        TreeConnection conn = this.m_sess.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
            return;
        }
        if (conn.getContext() == null || !(conn.getContext() instanceof DiskDeviceContext)) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 1, 2);
            return;
        }
        DiskDeviceContext diskCtx = (DiskDeviceContext)conn.getContext();
        if (!diskCtx.hasChangeHandler()) {
            this.m_sess.sendErrorResponseSMB(-1073741822, 1, 2);
            return;
        }
        ntpkt.resetSetupPointer();
        int filter = ntpkt.unpackInt();
        int fid = ntpkt.unpackWord();
        boolean watchTree = ntpkt.unpackByte() == 1;
        int mid = ntpkt.getMultiplexId();
        NetworkFile dir = conn.findFile(fid);
        if (dir == null) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 1, 2);
            return;
        }
        int maxQueue = 0;
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(65536)) {
            logger.debug((Object)("NT NotifyChange fid=" + fid + ", mid=" + mid + ", filter=0x" + Integer.toHexString(filter) + ", dir=" + dir.getFullName() + ", maxQueue=" + maxQueue));
        }
        if ((req = this.m_sess.findNotifyRequest(dir, filter, watchTree)) != null && req.isCompleted()) {
            req.setMultiplexId(mid);
            req.setCompleted(false);
            if (req.hasBufferedEvents() || req.hasNotifyEnum()) {
                NotifyChangeEventList bufList = req.getBufferedEventList();
                req.clearBufferedEvents();
                diskCtx.getChangeHandler().sendBufferedNotifications(req, bufList);
                if (logger.isDebugEnabled() && this.m_sess.hasDebug(65536)) {
                    if (bufList == null) {
                        logger.debug((Object)("   Sent buffered notifications, req=" + req.toString() + ", Enum"));
                    } else {
                        logger.debug((Object)("   Sent buffered notifications, req=" + req.toString() + ", count=" + bufList.numberOfEvents()));
                    }
                }
            } else if (logger.isDebugEnabled() && this.m_sess.hasDebug(65536)) {
                logger.debug((Object)("   Reset notify request, " + req.toString()));
            }
        } else {
            req = new NotifyRequest(filter, watchTree, this.m_sess, dir, mid, ntpkt.getTreeId(), ntpkt.getProcessId(), ntpkt.getUserId(), maxQueue);
            this.m_sess.addNotifyRequest(req, diskCtx);
            if (logger.isDebugEnabled() && this.m_sess.hasDebug(65536)) {
                logger.debug((Object)("   Added new request, " + req.toString()));
            }
        }
    }

    protected final void procNTTransactRename(SrvTransactBuffer tbuf, NTTransPacket outPkt) throws IOException, SMBSrvException {
        int treeId = tbuf.getTreeId();
        TreeConnection conn = this.m_sess.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 15, 1);
            return;
        }
        if (!conn.hasWriteAccess()) {
            this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
            return;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(256)) {
            logger.debug((Object)"NT TransactRename");
        }
        this.m_sess.sendErrorResponseSMB(1, 2);
    }
}

