/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.smb.server;

import java.io.IOException;
import java.net.Socket;
import org.alfresco.filesys.smb.server.PacketHandler;
import org.alfresco.filesys.smb.server.SMBSrvPacket;
import org.alfresco.filesys.util.DataPacker;

public class NetBIOSPacketHandler
extends PacketHandler {
    public NetBIOSPacketHandler(Socket sock) throws IOException {
        super(sock, 0, "NetBIOS", "NB");
    }

    public final int readPacket(SMBSrvPacket pkt) throws IOException {
        int offset;
        byte[] buf = pkt.getBuffer();
        int len = 0;
        while (len < 4 && len != -1) {
            len = this.readPacket(buf, len, 4 - len);
        }
        if (len == -1) {
            return len;
        }
        if (len < 4) {
            throw new IOException("Invalid NetBIOS header, len=" + len);
        }
        int typ = buf[0] & 0xFF;
        byte flags = buf[1];
        int dlen = DataPacker.getShort(buf, 2);
        if ((flags & 1) != 0) {
            dlen += 65536;
        }
        if (typ == 133) {
            return 0;
        }
        if (buf.length < dlen + 4) {
            byte[] newBuf = new byte[dlen + 4];
            for (int i = 0; i < 4; ++i) {
                newBuf[i] = buf[i];
            }
            pkt.setBuffer(newBuf);
            buf = newBuf;
        }
        int totlen = offset = 4;
        while (dlen > 0) {
            len = this.readPacket(buf, offset, dlen);
            if (len == -1) {
                return -1;
            }
            totlen += len;
            dlen -= len;
            offset += len;
        }
        return totlen;
    }

    public final void writePacket(SMBSrvPacket pkt, int len) throws IOException {
        byte[] buf = pkt.getBuffer();
        buf[0] = 0;
        buf[1] = 0;
        if (len > 65535) {
            buf[1] = 1;
            DataPacker.putShort((short)(len & 0xFFFF), buf, 2);
        } else {
            DataPacker.putShort((short)len, buf, 2);
        }
        int bufSiz = len + 4;
        this.writePacket(buf, 0, bufSiz);
    }
}

