/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.smb.server;

import java.io.IOException;
import java.util.Enumeration;
import org.alfresco.filesys.server.core.ShareType;
import org.alfresco.filesys.server.core.SharedDevice;
import org.alfresco.filesys.server.core.SharedDeviceList;
import org.alfresco.filesys.smb.TransactBuffer;
import org.alfresco.filesys.smb.server.SMBSrvException;
import org.alfresco.filesys.smb.server.SMBSrvPacket;
import org.alfresco.filesys.smb.server.SMBSrvSession;
import org.alfresco.filesys.smb.server.SMBSrvTransPacket;
import org.alfresco.filesys.util.DataBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class PipeLanmanHandler {
    private static final Log logger = LogFactory.getLog((String)"org.alfresco.smb.protocol");
    public static final int WorkStation = 1;
    public static final int Server = 2;
    public static final int SQLServer = 4;
    public static final int DomainCtrl = 8;
    public static final int DomainBakCtrl = 16;
    public static final int TimeSource = 32;
    public static final int AFPServer = 64;
    public static final int NovellServer = 128;
    public static final int DomainMember = 256;
    public static final int PrintServer = 512;
    public static final int DialinServer = 1024;
    public static final int UnixServer = 2048;
    public static final int NTServer = 4096;
    public static final int WfwServer = 8192;
    public static final int MFPNServer = 16384;
    public static final int NTNonDCServer = 32768;
    public static final int PotentialBrowse = 65536;
    public static final int BackupBrowser = 131072;
    public static final int MasterBrowser = 262144;
    public static final int DomainMaster = 524288;
    public static final int OSFServer = 0x100000;
    public static final int VMSServer = 0x200000;
    public static final int Win95Plus = 0x400000;
    public static final int DFSRoot = 0x800000;
    public static final int NTCluster = 0x1000000;
    public static final int TerminalServer = 0x2000000;
    public static final int DCEServer = 0x10000000;
    public static final int AlternateXport = 0x20000000;
    public static final int LocalListOnly = 0x40000000;
    public static final int DomainEnum = Integer.MIN_VALUE;

    PipeLanmanHandler() {
    }

    public static final boolean processRequest(TransactBuffer tbuf, SMBSrvSession sess, SMBSrvPacket trans) throws IOException, SMBSrvException {
        SMBSrvTransPacket tpkt = new SMBSrvTransPacket(trans.getBuffer());
        DataBuffer paramBuf = tbuf.getParameterBuffer();
        int cmd = paramBuf.getShort();
        String prmDesc = paramBuf.getString(false);
        String dataDesc = paramBuf.getString(false);
        if (logger.isDebugEnabled() && sess.hasDebug(2048)) {
            logger.debug((Object)("\\PIPE\\LANMAN\\ transact request, cmd=" + cmd + ", prm=" + prmDesc + ", data=" + dataDesc));
        }
        boolean processed = false;
        switch (cmd) {
            case 0: {
                processed = PipeLanmanHandler.procNetShareEnum(sess, tbuf, prmDesc, dataDesc, tpkt);
                break;
            }
            case 1: {
                processed = PipeLanmanHandler.procNetShareGetInfo(sess, tbuf, prmDesc, dataDesc, tpkt);
                break;
            }
            case 63: {
                processed = PipeLanmanHandler.procNetWkstaGetInfo(sess, tbuf, prmDesc, dataDesc, tpkt);
                break;
            }
            case 13: {
                processed = PipeLanmanHandler.procNetServerGetInfo(sess, tbuf, prmDesc, dataDesc, tpkt);
                break;
            }
            case 70: {
                processed = PipeLanmanHandler.procNetPrintQGetInfo(sess, tbuf, prmDesc, dataDesc, tpkt);
                break;
            }
            default: {
                if (!logger.isDebugEnabled() || !sess.hasDebug(2048)) break;
                logger.debug((Object)("No handler for \\PIPE\\LANMAN\\ request, cmd=" + cmd + ", prm=" + prmDesc + ", data=" + dataDesc));
            }
        }
        return processed;
    }

    protected static final boolean procNetServerGetInfo(SMBSrvSession sess, TransactBuffer tbuf, String prmDesc, String dataDesc, SMBSrvTransPacket tpkt) throws IOException, SMBSrvException {
        String srvComment;
        int strPos;
        DataBuffer dataBuf;
        TransactBuffer replyBuf;
        if (prmDesc.compareTo("WrLh") != 0) {
            throw new SMBSrvException(65, 2);
        }
        DataBuffer paramBuf = tbuf.getParameterBuffer();
        int infoLevel = paramBuf.getShort();
        int bufSize = paramBuf.getShort();
        if (logger.isDebugEnabled() && sess.hasDebug(2048)) {
            logger.debug((Object)("NetServerGetInfo infoLevel=" + infoLevel));
        }
        if (infoLevel == 1 && dataDesc.compareTo("B16BBDz") == 0) {
            replyBuf = new TransactBuffer(tbuf.isType(), 0, 6, 1024);
            paramBuf = replyBuf.getParameterBuffer();
            paramBuf.putShort(0);
            paramBuf.putShort(0);
            paramBuf.putShort(1);
            dataBuf = replyBuf.getDataBuffer();
            strPos = SMBSrvTransPacket.CalculateDataItemSize("B16BBDz");
            dataBuf.putStringPointer(strPos);
            strPos = dataBuf.putFixedStringAt(sess.getServerName(), 16, strPos);
            dataBuf.putByte(1);
            dataBuf.putByte(0);
            dataBuf.putInt(sess.getSMBServer().getServerType());
            srvComment = sess.getSMBServer().getComment();
            if (srvComment == null) {
                srvComment = "";
            }
        } else {
            throw new SMBSrvException(65, 2);
        }
        dataBuf.putStringPointer(strPos);
        strPos = dataBuf.putStringAt(srvComment, strPos, false, true);
        dataBuf.setLength(strPos);
        tpkt.doTransactionResponse(sess, replyBuf);
        return true;
    }

    protected static final boolean procNetShareEnum(SMBSrvSession sess, TransactBuffer tbuf, String prmDesc, String dataDesc, SMBSrvTransPacket tpkt) throws IOException, SMBSrvException {
        DataBuffer dataBuf;
        TransactBuffer replyBuf;
        int strPos;
        if (prmDesc.compareTo("WrLeh") != 0) {
            throw new SMBSrvException(65, 2);
        }
        DataBuffer paramBuf = tbuf.getParameterBuffer();
        int infoLevel = paramBuf.getShort();
        int bufSize = paramBuf.getShort();
        if (logger.isDebugEnabled() && sess.hasDebug(2048)) {
            logger.debug((Object)("NetShareEnum infoLevel=" + infoLevel));
        }
        if (infoLevel == 1 && dataDesc.compareTo("B13BWz") == 0) {
            SharedDeviceList shrList = sess.getSMBServer().getShareList(null, sess);
            int shrCount = 0;
            strPos = 0;
            if (shrList != null) {
                shrCount = shrList.numberOfShares();
                strPos = SMBSrvTransPacket.CalculateDataItemSize("B13BWz") * shrCount;
            }
            replyBuf = new TransactBuffer(tbuf.isType(), 0, 6, bufSize);
            paramBuf = replyBuf.getParameterBuffer();
            paramBuf.putShort(0);
            paramBuf.putShort(0);
            paramBuf.putShort(shrCount);
            paramBuf.putShort(shrCount);
            dataBuf = replyBuf.getDataBuffer();
            Enumeration<SharedDevice> enm = shrList.enumerateShares();
            while (enm.hasMoreElements()) {
                SharedDevice shrDev = enm.nextElement();
                dataBuf.putFixedString(shrDev.getName(), 13);
                dataBuf.putByte(0);
                dataBuf.putShort(ShareType.asShareInfoType(shrDev.getType()));
                dataBuf.putStringPointer(strPos);
                if (shrDev.getComment() != null) {
                    strPos = dataBuf.putStringAt(shrDev.getComment(), strPos, false, true);
                    continue;
                }
                strPos = dataBuf.putStringAt("", strPos, false, true);
            }
        } else {
            throw new SMBSrvException(65, 2);
        }
        dataBuf.setLength(strPos);
        tpkt.doTransactionResponse(sess, replyBuf);
        return true;
    }

    protected static final boolean procNetShareGetInfo(SMBSrvSession sess, TransactBuffer tbuf, String prmDesc, String dataDesc, SMBSrvTransPacket tpkt) throws IOException, SMBSrvException {
        SharedDevice share;
        if (prmDesc.compareTo("zWrLh") != 0) {
            throw new SMBSrvException(65, 2);
        }
        DataBuffer paramBuf = tbuf.getParameterBuffer();
        String shareName = paramBuf.getString(32, false);
        int infoLevel = paramBuf.getShort();
        int bufSize = paramBuf.getShort();
        if (logger.isDebugEnabled() && sess.hasDebug(2048)) {
            logger.debug((Object)("NetShareGetInfo - " + shareName + ", infoLevel=" + infoLevel));
        }
        if (infoLevel == 1 && dataDesc.compareTo("B13BWz") == 0) {
            share = null;
            try {
                share = sess.getSMBServer().findShare(null, shareName, -1, sess, false);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (share == null) {
                sess.sendErrorResponseSMB(65, 2);
                return true;
            }
        } else {
            if (logger.isDebugEnabled() && sess.hasDebug(2048)) {
                logger.debug((Object)("NetShareGetInfo - UNSUPPORTED " + shareName + ", infoLevel=" + infoLevel + ", dataDesc=" + dataDesc));
            }
            throw new SMBSrvException(65, 2);
        }
        TransactBuffer replyBuf = new TransactBuffer(tbuf.isType(), 0, 6, 1024);
        paramBuf = replyBuf.getParameterBuffer();
        paramBuf.putShort(0);
        paramBuf.putShort(0);
        paramBuf.putShort(1);
        DataBuffer dataBuf = replyBuf.getDataBuffer();
        int strPos = SMBSrvTransPacket.CalculateDataItemSize("B13BWz");
        dataBuf.putStringPointer(strPos);
        strPos = dataBuf.putFixedStringAt(share.getName(), 13, strPos);
        dataBuf.putByte(0);
        dataBuf.putShort(share.getType());
        dataBuf.putStringPointer(strPos);
        strPos = share.getComment() != null ? dataBuf.putStringAt(share.getComment(), strPos, false, true) : dataBuf.putStringAt("", strPos, false, true);
        dataBuf.setLength(strPos);
        tpkt.doTransactionResponse(sess, replyBuf);
        return true;
    }

    protected static final boolean procNetWkstaGetInfo(SMBSrvSession sess, TransactBuffer tbuf, String prmDesc, String dataDesc, SMBSrvTransPacket tpkt) throws IOException, SMBSrvException {
        int strPos;
        DataBuffer dataBuf;
        TransactBuffer replyBuf;
        if (prmDesc.compareTo("WrLh") != 0) {
            throw new SMBSrvException(65, 2);
        }
        DataBuffer paramBuf = tbuf.getParameterBuffer();
        int infoLevel = paramBuf.getShort();
        int bufSize = paramBuf.getShort();
        if (logger.isDebugEnabled() && sess.hasDebug(2048)) {
            logger.debug((Object)("NetWkstaGetInfo infoLevel=" + infoLevel));
        }
        if (infoLevel == 1 && dataDesc.compareTo("zzzBBzzz") == 0 || infoLevel == 10 && dataDesc.compareTo("zzzBBzz") == 0) {
            replyBuf = new TransactBuffer(tbuf.isType(), 0, 6, 1024);
            dataBuf = replyBuf.getDataBuffer();
            strPos = SMBSrvTransPacket.CalculateDataItemSize(dataDesc);
            dataBuf.putStringPointer(strPos);
            strPos = dataBuf.putStringAt(sess.getServerName(), strPos, false, true);
            dataBuf.putStringPointer(strPos);
            strPos = dataBuf.putStringAt("", strPos, false, true);
            dataBuf.putStringPointer(strPos);
            String domain = sess.getServer().getConfiguration().getDomainName();
            if (domain == null) {
                domain = "";
            }
            strPos = dataBuf.putStringAt(domain, strPos, false, true);
            dataBuf.putByte(4);
            dataBuf.putByte(2);
            dataBuf.putStringPointer(strPos);
            strPos = dataBuf.putStringAt("", strPos, false, true);
            if (infoLevel == 1 && dataDesc.compareTo("zzzBBzzz") == 0) {
                dataBuf.putStringPointer(strPos);
                strPos = dataBuf.putStringAt("", strPos, false, true);
            }
        } else {
            if (logger.isDebugEnabled() && sess.hasDebug(2048)) {
                logger.debug((Object)("NetWkstaGetInfo UNSUPPORTED infoLevel=" + infoLevel + ", dataDesc=" + dataDesc));
            }
            throw new SMBSrvException(65, 2);
        }
        dataBuf.setLength(strPos);
        paramBuf = replyBuf.getParameterBuffer();
        paramBuf.putShort(0);
        paramBuf.putShort(0);
        paramBuf.putShort(dataBuf.getLength());
        paramBuf.putShort(0);
        tpkt.doTransactionResponse(sess, replyBuf);
        return true;
    }

    protected static final boolean procNetPrintQGetInfo(SMBSrvSession sess, TransactBuffer tbuf, String prmDesc, String dataDesc, SMBSrvTransPacket tpkt) throws IOException, SMBSrvException {
        if (prmDesc.compareTo("zWrLh") != 0) {
            throw new SMBSrvException(65, 2);
        }
        DataBuffer paramBuf = tbuf.getParameterBuffer();
        String shareName = paramBuf.getString(32, false);
        int infoLevel = paramBuf.getShort();
        int bufSize = paramBuf.getShort();
        if (logger.isDebugEnabled() && sess.hasDebug(2048)) {
            logger.debug((Object)("NetPrintQGetInfo - " + shareName + ", infoLevel=" + infoLevel));
        }
        return false;
    }
}

