/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.smb.server;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.UUID;
import java.util.Vector;
import org.alfresco.filesys.netbios.NetworkSettings;
import org.alfresco.filesys.server.SrvSessionList;
import org.alfresco.filesys.server.config.ServerConfiguration;
import org.alfresco.filesys.server.core.InvalidDeviceInterfaceException;
import org.alfresco.filesys.server.core.SharedDevice;
import org.alfresco.filesys.server.filesys.DiskInterface;
import org.alfresco.filesys.server.filesys.NetworkFileServer;
import org.alfresco.filesys.smb.SMBException;
import org.alfresco.filesys.smb.mailslot.HostAnnouncer;
import org.alfresco.filesys.smb.server.AdminSharedDevice;
import org.alfresco.filesys.smb.server.NetBIOSSessionSocketHandler;
import org.alfresco.filesys.smb.server.SMBSrvSession;
import org.alfresco.filesys.smb.server.SessionSocketHandler;
import org.alfresco.filesys.smb.server.TcpipSMBSessionSocketHandler;
import org.alfresco.filesys.smb.server.win32.Win32NetBIOSLanaMonitor;
import org.alfresco.filesys.smb.server.win32.Win32NetBIOSSessionSocketHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SMBServer
extends NetworkFileServer
implements Runnable {
    private static final Log logger = LogFactory.getLog((String)"org.alfresco.smb.protocol");
    private static final String ServerVersion = "3.5.1";
    private Thread m_srvThread;
    private Vector<SessionSocketHandler> m_sessionHandlers;
    private Vector<HostAnnouncer> m_hostAnnouncers;
    private SrvSessionList m_sessions;
    private int m_srvType = 3;
    private int m_sessId;
    private boolean m_shutdown = false;
    private boolean m_active = false;
    private UUID m_serverGUID;

    public SMBServer(ServerConfiguration cfg) throws IOException {
        super("SMB", cfg);
        this.CommonConstructor();
    }

    public final synchronized boolean addShare(SharedDevice shr) {
        if (shr.getType() == 0) {
            this.checkReadOnly(shr);
        }
        boolean sts = this.getConfiguration().getShares().addShare(shr);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Add Share " + shr.toString() + " : " + sts));
        }
        return sts;
    }

    public final void addSessionHandler(SessionSocketHandler handler) {
        if (this.m_sessionHandlers == null) {
            this.m_sessionHandlers = new Vector();
        }
        this.m_sessionHandlers.addElement(handler);
    }

    public final void addHostAnnouncer(HostAnnouncer announcer) {
        if (this.m_hostAnnouncers == null) {
            this.m_hostAnnouncers = new Vector();
        }
        this.m_hostAnnouncers.addElement(announcer);
    }

    public final void addSession(SMBSrvSession sess) {
        this.m_sessions.addSession(sess);
        sess.setDebug(this.getConfiguration().getSessionDebugFlags());
    }

    protected final void checkReadOnly(SharedDevice shr) {
        if (shr.getType() == 0) {
            try {
                DiskInterface disk = (DiskInterface)shr.getInterface();
                if (disk.isReadOnly(null, shr.getContext())) {
                    int attr = shr.getAttributes();
                    if ((attr & 4) == 0) {
                        attr += 4;
                    }
                    shr.setAttributes(attr);
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("[SMB] Add Share " + shr.toString() + " : isReadOnly"));
                    }
                }
            }
            catch (InvalidDeviceInterfaceException ex) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("[SMB] Add Share " + shr.toString() + " : " + ex.toString()));
                }
                return;
            }
            catch (FileNotFoundException ex) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("[SMB] Add Share " + shr.toString() + " : " + ex.toString()));
                }
                return;
            }
            catch (IOException ex) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("[SMB] Add Share " + shr.toString() + " : " + ex.toString()));
                }
                return;
            }
        }
    }

    private void CommonConstructor() throws IOException {
        this.setVersion(ServerVersion);
        this.m_sessionHandlers = new Vector();
        this.m_sessions = new SrvSessionList();
        NetworkSettings.setDomain(this.getConfiguration().getDomainName());
        NetworkSettings.setBroadcastMask(this.getConfiguration().getBroadcastMask());
    }

    protected void closeHostAnnouncers() {
        if (this.m_hostAnnouncers != null) {
            for (int i = 0; i < this.m_hostAnnouncers.size(); ++i) {
                HostAnnouncer announcer = this.m_hostAnnouncers.elementAt(i);
                announcer.shutdownAnnouncer();
            }
        }
    }

    protected void closeSessionHandlers() {
        for (SessionSocketHandler handler : this.m_sessionHandlers) {
            handler.shutdownRequest();
        }
        this.m_sessionHandlers.removeAllElements();
    }

    public final synchronized SharedDevice deleteShare(String name) {
        return this.getConfiguration().getShares().deleteShare(name);
    }

    public final void deleteTemporaryShares(SMBSrvSession sess) {
        this.getConfiguration().getShareMapper().deleteShares(sess);
    }

    public final Enumeration enumerateShares() {
        return this.getConfiguration().getShares().enumerateShares();
    }

    public final String getComment() {
        return this.getConfiguration().getComment();
    }

    public final int getServerType() {
        return this.m_srvType;
    }

    public final int getSessionDebug() {
        return this.getConfiguration().getSessionDebugFlags();
    }

    public final SrvSessionList getSessions() {
        return this.m_sessions;
    }

    public void run() {
        boolean isWindows;
        block20: {
            this.setActive(true);
            isWindows = this.isWindowsNTOnwards();
            this.m_serverGUID = UUID.nameUUIDFromBytes(this.getServerName().getBytes());
            if (logger.isInfoEnabled()) {
                logger.info((Object)("SMB Server " + this.getServerName() + " starting"));
                logger.info((Object)("GUID " + this.m_serverGUID));
                if (this.getAuthenticator() != null) {
                    logger.info((Object)("Using authenticator " + this.getAuthenticator().getClass().getName()));
                }
                if (this.getConfiguration().getTimeZone() != null) {
                    logger.info((Object)("Server timezone " + this.getConfiguration().getTimeZone() + ", offset from UTC = " + this.getConfiguration().getTimeZoneOffset() / 60 + "hrs"));
                } else {
                    logger.info((Object)("Server timezone offset = " + this.getConfiguration().getTimeZoneOffset() / 60 + "hrs"));
                }
                logger.info((Object)"Shares:");
                Enumeration<SharedDevice> enm = this.getFullShareList(this.getServerName(), null).enumerateShares();
                while (enm.hasMoreElements()) {
                    SharedDevice share = enm.nextElement();
                    logger.info((Object)(" " + share.toString() + " " + share.getContext().toString()));
                }
            }
            try {
                AdminSharedDevice admShare = new AdminSharedDevice();
                this.addShare(admShare);
                this.m_shutdown = false;
                this.getServerIPAddresses();
                boolean sockDbg = false;
                if ((this.getSessionDebug() & 0x40000) != 0) {
                    sockDbg = true;
                }
                if (this.getConfiguration().hasNetBIOSSMB()) {
                    NetBIOSSessionSocketHandler.createSessionHandlers(this, sockDbg);
                }
                if (this.getConfiguration().hasTcpipSMB()) {
                    TcpipSMBSessionSocketHandler.createSessionHandlers(this, sockDbg);
                }
                if (this.getConfiguration().hasWin32NetBIOS() && isWindows) {
                    Win32NetBIOSSessionSocketHandler.createSessionHandlers(this, sockDbg);
                }
                if (this.m_sessionHandlers.size() > 0 || this.getConfiguration().hasWin32NetBIOS()) {
                    while (!this.m_shutdown) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException ex) {}
                    }
                } else if (logger.isInfoEnabled()) {
                    logger.info((Object)"No valid session handlers, server closing");
                }
            }
            catch (SMBException ex) {
                logger.error((Object)"SMB server error", (Throwable)ex);
                this.setException(ex);
                this.fireServerEvent(3);
            }
            catch (Exception ex) {
                if (this.m_shutdown) break block20;
                logger.error((Object)"Server error : ", (Throwable)ex);
                this.setException(ex);
                this.fireServerEvent(3);
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)"SMB Server shutting down ...");
        }
        this.closeHostAnnouncers();
        this.closeSessionHandlers();
        if (isWindows && Win32NetBIOSLanaMonitor.getLanaMonitor() != null) {
            Win32NetBIOSLanaMonitor.getLanaMonitor().shutdownRequest();
        }
        this.setActive(false);
        this.fireServerEvent(2);
    }

    protected final void sessionClosed(SMBSrvSession sess) {
        this.m_sessions.removeSession(sess);
        this.fireSessionClosedEvent(sess);
    }

    protected final void sessionLoggedOn(SMBSrvSession sess) {
        this.fireSessionLoggedOnEvent(sess);
    }

    protected final void sessionOpened(SMBSrvSession sess) {
        this.fireSessionOpenEvent(sess);
    }

    public final void shutdownServer(boolean immediate) {
        this.m_shutdown = true;
        try {
            this.closeSessionHandlers();
        }
        catch (Exception ex) {
            // empty catch block
        }
        Enumeration<Integer> enm = this.m_sessions.enumerate();
        while (enm.hasMoreElements()) {
            Integer sessId = enm.nextElement();
            SMBSrvSession sess = (SMBSrvSession)this.m_sessions.findSession(sessId);
            this.fireSessionClosedEvent(sess);
            sess.closeSession();
        }
        if (this.m_srvThread != null) {
            try {
                this.m_srvThread.join(3000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.fireServerEvent(2);
    }

    public void startServer() {
        this.m_srvThread = new Thread(this);
        this.m_srvThread.setName("SMB Server");
        this.m_srvThread.setDaemon(true);
        this.m_srvThread.start();
        this.fireServerEvent(0);
    }

    private final boolean isWindowsNTOnwards() {
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Windows")) {
            return !osName.endsWith("95") && !osName.endsWith("98") && !osName.endsWith("ME");
        }
        return false;
    }

    private final void getServerIPAddresses() {
        try {
            Enumeration<NetworkInterface> enm = NetworkInterface.getNetworkInterfaces();
            Vector<InetAddress> addrList = new Vector<InetAddress>();
            while (enm.hasMoreElements()) {
                NetworkInterface ni = enm.nextElement();
                Enumeration<InetAddress> addrs = ni.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    addrList.add(addrs.nextElement());
                }
            }
            if (addrList.size() > 0) {
                InetAddress[] inetAddrs = new InetAddress[addrList.size()];
                for (int i = 0; i < addrList.size(); ++i) {
                    inetAddrs[i] = (InetAddress)addrList.elementAt(i);
                }
                this.setServerAddresses(inetAddrs);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Error getting local IP addresses", (Throwable)ex);
        }
    }

    public final UUID getServerGUID() {
        return this.m_serverGUID;
    }
}

