/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.smb.server;

import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.alfresco.filesys.netbios.NetBIOSException;
import org.alfresco.filesys.netbios.NetBIOSPacket;
import org.alfresco.filesys.netbios.NetBIOSSession;
import org.alfresco.filesys.server.SrvSession;
import org.alfresco.filesys.server.auth.AuthenticatorException;
import org.alfresco.filesys.server.auth.CifsAuthenticator;
import org.alfresco.filesys.server.core.DeviceInterface;
import org.alfresco.filesys.server.core.SharedDevice;
import org.alfresco.filesys.server.filesys.DiskDeviceContext;
import org.alfresco.filesys.server.filesys.DiskInterface;
import org.alfresco.filesys.server.filesys.NetworkFile;
import org.alfresco.filesys.server.filesys.SearchContext;
import org.alfresco.filesys.server.filesys.TooManyConnectionsException;
import org.alfresco.filesys.server.filesys.TreeConnection;
import org.alfresco.filesys.smb.Dialect;
import org.alfresco.filesys.smb.DialectSelector;
import org.alfresco.filesys.smb.NTTime;
import org.alfresco.filesys.smb.SMBDate;
import org.alfresco.filesys.smb.SMBErrorText;
import org.alfresco.filesys.smb.server.NTParameterPacker;
import org.alfresco.filesys.smb.server.PacketHandler;
import org.alfresco.filesys.smb.server.ProtocolFactory;
import org.alfresco.filesys.smb.server.ProtocolHandler;
import org.alfresco.filesys.smb.server.SMBServer;
import org.alfresco.filesys.smb.server.SMBSrvException;
import org.alfresco.filesys.smb.server.SMBSrvPacket;
import org.alfresco.filesys.smb.server.SMBSrvSessionState;
import org.alfresco.filesys.smb.server.SrvTransactBuffer;
import org.alfresco.filesys.smb.server.notify.NotifyRequest;
import org.alfresco.filesys.smb.server.notify.NotifyRequestList;
import org.alfresco.filesys.util.DataPacker;
import org.alfresco.filesys.util.StringList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SMBSrvSession
extends SrvSession
implements Runnable {
    private static Log logger = LogFactory.getLog((String)"org.alfresco.smb.protocol");
    public static final int DefaultBufferSize = 65540;
    public static final int LanManBufferSize = 8192;
    public static final int DefaultConnections = 4;
    public static final int MaxConnections = 16;
    private static final int TreeIdMask = 65535;
    private static final int DefaultSearches = 8;
    private static final int MaxSearches = 256;
    public static final int LanManMaxMultiplexed = 1;
    public static final int NTMaxMultiplexed = 4;
    public static final int MaxVirtualCircuits = 0;
    private PacketHandler m_pktHandler;
    private byte[] m_buf;
    private int m_rxlen;
    private SMBSrvPacket m_smbPkt;
    private ProtocolHandler m_handler;
    private int m_state = 0;
    private int m_dialect = -1;
    private String m_callerNBName;
    private String m_targetNBName;
    private Hashtable<Integer, TreeConnection> m_connections;
    private int m_treeId;
    private SearchContext[] m_search;
    private int m_searchCount;
    private SrvTransactBuffer m_transact;
    private NotifyRequestList m_notifyList;
    private boolean m_notifyPending;
    private int m_defFlags;
    private int m_defFlags2;
    private Vector<SMBSrvPacket> m_asynchQueue;
    private int m_maxBufSize;
    private int m_maxMultiplex;
    private int m_clientCaps;
    private Object m_setupObject;
    public static final int DBG_NETBIOS = 1;
    public static final int DBG_STATE = 2;
    public static final int DBG_NEGOTIATE = 4;
    public static final int DBG_TREE = 8;
    public static final int DBG_SEARCH = 16;
    public static final int DBG_INFO = 32;
    public static final int DBG_FILE = 64;
    public static final int DBG_FILEIO = 128;
    public static final int DBG_TRAN = 256;
    public static final int DBG_ECHO = 512;
    public static final int DBG_ERROR = 1024;
    public static final int DBG_IPC = 2048;
    public static final int DBG_LOCK = 4096;
    public static final int DBG_PKTTYPE = 8192;
    public static final int DBG_DCERPC = 16384;
    public static final int DBG_STATECACHE = 32768;
    public static final int DBG_NOTIFY = 65536;
    public static final int DBG_STREAMS = 131072;
    public static final int DBG_SOCKET = 262144;

    public SMBSrvSession(PacketHandler handler, SMBServer srv) {
        super(-1, srv, handler.isProtocolName(), null);
        this.m_pktHandler = handler;
        this.m_buf = new byte[65540];
        this.m_smbPkt = new SMBSrvPacket(this.m_buf);
        if (this.isProtocol() == 1 || this.isProtocol() == 2) {
            this.setState(1);
            if (handler.hasClientName()) {
                this.m_callerNBName = handler.getClientName();
            }
        }
    }

    public final int isProtocol() {
        return this.m_pktHandler.isProtocol();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int addConnection(SharedDevice shrDev) throws TooManyConnectionsException {
        if (this.m_connections == null) {
            this.m_connections = new Hashtable(4);
        }
        int treeId = 0;
        Hashtable<Integer, TreeConnection> hashtable = this.m_connections;
        synchronized (hashtable) {
            if (this.m_connections.size() == 16) {
                throw new TooManyConnectionsException();
            }
            treeId = this.m_treeId++ & 0xFFFF;
            Integer key = new Integer(treeId);
            while (this.m_connections.contains(key)) {
                treeId = this.m_treeId++ & 0xFFFF;
                key = new Integer(treeId);
            }
            this.m_connections.put(key, new TreeConnection(shrDev));
        }
        return treeId;
    }

    protected final int allocateSearchSlot() {
        int idx;
        if (this.m_search == null) {
            this.m_search = new SearchContext[8];
        }
        for (idx = 0; idx < this.m_search.length && this.m_search[idx] != null; ++idx) {
        }
        if (idx == this.m_search.length) {
            if (this.m_search.length >= 256) {
                return -1;
            }
            SearchContext[] newSearch = new SearchContext[this.m_search.length * 2];
            System.arraycopy(this.m_search, 0, newSearch, 0, this.m_search.length);
            this.m_search = newSearch;
        }
        ++this.m_searchCount;
        return idx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void cleanupSession() {
        block16: {
            if (logger.isDebugEnabled() && this.hasDebug(2)) {
                logger.debug((Object)("Cleanup session, searches=" + this.getSearchCount() + ", treeConns=" + this.getConnectionCount() + ", changeNotify=" + this.getNotifyChangeCount()));
            }
            if (this.m_search != null) {
                for (int idx = 0; idx < this.m_search.length; ++idx) {
                    if (this.m_search[idx] == null) continue;
                    this.deallocateSearchSlot(idx);
                }
                this.m_search = null;
                this.m_searchCount = 0;
            }
            if (this.m_connections != null) {
                Hashtable<Integer, TreeConnection> idx = this.m_connections;
                synchronized (idx) {
                    Enumeration<TreeConnection> enm = this.m_connections.elements();
                    while (enm.hasMoreElements()) {
                        TreeConnection tree = enm.nextElement();
                        DeviceInterface devIface = tree.getInterface();
                        if (tree.openFileCount() > 0) {
                            for (int i = 0; i < tree.getFileTableLength(); ++i) {
                                NetworkFile curFile = tree.findFile(i);
                                if (curFile == null || !(devIface instanceof DiskInterface)) continue;
                                DiskInterface diskIface = (DiskInterface)devIface;
                                try {
                                    tree.removeFile(i, this);
                                    diskIface.closeFile(this, tree, curFile);
                                    continue;
                                }
                                catch (Exception ex) {
                                    // empty catch block
                                }
                            }
                        }
                        if (devIface == null) continue;
                        devIface.treeClosed(this, tree);
                    }
                    this.m_connections.clear();
                }
            }
            try {
                this.endTransaction();
            }
            catch (Exception ex) {
                if (!logger.isDebugEnabled()) break block16;
                logger.debug((Object)"Error committing transaction", (Throwable)ex);
            }
        }
        if (this.m_notifyList != null && this.m_notifyList.numberOfRequests() > 0) {
            for (int i = 0; i < this.m_notifyList.numberOfRequests(); ++i) {
                NotifyRequest curReq = this.m_notifyList.getRequest(i);
                curReq.getDiskContext().getChangeHandler().removeNotifyRequests(this);
            }
        }
        this.getSMBServer().deleteTemporaryShares(this);
    }

    protected final void closeSocket() {
        this.setShutdown(true);
        try {
            this.m_pktHandler.closeHandler();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void closeSession() {
        super.closeSession();
        try {
            this.setState(5);
            this.setShutdown(true);
            this.m_pktHandler.closeHandler();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected final void deallocateSearchSlot(int ctxId) {
        if (this.m_search == null || ctxId >= this.m_search.length) {
            return;
        }
        if (this.m_search[ctxId] != null) {
            this.m_search[ctxId].closeSearch();
        }
        --this.m_searchCount;
        this.m_search[ctxId] = null;
    }

    public void finalize() {
        this.cleanupSession();
        this.closeSocket();
    }

    protected final TreeConnection findConnection(int treeId) {
        if (this.m_connections == null) {
            return null;
        }
        return this.m_connections.get(new Integer(treeId));
    }

    protected final byte[] getBuffer() {
        return this.m_buf;
    }

    public final int getConnectionCount() {
        return this.m_connections != null ? this.m_connections.size() : 0;
    }

    public final int getDefaultFlags() {
        return this.m_defFlags;
    }

    public final int getDefaultFlags2() {
        return this.m_defFlags2;
    }

    public final int getNotifyChangeCount() {
        if (this.m_notifyList == null) {
            return 0;
        }
        return this.m_notifyList.numberOfRequests();
    }

    public final int getClientMaximumBufferSize() {
        return this.m_maxBufSize;
    }

    public final int getClientMaximumMultiplex() {
        return this.m_maxMultiplex;
    }

    public final int getClientCapabilities() {
        return this.m_clientCaps;
    }

    public final boolean hasClientCapability(int cap) {
        return (this.m_clientCaps & cap) != 0;
    }

    public final int getNegotiatedSMBDialect() {
        return this.m_dialect;
    }

    public final PacketHandler getPacketHandler() {
        return this.m_pktHandler;
    }

    public final SMBSrvPacket getReceivePacket() {
        return this.m_smbPkt;
    }

    public final String getRemoteNetBIOSName() {
        return this.m_callerNBName;
    }

    public final boolean hasTargetNetBIOSName() {
        return this.m_targetNBName != null;
    }

    public final String getTargetNetBIOSName() {
        return this.m_targetNBName;
    }

    public final boolean hasRemoteAddress() {
        return this.m_pktHandler.hasRemoteAddress();
    }

    public final InetAddress getRemoteAddress() {
        return this.m_pktHandler.getRemoteAddress();
    }

    protected final SearchContext getSearchContext(int srchId) {
        if (this.m_search == null || srchId >= this.m_search.length) {
            return null;
        }
        return this.m_search[srchId];
    }

    public final int getSearchCount() {
        return this.m_searchCount;
    }

    public final SMBServer getSMBServer() {
        return (SMBServer)this.getServer();
    }

    public final String getServerName() {
        return this.getSMBServer().getServerName();
    }

    public final boolean hasSetupObject() {
        return this.m_setupObject != null;
    }

    public final Object getSetupObject() {
        return this.m_setupObject;
    }

    public final int isState() {
        return this.m_state;
    }

    private void hangupSession(String reason) {
        if (logger.isDebugEnabled() && this.hasDebug(1)) {
            logger.debug((Object)("## Session closing - " + reason));
        }
        this.setState(5);
    }

    public final boolean hasMacintoshExtensions() {
        return this.getSMBServer().getConfiguration().hasMacintoshExtensions();
    }

    public final boolean hasNotifyPending() {
        return this.m_notifyPending;
    }

    public final void setNotifyPending(boolean pend) {
        this.m_notifyPending = pend;
    }

    public final void setClientMaximumBufferSize(int maxBuf) {
        this.m_maxBufSize = maxBuf;
    }

    public final void setClientMaximumMultiplex(int maxMpx) {
        this.m_maxMultiplex = maxMpx;
    }

    public final void setClientCapabilities(int flags) {
        this.m_clientCaps = flags;
    }

    public final void setDefaultFlags(int flags) {
        this.m_defFlags = flags;
    }

    public final void setDefaultFlags2(int flags) {
        this.m_defFlags2 = flags;
    }

    public final void setReceivePacket(SMBSrvPacket pkt) {
        this.m_smbPkt = pkt;
        this.m_buf = pkt.getBuffer();
    }

    protected final void setSearchContext(int slot, SearchContext srch) {
        if (this.m_search == null || slot > this.m_search.length) {
            return;
        }
        this.m_search[slot] = srch;
    }

    protected void setState(int state) {
        if (logger.isDebugEnabled() && this.hasDebug(2)) {
            logger.debug((Object)("State changed to " + SMBSrvSessionState.getStateAsString(state)));
        }
        if (state == 3) {
            this.m_setupObject = null;
        }
        this.m_state = state;
    }

    public final void setSetupObject(Object obj) {
        this.m_setupObject = obj;
    }

    protected void procNetBIOSSessionRequest() throws IOException, NetBIOSException {
        NetBIOSPacket nbPkt = new NetBIOSPacket(this.m_buf);
        if (this.m_rxlen < 72 || nbPkt.getHeaderType() != 129) {
            throw new NetBIOSException("NBREQ Invalid packet");
        }
        if (this.m_buf[4] != 32 || this.m_buf[38] != 32) {
            throw new NetBIOSException("NBREQ Invalid NetBIOS name data");
        }
        StringBuffer nbName = new StringBuffer(32);
        for (int i = 0; i < 32; ++i) {
            nbName.append((char)this.m_buf[5 + i]);
        }
        String toName = NetBIOSSession.DecodeName(nbName.toString());
        toName = toName.trim();
        nbName.setLength(0);
        for (int i = 0; i < 32; ++i) {
            nbName.append((char)this.m_buf[39 + i]);
        }
        String fromName = NetBIOSSession.DecodeName(nbName.toString());
        fromName = fromName.trim();
        if (logger.isDebugEnabled() && this.hasDebug(1)) {
            logger.debug((Object)("NetBIOS CALL From " + fromName + " to " + toName));
        }
        boolean forThisServer = false;
        if (toName.compareTo(this.getServerName()) == 0 || toName.compareTo("*SMBSERVER") == 0 || toName.compareTo("*SMBSERV") == 0 || toName.compareTo("*") == 0) {
            forThisServer = true;
        } else {
            InetAddress[] srvAddr = this.getSMBServer().getServerAddresses();
            if (srvAddr != null) {
                int idx = 0;
                while (idx < srvAddr.length && !forThisServer) {
                    if (srvAddr[idx++].getHostAddress().compareTo(toName) != 0) continue;
                    forThisServer = true;
                }
            }
        }
        if (!forThisServer) {
            throw new NetBIOSException("NBREQ Called name is not this server (" + toName + ")");
        }
        if (logger.isDebugEnabled() && this.hasDebug(1)) {
            logger.debug((Object)("NetBIOS session request from " + fromName));
        }
        this.m_callerNBName = fromName;
        this.m_targetNBName = toName;
        this.setRemoteName(fromName);
        nbPkt.setHeaderType(130);
        nbPkt.setHeaderFlags(0);
        nbPkt.setHeaderLength(0);
        this.m_pktHandler.writePacket(this.m_buf, 0, 4);
        this.setState(1);
    }

    protected void procSMBNegotiate() throws SMBSrvException, IOException {
        boolean extendedSecurity;
        this.m_smbPkt = new SMBSrvPacket(this.m_buf);
        this.m_buf[0] = 0;
        if (this.m_smbPkt.getCommand() != 114 || !this.m_smbPkt.checkPacketIsValid(0, 2)) {
            this.sendErrorResponseSMB(64, 2);
            return;
        }
        int dataPos = this.m_smbPkt.getByteOffset();
        String diaStr = null;
        StringList dialects = new StringList();
        for (int dataLen = this.m_smbPkt.getByteCount(); dataLen > 0; dataLen -= diaStr.length() + 2) {
            diaStr = DataPacker.getDataString('\u0002', this.m_buf, dataPos, dataLen, false);
            if (diaStr == null) {
                this.sendErrorResponseSMB(1, 2);
                this.setState(5);
                return;
            }
            dialects.addString(diaStr);
            dataPos += diaStr.length() + 2;
        }
        DialectSelector dia = this.getSMBServer().getConfiguration().getAuthenticator().getEnabledDialects();
        int diaIdx = -1;
        for (int i = 0; i < 8; ++i) {
            if (!dia.hasDialect(i)) continue;
            for (int j = 0; j < Dialect.SMB_PROT_MAXSTRING; ++j) {
                if (Dialect.DialectType(j) != i || !dialects.containsString(Dialect.DialectString(j)) || i <= diaIdx) continue;
                diaIdx = i;
            }
        }
        if (logger.isDebugEnabled() && this.hasDebug(4)) {
            if (diaIdx == -1) {
                logger.debug((Object)"Failed to negotiate SMB dialect");
            } else {
                logger.debug((Object)("Negotiated SMB dialect - " + Dialect.DialectTypeString(diaIdx)));
            }
        }
        if (diaIdx != -1) {
            this.m_dialect = diaIdx;
            diaIdx = dialects.findString(Dialect.DialectTypeString(diaIdx));
            this.m_handler = ProtocolFactory.getHandler(this.m_dialect);
            if (this.m_handler != null) {
                if (logger.isDebugEnabled() && this.hasDebug(4)) {
                    logger.debug((Object)("Assigned protocol handler - " + this.m_handler.getClass().getName()));
                }
                this.m_handler.setSession(this);
            } else {
                diaIdx = -1;
            }
        }
        boolean bl = extendedSecurity = (this.m_smbPkt.getFlags2() & 0x800) != 0;
        if (this.m_dialect == -1 || this.m_dialect <= 1) {
            this.m_smbPkt.setParameterCount(1);
            this.m_smbPkt.setParameter(0, diaIdx);
            this.m_smbPkt.setByteCount(0);
            this.m_smbPkt.setTreeId(0);
            this.m_smbPkt.setUserId(0);
        } else {
            if (this.m_dialect <= 6) {
                this.m_smbPkt.setFlags(8);
                this.m_smbPkt.setFlags2(1);
                CifsAuthenticator auth = this.getServer().getConfiguration().getAuthenticator();
                this.m_smbPkt.setParameterCount(13);
                this.m_smbPkt.setParameter(0, diaIdx);
                this.m_smbPkt.setParameter(1, auth.getSecurityMode());
                this.m_smbPkt.setParameter(2, 8192);
                this.m_smbPkt.setParameter(3, 1);
                this.m_smbPkt.setParameter(4, 0);
                this.m_smbPkt.setParameter(5, 0);
                this.m_smbPkt.setParameterLong(6, (int)(System.currentTimeMillis() & 0xFFFFFFFFFFFFFFFFL));
                SMBDate srvDate = new SMBDate(System.currentTimeMillis());
                this.m_smbPkt.setParameter(8, srvDate.asSMBTime());
                this.m_smbPkt.setParameter(9, srvDate.asSMBDate());
                this.m_smbPkt.setParameter(10, this.getServer().getConfiguration().getTimeZoneOffset());
                this.m_smbPkt.setParameter(11, auth.getEncryptionKeyLength());
                this.m_smbPkt.setParameter(12, 0);
                this.m_smbPkt.setTreeId(0);
                this.m_smbPkt.setUserId(0);
                try {
                    auth.generateNegotiateResponse(this, this.m_smbPkt, extendedSecurity);
                }
                catch (AuthenticatorException ex) {
                    if (logger.isErrorEnabled()) {
                        logger.error((Object)"Negotiate error", (Throwable)ex);
                    }
                    this.setState(5);
                    return;
                }
            }
            if (this.m_dialect == 7) {
                this.setDefaultFlags(8);
                this.setDefaultFlags2(32769);
                CifsAuthenticator auth = this.getServer().getConfiguration().getAuthenticator();
                NTParameterPacker nt = new NTParameterPacker(this.m_smbPkt.getBuffer());
                this.m_smbPkt.setParameterCount(17);
                nt.packWord(diaIdx);
                nt.packByte(auth.getSecurityMode());
                nt.packWord(4);
                nt.packWord(0);
                int maxBufSize = this.m_smbPkt.getBuffer().length - 4;
                nt.packInt(maxBufSize);
                nt.packInt(0);
                nt.packInt((int)(System.currentTimeMillis() & 0xFFFFFFFFL));
                int srvCapabs = auth.getServerCapabilities();
                if (!extendedSecurity) {
                    srvCapabs &= Integer.MAX_VALUE;
                }
                nt.packInt(srvCapabs);
                long srvTime = NTTime.toNTTime(new Date(System.currentTimeMillis()));
                nt.packLong(srvTime);
                nt.packWord(this.getServer().getConfiguration().getTimeZoneOffset());
                nt.packByte(auth.getEncryptionKeyLength());
                this.m_smbPkt.setFlags(this.getDefaultFlags());
                this.m_smbPkt.setFlags2(this.getDefaultFlags2());
                this.m_smbPkt.setTreeId(0);
                this.m_smbPkt.setUserId(0);
                try {
                    auth.generateNegotiateResponse(this, this.m_smbPkt, extendedSecurity);
                }
                catch (AuthenticatorException ex) {
                    if (logger.isErrorEnabled()) {
                        logger.error((Object)"Negotiate error", (Throwable)ex);
                    }
                    this.setState(5);
                    return;
                }
            }
        }
        if (!this.m_smbPkt.isResponse()) {
            this.m_smbPkt.setFlags(this.m_smbPkt.getFlags() + 128);
        }
        this.m_pktHandler.writePacket(this.m_smbPkt, this.m_smbPkt.getLength());
        if (this.m_dialect == -1) {
            this.setState(5);
        } else if (Dialect.DialectSupportsCommand(this.m_dialect, 115)) {
            this.setState(2);
        } else {
            this.setState(3);
        }
        if (this.m_dialect != -1) {
            this.getSMBServer().sessionOpened(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeConnection(int treeId) {
        if (this.m_connections == null) {
            return;
        }
        Hashtable<Integer, TreeConnection> hashtable = this.m_connections;
        synchronized (hashtable) {
            Integer key = new Integer(treeId);
            TreeConnection tree = this.m_connections.get(key);
            if (tree != null) {
                tree.closeConnection(this);
                this.m_connections.remove(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            if (logger.isDebugEnabled() && this.hasDebug(4)) {
                logger.debug((Object)"Server session started");
            }
            while (this.m_state != 5) {
                block33: {
                    this.m_rxlen = -1;
                    this.m_rxlen = this.m_pktHandler.readPacket(this.m_smbPkt);
                    if (this.m_rxlen == 0) continue;
                    if (this.m_rxlen == -1) {
                        this.hangupSession("Remote disconnect");
                        continue;
                    }
                    this.m_smbPkt.setReceivedLength(this.m_rxlen);
                    ++this.m_reqCount;
                    switch (this.m_state) {
                        case 0: {
                            this.procNetBIOSSessionRequest();
                            break;
                        }
                        case 1: {
                            this.procSMBNegotiate();
                            break;
                        }
                        case 2: {
                            this.m_handler.runProtocol();
                            break;
                        }
                        case 3: {
                            this.runHandler();
                        }
                    }
                    try {
                        this.endTransaction();
                    }
                    catch (Exception ex) {
                        if (!logger.isDebugEnabled()) break block33;
                        logger.debug((Object)"Error committing transaction", (Throwable)ex);
                    }
                }
                Thread.yield();
            }
        }
        catch (SocketException ex) {
            logger.error((Object)"Socket closed by remote client");
        }
        catch (Exception ex) {
            if (!this.isShutdown()) {
                logger.error((Object)"Closing session due to exception", (Throwable)ex);
            }
        }
        catch (Throwable ex) {
            logger.error((Object)"Closing session due to throwable", ex);
        }
        finally {
            if (this.hasUserTransaction()) {
                try {
                    this.getUserTransaction().rollback();
                }
                catch (Exception ex) {
                    logger.warn((Object)"Failed to rollback transaction", (Throwable)ex);
                }
            }
        }
        this.cleanupSession();
        if (logger.isDebugEnabled() && this.hasDebug(2)) {
            logger.debug((Object)"Server session closed");
        }
        this.closeSocket();
        this.getSMBServer().sessionClosed(this);
    }

    protected final void runHandler() throws IOException, SMBSrvException, TooManyConnectionsException {
        if (this.m_rxlen < 4) {
            return;
        }
        if (logger.isDebugEnabled() && this.hasDebug(8192)) {
            logger.debug((Object)("Rx packet type - " + this.m_smbPkt.getPacketTypeString() + ", SID=" + this.m_smbPkt.getSID()));
        }
        if (!this.m_handler.runProtocol()) {
            this.sendErrorResponseSMB(65535, 2);
        }
        while (this.hasAsynchResponse()) {
            SMBSrvPacket asynchPkt = this.removeFirstAsynchResponse();
            this.sendResponseSMB(asynchPkt, asynchPkt.getLength());
            if (!logger.isDebugEnabled() || !this.hasDebug(65536)) continue;
            logger.debug((Object)("Sent queued asynch response type=" + asynchPkt.getPacketTypeString() + ", mid=" + asynchPkt.getMultiplexId() + ", pid=" + asynchPkt.getProcessId()));
        }
    }

    public final void sendResponseSMB(SMBSrvPacket pkt) throws IOException {
        this.sendResponseSMB(pkt, pkt.getLength());
    }

    public final synchronized void sendResponseSMB(SMBSrvPacket pkt, int len) throws IOException {
        if (!pkt.isResponse()) {
            pkt.setFlags(pkt.getFlags() + 128);
        }
        pkt.setFlags(pkt.getFlags() | this.getDefaultFlags());
        int flags2 = pkt.getFlags2() | this.getDefaultFlags2();
        pkt.setFlags2(flags2 &= 0xFFFFEFF9);
        this.m_pktHandler.writePacket(pkt, len);
        this.m_pktHandler.flushPacket();
    }

    public final void sendSuccessResponseSMB() throws IOException {
        if (!this.m_smbPkt.isResponse()) {
            this.m_smbPkt.setFlags(this.m_smbPkt.getFlags() + 128);
        }
        this.m_smbPkt.setFlags(this.m_smbPkt.getFlags() | this.getDefaultFlags());
        this.m_smbPkt.setFlags2(this.m_smbPkt.getFlags2() | this.getDefaultFlags2());
        this.m_smbPkt.setParameterCount(0);
        this.m_smbPkt.setByteCount(0);
        if (this.m_smbPkt.isLongErrorCode()) {
            this.m_smbPkt.setLongErrorCode(0);
        } else {
            this.m_smbPkt.setErrorClass(0);
            this.m_smbPkt.setErrorCode(0);
        }
        this.sendResponseSMB(this.m_smbPkt, this.m_smbPkt.getLength());
    }

    public final void sendErrorResponseSMB(int ntCode, int stdCode, int stdClass) throws IOException {
        if (this.m_smbPkt.isLongErrorCode()) {
            this.sendErrorResponseSMB(ntCode, 6);
        } else {
            this.sendErrorResponseSMB(stdCode, stdClass);
        }
    }

    public final void sendErrorResponseSMB(int errCode, int errClass) throws IOException {
        if (!this.m_smbPkt.isResponse()) {
            this.m_smbPkt.setFlags(this.m_smbPkt.getFlags() + 128);
        }
        this.m_smbPkt.setParameterCount(0);
        this.m_smbPkt.setByteCount(0);
        this.m_smbPkt.setFlags(this.m_smbPkt.getFlags() | this.getDefaultFlags());
        this.m_smbPkt.setFlags2(this.m_smbPkt.getFlags2() | this.getDefaultFlags2());
        if (errClass == 6) {
            if (!this.m_smbPkt.isLongErrorCode()) {
                this.m_smbPkt.setFlags2(this.m_smbPkt.getFlags2() + 16384);
            }
            this.m_smbPkt.setLongErrorCode(errCode);
        } else {
            if (this.m_smbPkt.isLongErrorCode()) {
                this.m_smbPkt.setFlags2(this.m_smbPkt.getFlags2() - 16384);
            }
            this.m_smbPkt.setErrorCode(errCode);
            this.m_smbPkt.setErrorClass(errClass);
        }
        this.sendResponseSMB(this.m_smbPkt, this.m_smbPkt.getLength());
        if (logger.isDebugEnabled() && this.hasDebug(1024)) {
            logger.debug((Object)("Error : Cmd = " + this.m_smbPkt.getPacketTypeString() + " - " + SMBErrorText.ErrorString(errClass, errCode)));
        }
    }

    public final boolean sendAsynchResponseSMB(SMBSrvPacket pkt, int len) throws IOException {
        boolean sts = false;
        if (this.m_rxlen == -1 && this.m_pktHandler.availableBytes() == 0) {
            this.sendResponseSMB(pkt, len);
            this.m_pktHandler.flushPacket();
            sts = true;
        } else {
            this.queueAsynchResponseSMB(pkt);
        }
        return sts;
    }

    protected final synchronized void queueAsynchResponseSMB(SMBSrvPacket pkt) {
        if (this.m_asynchQueue == null) {
            this.m_asynchQueue = new Vector();
        }
        this.m_asynchQueue.addElement(pkt);
    }

    protected final synchronized boolean hasAsynchResponse() {
        return this.m_asynchQueue != null && this.m_asynchQueue.size() > 0;
    }

    protected final synchronized SMBSrvPacket removeFirstAsynchResponse() {
        if (this.m_asynchQueue == null || this.m_asynchQueue.size() == 0) {
            return null;
        }
        return this.m_asynchQueue.remove(0);
    }

    public final NotifyRequest findNotifyRequest(int mid, int tid, int uid, int pid) {
        if (this.m_notifyList == null) {
            return null;
        }
        return this.m_notifyList.findRequest(mid, tid, uid, pid);
    }

    public final NotifyRequest findNotifyRequest(NetworkFile dir, int filter, boolean watchTree) {
        if (this.m_notifyList == null) {
            return null;
        }
        return this.m_notifyList.findRequest(dir, filter, watchTree);
    }

    public final void addNotifyRequest(NotifyRequest req, DiskDeviceContext ctx) {
        if (this.m_notifyList == null) {
            this.m_notifyList = new NotifyRequestList();
        }
        this.m_notifyList.addRequest(req);
        ctx.addNotifyRequest(req);
    }

    public final void removeNotifyRequest(NotifyRequest req) {
        if (this.m_notifyList == null) {
            return;
        }
        this.m_notifyList.removeRequest(req);
        if (req.getDiskContext() != null) {
            req.getDiskContext().removeNotifyRequest(req);
        }
    }

    protected final boolean hasTransaction() {
        return this.m_transact != null;
    }

    protected final SrvTransactBuffer getTransaction() {
        return this.m_transact;
    }

    protected final void setTransaction(SrvTransactBuffer buf) {
        this.m_transact = buf;
    }
}

