/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.smb.server;

import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import org.alfresco.filesys.server.config.ServerConfiguration;
import org.alfresco.filesys.smb.server.SMBServer;
import org.alfresco.filesys.smb.server.SMBSrvSession;
import org.alfresco.filesys.smb.server.SessionSocketHandler;
import org.alfresco.filesys.smb.server.TcpipSMBPacketHandler;

public class TcpipSMBSessionSocketHandler
extends SessionSocketHandler {
    private static final ThreadGroup THREAD_GROUP_SESSION = new ThreadGroup("SMB_SESSION_GROUP");

    public TcpipSMBSessionSocketHandler(SMBServer srv, int port, InetAddress bindAddr, boolean debug) {
        super("TCP-SMB", srv, port, bindAddr, debug);
    }

    public void run() {
        block10: {
            try {
                this.clearShutdown();
                while (!this.hasShutdown()) {
                    if (logger.isDebugEnabled() && this.hasDebug()) {
                        logger.debug((Object)"Waiting for TCP-SMB session request ...");
                    }
                    Socket sessSock = this.getSocket().accept();
                    if (logger.isDebugEnabled() && this.hasDebug()) {
                        logger.debug((Object)("TCP-SMB session request received from " + sessSock.getInetAddress().getHostAddress()));
                    }
                    try {
                        TcpipSMBPacketHandler pktHandler = new TcpipSMBPacketHandler(sessSock);
                        SMBSrvSession srvSess = new SMBSrvSession(pktHandler, this.getServer());
                        srvSess.setSessionId(this.getNextSessionId());
                        srvSess.setUniqueId(pktHandler.getShortName() + srvSess.getSessionId());
                        srvSess.setDebugPrefix("[" + pktHandler.getShortName() + srvSess.getSessionId() + "] ");
                        this.getServer().addSession(srvSess);
                        Thread srvThread = new Thread(THREAD_GROUP_SESSION, srvSess);
                        srvThread.setDaemon(true);
                        srvThread.setName("Sess_T" + srvSess.getSessionId() + "_" + sessSock.getInetAddress().getHostAddress());
                        srvThread.start();
                    }
                    catch (Exception ex) {
                        logger.error((Object)"TCP-SMB Failed to create session, ", (Throwable)ex);
                    }
                }
            }
            catch (SocketException ex) {
                if (!this.hasShutdown()) {
                    logger.error((Object)"TCP-SMB Socket error : ", (Throwable)ex);
                }
            }
            catch (Exception ex) {
                if (this.hasShutdown()) break block10;
                logger.error((Object)"TCP-SMB Server error : ", (Throwable)ex);
            }
        }
        if (logger.isDebugEnabled() && this.hasDebug()) {
            logger.debug((Object)"TCP-SMB session handler closed");
        }
    }

    public static final void createSessionHandlers(SMBServer server, boolean sockDbg) throws Exception {
        ServerConfiguration config = server.getConfiguration();
        TcpipSMBSessionSocketHandler sessHandler = new TcpipSMBSessionSocketHandler(server, 445, config.getSMBBindAddress(), sockDbg);
        sessHandler.initialize();
        server.addSessionHandler(sessHandler);
        Thread tcpThread = new Thread(sessHandler);
        tcpThread.setName("TcpipSMB_Handler");
        tcpThread.start();
        if (logger.isDebugEnabled() && sockDbg) {
            logger.debug((Object)"Native SMB TCP session handler created");
        }
    }
}

