/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.smb.server.notify;

import java.util.Date;
import org.alfresco.filesys.server.filesys.DiskDeviceContext;
import org.alfresco.filesys.server.filesys.NetworkFile;
import org.alfresco.filesys.smb.server.SMBSrvSession;
import org.alfresco.filesys.smb.server.notify.NotifyChangeEvent;
import org.alfresco.filesys.smb.server.notify.NotifyChangeEventList;

public class NotifyRequest {
    public static final long DefaultRequestTimeout = 10000L;
    private int m_filter;
    private boolean m_watchTree;
    private SMBSrvSession m_sess;
    private NetworkFile m_watchDir;
    private String m_watchPath;
    private int m_mid;
    private int m_tid;
    private int m_pid;
    private int m_uid;
    private int m_maxQueueLen;
    private DiskDeviceContext m_diskCtx;
    private NotifyChangeEventList m_bufferedEvents;
    private boolean m_completed;
    private long m_expiresAt;
    private boolean m_notifyEnum;

    public NotifyRequest(int filter, boolean watchTree, SMBSrvSession sess, NetworkFile dir, int mid, int tid, int pid, int uid, int qlen) {
        this.m_filter = filter;
        this.m_watchTree = watchTree;
        this.m_sess = sess;
        this.m_watchDir = dir;
        this.m_mid = mid;
        this.m_tid = tid;
        this.m_pid = pid;
        this.m_uid = uid;
        this.m_maxQueueLen = qlen;
        this.m_watchPath = this.m_watchDir.getFullName().toUpperCase();
        if (this.m_watchPath.length() == 0) {
            this.m_watchPath = "\\";
        } else if (this.m_watchPath.indexOf(47) != -1) {
            this.m_watchPath.replace('/', '\\');
        }
    }

    public final int getFilter() {
        return this.m_filter;
    }

    public final boolean isCompleted() {
        return this.m_completed;
    }

    public final boolean hasExpired(long curTime) {
        if (!this.isCompleted()) {
            return false;
        }
        return this.m_expiresAt < curTime;
    }

    public final boolean hasFileNameChange() {
        return this.hasFilter(1);
    }

    public final boolean hasDirectoryNameChange() {
        return this.hasFilter(2);
    }

    public final boolean hasAttributeChange() {
        return this.hasFilter(4);
    }

    public final boolean hasFileSizeChange() {
        return this.hasFilter(8);
    }

    public final boolean hasFileWriteTimeChange() {
        return this.hasFilter(16);
    }

    public final boolean hasFileAccessTimeChange() {
        return this.hasFilter(32);
    }

    public final boolean hasFileCreateTimeChange() {
        return this.hasFilter(64);
    }

    public final boolean hasSecurityDescriptorChange() {
        return this.hasFilter(256);
    }

    public final boolean hasFilter(int flag) {
        return (this.m_filter & flag) != 0;
    }

    public final boolean hasNotifyEnum() {
        return this.m_notifyEnum;
    }

    public final boolean hasWatchTree() {
        return this.m_watchTree;
    }

    public final SMBSrvSession getSession() {
        return this.m_sess;
    }

    public final NetworkFile getDirectory() {
        return this.m_watchDir;
    }

    public final String getWatchPath() {
        return this.m_watchPath;
    }

    public final int getMultiplexId() {
        return this.m_mid;
    }

    public final int getTreeId() {
        return this.m_tid;
    }

    public final int getProcessId() {
        return this.m_pid;
    }

    public final int getUserId() {
        return this.m_uid;
    }

    public final long getExpiryTime() {
        return this.m_expiresAt;
    }

    public final DiskDeviceContext getDiskContext() {
        return this.m_diskCtx;
    }

    public final int getMaximumQueueLength() {
        return this.m_maxQueueLen;
    }

    public final boolean hasBufferedEvents() {
        return this.m_bufferedEvents != null && this.m_bufferedEvents.numberOfEvents() > 0;
    }

    public final NotifyChangeEventList getBufferedEventList() {
        return this.m_bufferedEvents;
    }

    public final void addEvent(NotifyChangeEvent evt) {
        if (this.hasNotifyEnum()) {
            return;
        }
        if (this.m_bufferedEvents == null) {
            this.m_bufferedEvents = new NotifyChangeEventList();
        }
        if (this.m_bufferedEvents.numberOfEvents() < this.getMaximumQueueLength()) {
            this.m_bufferedEvents.addEvent(evt);
        } else {
            this.removeAllEvents();
            this.setNotifyEnum(true);
        }
    }

    public final void removeAllEvents() {
        if (this.m_bufferedEvents != null) {
            this.m_bufferedEvents.removeAllEvents();
            this.m_bufferedEvents = null;
        }
    }

    public final void clearBufferedEvents() {
        this.m_bufferedEvents = null;
    }

    public final void setNotifyEnum(boolean ena) {
        this.m_notifyEnum = ena;
    }

    protected final void setDiskContext(DiskDeviceContext ctx) {
        this.m_diskCtx = ctx;
    }

    public final void setMultiplexId(int mid) {
        this.m_mid = mid;
    }

    public final void setCompleted(boolean comp) {
        this.m_completed = comp;
        if (comp) {
            this.m_expiresAt = System.currentTimeMillis() + 10000L;
        }
    }

    public final void setCompleted(boolean comp, long expires) {
        this.m_completed = comp;
        this.m_expiresAt = expires;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[");
        str.append(this.getSession().getUniqueId());
        str.append(":");
        if (this.getWatchPath().length() == 0) {
            str.append("Root");
        } else {
            str.append(this.getWatchPath());
        }
        str.append(":");
        if (this.hasFileNameChange()) {
            str.append("File,");
        }
        if (this.hasDirectoryNameChange()) {
            str.append("Dir,");
        }
        if (this.hasAttributeChange()) {
            str.append("Attr,");
        }
        if (this.hasFileSizeChange()) {
            str.append("Size,");
        }
        if (this.hasFileWriteTimeChange()) {
            str.append("Write,");
        }
        if (this.hasFileAccessTimeChange()) {
            str.append("Access,");
        }
        if (this.hasFileCreateTimeChange()) {
            str.append("Create,");
        }
        if (this.hasSecurityDescriptorChange()) {
            str.append("Security,");
        }
        if (this.hasWatchTree()) {
            str.append("Tree");
        } else {
            str.append("NoTree");
        }
        str.append(" MID=");
        str.append(this.getMultiplexId());
        str.append(" PID=");
        str.append(this.getProcessId());
        str.append(" TID=");
        str.append(this.getTreeId());
        str.append(" UID=");
        str.append(this.getUserId());
        if (this.isCompleted()) {
            str.append(",Completed,TMO=");
            str.append(new Date(this.getExpiryTime()).toString());
        }
        str.append(",Queue=");
        str.append(this.getMaximumQueueLength());
        if (this.hasBufferedEvents()) {
            str.append("/");
            str.append(this.getBufferedEventList().numberOfEvents());
        }
        if (this.hasNotifyEnum()) {
            str.append(",ENUM");
        }
        str.append("]");
        return str.toString();
    }
}

