/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.smb.server.ntfs;

public class StreamInfo {
    public static final String StreamSeparator = ":";
    public static final int SetStreamSize = 1;
    public static final int SetAllocationSize = 2;
    public static final int SetModifyDate = 4;
    public static final int SetCreationDate = 8;
    public static final int SetAccessDate = 16;
    private String m_path;
    private String m_name;
    private int m_fid;
    private int m_stid;
    private long m_size;
    private long m_allocSize;
    private long m_createDate;
    private long m_modifyDate;
    private long m_accessDate;
    private int m_setFlags;

    public StreamInfo() {
    }

    public StreamInfo(String path) {
        this.parsePath(path);
    }

    public StreamInfo(String name, int fid, int stid) {
        this.m_name = name;
        this.m_fid = fid;
        this.m_stid = stid;
    }

    public StreamInfo(String name, int fid, int stid, long size, long alloc) {
        this.m_name = name;
        this.m_fid = fid;
        this.m_stid = stid;
        this.m_size = size;
        this.m_allocSize = alloc;
    }

    public final String getPath() {
        return this.m_path;
    }

    public final String getName() {
        return this.m_name;
    }

    public final int getFileId() {
        return this.m_fid;
    }

    public final int getStreamId() {
        return this.m_stid;
    }

    public long getAccessDateTime() {
        return this.m_accessDate;
    }

    public long getCreationDateTime() {
        return this.m_createDate;
    }

    public final long getModifyDateTime() {
        return this.m_modifyDate;
    }

    public final long getSize() {
        return this.m_size;
    }

    public final long getAllocationSize() {
        return this.m_allocSize;
    }

    public boolean hasAccessDateTime() {
        return this.m_accessDate != 0L;
    }

    public boolean hasCreationDateTime() {
        return this.m_createDate != 0L;
    }

    public boolean hasModifyDateTime() {
        return this.m_modifyDate != 0L;
    }

    public final boolean hasSetFlag(int flag) {
        return (this.m_setFlags & flag) != 0;
    }

    public final int getSetStreamInformationFlags() {
        return this.m_setFlags;
    }

    public final void setPath(String path) {
        this.parsePath(path);
    }

    public final void setName(String name) {
        this.m_name = name;
    }

    public void setAccessDateTime(long timesec) {
        this.m_accessDate = timesec;
    }

    public void setCreationDateTime(long timesec) {
        this.m_createDate = timesec;
    }

    public void setModifyDateTime(long timesec) {
        this.m_modifyDate = timesec;
    }

    public final void setFileId(int id) {
        this.m_fid = id;
    }

    public final void setStreamId(int id) {
        this.m_stid = id;
    }

    public final void setSize(long size) {
        this.m_size = size;
    }

    public final void setAllocationSize(long alloc) {
        this.m_allocSize = alloc;
    }

    public final void setStreamInformationFlags(int setFlags) {
        this.m_setFlags = setFlags;
    }

    protected final void parsePath(String path) {
        int pos = path.indexOf(StreamSeparator);
        if (pos == -1) {
            this.m_path = path;
            return;
        }
        this.m_path = path.substring(0, pos);
        this.m_name = path.substring(pos + 1);
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[");
        str.append(this.getName());
        str.append(",");
        str.append(this.getFileId());
        str.append(StreamSeparator);
        str.append(this.getStreamId());
        str.append(",");
        str.append(this.getSize());
        str.append("/");
        str.append(this.getAllocationSize());
        str.append("]");
        return str.toString();
    }
}

