/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.smb.server.repo;

import java.io.FileNotFoundException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.filesys.server.filesys.FileInfo;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.model.FileExistsException;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.SearchLanguageConversion;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CifsHelper {
    private static Log logger = LogFactory.getLog(CifsHelper.class);
    private DictionaryService dictionaryService;
    private NodeService nodeService;
    private FileFolderService fileFolderService;
    private MimetypeService mimetypeService;
    private PermissionService permissionService;
    private boolean isReadOnly = false;
    private boolean lockedFilesAsOffline;

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public void setMimetypeService(MimetypeService mimetypeService) {
        this.mimetypeService = mimetypeService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public void setAllowWrites(boolean allowWrites) {
        this.isReadOnly = !allowWrites;
    }

    public final void setMarkLockedFilesAsOffline(boolean ena) {
        this.lockedFilesAsOffline = ena;
    }

    public final boolean hasLockedFilesAsOffline() {
        return this.lockedFilesAsOffline;
    }

    public boolean isDirectory(NodeRef nodeRef) {
        QName nodeTypeQName = this.nodeService.getType(nodeRef);
        if (this.dictionaryService.isSubClass(nodeTypeQName, ContentModel.TYPE_FOLDER)) {
            return true;
        }
        if (this.dictionaryService.isSubClass(nodeTypeQName, ContentModel.TYPE_CONTENT)) {
            return false;
        }
        return false;
    }

    public FileInfo getFileInformation(NodeRef pathRootNodeRef, String path) throws FileNotFoundException {
        NodeRef nodeRef = this.getNodeRef(pathRootNodeRef, path);
        FileInfo fileInfo = this.getFileInformation(nodeRef);
        return fileInfo;
    }

    public FileInfo getFileInformation(NodeRef nodeRef) throws FileNotFoundException {
        int attr;
        boolean deniedPermission;
        String name;
        Date modifiedDate;
        org.alfresco.service.cmr.model.FileInfo fileFolderInfo = this.fileFolderService.getFileInfo(nodeRef);
        FileInfo fileInfo = new FileInfo();
        int fileAttributes = 0;
        fileInfo.setFileAttributes(fileAttributes);
        if (fileFolderInfo.isFolder()) {
            fileInfo.setFileAttributes(fileAttributes |= 0x10);
        } else {
            String lockTypeStr;
            Map<QName, Serializable> nodeProperties = fileFolderInfo.getProperties();
            ContentData contentData = (ContentData)nodeProperties.get(ContentModel.PROP_CONTENT);
            long size = 0L;
            if (contentData != null) {
                size = contentData.getSize();
            }
            fileInfo.setSize(size);
            if (size > 0L) {
                fileInfo.setAllocationSize(size + 512L & 0xFFFFFFFFFFFFFE00L);
            }
            if ((lockTypeStr = (String)((Object)nodeProperties.get(ContentModel.PROP_LOCK_TYPE))) != null) {
                int attr2 = fileInfo.getFileAttributes();
                if ((attr2 & 1) == 0) {
                    ++attr2;
                }
                if (this.hasLockedFilesAsOffline()) {
                    attr2 += 4096;
                }
                fileInfo.setFileAttributes(attr2);
            }
        }
        Date createdDate = fileFolderInfo.getCreatedDate();
        if (createdDate != null) {
            long created = DefaultTypeConverter.INSTANCE.longValue(createdDate);
            fileInfo.setCreationDateTime(created);
        }
        if ((modifiedDate = fileFolderInfo.getModifiedDate()) != null) {
            long modified = DefaultTypeConverter.INSTANCE.longValue(modifiedDate);
            fileInfo.setModifyDateTime(modified);
            fileInfo.setAccessDateTime(modified);
        }
        if ((name = fileFolderInfo.getName()) != null) {
            fileInfo.setFileName(name);
        }
        boolean bl = deniedPermission = this.permissionService.hasPermission(nodeRef, "Write") == AccessStatus.DENIED;
        if ((this.isReadOnly || deniedPermission) && ((attr = fileInfo.getFileAttributes()) & 1) == 0) {
            fileInfo.setFileAttributes(++attr);
        }
        if (fileInfo.getFileAttributes() == 0) {
            fileInfo.setFileAttributes(128);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Fetched file info: \n   info: " + fileInfo));
        }
        return fileInfo;
    }

    public NodeRef createNode(NodeRef rootNodeRef, String path, boolean isFile) throws org.alfresco.filesys.server.filesys.FileExistsException {
        StringTokenizer tokenizer = new StringTokenizer(path, "\\", false);
        ArrayList<String> folderPathElements = new ArrayList<String>(10);
        String name = null;
        while (tokenizer.hasMoreTokens()) {
            String pathElement = tokenizer.nextToken();
            if (!tokenizer.hasMoreTokens()) {
                name = pathElement;
                continue;
            }
            folderPathElements.add(pathElement);
        }
        NodeRef parentFolderNodeRef = rootNodeRef;
        if (folderPathElements.size() > 0) {
            parentFolderNodeRef = this.fileFolderService.makeFolders(rootNodeRef, folderPathElements, ContentModel.TYPE_FOLDER).getNodeRef();
        }
        QName typeQName = isFile ? ContentModel.TYPE_CONTENT : ContentModel.TYPE_FOLDER;
        try {
            NodeRef nodeRef = this.fileFolderService.create(parentFolderNodeRef, name, typeQName).getNodeRef();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Created node: \n   device root: " + rootNodeRef + "\n" + "   path: " + path + "\n" + "   is file: " + isFile + "\n" + "   new node: " + nodeRef));
            }
            return nodeRef;
        }
        catch (FileExistsException e) {
            throw new org.alfresco.filesys.server.filesys.FileExistsException(path);
        }
    }

    private void addDescendents(List<NodeRef> pathRootNodeRefs, Stack<String> pathElements, List<NodeRef> results) {
        if (pathElements.isEmpty()) {
            results.addAll(pathRootNodeRefs);
            return;
        }
        String pathElement = pathElements.pop();
        for (NodeRef pathRootNodeRef : pathRootNodeRefs) {
            if (results.contains(pathRootNodeRef)) continue;
            List<NodeRef> directDescendents = this.getDirectDescendents(pathRootNodeRef, pathElement);
            this.addDescendents(directDescendents, pathElements, results);
        }
        pathElements.push(pathElement);
    }

    private List<NodeRef> getDirectDescendents(NodeRef pathRootNodeRef, String pathElement) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Getting direct descendents: \n   Path Root: " + pathRootNodeRef + "\n" + "   Path Element: " + pathElement));
        }
        String escapedPathElement = SearchLanguageConversion.convertCifsToLucene(pathElement);
        List<org.alfresco.service.cmr.model.FileInfo> childInfos = this.fileFolderService.search(pathRootNodeRef, escapedPathElement, false);
        ArrayList<NodeRef> results = new ArrayList<NodeRef>(childInfos.size());
        for (org.alfresco.service.cmr.model.FileInfo info : childInfos) {
            results.add(info.getNodeRef());
        }
        return results;
    }

    public List<NodeRef> getNodeRefs(NodeRef pathRootNodeRef, String path) {
        StringTokenizer tokenizer = new StringTokenizer(path, "\\", false);
        String[] tokens = new String[tokenizer.countTokens()];
        int count = 0;
        while (tokenizer.hasMoreTokens()) {
            tokens[count] = tokenizer.nextToken();
            ++count;
        }
        Stack<String> pathElements = new Stack<String>();
        for (int i = tokens.length - 1; i >= 0; --i) {
            pathElements.push(tokens[i]);
        }
        List<NodeRef> pathRootNodeRefs = Collections.singletonList(pathRootNodeRef);
        ArrayList<NodeRef> results = new ArrayList<NodeRef>(5);
        this.addDescendents(pathRootNodeRefs, pathElements, results);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Retrieved node references for path: \n   path root: " + pathRootNodeRef + "\n" + "   path: " + path + "\n" + "   results: " + results));
        }
        return results;
    }

    public NodeRef getNodeRef(NodeRef pathRootNodeRef, String path) throws FileNotFoundException {
        List<NodeRef> nodeRefs = this.getNodeRefs(pathRootNodeRef, path);
        if (nodeRefs.size() == 0) {
            throw new FileNotFoundException(path);
        }
        if (nodeRefs.size() > 1) {
            logger.warn((Object)("Multiple matching nodes: \n   search root: " + pathRootNodeRef + "\n" + "   path: " + path));
        }
        NodeRef nodeRef = nodeRefs.get(0);
        return nodeRef;
    }

    public void relinkNode(NodeRef tempNodeRef, NodeRef nodeToMoveRef, NodeRef newParentNodeRef, String newName) throws FileNotFoundException, org.alfresco.filesys.server.filesys.FileExistsException {
        org.alfresco.service.cmr.model.FileInfo tempFileInfo = this.fileFolderService.getFileInfo(tempNodeRef);
        org.alfresco.service.cmr.model.FileInfo fileToMoveInfo = this.fileFolderService.getFileInfo(nodeToMoveRef);
        String tempName = tempFileInfo.getName();
        try {
            this.fileFolderService.rename(tempNodeRef, newName);
            this.fileFolderService.rename(nodeToMoveRef, tempName);
        }
        catch (org.alfresco.service.cmr.model.FileNotFoundException e) {
            throw new FileNotFoundException(e.getMessage());
        }
        catch (FileExistsException e) {
            throw new org.alfresco.filesys.server.filesys.FileExistsException(e.getMessage());
        }
        if (!tempFileInfo.isFolder() && !fileToMoveInfo.isFolder()) {
            ContentData oldContentData = tempFileInfo.getContentData();
            if (oldContentData == null) {
                String mimetype = this.mimetypeService.guessMimetype(tempName);
                oldContentData = ContentData.setMimetype(null, mimetype);
            }
            ContentData newContentData = fileToMoveInfo.getContentData();
            String mimetype = this.mimetypeService.guessMimetype(newName);
            newContentData = ContentData.setMimetype(newContentData, mimetype);
            this.nodeService.setProperty(tempNodeRef, ContentModel.PROP_CONTENT, newContentData);
            this.nodeService.setProperty(nodeToMoveRef, ContentModel.PROP_CONTENT, oldContentData);
        }
    }

    public void move(NodeRef nodeToMoveRef, NodeRef newParentNodeRef, String newName) throws org.alfresco.filesys.server.filesys.FileExistsException {
        try {
            this.fileFolderService.move(nodeToMoveRef, newParentNodeRef, newName);
        }
        catch (FileExistsException e) {
            throw new org.alfresco.filesys.server.filesys.FileExistsException(newName);
        }
        catch (Throwable e) {
            throw new AlfrescoRuntimeException("Move failed: \n   node to move: " + nodeToMoveRef + "\n" + "   new parent: " + newParentNodeRef + "\n" + "   new name: " + newName, e);
        }
    }

    public String getFileName(NodeRef node) {
        String fname = null;
        try {
            fname = (String)((Object)this.nodeService.getProperty(node, ContentModel.PROP_NAME));
        }
        catch (InvalidNodeRefException invalidNodeRefException) {
            // empty catch block
        }
        return fname;
    }
}

