/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.smb.server.repo;

import org.alfresco.filesys.CIFSServer;
import org.alfresco.filesys.server.filesys.DiskSharedDevice;
import org.alfresco.filesys.smb.server.repo.ContentContext;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.util.BaseAlfrescoTestCase;

public class CifsIntegrationTest
extends BaseAlfrescoTestCase {
    public void testGetServerName() {
        CIFSServer cifsServer = (CIFSServer)ctx.getBean("cifsServer");
        CifsIntegrationTest.assertNotNull((String)"No CIFS server available", (Object)cifsServer);
        if (!cifsServer.isStarted()) {
            return;
        }
        String serverName = cifsServer.getConfiguration().getServerName();
        CifsIntegrationTest.assertNotNull((String)"No server name available", (Object)serverName);
        CifsIntegrationTest.assertTrue((String)"No server name available (zero length)", (serverName.length() > 0 ? 1 : 0) != 0);
        DiskSharedDevice mainFilesys = cifsServer.getConfiguration().getPrimaryFilesystem();
        if (mainFilesys != null) {
            String shareName = mainFilesys.getName();
            CifsIntegrationTest.assertNotNull((String)"No share name available", (Object)shareName);
            CifsIntegrationTest.assertTrue((String)"No share name available (zero length)", (shareName.length() > 0 ? 1 : 0) != 0);
            ContentContext filesysCtx = (ContentContext)mainFilesys.getContext();
            CifsIntegrationTest.assertNotNull((String)"Content context is null", (Object)filesysCtx);
            CifsIntegrationTest.assertNotNull((String)"Store id is null", (Object)filesysCtx.getStoreName());
            CifsIntegrationTest.assertNotNull((String)"Root path is null", (Object)filesysCtx.getRootPath());
            CifsIntegrationTest.assertNotNull((String)"Root node is null", (Object)filesysCtx.getRootNode());
            NodeService nodeService = (NodeService)ctx.getBean(ServiceRegistry.NODE_SERVICE.getLocalName());
            NodeRef shareNodeRef = filesysCtx.getRootNode();
            CifsIntegrationTest.assertNotNull((String)"No share root node available", (Object)shareNodeRef);
            CifsIntegrationTest.assertTrue((String)"Share root node doesn't exist", (boolean)nodeService.exists(shareNodeRef));
        }
    }
}

