/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.smb.server.repo;

import org.alfresco.filesys.server.filesys.DiskDeviceContext;
import org.alfresco.filesys.smb.server.repo.FileStateTable;
import org.alfresco.filesys.smb.server.repo.pseudo.PseudoFile;
import org.alfresco.service.cmr.repository.NodeRef;

public class ContentContext
extends DiskDeviceContext {
    private String m_storeName;
    private String m_rootPath;
    private NodeRef m_rootNodeRef;
    private FileStateTable m_stateTable;
    private PseudoFile m_dragAndDropApp;
    private String m_urlPathPrefix;
    private String m_urlFileName;

    public ContentContext(String storeName, String rootPath, NodeRef rootNodeRef) {
        super(rootNodeRef.toString());
        this.m_storeName = storeName;
        this.m_rootPath = rootPath;
        this.m_rootNodeRef = rootNodeRef;
        this.m_stateTable = new FileStateTable();
    }

    public String getFilesystemType() {
        return "NTFS";
    }

    public final String getStoreName() {
        return this.m_storeName;
    }

    public final String getRootPath() {
        return this.m_rootPath;
    }

    public final NodeRef getRootNode() {
        return this.m_rootNodeRef;
    }

    public final boolean hasStateTable() {
        return this.m_stateTable != null;
    }

    public final FileStateTable getStateTable() {
        return this.m_stateTable;
    }

    public final void enableStateTable(boolean ena) {
        if (!ena) {
            this.m_stateTable = null;
        } else if (this.m_stateTable == null) {
            this.m_stateTable = new FileStateTable();
        }
    }

    public final boolean hasDragAndDropApp() {
        return this.m_dragAndDropApp != null;
    }

    public final PseudoFile getDragAndDropApp() {
        return this.m_dragAndDropApp;
    }

    public final boolean hasURLFile() {
        return this.m_urlPathPrefix != null && this.m_urlFileName != null;
    }

    public final String getURLPrefix() {
        return this.m_urlPathPrefix;
    }

    public final String getURLFileName() {
        return this.m_urlFileName;
    }

    public final void setDragAndDropApp(PseudoFile dragDropApp) {
        this.m_dragAndDropApp = dragDropApp;
    }

    public final void setURLPrefix(String urlPrefix) {
        this.m_urlPathPrefix = urlPrefix;
    }

    public final void setURLFileName(String urlFileName) {
        this.m_urlFileName = urlFileName;
    }

    public void CloseContext() {
        if (this.hasStateTable()) {
            this.getStateTable().shutdownRequest();
        }
        super.CloseContext();
    }
}

