/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.smb.server.repo;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.transaction.UserTransaction;
import org.alfresco.config.ConfigElement;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.filesys.server.SrvSession;
import org.alfresco.filesys.server.core.DeviceContext;
import org.alfresco.filesys.server.core.DeviceContextException;
import org.alfresco.filesys.server.filesys.AccessDeniedException;
import org.alfresco.filesys.server.filesys.DiskInterface;
import org.alfresco.filesys.server.filesys.FileInfo;
import org.alfresco.filesys.server.filesys.FileName;
import org.alfresco.filesys.server.filesys.FileOpenParams;
import org.alfresco.filesys.server.filesys.FileSharingException;
import org.alfresco.filesys.server.filesys.IOControlNotImplementedException;
import org.alfresco.filesys.server.filesys.IOCtlInterface;
import org.alfresco.filesys.server.filesys.NetworkFile;
import org.alfresco.filesys.server.filesys.SearchContext;
import org.alfresco.filesys.server.filesys.SrvDiskInfo;
import org.alfresco.filesys.server.filesys.TreeConnection;
import org.alfresco.filesys.smb.SMBException;
import org.alfresco.filesys.smb.server.SMBSrvSession;
import org.alfresco.filesys.smb.server.repo.CifsHelper;
import org.alfresco.filesys.smb.server.repo.ContentContext;
import org.alfresco.filesys.smb.server.repo.ContentIOControlHandler;
import org.alfresco.filesys.smb.server.repo.ContentNetworkFile;
import org.alfresco.filesys.smb.server.repo.ContentSearchContext;
import org.alfresco.filesys.smb.server.repo.FileState;
import org.alfresco.filesys.smb.server.repo.IOControlHandler;
import org.alfresco.filesys.smb.server.repo.pseudo.ContentPseudoFileImpl;
import org.alfresco.filesys.smb.server.repo.pseudo.LocalPseudoFile;
import org.alfresco.filesys.smb.server.repo.pseudo.MemoryNetworkFile;
import org.alfresco.filesys.smb.server.repo.pseudo.PseudoFile;
import org.alfresco.filesys.smb.server.repo.pseudo.PseudoFileInterface;
import org.alfresco.filesys.smb.server.repo.pseudo.PseudoFileList;
import org.alfresco.filesys.smb.server.repo.pseudo.PseudoNetworkFile;
import org.alfresco.filesys.util.DataBuffer;
import org.alfresco.filesys.util.WildCard;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.lock.NodeLockedException;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ContentDiskDriver
implements DiskInterface,
IOCtlInterface {
    private static final Log logger = LogFactory.getLog(ContentDiskDriver.class);
    private static final String KEY_STORE = "store";
    private static final String KEY_ROOT_PATH = "rootPath";
    private static final String KEY_RELATIVE_PATH = "relativePath";
    private CifsHelper cifsHelper;
    private TransactionService transactionService;
    private NamespaceService namespaceService;
    private NodeService nodeService;
    private SearchService searchService;
    private ContentService contentService;
    private PermissionService permissionService;
    private CheckOutCheckInService checkInOutService;
    private AuthenticationComponent authComponent;
    private IOControlHandler m_ioHandler;
    private PseudoFileInterface m_pseudoFiles;

    public ContentDiskDriver(CifsHelper cifsHelper) {
        this.cifsHelper = cifsHelper;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setCheckInOutService(CheckOutCheckInService checkInOutService) {
        this.checkInOutService = checkInOutService;
    }

    public void setAuthenticationComponent(AuthenticationComponent authComponent) {
        this.authComponent = authComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeviceContext createContext(ConfigElement cfg) throws DeviceContextException {
        ConfigElement offlineFiles;
        ConfigElement urlFileElem;
        this.authComponent.setCurrentUser(this.authComponent.getSystemUserName());
        UserTransaction tx = this.transactionService.getUserTransaction(true);
        ContentContext context = null;
        try {
            ConfigElement storeElement;
            if (tx != null) {
                tx.begin();
            }
            if ((storeElement = cfg.getChild(KEY_STORE)) == null || storeElement.getValue() == null || storeElement.getValue().length() == 0) {
                throw new DeviceContextException("Device missing init value: store");
            }
            String storeValue = storeElement.getValue();
            StoreRef storeRef = new StoreRef(storeValue);
            if (!this.nodeService.exists(storeRef)) {
                throw new DeviceContextException("Store not created prior to application startup: " + storeRef);
            }
            NodeRef storeRootNodeRef = this.nodeService.getRootNode(storeRef);
            ConfigElement rootPathElement = cfg.getChild(KEY_ROOT_PATH);
            if (rootPathElement == null || rootPathElement.getValue() == null || rootPathElement.getValue().length() == 0) {
                throw new DeviceContextException("Device missing init value: rootPath");
            }
            String rootPath = rootPathElement.getValue();
            List<NodeRef> nodeRefs = this.searchService.selectNodes(storeRootNodeRef, rootPath, null, this.namespaceService, false);
            NodeRef rootNodeRef = null;
            if (nodeRefs.size() > 1) {
                throw new DeviceContextException("Multiple possible roots for device: \n   root path: " + rootPath + "\n" + "   results: " + nodeRefs);
            }
            if (nodeRefs.size() == 0) {
                throw new DeviceContextException("No root found for device: \n   root path: " + rootPath);
            }
            rootNodeRef = nodeRefs.get(0);
            ConfigElement relativePathElement = cfg.getChild(KEY_RELATIVE_PATH);
            if (relativePathElement != null) {
                String relPath = relativePathElement.getValue().replace('/', '\\');
                NodeRef relPathNode = this.cifsHelper.getNodeRef(rootNodeRef, relPath);
                if (!this.cifsHelper.isDirectory(relPathNode)) {
                    throw new DeviceContextException("Relative path is not a folder, " + relativePathElement.getValue());
                }
                rootNodeRef = relPathNode;
            }
            tx.commit();
            tx = null;
            context = new ContentContext(storeValue, rootPath, rootNodeRef);
            context.setDiskInformation(new SrvDiskInfo(2560000, 64, 512, 2304000));
            context.setFilesystemAttributes(2);
        }
        catch (Exception ex) {
            logger.error((Object)"Error during create context", (Throwable)ex);
        }
        finally {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception ex) {
                    logger.warn((Object)"Failed to rollback transaction", (Throwable)ex);
                }
            }
        }
        ConfigElement dragDropElem = cfg.getChild("dragAndDrop");
        if (dragDropElem != null) {
            ConfigElement pseudoName = dragDropElem.getChild("filename");
            ConfigElement appPath = dragDropElem.getChild("path");
            if (pseudoName != null && appPath != null) {
                URL appURL = this.getClass().getClassLoader().getResource(appPath.getValue());
                if (appURL == null) {
                    throw new DeviceContextException("Failed to find drag and drop application, " + appPath.getValue());
                }
                File appFile = new File(appURL.getFile());
                if (!appFile.exists()) {
                    throw new DeviceContextException("Drag and drop application not found, " + appPath.getValue());
                }
                LocalPseudoFile dragDropPseudo = new LocalPseudoFile(pseudoName.getValue(), appFile.getAbsolutePath());
                context.setDragAndDropApp(dragDropPseudo);
            }
            try {
                this.m_ioHandler = new ContentIOControlHandler();
                this.m_ioHandler.initialize(this, this.cifsHelper, this.transactionService, this.nodeService, this.checkInOutService);
            }
            catch (Exception ex) {
                logger.error((Object)"Failed to initialize I/O control handler", (Throwable)ex);
                throw new DeviceContextException("Failed to initialize I/O control handler");
            }
        }
        if ((urlFileElem = cfg.getChild("urlFile")) != null) {
            ConfigElement pseudoName = urlFileElem.getChild("filename");
            ConfigElement webPath = urlFileElem.getChild("webpath");
            if (pseudoName != null && webPath != null) {
                String path = webPath.getValue();
                if (!path.endsWith("/")) {
                    path = path + "/";
                }
                if (!pseudoName.getValue().endsWith(".url")) {
                    throw new DeviceContextException("URL link file must end with .url, " + pseudoName.getValue());
                }
                context.setURLFileName(pseudoName.getValue());
                context.setURLPrefix(path);
            }
        }
        if (context.hasDragAndDropApp() || context.hasURLFile()) {
            this.m_pseudoFiles = new ContentPseudoFileImpl();
        }
        if ((offlineFiles = cfg.getChild("offlineFiles")) != null) {
            this.cifsHelper.setMarkLockedFilesAsOffline(true);
            logger.info((Object)"Locked files will be marked as offline");
        }
        return context;
    }

    public final boolean hasPseudoFileInterface() {
        return this.m_pseudoFiles != null;
    }

    public final PseudoFileInterface getPseudoFileInterface() {
        return this.m_pseudoFiles;
    }

    public boolean isReadOnly(SrvSession sess, DeviceContext ctx) throws IOException {
        return this.cifsHelper.isReadOnly();
    }

    public FileInfo getFileInformation(SrvSession session, TreeConnection tree, String path) throws IOException {
        ContentContext ctx = (ContentContext)tree.getContext();
        NodeRef infoParentNodeRef = ctx.getRootNode();
        if (path == null) {
            path = "";
        }
        String infoPath = path;
        try {
            PseudoFile pfile;
            FileInfo finfo = null;
            if (this.hasPseudoFileInterface() && (pfile = this.getPseudoFileInterface().getPseudoFile(session, tree, path)) != null) {
                int attr;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("getInfo using pseudo file info for " + path));
                }
                FileInfo pseudoFileInfo = pfile.getFileInfo();
                if (this.cifsHelper.isReadOnly() && ((attr = pseudoFileInfo.getFileAttributes()) & 1) == 0) {
                    pseudoFileInfo.setFileAttributes(++attr);
                }
                return pfile.getFileInfo();
            }
            NodeRef nodeRef = this.getNodeForPath(tree, infoPath);
            if (nodeRef != null) {
                session.beginTransaction(this.transactionService, true);
                finfo = this.cifsHelper.getFileInformation(nodeRef);
                if (logger.isInfoEnabled()) {
                    logger.debug((Object)("getInfo using cached noderef for path " + path));
                }
            }
            if (finfo == null) {
                session.beginTransaction(this.transactionService, true);
                String[] paths = FileName.splitPath(path);
                if (paths[0] != null && paths[0].length() > 1 && (nodeRef = this.getNodeForPath(tree, paths[0])) != null) {
                    infoParentNodeRef = nodeRef;
                    infoPath = paths[1];
                    if (logger.isInfoEnabled()) {
                        logger.debug((Object)("getInfo using cached noderef for parent " + path));
                    }
                }
                finfo = this.cifsHelper.getFileInformation(infoParentNodeRef, infoPath);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Getting file information: \n   path: " + path + "\n" + "   file info: " + finfo));
                }
            }
            return finfo;
        }
        catch (FileNotFoundException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Getting file information - File not found: \n   path: " + path));
            }
            throw e;
        }
        catch (org.alfresco.repo.security.permissions.AccessDeniedException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Get file info - access denied, " + path));
            }
            throw new AccessDeniedException("Get file information " + path);
        }
        catch (AlfrescoRuntimeException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Get file info error", (Throwable)ex);
            }
            throw new IOException("Get file information " + path);
        }
    }

    public SearchContext startSearch(SrvSession sess, TreeConnection tree, String searchPath, int attributes) throws FileNotFoundException {
        try {
            ContentContext ctx = (ContentContext)tree.getContext();
            String searchFileSpec = searchPath;
            NodeRef searchRootNodeRef = ctx.getRootNode();
            FileState searchFolderState = null;
            sess.beginTransaction(this.transactionService, true);
            String[] paths = null;
            if (ctx.hasStateTable() && (paths = FileName.splitPath(searchPath))[0] != null && paths[0].length() > 1) {
                NodeRef nodeRef = this.getNodeForPath(tree, paths[0]);
                searchFolderState = this.getStateForPath(tree, paths[0]);
                if (searchFolderState == null) {
                    searchFolderState = ctx.getStateTable().findFileState(paths[0], true, true);
                }
                if (!searchFolderState.hasNodeRef()) {
                    searchFolderState.setNodeRef(nodeRef);
                }
                if (this.hasPseudoFileInterface()) {
                    this.getPseudoFileInterface().addPseudoFilesToFolder(sess, tree, paths[0]);
                }
                if (nodeRef != null) {
                    searchRootNodeRef = nodeRef;
                    searchFileSpec = paths[1];
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Search using cached noderef for path " + searchPath));
                    }
                }
            }
            List<NodeRef> results = this.cifsHelper.getNodeRefs(searchRootNodeRef, searchFileSpec);
            PseudoFileList pseudoList = null;
            if (sess instanceof SMBSrvSession && searchFolderState != null && searchFolderState.hasPseudoFiles()) {
                PseudoFile pfile;
                String fname;
                if (WildCard.containsWildcards(searchFileSpec)) {
                    pseudoList = searchFolderState.getPseudoFileList();
                } else if ((results == null || results.size() == 0) && (fname = paths[1]) != null && (pfile = searchFolderState.getPseudoFileList().findFile(fname, true)) != null) {
                    pseudoList = new PseudoFileList();
                    pseudoList.addFile(pfile);
                }
            }
            ContentSearchContext searchCtx = new ContentSearchContext(this.cifsHelper, results, searchFileSpec, pseudoList);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Started search: \n   search path: " + searchPath + "\n" + "   attributes: " + attributes));
            }
            return searchCtx;
        }
        catch (org.alfresco.repo.security.permissions.AccessDeniedException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Start search - access denied, " + searchPath));
            }
            throw new FileNotFoundException("Start search " + searchPath);
        }
        catch (AlfrescoRuntimeException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Start search", (Throwable)ex);
            }
            throw new FileNotFoundException("Start search " + searchPath);
        }
    }

    public int fileExists(SrvSession sess, TreeConnection tree, String name) {
        int status = -1;
        try {
            ContentContext ctx = (ContentContext)tree.getContext();
            FileState fstate = null;
            if (ctx.hasStateTable()) {
                ctx.getStateTable().findFileState(name);
            }
            if (fstate != null) {
                FileState.FileStateStatus fsts = fstate.getFileStatus();
                if (fsts == FileState.FileStateStatus.FileExists) {
                    status = 1;
                } else if (fsts == FileState.FileStateStatus.FolderExists) {
                    status = 2;
                } else if (fsts == FileState.FileStateStatus.NotExist || fsts == FileState.FileStateStatus.Renamed) {
                    status = 0;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Cache hit - fileExists() " + name + ", sts=" + status));
                }
            } else {
                sess.beginTransaction(this.transactionService, true);
                FileInfo info = this.getFileInformation(sess, tree, name);
                status = info.isDirectory() ? 2 : 1;
            }
        }
        catch (FileNotFoundException e) {
            status = 0;
        }
        catch (IOException e) {
            logger.debug((Object)("File exists error, " + name), (Throwable)e);
            status = 0;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("File status determined: \n   name: " + name + "\n" + "   status: " + status));
        }
        return status;
    }

    public NetworkFile openFile(SrvSession sess, TreeConnection tree, FileOpenParams params) throws IOException {
        sess.beginTransaction(this.transactionService, false);
        try {
            PseudoFile pfile;
            ContentContext ctx = (ContentContext)tree.getContext();
            if (this.hasPseudoFileInterface() && (pfile = this.getPseudoFileInterface().getPseudoFile(sess, tree, params.getPath())) != null) {
                return pfile.getFile(params.getPath());
            }
            NodeRef nodeRef = this.getNodeForPath(tree, params.getPath());
            if (params.hasAccessMode(1) && this.permissionService.hasPermission(nodeRef, "Read") == AccessStatus.DENIED) {
                throw new AccessDeniedException("No read access to " + params.getFullPath());
            }
            if (params.hasAccessMode(2) && this.permissionService.hasPermission(nodeRef, "Write") == AccessStatus.DENIED) {
                throw new AccessDeniedException("No write access to " + params.getFullPath());
            }
            if (params.hasAccessMode(65536) && this.permissionService.hasPermission(nodeRef, "Delete") == AccessStatus.DENIED) {
                throw new AccessDeniedException("No delete access to " + params.getFullPath());
            }
            String lockTypeStr = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_LOCK_TYPE));
            if (params.hasAccessMode(2) && lockTypeStr != null) {
                throw new AccessDeniedException("File is locked, no write access to " + params.getFullPath());
            }
            FileState fstate = null;
            if (ctx.hasStateTable() && (fstate = ctx.getStateTable().findFileState(params.getPath())) != null) {
                if (!fstate.exists()) {
                    throw new FileNotFoundException();
                }
                if (fstate != null && params.getSharedAccess() == 0 && fstate.getOpenCount() > 0) {
                    throw new FileSharingException("File already open, " + params.getPath());
                }
            }
            ContentNetworkFile netFile = ContentNetworkFile.createFile(this.transactionService, this.nodeService, this.contentService, this.cifsHelper, nodeRef, params);
            if (ctx.hasStateTable()) {
                if (fstate == null) {
                    fstate = ctx.getStateTable().findFileState(params.getPath(), params.isDirectory(), true);
                }
                fstate.incrementOpenCount();
                fstate.setNodeRef(nodeRef);
            }
            if (params.isOverwrite() && netFile != null) {
                ((NetworkFile)netFile).truncateFile(0L);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Opened network file: \n   path: " + params.getPath() + "\n" + "   file open parameters: " + params + "\n" + "   network file: " + netFile));
            }
            return netFile;
        }
        catch (org.alfresco.repo.security.permissions.AccessDeniedException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Open file - access denied, " + params.getFullPath()));
            }
            throw new AccessDeniedException("Open file " + params.getFullPath());
        }
        catch (AlfrescoRuntimeException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Open file error", (Throwable)ex);
            }
            throw new IOException("Open file " + params.getFullPath());
        }
    }

    public NetworkFile createFile(SrvSession sess, TreeConnection tree, FileOpenParams params) throws IOException {
        sess.beginTransaction(this.transactionService, false);
        try {
            FileState fstate;
            NodeRef nodeRef;
            String[] paths;
            ContentContext ctx = (ContentContext)tree.getContext();
            NodeRef deviceRootNodeRef = ctx.getRootNode();
            String path = params.getPath();
            if (ctx.hasStateTable() && (paths = FileName.splitPath(path))[0] != null && paths[0].length() > 1 && (nodeRef = this.getNodeForPath(tree, paths[0])) != null) {
                deviceRootNodeRef = nodeRef;
                path = paths[1];
                if (logger.isInfoEnabled()) {
                    logger.debug((Object)("Create file using cached noderef for path " + paths[0]));
                }
            }
            NodeRef nodeRef2 = this.cifsHelper.createNode(deviceRootNodeRef, path, true);
            ContentNetworkFile netFile = ContentNetworkFile.createFile(this.transactionService, this.nodeService, this.contentService, this.cifsHelper, nodeRef2, params);
            if (ctx.hasStateTable() && (fstate = ctx.getStateTable().findFileState(path, false, true)) != null) {
                fstate.setFileStatus(FileState.FileStateStatus.FileExists);
                fstate.incrementOpenCount();
                fstate.setNodeRef(nodeRef2);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Creaste file, state=" + fstate));
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Created file: \n   path: " + path + "\n" + "   file open parameters: " + params + "\n" + "   node: " + nodeRef2 + "\n" + "   network file: " + netFile));
            }
            return netFile;
        }
        catch (org.alfresco.repo.security.permissions.AccessDeniedException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Create file - access denied, " + params.getFullPath()));
            }
            throw new AccessDeniedException("Create file " + params.getFullPath());
        }
        catch (AlfrescoRuntimeException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Create file error", (Throwable)ex);
            }
            throw new IOException("Create file " + params.getFullPath());
        }
    }

    public void createDirectory(SrvSession sess, TreeConnection tree, FileOpenParams params) throws IOException {
        sess.beginTransaction(this.transactionService, false);
        try {
            FileState fstate;
            NodeRef nodeRef;
            String[] paths;
            ContentContext ctx = (ContentContext)tree.getContext();
            NodeRef deviceRootNodeRef = ctx.getRootNode();
            String path = params.getPath();
            if (ctx.hasStateTable() && (paths = FileName.splitPath(path))[0] != null && paths[0].length() > 1 && (nodeRef = this.getNodeForPath(tree, paths[0])) != null) {
                deviceRootNodeRef = nodeRef;
                path = paths[1];
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Create file using cached noderef for path " + paths[0]));
                }
            }
            NodeRef nodeRef2 = this.cifsHelper.createNode(deviceRootNodeRef, path, false);
            if (ctx.hasStateTable() && (fstate = ctx.getStateTable().findFileState(path, true, true)) != null) {
                fstate.setFileStatus(FileState.FileStateStatus.FolderExists);
                fstate.incrementOpenCount();
                fstate.setNodeRef(nodeRef2);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Creaste folder, state=" + fstate));
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Created directory: \n   path: " + path + "\n" + "   file open params: " + params + "\n" + "   node: " + nodeRef2));
            }
        }
        catch (org.alfresco.repo.security.permissions.AccessDeniedException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Create directory - access denied, " + params.getFullPath()));
            }
            throw new AccessDeniedException("Create directory " + params.getFullPath());
        }
        catch (AlfrescoRuntimeException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Create directory error", (Throwable)ex);
            }
            throw new IOException("Create directory " + params.getFullPath());
        }
    }

    public void deleteDirectory(SrvSession sess, TreeConnection tree, String dir) throws IOException {
        sess.beginTransaction(this.transactionService, false);
        ContentContext ctx = (ContentContext)tree.getContext();
        NodeRef deviceRootNodeRef = ctx.getRootNode();
        try {
            NodeRef nodeRef = this.cifsHelper.getNodeRef(deviceRootNodeRef, dir);
            if (this.nodeService.exists(nodeRef)) {
                this.nodeService.deleteNode(nodeRef);
                if (ctx.hasStateTable()) {
                    ctx.getStateTable().removeFileState(dir);
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Deleted directory: \n   directory: " + dir + "\n" + "   node: " + nodeRef));
            }
        }
        catch (FileNotFoundException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Deleted directory <alfready gone>: \n   directory: " + dir));
            }
        }
        catch (org.alfresco.repo.security.permissions.AccessDeniedException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Delete directory - access denied, " + dir));
            }
            throw new AccessDeniedException("Delete directory " + dir);
        }
        catch (AlfrescoRuntimeException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Delete directory", (Throwable)ex);
            }
            throw new IOException("Delete directory " + dir);
        }
    }

    public void flushFile(SrvSession sess, TreeConnection tree, NetworkFile file) throws IOException {
        file.flushFile();
    }

    /*
     * Unable to fully structure code
     */
    public void closeFile(SrvSession sess, TreeConnection tree, NetworkFile file) throws IOException {
        sess.beginTransaction(this.transactionService, false);
        ctx = (ContentContext)tree.getContext();
        if (ctx.hasStateTable() && (fstate = ctx.getStateTable().findFileState(file.getFullName())) != null) {
            fstate.decrementOpenCount();
        }
        file.closeFile();
        if (file.hasDeleteOnClose()) {
            if (file instanceof ContentNetworkFile) {
                contentNetFile = (ContentNetworkFile)file;
                nodeRef = contentNetFile.getNodeRef();
                if (this.nodeService.exists(nodeRef)) {
                    try {
                        this.nodeService.deleteNode(nodeRef);
                        if (!ctx.hasStateTable()) ** GOTO lbl26
                        ctx.getStateTable().removeFileState(file.getFullName());
                    }
                    catch (org.alfresco.repo.security.permissions.AccessDeniedException ex) {
                        if (ContentDiskDriver.logger.isDebugEnabled()) {
                            ContentDiskDriver.logger.debug((Object)("Delete on close - access denied, " + file.getFullName()));
                        }
                        throw new AccessDeniedException("Delete on close " + file.getFullName());
                    }
                }
            } else if ((file instanceof PseudoNetworkFile || file instanceof MemoryNetworkFile) && this.hasPseudoFileInterface()) {
                this.getPseudoFileInterface().deletePseudoFile(sess, tree, file.getFullName());
            }
        }
lbl26:
        // 8 sources

        if (ContentDiskDriver.logger.isDebugEnabled()) {
            ContentDiskDriver.logger.debug((Object)("Closed file: \n   network file: " + file + "\n" + "   deleted on close: " + file.hasDeleteOnClose()));
        }
    }

    public void deleteFile(SrvSession sess, TreeConnection tree, String name) throws IOException {
        sess.beginTransaction(this.transactionService, false);
        ContentContext ctx = (ContentContext)tree.getContext();
        try {
            NodeRef nodeRef = this.getNodeForPath(tree, name);
            if (this.nodeService.exists(nodeRef)) {
                this.nodeService.deleteNode(nodeRef);
                if (ctx.hasStateTable()) {
                    ctx.getStateTable().removeFileState(name);
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Deleted file: \n   file: " + name + "\n" + "   node: " + nodeRef));
            }
        }
        catch (FileNotFoundException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Deleted file <alfready gone>: \n   file: " + name));
            }
        }
        catch (NodeLockedException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Delete file - access denied (locked)");
            }
            throw new AccessDeniedException("Delete " + name);
        }
        catch (org.alfresco.repo.security.permissions.AccessDeniedException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Delete file - access denied");
            }
            throw new AccessDeniedException("Delete " + name);
        }
        catch (AlfrescoRuntimeException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Delete file error", (Throwable)ex);
            }
            throw new IOException("Delete file " + name);
        }
    }

    public void renameFile(SrvSession sess, TreeConnection tree, String oldName, String newName) throws IOException {
        sess.beginTransaction(this.transactionService, false);
        try {
            ContentContext ctx = (ContentContext)tree.getContext();
            NodeRef nodeToMoveRef = this.getNodeForPath(tree, oldName);
            String[] splitPaths = FileName.splitPath(newName);
            NodeRef targetFolderRef = this.getNodeForPath(tree, splitPaths[0]);
            String name = splitPaths[1];
            boolean relinked = false;
            if (ctx.hasStateTable()) {
                if (!this.cifsHelper.isDirectory(nodeToMoveRef)) {
                    FileState renState = ctx.getStateTable().removeFileState(newName);
                    if (renState != null && renState.getFileStatus() == FileState.FileStateStatus.Renamed) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)(" Found rename state, relinking, " + renState));
                        }
                        this.cifsHelper.relinkNode(renState.getNodeRef(), nodeToMoveRef, targetFolderRef, name);
                        relinked = true;
                        if (renState.hasRenameState()) {
                            renState.getRenameState().setNodeRef(nodeToMoveRef);
                        }
                        ctx.getStateTable().removeFileState(oldName);
                        FileState fstate = ctx.getStateTable().findFileState(newName, false, true);
                        fstate.setNodeRef(renState.getNodeRef());
                        fstate.setFileStatus(FileState.FileStateStatus.FileExists);
                    } else {
                        FileState fstate = ctx.getStateTable().findFileState(oldName, false, true);
                        fstate.setExpiryTime(System.currentTimeMillis() + 60000L);
                        fstate.setFileStatus(FileState.FileStateStatus.Renamed);
                        fstate.setNodeRef(nodeToMoveRef);
                        FileState newState = ctx.getStateTable().findFileState(newName, false, true);
                        newState.setNodeRef(nodeToMoveRef);
                        newState.setFileStatus(FileState.FileStateStatus.FileExists);
                        fstate.setRenameState(newState);
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Cached rename state for " + oldName + ", state=" + fstate));
                        }
                    }
                } else {
                    FileState fstate = ctx.getStateTable().findFileState(oldName);
                    if (fstate != null) {
                        ctx.getStateTable().renameFileState(newName, fstate);
                    }
                }
            }
            if (!relinked) {
                this.cifsHelper.move(nodeToMoveRef, targetFolderRef, name);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Moved node:  from: " + oldName + " to: " + newName));
            }
        }
        catch (org.alfresco.repo.security.permissions.AccessDeniedException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Rename file - access denied, " + oldName));
            }
            throw new AccessDeniedException("Rename file " + oldName);
        }
        catch (NodeLockedException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Rename file", (Throwable)((Object)ex));
            }
            throw new AccessDeniedException("Node locked " + oldName);
        }
        catch (AlfrescoRuntimeException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Rename file", (Throwable)ex);
            }
            throw new IOException("Rename file " + oldName);
        }
    }

    public void setFileInformation(SrvSession sess, TreeConnection tree, String name, FileInfo info) throws IOException {
        try {
            String lockTypeStr;
            if (this.hasPseudoFileInterface() && this.getPseudoFileInterface().isPseudoFile(sess, tree, name)) {
                return;
            }
            NodeRef nodeRef = this.getNodeForPath(tree, name);
            if (this.permissionService.hasPermission(nodeRef, "Write") == AccessStatus.DENIED) {
                throw new AccessDeniedException("No write access to " + name);
            }
            if (info.hasSetFlag(1024) && info.hasDeleteOnClose() && this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_LOCKABLE) && (lockTypeStr = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_LOCK_TYPE))) != null) {
                throw new AccessDeniedException("Node locked, cannot mark for delete");
            }
        }
        catch (org.alfresco.repo.security.permissions.AccessDeniedException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Set file information - access denied, " + name));
            }
            throw new AccessDeniedException("Set file information " + name);
        }
        catch (AlfrescoRuntimeException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Open file error", (Throwable)ex);
            }
            throw new IOException("Set file information " + name);
        }
    }

    public void truncateFile(SrvSession sess, TreeConnection tree, NetworkFile file, long size) throws IOException {
        file.truncateFile(size);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Truncated file: \n   network file: " + file + "\n" + "   size: " + size));
        }
    }

    public int readFile(SrvSession sess, TreeConnection tree, NetworkFile file, byte[] buffer, int bufferPosition, int size, long fileOffset) throws IOException {
        if (file.isDirectory()) {
            throw new AccessDeniedException();
        }
        int count = file.readFile(buffer, size, bufferPosition, fileOffset);
        if (count == -1) {
            count = 0;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Read bytes from file: \n   network file: " + file + "\n" + "   buffer size: " + buffer.length + "\n" + "   buffer pos: " + bufferPosition + "\n" + "   size: " + size + "\n" + "   file offset: " + fileOffset + "\n" + "   bytes read: " + count));
        }
        return count;
    }

    public long seekFile(SrvSession sess, TreeConnection tree, NetworkFile file, long pos, int typ) throws IOException {
        throw new UnsupportedOperationException("Unsupported: " + file + " (seek)");
    }

    public int writeFile(SrvSession sess, TreeConnection tree, NetworkFile file, byte[] buffer, int bufferOffset, int size, long fileOffset) throws IOException {
        file.writeFile(buffer, size, bufferOffset, fileOffset);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Wrote bytes to file: \n   network file: " + file + "\n" + "   buffer size: " + buffer.length + "\n" + "   size: " + size + "\n" + "   file offset: " + fileOffset));
        }
        return size;
    }

    public NodeRef getNodeForPath(TreeConnection tree, String path) throws FileNotFoundException {
        FileState fstate;
        ContentContext ctx = (ContentContext)tree.getContext();
        if (ctx.hasStateTable() && (fstate = ctx.getStateTable().findFileState(path)) != null && fstate.hasNodeRef() && fstate.exists()) {
            if (this.nodeService.exists(fstate.getNodeRef())) {
                fstate.setExpiryTime(System.currentTimeMillis() + 120000L);
                return fstate.getNodeRef();
            }
            ctx.getStateTable().removeFileState(path);
        }
        return this.cifsHelper.getNodeRef(ctx.getRootNode(), path);
    }

    public FileState getStateForPath(TreeConnection tree, String path) throws FileNotFoundException {
        ContentContext ctx = (ContentContext)tree.getContext();
        FileState fstate = null;
        if (ctx.hasStateTable()) {
            fstate = ctx.getStateTable().findFileState(path);
        }
        return fstate;
    }

    public void treeClosed(SrvSession sess, TreeConnection tree) {
    }

    public void treeOpened(SrvSession sess, TreeConnection tree) {
    }

    public DataBuffer processIOControl(SrvSession sess, TreeConnection tree, int ctrlCode, int fid, DataBuffer dataBuf, boolean isFSCtrl, int filter) throws IOControlNotImplementedException, SMBException {
        NetworkFile netFile = tree.findFile(fid);
        if (netFile == null || !netFile.isDirectory()) {
            throw new SMBException(6, -1073741811);
        }
        if (this.m_ioHandler != null) {
            return this.m_ioHandler.processIOControl(sess, tree, ctrlCode, fid, dataBuf, isFSCtrl, filter);
        }
        throw new IOControlNotImplementedException();
    }
}

