/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.smb.server.repo;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.filesys.server.filesys.AccessDeniedException;
import org.alfresco.filesys.server.filesys.FileInfo;
import org.alfresco.filesys.server.filesys.FileOpenParams;
import org.alfresco.filesys.server.filesys.NetworkFile;
import org.alfresco.filesys.smb.server.repo.CifsHelper;
import org.alfresco.i18n.I18NUtil;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.filestore.FileContentReader;
import org.alfresco.repo.transaction.TransactionUtil;
import org.alfresco.service.cmr.repository.ContentAccessor;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ContentNetworkFile
extends NetworkFile {
    private static final Log logger = LogFactory.getLog(ContentNetworkFile.class);
    private TransactionService transactionService;
    private NodeService nodeService;
    private ContentService contentService;
    private NodeRef nodeRef;
    private FileChannel channel;
    private ContentAccessor content;
    private boolean modified;
    private boolean writableChannel;

    public static ContentNetworkFile createFile(TransactionService transactionService, NodeService nodeService, ContentService contentService, CifsHelper cifsHelper, NodeRef nodeRef, FileOpenParams params) {
        FileInfo fileInfo;
        String path = params.getPath();
        ContentNetworkFile netFile = new ContentNetworkFile(transactionService, nodeService, contentService, nodeRef, path);
        if (params.isReadOnlyAccess()) {
            netFile.setGrantedAccess(0);
        } else {
            netFile.setGrantedAccess(2);
        }
        try {
            fileInfo = cifsHelper.getFileInformation(nodeRef, "");
        }
        catch (FileNotFoundException e) {
            throw new AlfrescoRuntimeException("File not found when creating network file: " + nodeRef, (Throwable)e);
        }
        if (fileInfo.isDirectory()) {
            netFile.setAttributes(16);
        } else {
            netFile.setFileSize(fileInfo.getSize());
        }
        if (fileInfo.hasCreationDateTime()) {
            netFile.setCreationDate(fileInfo.getCreationDateTime());
        }
        if (fileInfo.hasModifyDateTime()) {
            netFile.setModifyDate(fileInfo.getModifyDateTime());
        }
        if (fileInfo.hasAccessDateTime()) {
            netFile.setAccessDate(fileInfo.getAccessDateTime());
        }
        netFile.setAttributes(fileInfo.getFileAttributes());
        if (netFile.isReadOnly()) {
            netFile.setGrantedAccess(0);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Created network file: \n   node: " + nodeRef + "\n" + "   param: " + params + "\n" + "   netfile: " + netFile));
        }
        return netFile;
    }

    private ContentNetworkFile(TransactionService transactionService, NodeService nodeService, ContentService contentService, NodeRef nodeRef, String name) {
        super(name);
        this.setFullName(name);
        this.transactionService = transactionService;
        this.nodeService = nodeService;
        this.contentService = contentService;
        this.nodeRef = nodeRef;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(50);
        sb.append("ContentNetworkFile:").append("[ node=").append(this.nodeRef).append(", channel=").append(this.channel).append(this.writableChannel ? "(Write)" : "(Read)").append(", writable=").append(this.isWritable()).append(", content=").append(this.content).append(", modified=").append(this.modified).append("]");
        return sb.toString();
    }

    public NodeRef getNodeRef() {
        return this.nodeRef;
    }

    private boolean isWritable() {
        int access = this.getGrantedAccess();
        return access == 2 || access == 1;
    }

    public final boolean hasContent() {
        return this.content != null;
    }

    private synchronized void openContent(boolean write, boolean trunc) throws AccessDeniedException, AlfrescoRuntimeException {
        if (this.isDirectory()) {
            throw new AlfrescoRuntimeException("Unable to open channel for a directory network file: " + this);
        }
        if (write && !this.writableChannel && this.channel != null) {
            try {
                this.channel.close();
                this.channel = null;
            }
            catch (IOException ex) {
                logger.error((Object)"Error closing read-only channel", (Throwable)ex);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Switching to writable channel for " + this.getName()));
            }
        } else if (this.channel != null) {
            return;
        }
        if (write && !this.isWritable()) {
            throw new AccessDeniedException("The network file was created for read-only: " + this);
        }
        this.content = null;
        if (write) {
            this.content = this.contentService.getWriter(this.nodeRef, ContentModel.PROP_CONTENT, false);
            this.writableChannel = true;
            this.channel = ((ContentWriter)this.content).getFileChannel(trunc);
        } else {
            this.content = this.contentService.getReader(this.nodeRef, ContentModel.PROP_CONTENT);
            this.content = FileContentReader.getSafeContentReader((ContentReader)this.content, I18NUtil.getMessage((String)"content.content_missing"), this.nodeRef, this.content);
            this.writableChannel = false;
            this.channel = ((ContentReader)this.content).getFileChannel();
        }
    }

    public synchronized void closeFile() throws IOException {
        if (this.isDirectory()) {
            return;
        }
        if (this.channel == null) {
            return;
        }
        if (this.modified) {
            TransactionUtil.TransactionWork<Object> closeWork = new TransactionUtil.TransactionWork<Object>(){

                @Override
                public Object doWork() throws Exception {
                    ContentNetworkFile.this.channel.close();
                    ContentNetworkFile.this.channel = null;
                    ContentData contentData = ContentNetworkFile.this.content.getContentData();
                    ContentNetworkFile.this.nodeService.setProperty(ContentNetworkFile.this.nodeRef, ContentModel.PROP_CONTENT, contentData);
                    return null;
                }
            };
            TransactionUtil.executeInUserTransaction(this.transactionService, closeWork);
        } else {
            this.channel.close();
            this.channel = null;
        }
    }

    public synchronized void truncateFile(long size) throws IOException {
        if (!this.hasContent() && size == 0L) {
            this.openContent(true, true);
        } else {
            this.openContent(true, false);
            this.channel.truncate(size);
        }
        this.modified = true;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Truncated channel:    net file: " + this + "\n" + "   size: " + size));
        }
    }

    public synchronized void writeFile(byte[] buffer, int length, int position, long fileOffset) throws IOException {
        this.openContent(true, false);
        ByteBuffer byteBuffer = ByteBuffer.wrap(buffer, position, length);
        int count = this.channel.write(byteBuffer, fileOffset);
        this.modified = true;
        this.setFileSize(this.channel.size());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Wrote to channel:    net file: " + this + "\n" + "   written: " + count));
        }
    }

    public synchronized int readFile(byte[] buffer, int length, int position, long fileOffset) throws IOException {
        this.openContent(false, false);
        ByteBuffer byteBuffer = ByteBuffer.wrap(buffer, position, length);
        int count = this.channel.read(byteBuffer, fileOffset);
        if (count < 0) {
            count = 0;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Read from channel:    net file: " + this + "\n" + "   read: " + count));
        }
        return count;
    }

    public synchronized void openFile(boolean createFlag) throws IOException {
        throw new UnsupportedOperationException();
    }

    public synchronized long seekFile(long pos, int typ) throws IOException {
        throw new UnsupportedOperationException();
    }

    public synchronized void flushFile() throws IOException {
        this.openContent(true, false);
        this.channel.force(false);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Flushed channel:    net file: " + this));
        }
    }
}

