/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.smb.server.repo;

import java.io.FileNotFoundException;
import java.util.List;
import org.alfresco.filesys.server.filesys.FileInfo;
import org.alfresco.filesys.server.filesys.SearchContext;
import org.alfresco.filesys.smb.server.repo.CifsHelper;
import org.alfresco.filesys.smb.server.repo.pseudo.PseudoFile;
import org.alfresco.filesys.smb.server.repo.pseudo.PseudoFileList;
import org.alfresco.service.cmr.repository.NodeRef;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentSearchContext
extends SearchContext {
    private static final Log logger = LogFactory.getLog(ContentSearchContext.class);
    private CifsHelper cifsHelper;
    private List<NodeRef> results;
    private int index = -1;
    private PseudoFileList pseudoList;
    private boolean donePseudoFiles = false;
    private int resumeId;

    protected ContentSearchContext(CifsHelper cifsHelper, List<NodeRef> results, String searchStr, PseudoFileList pseudoList) {
        super.setSearchString(searchStr);
        this.cifsHelper = cifsHelper;
        this.results = results;
        this.pseudoList = pseudoList;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(60);
        sb.append("ContentSearchContext").append("[ searchStr=").append(this.getSearchString()).append(", resultCount=").append(this.results.size()).append("]");
        return sb.toString();
    }

    @Override
    public int getResumeId() {
        return this.resumeId;
    }

    @Override
    public boolean hasMoreFiles() {
        if (!this.donePseudoFiles && this.pseudoList != null && this.index < this.pseudoList.numberOfFiles() - 1) {
            return true;
        }
        return this.index < this.results.size() - 1;
    }

    @Override
    public boolean nextFileInfo(FileInfo info) {
        PseudoFile pfile;
        if (!this.hasMoreFiles()) {
            return false;
        }
        ++this.index;
        ++this.resumeId;
        if (!this.donePseudoFiles && this.pseudoList != null && this.index < this.pseudoList.numberOfFiles() && (pfile = this.pseudoList.getFileAt(this.index)) != null) {
            FileInfo pinfo = pfile.getFileInfo();
            info.copyFrom(pinfo);
            if (this.index == this.pseudoList.numberOfFiles() - 1) {
                this.donePseudoFiles = true;
                this.index = -1;
            }
            return true;
        }
        NodeRef nextNodeRef = this.results.get(this.index);
        try {
            FileInfo nextInfo = this.cifsHelper.getFileInformation(nextNodeRef, "");
            info.copyFrom(nextInfo);
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
    }

    @Override
    public String nextFileName() {
        if (!this.hasMoreFiles()) {
            return null;
        }
        ++this.index;
        ++this.resumeId;
        if (!this.donePseudoFiles && this.pseudoList != null) {
            if (this.index < this.pseudoList.numberOfFiles()) {
                PseudoFile pfile = this.pseudoList.getFileAt(this.index);
                if (pfile != null) {
                    FileInfo pinfo = pfile.getFileInfo();
                    return pinfo.getFileName();
                }
            } else {
                this.donePseudoFiles = true;
                this.index = -1;
                if (this.results == null || this.results.size() == 0) {
                    return null;
                }
            }
        }
        NodeRef nextNodeRef = this.results.get(this.index);
        try {
            FileInfo nextInfo = this.cifsHelper.getFileInformation(nextNodeRef, "");
            return nextInfo.getFileName();
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    @Override
    public boolean restartAt(FileInfo info) {
        int resId;
        if (this.pseudoList != null) {
            for (resId = 0; resId < this.pseudoList.numberOfFiles(); ++resId) {
                PseudoFile pfile = this.pseudoList.getFileAt(resId);
                if (!pfile.getFileName().equals(info.getFileName())) continue;
                this.donePseudoFiles = false;
                this.index = resId - 1;
                return true;
            }
        }
        if (this.results != null) {
            int idx = 0;
            while (idx < this.results.size()) {
                String fname = this.cifsHelper.getFileName(this.results.get(idx));
                if (fname != null && fname.equals(info.getFileName())) {
                    this.index = idx - 1;
                    this.resumeId = resId - 1;
                    this.donePseudoFiles = true;
                    return true;
                }
                ++idx;
                ++resId;
            }
        }
        return false;
    }

    @Override
    public boolean restartAt(int resumeId) {
        if (this.pseudoList != null) {
            if (resumeId < this.pseudoList.numberOfFiles()) {
                this.index = resumeId;
                this.donePseudoFiles = false;
                return true;
            }
            resumeId -= this.pseudoList.numberOfFiles();
        }
        if (this.results != null && resumeId < this.results.size()) {
            this.index = resumeId;
            this.donePseudoFiles = true;
            return true;
        }
        return false;
    }
}

