/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.smb.server.repo;

import org.alfresco.filesys.locking.FileLock;
import org.alfresco.filesys.locking.FileLockList;
import org.alfresco.filesys.locking.LockConflictException;
import org.alfresco.filesys.locking.NotLockedException;
import org.alfresco.filesys.server.filesys.FileOpenParams;
import org.alfresco.filesys.smb.server.repo.pseudo.PseudoFile;
import org.alfresco.filesys.smb.server.repo.pseudo.PseudoFileList;
import org.alfresco.service.cmr.repository.NodeRef;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileState {
    private static final Log logger = LogFactory.getLog(FileState.class);
    public static final long NoTimeout = -1L;
    public static final long DefTimeout = 120000L;
    public static final long RenameTimeout = 60000L;
    private String m_path;
    private long m_tmo;
    private FileStateStatus m_fileStatus = FileStateStatus.NotExist;
    private int m_openCount;
    private int m_sharedAccess = 3;
    private FileLockList m_lockList;
    private NodeRef m_nodeRef;
    private FileState m_newNameState;
    private PseudoFileList m_pseudoFiles;

    public FileState(String fname, boolean isdir) {
        this.setPath(fname);
        this.setExpiryTime(System.currentTimeMillis() + 120000L);
        this.setFileStatus(isdir ? FileStateStatus.FolderExists : FileStateStatus.FileExists);
    }

    public final String getPath() {
        return this.m_path;
    }

    public final FileStateStatus getFileStatus() {
        return this.m_fileStatus;
    }

    public final boolean exists() {
        return this.m_fileStatus == FileStateStatus.FileExists || this.m_fileStatus == FileStateStatus.FolderExists;
    }

    public final boolean isDirectory() {
        return this.m_fileStatus == FileStateStatus.FolderExists;
    }

    public final boolean hasNodeRef() {
        return this.m_nodeRef != null;
    }

    public final NodeRef getNodeRef() {
        return this.m_nodeRef;
    }

    public final int getOpenCount() {
        return this.m_openCount;
    }

    public final int getSharedAccess() {
        return this.m_sharedAccess;
    }

    public final boolean hasActiveLocks() {
        return this.m_lockList != null && this.m_lockList.numberOfLocks() > 0;
    }

    public final boolean hasNoTimeout() {
        return this.m_tmo == -1L;
    }

    public final boolean allowsOpen(FileOpenParams params) {
        if (this.getOpenCount() == 0) {
            return true;
        }
        if (this.getSharedAccess() == 3 && params.getSharedAccess() == 3) {
            return true;
        }
        if ((this.getSharedAccess() & 1) != 0 && params.isReadOnlyAccess()) {
            return true;
        }
        return (this.getSharedAccess() & 2) != 0 && params.isWriteOnlyAccess();
    }

    public final synchronized int incrementOpenCount() {
        return this.m_openCount++;
    }

    public final synchronized int decrementOpenCount() {
        if (this.m_openCount <= 0) {
            logger.debug((Object)("@@@@@ File close name=" + this.getPath() + ", count=" + this.m_openCount + " <<ERROR>>"));
        } else {
            --this.m_openCount;
        }
        return this.m_openCount;
    }

    public final boolean hasExpired(long curTime) {
        if (this.m_tmo == -1L) {
            return false;
        }
        return curTime > this.m_tmo;
    }

    public final long getSecondsToExpire(long curTime) {
        if (this.m_tmo == -1L) {
            return -1L;
        }
        return (this.m_tmo - curTime) / 1000L;
    }

    public final boolean hasRenameState() {
        return this.m_newNameState != null;
    }

    public final FileState getRenameState() {
        return this.m_newNameState;
    }

    public final boolean hasPseudoFiles() {
        if (this.m_pseudoFiles != null) {
            return this.m_pseudoFiles.numberOfFiles() > 0;
        }
        return false;
    }

    public final PseudoFileList getPseudoFileList() {
        return this.m_pseudoFiles;
    }

    public final void addPseudoFile(PseudoFile pfile) {
        if (this.m_pseudoFiles == null) {
            this.m_pseudoFiles = new PseudoFileList();
        }
        this.m_pseudoFiles.addFile(pfile);
    }

    public final void setFileStatus(FileStateStatus status) {
        this.m_fileStatus = status;
    }

    public final void setFileStatus(int fsts) {
        if (fsts == 1) {
            this.m_fileStatus = FileStateStatus.FileExists;
        } else if (fsts == 2) {
            this.m_fileStatus = FileStateStatus.FolderExists;
        } else if (fsts == 0) {
            this.m_fileStatus = FileStateStatus.NotExist;
        }
    }

    public final void setExpiryTime(long expire) {
        this.m_tmo = expire;
    }

    public final void setNodeRef(NodeRef nodeRef) {
        this.m_nodeRef = nodeRef;
    }

    public final void setRenameState(FileState fstate) {
        this.m_newNameState = fstate;
    }

    public final void setSharedAccess(int mode) {
        if (this.getOpenCount() == 0) {
            this.m_sharedAccess = mode;
        }
    }

    public final void setPath(String path) {
        this.m_path = FileState.normalizePath(path);
    }

    public final int numberOfLocks() {
        if (this.m_lockList != null) {
            return this.m_lockList.numberOfLocks();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addLock(FileLock lock) throws LockConflictException {
        Object object;
        if (this.m_lockList == null) {
            object = this;
            synchronized (object) {
                if (this.m_lockList == null) {
                    this.m_lockList = new FileLockList();
                }
            }
        }
        object = this.m_lockList;
        synchronized (object) {
            if (!this.m_lockList.allowsLock(lock)) {
                throw new LockConflictException();
            }
            this.m_lockList.addLock(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeLock(FileLock lock) throws NotLockedException {
        if (this.m_lockList == null) {
            throw new NotLockedException();
        }
        FileLockList fileLockList = this.m_lockList;
        synchronized (fileLockList) {
            if (this.m_lockList.removeLock(lock) == null) {
                throw new NotLockedException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean canReadFile(long offset, long len, int pid) {
        if (this.m_lockList == null) {
            return true;
        }
        boolean readOK = false;
        FileLockList fileLockList = this.m_lockList;
        synchronized (fileLockList) {
            readOK = this.m_lockList.canReadFile(offset, len, pid);
        }
        return readOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean canWriteFile(long offset, long len, int pid) {
        if (this.m_lockList == null) {
            return true;
        }
        boolean writeOK = false;
        FileLockList fileLockList = this.m_lockList;
        synchronized (fileLockList) {
            writeOK = this.m_lockList.canWriteFile(offset, len, pid);
        }
        return writeOK;
    }

    public static final String normalizePath(String path) {
        int pos;
        String normPath = path;
        if (path.length() > 3 && (pos = path.lastIndexOf(92)) != -1) {
            String pathPart = path.substring(0, pos).toUpperCase();
            String namePart = path.substring(pos);
            normPath = pathPart + namePart;
        }
        return normPath;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[");
        str.append(this.getPath());
        str.append(",");
        str.append((Object)this.getFileStatus());
        str.append(":Opn=");
        str.append(this.getOpenCount());
        str.append(",Expire=");
        str.append(this.getSecondsToExpire(System.currentTimeMillis()));
        str.append(",Locks=");
        str.append(this.numberOfLocks());
        str.append(",Ref=");
        if (this.hasNodeRef()) {
            str.append(this.getNodeRef().getId());
        } else {
            str.append("Null");
        }
        if (this.isDirectory()) {
            str.append(",Pseudo=");
            if (this.hasPseudoFiles()) {
                str.append(this.getPseudoFileList().numberOfFiles());
            } else {
                str.append(0);
            }
        }
        str.append("]");
        return str.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FileStateStatus {
        NotExist,
        FileExists,
        FolderExists,
        Renamed;

    }
}

