/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.smb.server.repo;

import java.util.Enumeration;
import java.util.Hashtable;
import org.alfresco.filesys.smb.server.repo.FileState;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileStateTable
implements Runnable {
    private static final Log logger = LogFactory.getLog(FileStateTable.class);
    private static final int INITIAL_SIZE = 100;
    private static final long DEFAULT_EXPIRECHECK = 15000L;
    private Hashtable<String, FileState> m_stateTable = new Hashtable(100);
    private long m_expireInterval = 15000L;
    private long m_cacheTimer = 120000L;
    private Thread m_thread = new Thread(this);
    private boolean m_shutdown;

    public FileStateTable() {
        this.m_thread.setDaemon(true);
        this.m_thread.setName("FileStateExpire");
        this.m_thread.start();
    }

    public final long getCheckInterval() {
        return this.m_expireInterval;
    }

    public final long getCacheTimer() {
        return this.m_cacheTimer;
    }

    public final int numberOfStates() {
        return this.m_stateTable.size();
    }

    public final void setCacheTimer(long tmo) {
        this.m_cacheTimer = tmo;
    }

    public final void setCheckInterval(long chkIntval) {
        this.m_expireInterval = chkIntval;
    }

    public final synchronized void addFileState(FileState fstate) {
        if (logger.isDebugEnabled() && this.m_stateTable.get(fstate.getPath()) != null) {
            logger.debug((Object)("***** addFileState() state=" + fstate.toString() + " - ALREADY IN CACHE *****"));
        }
        if (logger.isDebugEnabled() && fstate == null) {
            logger.debug((Object)"addFileState() NULL FileState");
            return;
        }
        fstate.setExpiryTime(System.currentTimeMillis() + this.getCacheTimer());
        this.m_stateTable.put(fstate.getPath(), fstate);
    }

    public final synchronized FileState findFileState(String path) {
        return this.m_stateTable.get(FileState.normalizePath(path));
    }

    public final synchronized FileState findFileState(String path, boolean isdir, boolean create) {
        FileState state = this.m_stateTable.get(FileState.normalizePath(path));
        if (state == null && create) {
            state = new FileState(path, isdir);
            state.setExpiryTime(System.currentTimeMillis() + this.getCacheTimer());
            this.m_stateTable.put(state.getPath(), state);
        }
        return state;
    }

    public final synchronized FileState updateFileState(String oldName, String newName) {
        FileState state = this.m_stateTable.remove(FileState.normalizePath(oldName));
        if (state != null) {
            state.setPath(newName);
            this.addFileState(state);
        }
        return state;
    }

    public final Enumeration enumerate() {
        return this.m_stateTable.keys();
    }

    public final synchronized FileState removeFileState(String path) {
        FileState state = this.m_stateTable.remove(FileState.normalizePath(path));
        return state;
    }

    public final synchronized void renameFileState(String newPath, FileState state) {
        this.m_stateTable.remove(state.getPath());
        state.setPath(FileState.normalizePath(newPath));
        this.m_stateTable.put(state.getPath(), state);
    }

    public final synchronized void removeAllFileStates() {
        if (this.m_stateTable == null || this.m_stateTable.size() == 0) {
            return;
        }
        Enumeration<String> enm = this.m_stateTable.keys();
        while (enm.hasMoreElements()) {
            FileState state = this.m_stateTable.get(enm.nextElement());
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("++ Closed: " + state.getPath()));
        }
        this.m_stateTable.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int removeExpiredFileStates() {
        if (this.m_stateTable == null || this.m_stateTable.size() == 0) {
            return 0;
        }
        Enumeration<String> enm = this.m_stateTable.keys();
        long curTime = System.currentTimeMillis();
        int expiredCnt = 0;
        while (enm.hasMoreElements()) {
            FileState state = this.m_stateTable.get(enm.nextElement());
            if (state == null || state.hasNoTimeout()) continue;
            FileState fileState = state;
            synchronized (fileState) {
                if (state.hasExpired(curTime) && state.getOpenCount() == 0) {
                    this.m_stateTable.remove(state.getPath());
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("++ Expired file state: " + state));
                    }
                    ++expiredCnt;
                }
            }
        }
        return expiredCnt;
    }

    public void run() {
        this.m_shutdown = false;
        while (!this.m_shutdown) {
            try {
                Thread.sleep(this.getCheckInterval());
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            if (this.m_shutdown) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"FileStateExpire thread closing");
                }
                return;
            }
            try {
                int cnt = this.removeExpiredFileStates();
                if (!logger.isDebugEnabled() || cnt <= 0) continue;
                logger.debug((Object)("++ Expired " + cnt + " file states, cache=" + this.m_stateTable.size()));
                this.Dump();
            }
            catch (Exception ex) {
                logger.debug((Object)ex);
            }
        }
    }

    public final void shutdownRequest() {
        this.m_shutdown = true;
        if (this.m_thread != null) {
            try {
                this.m_thread.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public final void Dump() {
        if (this.m_stateTable.size() > 0) {
            logger.info((Object)"++ FileStateCache Entries:");
        }
        Enumeration<String> enm = this.m_stateTable.keys();
        long curTime = System.currentTimeMillis();
        while (enm.hasMoreElements()) {
            String fname = enm.nextElement();
            FileState state = this.m_stateTable.get(fname);
            logger.info((Object)("  ++  " + fname + "(" + state.getSecondsToExpire(curTime) + ") : " + state));
        }
    }
}

