/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.smb.server.repo.pseudo;

import org.alfresco.filesys.server.SrvSession;
import org.alfresco.filesys.server.filesys.FileName;
import org.alfresco.filesys.server.filesys.TreeConnection;
import org.alfresco.filesys.smb.server.SMBSrvSession;
import org.alfresco.filesys.smb.server.repo.ContentContext;
import org.alfresco.filesys.smb.server.repo.FileState;
import org.alfresco.filesys.smb.server.repo.pseudo.MemoryPseudoFile;
import org.alfresco.filesys.smb.server.repo.pseudo.PseudoFile;
import org.alfresco.filesys.smb.server.repo.pseudo.PseudoFileInterface;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ContentPseudoFileImpl
implements PseudoFileInterface {
    private static final Log logger = LogFactory.getLog(ContentPseudoFileImpl.class);

    public boolean isPseudoFile(SrvSession sess, TreeConnection tree, String path) {
        PseudoFile pfile;
        ContentContext ctx = (ContentContext)tree.getContext();
        boolean isPseudo = false;
        String[] paths = FileName.splitPath(path);
        FileState fstate = this.getStateForPath(ctx, paths[0]);
        if (fstate != null && fstate.hasPseudoFiles() && (pfile = fstate.getPseudoFileList().findFile(paths[1], false)) != null) {
            isPseudo = true;
        }
        return isPseudo;
    }

    public PseudoFile getPseudoFile(SrvSession sess, TreeConnection tree, String path) {
        PseudoFile pfile;
        String[] paths;
        ContentContext ctx = (ContentContext)tree.getContext();
        FileState fstate = this.getStateForPath(ctx, (paths = FileName.splitPath(path))[0]);
        if (fstate != null && fstate.hasPseudoFiles() && (pfile = fstate.getPseudoFileList().findFile(paths[1], false)) != null) {
            return pfile;
        }
        return null;
    }

    public int addPseudoFilesToFolder(SrvSession sess, TreeConnection tree, String path) {
        int pseudoCnt = 0;
        ContentContext ctx = (ContentContext)tree.getContext();
        FileState fstate = this.getStateForPath(ctx, path);
        if (fstate.hasPseudoFiles()) {
            return 0;
        }
        boolean isCIFS = sess instanceof SMBSrvSession;
        if (isCIFS && ctx.hasDragAndDropApp()) {
            if (fstate == null) {
                ctx.getStateTable().findFileState(path, true, true);
            }
            fstate.addPseudoFile(ctx.getDragAndDropApp());
            ++pseudoCnt;
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Added drag/drop pseudo file for " + path));
            }
        }
        if (isCIFS && ctx.hasURLFile() && fstate.getNodeRef() != null) {
            StringBuilder urlStr = new StringBuilder();
            urlStr.append("[InternetShortcut]\r\n");
            urlStr.append("URL=");
            urlStr.append(ctx.getURLPrefix());
            urlStr.append("navigate/browse/workspace/SpacesStore/");
            urlStr.append(fstate.getNodeRef().getId());
            urlStr.append("\r\n");
            byte[] urlData = urlStr.toString().getBytes();
            MemoryPseudoFile urlFile = new MemoryPseudoFile(ctx.getURLFileName(), urlData);
            fstate.addPseudoFile(urlFile);
            ++pseudoCnt;
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Added URL link pseudo file for " + path));
            }
        }
        return pseudoCnt;
    }

    public void deletePseudoFile(SrvSession sess, TreeConnection tree, String path) {
        String[] paths;
        ContentContext ctx = (ContentContext)tree.getContext();
        FileState fstate = this.getStateForPath(ctx, (paths = FileName.splitPath(path))[0]);
        if (fstate == null || !fstate.hasPseudoFiles()) {
            return;
        }
        fstate.getPseudoFileList().removeFile(paths[1], false);
    }

    private final FileState getStateForPath(ContentContext ctx, String path) {
        FileState fstate = null;
        if (ctx.hasStateTable()) {
            fstate = ctx.getStateTable().findFileState(path);
        }
        return fstate;
    }
}

