/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.smb.server.repo.pseudo;

import java.io.IOException;
import org.alfresco.filesys.server.filesys.AccessDeniedException;
import org.alfresco.filesys.server.filesys.FileInfo;
import org.alfresco.filesys.server.filesys.NetworkFile;

public class MemoryNetworkFile
extends NetworkFile {
    private long m_filePos;
    private byte[] m_data;
    private boolean m_eof;

    public MemoryNetworkFile(String name, byte[] data, FileInfo finfo) {
        super(name);
        this.m_data = data;
        if (this.m_data == null) {
            this.m_data = new byte[0];
        }
        this.setFileSize(this.m_data.length);
        this.m_eof = false;
        this.setModifyDate(finfo.getModifyDateTime());
        this.setCreationDate(finfo.getCreationDateTime());
        if (finfo.getPath() != null) {
            this.setFileId(finfo.getPath().hashCode());
            this.setFullName(finfo.getPath());
        }
    }

    public void closeFile() throws IOException {
    }

    public long currentPosition() {
        return this.m_filePos;
    }

    public void flushFile() throws IOException {
    }

    public boolean isEndOfFile() throws IOException {
        return this.m_filePos == (long)this.m_data.length;
    }

    public void openFile(boolean createFlag) throws IOException {
        this.setClosed(false);
    }

    public int readFile(byte[] buf, int len, int pos, long fileOff) throws IOException {
        long fileLen = this.m_data.length;
        if (fileOff >= fileLen) {
            return 0;
        }
        if (fileOff + (long)len > fileLen) {
            len = (int)(fileLen - fileOff);
        }
        System.arraycopy(this.m_data, (int)fileOff, buf, pos, len);
        this.m_filePos = fileOff + (long)len;
        return len;
    }

    public long seekFile(long pos, int typ) throws IOException {
        switch (typ) {
            case 0: {
                if (this.currentPosition() == pos) break;
                this.m_filePos = pos;
                break;
            }
            case 1: {
                this.m_filePos += pos;
                break;
            }
            case 2: {
                this.m_filePos += pos;
                if (this.m_filePos >= 0L) break;
                this.m_filePos = 0L;
            }
        }
        return this.currentPosition();
    }

    public void truncateFile(long siz) throws IOException {
        throw new AccessDeniedException("Cannot truncate pseudo file");
    }

    public void writeFile(byte[] buf, int len, int pos) throws IOException {
        throw new AccessDeniedException("Cannot write to pseudo file");
    }

    public void writeFile(byte[] buf, int len, int pos, long offset) throws IOException {
        throw new AccessDeniedException("Cannot write to pseudo file");
    }
}

