/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.smb.server.repo.pseudo;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.filesys.smb.server.repo.pseudo.PseudoFile;

public class PseudoFileList {
    private List<PseudoFile> m_list = new ArrayList<PseudoFile>();

    public final void addFile(PseudoFile pfile) {
        this.m_list.add(pfile);
    }

    public final int numberOfFiles() {
        return this.m_list.size();
    }

    public final PseudoFile getFileAt(int idx) {
        if (idx < this.m_list.size()) {
            return this.m_list.get(idx);
        }
        return null;
    }

    public final PseudoFile findFile(String fname, boolean caseSensitive) {
        if (this.m_list == null || this.m_list.size() == 0) {
            return null;
        }
        for (PseudoFile pfile : this.m_list) {
            if (caseSensitive && pfile.getFileName().equals(fname)) {
                return pfile;
            }
            if (!pfile.getFileName().equalsIgnoreCase(fname)) continue;
            return pfile;
        }
        return null;
    }

    public final PseudoFile removeFile(String fname, boolean caseSensitive) {
        if (this.m_list == null || this.m_list.size() == 0) {
            return null;
        }
        for (int idx = 0; idx < this.m_list.size(); ++idx) {
            PseudoFile pfile = this.m_list.get(idx);
            boolean match = false;
            if (caseSensitive && pfile.getFileName().equals(fname)) {
                match = true;
            } else if (pfile.getFileName().equalsIgnoreCase(fname)) {
                match = true;
            }
            if (!match) continue;
            this.m_list.remove(idx);
            return pfile;
        }
        return null;
    }
}

