/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.smb.server.win32;

import java.util.ArrayList;
import org.alfresco.filesys.netbios.NetBIOSName;
import org.alfresco.filesys.netbios.win32.NetBIOS;
import org.alfresco.filesys.netbios.win32.NetBIOSSocket;
import org.alfresco.filesys.netbios.win32.Win32NetBIOS;
import org.alfresco.filesys.netbios.win32.WinsockNetBIOSException;
import org.alfresco.filesys.server.config.ServerConfiguration;
import org.alfresco.filesys.smb.mailslot.HostAnnouncer;
import org.alfresco.filesys.smb.mailslot.Win32NetBIOSHostAnnouncer;
import org.alfresco.filesys.smb.mailslot.WinsockNetBIOSHostAnnouncer;
import org.alfresco.filesys.smb.server.SMBServer;
import org.alfresco.filesys.smb.server.SMBSrvSession;
import org.alfresco.filesys.smb.server.SessionSocketHandler;
import org.alfresco.filesys.smb.server.win32.LanaListener;
import org.alfresco.filesys.smb.server.win32.Win32NetBIOSLanaMonitor;
import org.alfresco.filesys.smb.server.win32.Win32NetBIOSPacketHandler;
import org.alfresco.filesys.smb.server.win32.WinsockNetBIOSPacketHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Win32NetBIOSSessionSocketHandler
extends SessionSocketHandler
implements LanaListener {
    private static final Log logger = LogFactory.getLog((String)"org.alfresco.smb.protocol");
    private static final ThreadGroup THREAD_GROUP_SESSION = new ThreadGroup("W32NETBIOS_SESSION_GROUP");
    public static final long LANAPollingInterval = 5000L;
    private String m_srvName;
    private byte[] m_acceptClient;
    private NetBIOSName m_nbName;
    private int m_nameNum;
    private NetBIOSName m_wksNbName;
    private int m_wksNameNum;
    private int m_lana = -1;
    private boolean m_lanaValid;
    private long m_lanaPoll;
    private boolean m_useWinsock;
    private NetBIOSSocket m_nbSocket;
    private NetBIOSSocket m_wksSocket;

    public Win32NetBIOSSessionSocketHandler(SMBServer srv, boolean debug) {
        super("Win32 NetBIOS", srv, debug);
        this.m_srvName = srv.getConfiguration().getWin32ServerName() != null ? srv.getConfiguration().getWin32ServerName() : srv.getConfiguration().getServerName();
        NetBIOSName accName = new NetBIOSName("*", '\u0000', false);
        this.m_acceptClient = accName.getNetBIOSName();
        this.m_lana = srv.getConfiguration().getWin32LANA();
        this.m_useWinsock = srv.getConfiguration().useWinsockNetBIOS();
        if (logger.isDebugEnabled() && this.hasDebug()) {
            logger.debug((Object)("Win32 NetBIOS server " + this.m_srvName + " (using " + (this.isUsingWinsock() ? "Winsock" : "Netbios() API") + ")"));
        }
        this.m_lanaPoll = 5000L;
    }

    public Win32NetBIOSSessionSocketHandler(SMBServer srv, int lana, boolean debug) {
        super("Win32 NetBIOS", srv, debug);
        this.m_srvName = srv.getConfiguration().getWin32ServerName() != null ? srv.getConfiguration().getWin32ServerName() : srv.getConfiguration().getServerName();
        NetBIOSName accName = new NetBIOSName("*", '\u0000', false);
        this.m_acceptClient = accName.getNetBIOSName();
        this.m_lana = lana;
        this.m_useWinsock = srv.getConfiguration().useWinsockNetBIOS();
        if (logger.isDebugEnabled() && this.hasDebug()) {
            logger.debug((Object)("Win32 NetBIOS server " + this.m_srvName + " (using " + (this.isUsingWinsock() ? "Winsock" : "Netbios() API") + ")"));
        }
        this.m_lanaPoll = 5000L;
    }

    public Win32NetBIOSSessionSocketHandler(SMBServer srv, String nbName, boolean debug) {
        super("Win32 NetBIOS", srv, debug);
        this.m_srvName = nbName;
        NetBIOSName accName = new NetBIOSName("*", '\u0000', false);
        this.m_acceptClient = accName.getNetBIOSName();
        this.m_lana = srv.getConfiguration().getWin32LANA();
        this.m_useWinsock = srv.getConfiguration().useWinsockNetBIOS();
        if (logger.isDebugEnabled() && this.hasDebug()) {
            logger.debug((Object)("Win32 NetBIOS server " + this.m_srvName + " (using " + (this.isUsingWinsock() ? "Winsock" : "Netbios() API") + ")"));
        }
        this.m_lanaPoll = 5000L;
    }

    public final int getLANANumber() {
        return this.m_lana;
    }

    public final long getLANAOfflinePollingInterval() {
        return this.m_lanaPoll;
    }

    public final int getNameNumber() {
        return this.m_nameNum;
    }

    public final String getServerName() {
        return this.m_srvName;
    }

    public final boolean isUsingWinsock() {
        return this.m_useWinsock;
    }

    public void initialize() throws Exception {
        int[] lanas = Win32NetBIOS.LanaEnumerate();
        if (lanas != null && lanas.length > 0) {
            if (this.m_lana == -1) {
                this.m_lana = lanas[0];
            } else {
                boolean lanaOnline = false;
                int idx = 0;
                while (idx < lanas.length && !lanaOnline) {
                    if (lanas[idx++] != this.getLANANumber()) continue;
                    lanaOnline = true;
                }
                if (!lanaOnline) {
                    this.m_lanaValid = false;
                    return;
                }
            }
        } else {
            if (this.m_lana == -1) {
                throw new Exception("No Win32 NetBIOS LANAs available");
            }
            this.m_lanaValid = false;
            return;
        }
        this.m_nbName = new NetBIOSName(this.m_srvName, ' ', false);
        this.m_wksNbName = new NetBIOSName(this.m_srvName, '\u0000', false);
        if (this.isUsingWinsock()) {
            this.initializeWinsockNetBIOS();
        } else {
            this.initializeNetbiosAPI();
        }
        this.m_lanaValid = true;
    }

    private final void initializeNetbiosAPI() throws Exception {
        Win32NetBIOS.Reset(this.m_lana);
        this.m_nameNum = Win32NetBIOS.AddName(this.m_lana, this.m_nbName.getNetBIOSName());
        if (this.m_nameNum < 0) {
            throw new Exception("Win32 NetBIOS AddName failed (file server), status = 0x" + Integer.toHexString(-this.m_nameNum) + ", " + NetBIOS.getErrorString(-this.m_nameNum));
        }
        this.m_wksNameNum = Win32NetBIOS.AddName(this.m_lana, this.m_wksNbName.getNetBIOSName());
        if (this.m_wksNameNum < 0) {
            throw new Exception("Win32 NetBIOS AddName failed (workstation), status = 0x" + Integer.toHexString(-this.m_wksNameNum) + ", " + NetBIOS.getErrorString(-this.m_wksNameNum));
        }
    }

    private final void initializeWinsockNetBIOS() throws Exception {
        this.m_nbSocket = NetBIOSSocket.createListenerSocket(this.getLANANumber(), this.m_nbName);
        this.m_wksSocket = NetBIOSSocket.createListenerSocket(this.getLANANumber(), this.m_wksNbName);
    }

    public final boolean isLANAValid() {
        return this.m_lanaValid;
    }

    public void shutdownRequest() {
        super.shutdownRequest();
        if (this.isLANAValid()) {
            Win32NetBIOS.Reset(this.m_lana);
        }
        if (this.isUsingWinsock()) {
            if (this.m_nbSocket != null) {
                this.m_nbSocket.closeSocket();
                this.m_nbSocket = null;
            }
            if (this.m_wksSocket != null) {
                this.m_wksSocket.closeSocket();
                this.m_wksSocket = null;
            }
        }
    }

    public void run() {
        block11: {
            try {
                this.clearShutdown();
                while (!this.hasShutdown()) {
                    block10: {
                        if (this.isLANAValid()) {
                            if (this.isUsingWinsock()) {
                                this.runWinsock();
                                continue;
                            }
                            this.runNetBIOS();
                            continue;
                        }
                        try {
                            Thread.sleep(this.getLANAOfflinePollingInterval());
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        try {
                            this.initialize();
                        }
                        catch (Exception ex) {
                            if (!logger.isDebugEnabled() || !this.hasDebug()) break block10;
                            logger.debug((Object)"Win32 NetBIOS Failed To ReInitialize LANA");
                            logger.debug((Object)("  " + ex.getMessage()));
                        }
                    }
                    if (!logger.isDebugEnabled() || !this.hasDebug() || !this.isLANAValid()) continue;
                    logger.debug((Object)("Win32 NetBIOS LANA " + this.getLANANumber() + " Back Online"));
                }
            }
            catch (Exception ex) {
                if (this.hasShutdown()) break block11;
                logger.debug((Object)("Win32 NetBIOS Server error : " + ex.toString()));
                logger.debug((Object)ex);
            }
        }
        if (logger.isDebugEnabled() && this.hasDebug()) {
            logger.debug((Object)"Win32 NetBIOS session handler closed");
        }
    }

    private final void runNetBIOS() throws Exception {
        if (logger.isDebugEnabled() && this.hasDebug()) {
            logger.debug((Object)"Waiting for Win32 NetBIOS session request (Netbios API) ...");
        }
        byte[] callerNameBuf = new byte[16];
        String callerName = null;
        callerNameBuf[0] = 0;
        callerName = null;
        int lsn = Win32NetBIOS.Listen(this.m_lana, this.m_nbName.getNetBIOSName(), this.m_acceptClient, callerNameBuf);
        if (this.hasShutdown()) {
            return;
        }
        callerName = callerNameBuf[0] != 0 ? new String(callerNameBuf).trim() : "";
        if (lsn >= 0) {
            try {
                if (logger.isDebugEnabled() && this.hasDebug()) {
                    logger.debug((Object)("Win32 NetBIOS session request received, lsn=" + lsn + ", caller=[" + callerName + "]"));
                }
                Win32NetBIOSPacketHandler pktHandler = new Win32NetBIOSPacketHandler(this.m_lana, lsn, callerName);
                SMBSrvSession srvSess = new SMBSrvSession(pktHandler, this.getServer());
                srvSess.setSessionId(this.getNextSessionId());
                srvSess.setUniqueId(pktHandler.getShortName() + srvSess.getSessionId());
                srvSess.setDebugPrefix("[" + pktHandler.getShortName() + srvSess.getSessionId() + "] ");
                this.getServer().addSession(srvSess);
                Thread srvThread = new Thread(THREAD_GROUP_SESSION, srvSess);
                srvThread.setDaemon(true);
                srvThread.setName("Sess_W" + srvSess.getSessionId() + "_LSN" + lsn);
                srvThread.start();
            }
            catch (Exception ex) {
                if (logger.isDebugEnabled() && this.hasDebug()) {
                    logger.debug((Object)("Win32 NetBIOS Failed to create session, " + ex.toString()));
                }
            }
        } else {
            int sts = -lsn;
            if (sts == 35) {
                this.m_lanaValid = false;
                if (logger.isDebugEnabled() && this.hasDebug()) {
                    logger.debug((Object)("Win32 NetBIOS LANA offline/disabled, LANA=" + this.getLANANumber()));
                }
            } else if (logger.isDebugEnabled() && this.hasDebug()) {
                logger.debug((Object)("Win32 NetBIOS Listen error, 0x" + Integer.toHexString(-lsn) + ", " + NetBIOS.getErrorString(-lsn)));
            }
        }
    }

    private final void runWinsock() throws Exception {
        block14: {
            NetBIOSSocket sessSock;
            block13: {
                if (logger.isDebugEnabled() && this.hasDebug()) {
                    logger.debug((Object)"Waiting for Win32 NetBIOS session request (Winsock) ...");
                }
                sessSock = null;
                try {
                    sessSock = this.m_nbSocket.listen();
                }
                catch (WinsockNetBIOSException ex) {
                    if (ex.getErrorCode() == 10050) {
                        if (!this.isLANAOnline(this.m_lana)) {
                            if (this.m_nbSocket != null) {
                                this.m_nbSocket.closeSocket();
                                this.m_nbSocket = null;
                            }
                            if (this.m_wksSocket != null) {
                                this.m_wksSocket.closeSocket();
                                this.m_wksSocket = null;
                            }
                            this.m_lanaValid = false;
                            if (logger.isDebugEnabled() && this.hasDebug()) {
                                logger.debug((Object)("Winsock NetBIOS network down, LANA=" + this.m_lana));
                            }
                        }
                    }
                    if (this.hasShutdown() || !logger.isDebugEnabled() || !this.hasDebug()) break block13;
                    logger.debug((Object)("Winsock NetBIOS listen error, " + ex.getMessage()));
                }
            }
            if (this.hasShutdown()) {
                return;
            }
            if (sessSock != null) {
                try {
                    if (logger.isDebugEnabled() && this.hasDebug()) {
                        logger.debug((Object)("Winsock NetBIOS session request received, caller=" + sessSock.getName()));
                    }
                    WinsockNetBIOSPacketHandler pktHandler = new WinsockNetBIOSPacketHandler(this.m_lana, sessSock);
                    SMBSrvSession srvSess = new SMBSrvSession(pktHandler, this.getServer());
                    srvSess.setSessionId(this.getNextSessionId());
                    srvSess.setUniqueId(pktHandler.getShortName() + srvSess.getSessionId());
                    srvSess.setDebugPrefix("[" + pktHandler.getShortName() + srvSess.getSessionId() + "] ");
                    this.getServer().addSession(srvSess);
                    Thread srvThread = new Thread(THREAD_GROUP_SESSION, srvSess);
                    srvThread.setDaemon(true);
                    srvThread.setName("Sess_WS" + srvSess.getSessionId());
                    srvThread.start();
                }
                catch (Exception ex) {
                    if (!logger.isDebugEnabled() || !this.hasDebug()) break block14;
                    logger.debug((Object)("Winsock NetBIOS Failed to create session, " + ex.toString()));
                }
            }
        }
    }

    public static final void createSessionHandlers(SMBServer server, boolean sockDbg) {
        ServerConfiguration config = server.getConfiguration();
        if (logger.isDebugEnabled() && sockDbg) {
            int[] lanas = Win32NetBIOS.LanaEnumerate();
            StringBuilder lanaStr = new StringBuilder();
            if (lanas != null && lanas.length > 0) {
                for (int i = 0; i < lanas.length; ++i) {
                    lanaStr.append(Integer.toString(lanas[i]));
                    lanaStr.append(" ");
                }
            }
            logger.debug((Object)("Win32 NetBIOS Available LANAs: " + lanaStr.toString()));
        }
        Win32NetBIOSSessionSocketHandler sessHandler = null;
        ArrayList<Win32NetBIOSSessionSocketHandler> lanaListeners = new ArrayList<Win32NetBIOSSessionSocketHandler>();
        if (config.getWin32LANA() != -1) {
            block20: {
                sessHandler = new Win32NetBIOSSessionSocketHandler(server, config.getWin32LANA(), sockDbg);
                try {
                    sessHandler.initialize();
                }
                catch (Exception ex) {
                    if (!logger.isDebugEnabled() || !sockDbg) break block20;
                    logger.debug((Object)("Win32 NetBIOS failed to create session handler for LANA " + config.getWin32LANA()));
                    logger.debug((Object)("      " + ex.getMessage()));
                }
            }
            server.addSessionHandler(sessHandler);
            Thread nbThread = new Thread(sessHandler);
            nbThread.setName("Win32NB_Handler_" + config.getWin32LANA());
            nbThread.start();
            if (logger.isDebugEnabled() && sockDbg) {
                logger.debug((Object)("Win32 NetBIOS created session handler on LANA " + config.getWin32LANA()));
            }
            if (config.hasWin32EnableAnnouncer()) {
                HostAnnouncer hostAnnouncer = null;
                String domain = config.getDomainName();
                int intvl = config.getWin32HostAnnounceInterval();
                hostAnnouncer = config.useWinsockNetBIOS() ? new WinsockNetBIOSHostAnnouncer(sessHandler, domain, intvl) : new Win32NetBIOSHostAnnouncer(sessHandler, domain, intvl);
                hostAnnouncer.setDebug(sockDbg);
                server.addHostAnnouncer(hostAnnouncer);
                hostAnnouncer.start();
                if (logger.isDebugEnabled() && sockDbg) {
                    logger.debug((Object)("Win32 NetBIOS host announcer enabled on LANA " + config.getWin32LANA()));
                }
            }
            if (sessHandler instanceof LanaListener) {
                lanaListeners.add(sessHandler);
            }
        } else {
            int[] lanas = Win32NetBIOS.LanaEnumerate();
            if (lanas != null && lanas.length > 0) {
                for (int i = 0; i < lanas.length; ++i) {
                    int lana;
                    block21: {
                        lana = lanas[i];
                        sessHandler = new Win32NetBIOSSessionSocketHandler(server, lana, sockDbg);
                        try {
                            sessHandler.initialize();
                        }
                        catch (Exception ex) {
                            if (!logger.isDebugEnabled() || !sockDbg) break block21;
                            logger.debug((Object)("Win32 NetBIOS failed to create session handler for LANA " + lana));
                            logger.debug((Object)("      " + ex.getMessage()));
                        }
                    }
                    server.addSessionHandler(sessHandler);
                    Thread nbThread = new Thread(sessHandler);
                    nbThread.setName("Win32NB_Handler_" + lana);
                    nbThread.start();
                    if (logger.isDebugEnabled() && sockDbg) {
                        logger.debug((Object)("Win32 NetBIOS created session handler on LANA " + lana));
                    }
                    if (config.hasWin32EnableAnnouncer()) {
                        HostAnnouncer hostAnnouncer = null;
                        String domain = config.getDomainName();
                        int intvl = config.getWin32HostAnnounceInterval();
                        hostAnnouncer = config.useWinsockNetBIOS() ? new WinsockNetBIOSHostAnnouncer(sessHandler, domain, intvl) : new Win32NetBIOSHostAnnouncer(sessHandler, domain, intvl);
                        hostAnnouncer.setDebug(sockDbg);
                        server.addHostAnnouncer(hostAnnouncer);
                        hostAnnouncer.start();
                        if (logger.isDebugEnabled() && sockDbg) {
                            logger.debug((Object)("Win32 NetBIOS host announcer enabled on LANA " + lana));
                        }
                    }
                    if (!(sessHandler instanceof LanaListener)) continue;
                    lanaListeners.add(sessHandler);
                }
            }
            Win32NetBIOSLanaMonitor lanaMonitor = new Win32NetBIOSLanaMonitor(server, lanas, 5000L, sockDbg);
            if (lanaListeners.size() > 0) {
                for (Win32NetBIOSSessionSocketHandler handler : lanaListeners) {
                    lanaMonitor.addLanaListener(handler.getLANANumber(), handler);
                }
            }
        }
    }

    private final boolean isLANAOnline(int lana) {
        int[] lanas = Win32NetBIOS.LanaEnumerate();
        if (lanas != null && lanas.length > 0) {
            for (int i = 0; i < lanas.length; ++i) {
                if (lanas[i] != lana) continue;
                return true;
            }
        }
        return false;
    }

    public void lanaStatusChange(int lana, boolean online) {
        if (!online) {
            this.m_lanaValid = false;
            if (this.m_nbSocket != null) {
                this.m_nbSocket.closeSocket();
                this.m_nbSocket = null;
            }
            if (this.m_wksSocket != null) {
                this.m_wksSocket.closeSocket();
                this.m_wksSocket = null;
            }
        }
    }
}

