/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.util;

public final class DataPacker {
    private static boolean bigEndian = false;

    public static final boolean isBigEndian() {
        return bigEndian;
    }

    public static final String getDataString(char typ, byte[] bytarray, int pos, int maxlen, boolean uni) {
        if (bytarray[pos++] == (byte)typ) {
            if (uni) {
                return DataPacker.getUnicodeString(bytarray, DataPacker.wordAlign(pos), maxlen / 2);
            }
            return DataPacker.getString(bytarray, pos, maxlen - 1);
        }
        return null;
    }

    public static final int getInt(byte[] buf, int pos) throws IndexOutOfBoundsException {
        if (buf.length < pos + 3) {
            throw new IndexOutOfBoundsException();
        }
        int i1 = buf[pos] & 0xFF;
        int i2 = buf[pos + 1] & 0xFF;
        int i3 = buf[pos + 2] & 0xFF;
        int i4 = buf[pos + 3] & 0xFF;
        int iVal = (i1 << 24) + (i2 << 16) + (i3 << 8) + i4;
        return iVal;
    }

    public static final int getIntelInt(byte[] bytarray, int pos) throws IndexOutOfBoundsException {
        if (bytarray.length < pos + 3) {
            throw new IndexOutOfBoundsException();
        }
        int iVal = 0;
        int i1 = bytarray[pos + 3] & 0xFF;
        int i2 = bytarray[pos + 2] & 0xFF;
        int i3 = bytarray[pos + 1] & 0xFF;
        int i4 = bytarray[pos] & 0xFF;
        iVal = (i1 << 24) + (i2 << 16) + (i3 << 8) + i4;
        return iVal;
    }

    public static final long getLong(byte[] buf, int pos) throws IndexOutOfBoundsException {
        if (buf.length < pos + 7) {
            throw new IndexOutOfBoundsException();
        }
        long lVal = 0L;
        for (int i = 0; i < 8; ++i) {
            long curVal = (long)buf[pos + i] & 0xFFL;
            lVal += (curVal <<= (7 - i) * 8);
        }
        return lVal;
    }

    public static final long getIntelLong(byte[] bytarray, int pos) throws IndexOutOfBoundsException {
        if (bytarray.length < pos + 7) {
            throw new IndexOutOfBoundsException();
        }
        long lVal = 0L;
        for (int i = 0; i < 8; ++i) {
            long curVal = (long)bytarray[pos + i] & 0xFFL;
            lVal += (curVal <<= i * 8);
        }
        return lVal;
    }

    public static final int getIntelShort(byte[] bytarray, int pos) throws IndexOutOfBoundsException {
        if (bytarray.length < pos) {
            throw new IndexOutOfBoundsException();
        }
        int sVal = (bytarray[pos + 1] << 8) + (bytarray[pos] & 0xFF);
        return sVal & 0xFFFF;
    }

    public static final int getShort(byte[] bytarray, int pos) throws IndexOutOfBoundsException {
        if (bytarray.length < pos) {
            throw new IndexOutOfBoundsException();
        }
        int sVal = 0;
        sVal = bigEndian ? (bytarray[pos + 1] << 8) + (bytarray[pos] & 0xFF) : (bytarray[pos] << 8) + (bytarray[pos + 1] & 0xFF);
        return sVal & 0xFFFF;
    }

    public static final String getString(byte[] bytarray, int pos, int maxlen) {
        int endpos;
        int maxpos = pos + maxlen;
        for (endpos = pos; bytarray[endpos] != 0 && endpos < maxpos; ++endpos) {
        }
        if (endpos <= maxpos) {
            return new String(bytarray, pos, endpos - pos);
        }
        return null;
    }

    public static final String getString(byte[] bytarray, int pos, int maxlen, boolean isUni) {
        String str = null;
        str = isUni ? DataPacker.getUnicodeString(bytarray, pos, maxlen) : DataPacker.getString(bytarray, pos, maxlen);
        return str;
    }

    public static final String getUnicodeString(byte[] byt, int pos, int maxlen) {
        char curChar;
        if (maxlen == 0) {
            return "";
        }
        int maxpos = pos + maxlen * 2;
        int endpos = pos;
        char[] chars = new char[maxlen];
        int cpos = 0;
        do {
            curChar = (char)(((byt[endpos + 1] & 0xFF) << 8) + (byt[endpos] & 0xFF));
            chars[cpos++] = curChar;
        } while (curChar != '\u0000' && (endpos += 2) < maxpos);
        if (endpos <= maxpos) {
            if (curChar == '\u0000') {
                --cpos;
            }
            return new String(chars, 0, cpos);
        }
        return null;
    }

    public static final void putInt(int val, byte[] bytarray, int pos) throws IndexOutOfBoundsException {
        if (bytarray.length < pos + 3) {
            throw new IndexOutOfBoundsException();
        }
        bytarray[pos] = (byte)(val >> 24 & 0xFF);
        bytarray[pos + 1] = (byte)(val >> 16 & 0xFF);
        bytarray[pos + 2] = (byte)(val >> 8 & 0xFF);
        bytarray[pos + 3] = (byte)(val & 0xFF);
    }

    public static final void putIntelInt(int val, byte[] bytarray, int pos) throws IndexOutOfBoundsException {
        if (bytarray.length < pos + 3) {
            throw new IndexOutOfBoundsException();
        }
        bytarray[pos + 3] = (byte)(val >> 24 & 0xFF);
        bytarray[pos + 2] = (byte)(val >> 16 & 0xFF);
        bytarray[pos + 1] = (byte)(val >> 8 & 0xFF);
        bytarray[pos] = (byte)(val & 0xFF);
    }

    public static final void putLong(long val, byte[] bytarray, int pos) throws IndexOutOfBoundsException {
        if (bytarray.length < pos + 7) {
            throw new IndexOutOfBoundsException();
        }
        bytarray[pos] = (byte)(val >> 56 & 0xFFL);
        bytarray[pos + 1] = (byte)(val >> 48 & 0xFFL);
        bytarray[pos + 2] = (byte)(val >> 40 & 0xFFL);
        bytarray[pos + 3] = (byte)(val >> 32 & 0xFFL);
        bytarray[pos + 4] = (byte)(val >> 24 & 0xFFL);
        bytarray[pos + 5] = (byte)(val >> 16 & 0xFFL);
        bytarray[pos + 6] = (byte)(val >> 8 & 0xFFL);
        bytarray[pos + 7] = (byte)(val & 0xFFL);
    }

    public static final void putIntelLong(long val, byte[] bytarray, int pos) throws IndexOutOfBoundsException {
        if (bytarray.length < pos + 7) {
            throw new IndexOutOfBoundsException();
        }
        bytarray[pos + 7] = (byte)(val >> 56 & 0xFFL);
        bytarray[pos + 6] = (byte)(val >> 48 & 0xFFL);
        bytarray[pos + 5] = (byte)(val >> 40 & 0xFFL);
        bytarray[pos + 4] = (byte)(val >> 32 & 0xFFL);
        bytarray[pos + 3] = (byte)(val >> 24 & 0xFFL);
        bytarray[pos + 2] = (byte)(val >> 16 & 0xFFL);
        bytarray[pos + 1] = (byte)(val >> 8 & 0xFFL);
        bytarray[pos] = (byte)(val & 0xFFL);
    }

    public static final void putIntelLong(int val, byte[] bytarray, int pos) throws IndexOutOfBoundsException {
        if (bytarray.length < pos + 7) {
            throw new IndexOutOfBoundsException();
        }
        bytarray[pos + 7] = 0;
        bytarray[pos + 6] = 0;
        bytarray[pos + 5] = 0;
        bytarray[pos + 4] = 0;
        bytarray[pos + 3] = (byte)(val >> 24 & 0xFF);
        bytarray[pos + 2] = (byte)(val >> 16 & 0xFF);
        bytarray[pos + 1] = (byte)(val >> 8 & 0xFF);
        bytarray[pos] = (byte)(val & 0xFF);
    }

    public static final void putIntelShort(int val, byte[] bytarray, int pos) throws IndexOutOfBoundsException {
        if (bytarray.length < pos) {
            throw new IndexOutOfBoundsException();
        }
        bytarray[pos + 1] = (byte)(val >> 8 & 0xFF);
        bytarray[pos] = (byte)(val & 0xFF);
    }

    public static final void putShort(int val, byte[] bytarray, int pos) throws IndexOutOfBoundsException {
        if (bytarray.length < pos) {
            throw new IndexOutOfBoundsException();
        }
        bytarray[pos] = (byte)(val >> 8 & 0xFF);
        bytarray[pos + 1] = (byte)(val & 0xFF);
    }

    public static final int putString(String str, byte[] bytarray, int pos, boolean nullterm) {
        byte[] byts = str.getBytes();
        int bufpos = pos;
        for (int i = 0; i < byts.length; ++i) {
            bytarray[bufpos++] = byts[i];
        }
        if (nullterm) {
            bytarray[bufpos++] = 0;
        }
        return bufpos;
    }

    public static final int putString(String str, int fldLen, byte[] bytarray, int pos) {
        byte[] byts = str.getBytes();
        int bufpos = pos;
        for (int idx = 0; idx < fldLen; ++idx) {
            bytarray[bufpos++] = idx < byts.length ? byts[idx] : (byte)0;
        }
        return bufpos;
    }

    public static final int putString(String str, byte[] bytarray, int pos, boolean nullterm, boolean isUni) {
        int newpos = -1;
        newpos = isUni ? DataPacker.putUnicodeString(str, bytarray, pos, nullterm) : DataPacker.putString(str, bytarray, pos, nullterm);
        return newpos;
    }

    public static final int putUnicodeString(String str, byte[] bytarray, int pos, boolean nullterm) {
        int bufpos = pos;
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            bytarray[bufpos++] = (byte)(ch & 0xFF);
            bytarray[bufpos++] = (byte)((ch & 0xFF00) >> 8);
        }
        if (nullterm) {
            bytarray[bufpos++] = 0;
            bytarray[bufpos++] = 0;
        }
        return bufpos;
    }

    public static final void putZeros(byte[] buf, int pos, int cnt) throws ArrayIndexOutOfBoundsException {
        if (buf.length < pos + cnt) {
            throw new ArrayIndexOutOfBoundsException();
        }
        for (int i = 0; i < cnt; ++i) {
            buf[pos + i] = 0;
        }
    }

    public static final int wordAlign(int pos) {
        return pos + 1 & 0xFFFFFFFE;
    }

    public static final int longwordAlign(int pos) {
        return pos + 3 & 0xFFFFFFFC;
    }

    public static final int getStringLength(String str, boolean uni, boolean nul) {
        int len = str.length();
        if (nul) {
            ++len;
        }
        if (uni) {
            len *= 2;
        }
        return len;
    }

    public static final int getBufferPosition(int pos, String str, boolean uni, boolean nul) {
        int len = str.length();
        if (nul) {
            ++len;
        }
        if (uni) {
            len *= 2;
        }
        return pos + len;
    }
}

